/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.util.Locale;
import java.util.Properties;
import org.apache.spark.Partition;
import org.apache.spark.annotation.Stable;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.Encoders$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.csv.CSVHeaderChecker;
import org.apache.spark.sql.catalyst.csv.CSVHeaderChecker$;
import org.apache.spark.sql.catalyst.csv.CSVOptions;
import org.apache.spark.sql.catalyst.csv.UnivocityParser;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.json.CreateJacksonParser$;
import org.apache.spark.sql.catalyst.json.JSONOptions;
import org.apache.spark.sql.catalyst.json.JacksonParser;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.util.FailureSafeParser;
import org.apache.spark.sql.connector.catalog.SupportsRead;
import org.apache.spark.sql.connector.catalog.Table;
import org.apache.spark.sql.connector.catalog.TableCapability;
import org.apache.spark.sql.connector.catalog.TableProvider;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.csv.CSVUtils$;
import org.apache.spark.sql.execution.datasources.csv.TextInputCSVDataSource$;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCOptions$;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCPartition;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCRelation;
import org.apache.spark.sql.execution.datasources.jdbc.JDBCRelation$;
import org.apache.spark.sql.execution.datasources.json.TextInputJsonDataSource$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Implicits$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Relation$;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Utils$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.util.CaseInsensitiveStringMap;
import org.apache.spark.unsafe.types.UTF8String;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Stable
@ScalaSignature(bytes="\u0006\u0001\t\u0015e\u0001B\u0017/\u0001]B\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006I!\u0012\u0005\u0007\u0013\u0002!\tA\f&\t\u000b5\u0003A\u0011\u0001(\t\u000bq\u0003A\u0011A/\t\u000bq\u0003A\u0011A3\t\u000b!\u0004A\u0011A5\t\u000b!\u0004A\u0011\u00018\t\u000b!\u0004A\u0011\u0001;\t\u000b!\u0004A\u0011\u0001>\t\u000f\u0005\u0005\u0001\u0001\"\u0001\u0002\u0004!9\u0011\u0011\u0001\u0001\u0005\u0002\u0005M\u0001bBA\u0013\u0001\u0011\u0005\u0011q\u0005\u0005\b\u0003K\u0001A\u0011AA\u001c\u0011\u001d\t)\u0003\u0001C\u0001\u0003{Aq!a\u0016\u0001\t\u0013\tI\u0006C\u0004\u0002^\u0001!\t!a\u0018\t\u000f\u0005u\u0003\u0001\"\u0001\u0002t!9\u0011Q\f\u0001\u0005\u0002\u0005M\u0005bBAS\u0001\u0011\u0005\u0011q\u0015\u0005\b\u0003K\u0003A\u0011AAV\u0011\u001d\t)\u000b\u0001C\u0001\u0003cCq!!*\u0001\t\u0003\t)\u000eC\u0004\u0002&\u0002!\t!a:\t\u000f\u0005M\b\u0001\"\u0001\u0002v\"9\u00111\u001f\u0001\u0005\u0002\u0005e\bbBAz\u0001\u0011\u0005\u0011q \u0005\b\u0005\u000b\u0001A\u0011\u0001B\u0004\u0011\u001d\u0011)\u0001\u0001C\u0001\u0005\u0017AqA!\u0005\u0001\t\u0003\u0011\u0019\u0002C\u0004\u0003\u0012\u0001!\tAa\u0006\t\u000f\u0005\u001d\u0004\u0001\"\u0001\u0003\u001e!9!1\u0005\u0001\u0005\u0002\t\u0015\u0002b\u0002B\u0012\u0001\u0011\u0005!\u0011\u0006\u0005\b\u0005_\u0001A\u0011\u0001B\u0019\u0011\u001d\u0011y\u0003\u0001C\u0001\u0005kAqAa\u000f\u0001\t\u0013\u0011i\u0004\u0003\u0005Q\u0001\u0001\u0007I\u0011\u0002B%\u0011%\u0011Y\u0005\u0001a\u0001\n\u0013\u0011i\u0005C\u0004\u0003T\u0001\u0001\u000b\u0015B)\t\u0013\tU\u0003\u00011A\u0005\n\t]\u0003\"\u0003B0\u0001\u0001\u0007I\u0011\u0002B1\u0011!\u0011)\u0007\u0001Q!\n\te\u0003\"\u0003B4\u0001\t\u0007I\u0011\u0002B5\u0011!\u00119\b\u0001Q\u0001\n\t-$a\u0004#bi\u00064%/Y7f%\u0016\fG-\u001a:\u000b\u0005=\u0002\u0014aA:rY*\u0011\u0011GM\u0001\u0006gB\f'o\u001b\u0006\u0003gQ\na!\u00199bG\",'\"A\u001b\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001Ad\b\u0005\u0002:y5\t!HC\u0001<\u0003\u0015\u00198-\u00197b\u0013\ti$H\u0001\u0004B]f\u0014VM\u001a\t\u0003\u007f\tk\u0011\u0001\u0011\u0006\u0003\u0003B\n\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003\u0007\u0002\u0013q\u0001T8hO&tw-\u0001\u0007ta\u0006\u00148nU3tg&|g\u000e\u0005\u0002G\u000f6\ta&\u0003\u0002I]\ta1\u000b]1sWN+7o]5p]\u00061A(\u001b8jiz\"\"a\u0013'\u0011\u0005\u0019\u0003\u0001\"\u0002#\u0003\u0001\u0004)\u0015A\u00024pe6\fG\u000f\u0006\u0002L\u001f\")\u0001k\u0001a\u0001#\u000611o\\;sG\u0016\u0004\"AU-\u000f\u0005M;\u0006C\u0001+;\u001b\u0005)&B\u0001,7\u0003\u0019a$o\\8u}%\u0011\u0001LO\u0001\u0007!J,G-\u001a4\n\u0005i[&AB*ue&twM\u0003\u0002Yu\u000511o\u00195f[\u0006$\"a\u00130\t\u000bq#\u0001\u0019A0\u0011\u0005\u0001\u001cW\"A1\u000b\u0005\tt\u0013!\u0002;za\u0016\u001c\u0018B\u00013b\u0005)\u0019FO];diRK\b/\u001a\u000b\u0003\u0017\u001aDQaZ\u0003A\u0002E\u000bAb]2iK6\f7\u000b\u001e:j]\u001e\faa\u001c9uS>tGcA&kY\")1N\u0002a\u0001#\u0006\u00191.Z=\t\u000b54\u0001\u0019A)\u0002\u000bY\fG.^3\u0015\u0007-{\u0007\u000fC\u0003l\u000f\u0001\u0007\u0011\u000bC\u0003n\u000f\u0001\u0007\u0011\u000f\u0005\u0002:e&\u00111O\u000f\u0002\b\u0005>|G.Z1o)\rYUO\u001e\u0005\u0006W\"\u0001\r!\u0015\u0005\u0006[\"\u0001\ra\u001e\t\u0003saL!!\u001f\u001e\u0003\t1{gn\u001a\u000b\u0004\u0017nd\b\"B6\n\u0001\u0004\t\u0006\"B7\n\u0001\u0004i\bCA\u001d\u007f\u0013\ty(H\u0001\u0004E_V\u0014G.Z\u0001\b_B$\u0018n\u001c8t)\rY\u0015Q\u0001\u0005\b\u0003\u0003Q\u0001\u0019AA\u0004!\u0019\tI!a\u0004R#6\u0011\u00111\u0002\u0006\u0004\u0003\u001bQ\u0014AC2pY2,7\r^5p]&!\u0011\u0011CA\u0006\u0005\ri\u0015\r\u001d\u000b\u0004\u0017\u0006U\u0001bBA\u0001\u0017\u0001\u0007\u0011q\u0003\t\u0007\u00033\t\u0019#U)\u000e\u0005\u0005m!\u0002BA\u000f\u0003?\tA!\u001e;jY*\u0011\u0011\u0011E\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002\u0012\u0005m\u0011\u0001\u00027pC\u0012$\"!!\u000b\u0011\t\u0005-\u0012\u0011\u0007\b\u0004\r\u00065\u0012bAA\u0018]\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u001a\u0003k\u0011\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\u0007\u0005=b\u0006\u0006\u0003\u0002*\u0005e\u0002BBA\u001e\u001b\u0001\u0007\u0011+\u0001\u0003qCRDG\u0003BA\u0015\u0003\u007fAq!!\u0011\u000f\u0001\u0004\t\u0019%A\u0003qCRD7\u000f\u0005\u0003:\u0003\u000b\n\u0016bAA$u\tQAH]3qK\u0006$X\r\u001a )\u00079\tY\u0005\u0005\u0003\u0002N\u0005MSBAA(\u0015\r\t\tFO\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA+\u0003\u001f\u0012qA^1sCJ<7/\u0001\u0007m_\u0006$g+M*pkJ\u001cW\r\u0006\u0003\u0002*\u0005m\u0003bBA!\u001f\u0001\u0007\u00111I\u0001\u0005U\u0012\u00147\r\u0006\u0005\u0002*\u0005\u0005\u0014QMA5\u0011\u0019\t\u0019\u0007\u0005a\u0001#\u0006\u0019QO\u001d7\t\r\u0005\u001d\u0004\u00031\u0001R\u0003\u0015!\u0018M\u00197f\u0011\u001d\tY\u0007\u0005a\u0001\u0003[\n!\u0002\u001d:pa\u0016\u0014H/[3t!\u0011\tI\"a\u001c\n\t\u0005E\u00141\u0004\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001cH\u0003EA\u0015\u0003k\n9(!\u001f\u0002~\u0005\u0005\u0015QQAH\u0011\u0019\t\u0019'\u0005a\u0001#\"1\u0011qM\tA\u0002ECa!a\u001f\u0012\u0001\u0004\t\u0016AC2pYVlgNT1nK\"1\u0011qP\tA\u0002]\f!\u0002\\8xKJ\u0014u.\u001e8e\u0011\u0019\t\u0019)\u0005a\u0001o\u0006QQ\u000f\u001d9fe\n{WO\u001c3\t\u000f\u0005\u001d\u0015\u00031\u0001\u0002\n\u0006ia.^7QCJ$\u0018\u000e^5p]N\u00042!OAF\u0013\r\tiI\u000f\u0002\u0004\u0013:$\bbBAI#\u0001\u0007\u0011QN\u0001\u0015G>tg.Z2uS>t\u0007K]8qKJ$\u0018.Z:\u0015\u0015\u0005%\u0012QSAL\u00033\u000b\u0019\u000b\u0003\u0004\u0002dI\u0001\r!\u0015\u0005\u0007\u0003O\u0012\u0002\u0019A)\t\u000f\u0005m%\u00031\u0001\u0002\u001e\u0006Q\u0001O]3eS\u000e\fG/Z:\u0011\te\ny*U\u0005\u0004\u0003CS$!B!se\u0006L\bbBAI%\u0001\u0007\u0011QN\u0001\u0005UN|g\u000e\u0006\u0003\u0002*\u0005%\u0006BBA\u001e'\u0001\u0007\u0011\u000b\u0006\u0003\u0002*\u00055\u0006bBA!)\u0001\u0007\u00111\t\u0015\u0004)\u0005-C\u0003BA\u0015\u0003gCq!!.\u0016\u0001\u0004\t9,A\u0004kg>t'\u000b\u0012#\u0011\u000b\u0005e\u0016\u0011Y)\u000e\u0005\u0005m&\u0002BA\u0011\u0003{S1!a01\u0003\r\t\u0007/[\u0005\u0005\u0003\u0007\fYLA\u0004KCZ\f'\u000b\u0012#)\u000fU\t9-!4\u0002RB\u0019\u0011(!3\n\u0007\u0005-'H\u0001\u0006eKB\u0014XmY1uK\u0012\f#!a4\u0002EU\u001bX\r\t6t_:DC)\u0019;bg\u0016$8l\u0015;sS:<W,\u000b\u0011j]N$X-\u00193/C\t\t\u0019.A\u00033]Ir\u0003\u0007\u0006\u0003\u0002*\u0005]\u0007bBA[-\u0001\u0007\u0011\u0011\u001c\t\u0006\u00037\f\t/U\u0007\u0003\u0003;T1!a81\u0003\r\u0011H\rZ\u0005\u0005\u0003G\fiNA\u0002S\t\u0012CsAFAd\u0003\u001b\f\t\u000e\u0006\u0003\u0002*\u0005%\bbBAv/\u0001\u0007\u0011Q^\u0001\fUN|g\u000eR1uCN,G\u000f\u0005\u0003G\u0003_\f\u0016bAAy]\t9A)\u0019;bg\u0016$\u0018aA2tmR!\u0011\u0011FA|\u0011\u0019\tY\u0004\u0007a\u0001#R!\u0011\u0011FA~\u0011\u001d\ti0\u0007a\u0001\u0003[\f!bY:w\t\u0006$\u0018m]3u)\u0011\tIC!\u0001\t\u000f\u0005\u0005#\u00041\u0001\u0002D!\u001a!$a\u0013\u0002\u000fA\f'/];fiR!\u0011\u0011\u0006B\u0005\u0011\u0019\tYd\u0007a\u0001#R!\u0011\u0011\u0006B\u0007\u0011\u001d\t\t\u0005\ba\u0001\u0003\u0007B3\u0001HA&\u0003\ry'o\u0019\u000b\u0005\u0003S\u0011)\u0002\u0003\u0004\u0002<u\u0001\r!\u0015\u000b\u0005\u0003S\u0011I\u0002C\u0004\u0002By\u0001\r!a\u0011)\u0007y\tY\u0005\u0006\u0003\u0002*\t}\u0001B\u0002B\u0011?\u0001\u0007\u0011+A\u0005uC\ndWMT1nK\u0006!A/\u001a=u)\u0011\tICa\n\t\r\u0005m\u0002\u00051\u0001R)\u0011\tICa\u000b\t\u000f\u0005\u0005\u0013\u00051\u0001\u0002D!\u001a\u0011%a\u0013\u0002\u0011Q,\u0007\u0010\u001e$jY\u0016$B!!<\u00034!1\u00111\b\u0012A\u0002E#B!!<\u00038!9\u0011\u0011I\u0012A\u0002\u0005\r\u0003fA\u0012\u0002L\u00059\u0012m]:feRtun\u00159fG&4\u0017.\u001a3TG\",W.\u0019\u000b\u0005\u0005\u007f\u0011)\u0005E\u0002:\u0005\u0003J1Aa\u0011;\u0005\u0011)f.\u001b;\t\r\t\u001dC\u00051\u0001R\u0003%y\u0007/\u001a:bi&|g.F\u0001R\u0003)\u0019x.\u001e:dK~#S-\u001d\u000b\u0005\u0005\u007f\u0011y\u0005\u0003\u0005\u0003R\u0019\n\t\u00111\u0001R\u0003\rAH%M\u0001\bg>,(oY3!\u0003M)8/\u001a:Ta\u0016\u001c\u0017NZ5fIN\u001b\u0007.Z7b+\t\u0011I\u0006\u0005\u0003:\u00057z\u0016b\u0001B/u\t1q\n\u001d;j_:\fq#^:feN\u0003XmY5gS\u0016$7k\u00195f[\u0006|F%Z9\u0015\t\t}\"1\r\u0005\n\u0005#J\u0013\u0011!a\u0001\u00053\nA#^:feN\u0003XmY5gS\u0016$7k\u00195f[\u0006\u0004\u0013\u0001D3yiJ\fw\n\u001d;j_:\u001cXC\u0001B6!\u0019\u0011iGa\u001dR#6\u0011!q\u000e\u0006\u0005\u0005c\nY!A\u0004nkR\f'\r\\3\n\t\tU$q\u000e\u0002\b\u0011\u0006\u001c\b.T1q\u00035)\u0007\u0010\u001e:b\u001fB$\u0018n\u001c8tA!\u001a\u0001Aa\u001f\u0011\t\tu$\u0011Q\u0007\u0003\u0005\u007fR1!!\u00151\u0013\u0011\u0011\u0019Ia \u0003\rM#\u0018M\u00197f\u0001")
public class DataFrameReader
implements Logging {
    private final SparkSession sparkSession;
    private String source;
    private Option<StructType> userSpecifiedSchema;
    private final HashMap<String, String> extraOptions;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Dataset<Row> load(String ... paths) {
        return this.load((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<Row> json(String ... paths) {
        return this.json((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<Row> csv(String ... paths) {
        return this.csv((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<Row> parquet(String ... paths) {
        return this.parquet((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<Row> orc(String ... paths) {
        return this.orc((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<Row> text(String ... paths) {
        return this.text((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])paths));
    }

    public Dataset<String> textFile(String ... paths) {
        return this.textFile((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])paths));
    }

    public DataFrameReader format(String source) {
        this.source_$eq(source);
        return this;
    }

    public DataFrameReader schema(StructType schema) {
        this.userSpecifiedSchema_$eq((Option<StructType>)Option$.MODULE$.apply((Object)schema));
        return this;
    }

    public DataFrameReader schema(String schemaString) {
        this.userSpecifiedSchema_$eq((Option<StructType>)Option$.MODULE$.apply((Object)StructType$.MODULE$.fromDDL(schemaString)));
        return this;
    }

    public DataFrameReader option(String key, String value) {
        this.extraOptions().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value));
        return this;
    }

    public DataFrameReader option(String key, boolean value) {
        return this.option(key, ((Object)BoxesRunTime.boxToBoolean((boolean)value)).toString());
    }

    public DataFrameReader option(String key, long value) {
        return this.option(key, ((Object)BoxesRunTime.boxToLong((long)value)).toString());
    }

    public DataFrameReader option(String key, double value) {
        return this.option(key, ((Object)BoxesRunTime.boxToDouble((double)value)).toString());
    }

    public DataFrameReader options(Map<String, String> options) {
        this.extraOptions().$plus$plus$eq(options);
        return this;
    }

    public DataFrameReader options(java.util.Map<String, String> options) {
        this.options((Map<String, String>)((Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(options).asScala()));
        return this;
    }

    public Dataset<Row> load() {
        return this.load((Seq<String>)((Seq)Seq$.MODULE$.empty()));
    }

    public Dataset<Row> load(String path) {
        return this.option("path", path).load((Seq<String>)((Seq)Seq$.MODULE$.empty()));
    }

    public Dataset<Row> load(Seq<String> paths) {
        String string = this.source().toLowerCase(Locale.ROOT);
        String string2 = DDLUtils$.MODULE$.HIVE_PROVIDER();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            throw new AnalysisException("Hive data source can only be used with tables, you can not read files of Hive data source directly.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        return (Dataset)DataSource$.MODULE$.lookupDataSourceV2(this.source(), this.sparkSession.sessionState().conf()).map((Function1 & Serializable & scala.Serializable)provider -> {
            Table table;
            Table table2;
            None$ none$;
            scala.collection.immutable.Map<String, String> sessionOptions = DataSourceV2Utils$.MODULE$.extractSessionConfigs((TableProvider)provider, $this.sparkSession.sessionState().conf());
            if (paths.isEmpty()) {
                none$ = None$.MODULE$;
            } else {
                ObjectMapper objectMapper = new ObjectMapper();
                none$ = new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"paths"), (Object)objectMapper.writeValueAsString(paths.toArray(ClassTag$.MODULE$.apply(String.class)))));
            }
            None$ pathsOption = none$;
            scala.collection.immutable.Map finalOptions = sessionOptions.$plus$plus((GenTraversableOnce)this.extraOptions().toMap(Predef$.MODULE$.$conforms())).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable((Option)pathsOption));
            CaseInsensitiveStringMap dsOptions = new CaseInsensitiveStringMap((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)finalOptions).asJava());
            Option<StructType> option = this.userSpecifiedSchema();
            if (option instanceof Some) {
                Some some = (Some)option;
                StructType schema = (StructType)some.value();
                table2 = provider.getTable(dsOptions, schema);
            } else {
                table2 = provider.getTable(dsOptions);
            }
            Table table3 = table = table2;
            Dataset<Row> dataset = table3 instanceof SupportsRead && DataSourceV2Implicits$.MODULE$.TableHelper(table).supports(TableCapability.BATCH_READ) ? Dataset$.MODULE$.ofRows($this.sparkSession, (LogicalPlan)DataSourceV2Relation$.MODULE$.create(table, dsOptions)) : this.loadV1Source(paths);
            return dataset;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.loadV1Source(paths));
    }

    private Dataset<Row> loadV1Source(Seq<String> paths) {
        SparkSession x$1 = this.sparkSession;
        Seq<String> x$2 = paths;
        Option<StructType> x$3 = this.userSpecifiedSchema();
        String x$4 = this.source();
        scala.collection.immutable.Map x$5 = this.extraOptions().toMap(Predef$.MODULE$.$conforms());
        Seq<String> x$6 = DataSource$.MODULE$.apply$default$5();
        Option<BucketSpec> x$7 = DataSource$.MODULE$.apply$default$6();
        Option<CatalogTable> x$8 = DataSource$.MODULE$.apply$default$8();
        DataSource qual$1 = new DataSource(x$1, x$4, x$2, x$3, x$6, x$7, (scala.collection.immutable.Map<String, String>)x$5, x$8);
        boolean x$9 = qual$1.resolveRelation$default$1();
        return this.sparkSession.baseRelationToDataFrame(qual$1.resolveRelation(x$9));
    }

    public Dataset<Row> jdbc(String url, String table, Properties properties) {
        this.assertNoSpecifiedSchema("jdbc");
        this.extraOptions().$plus$plus$eq((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(properties).asScala());
        this.extraOptions().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_URL()), (Object)url), (Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_TABLE_NAME()), (Object)table), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        return this.format("jdbc").load();
    }

    public Dataset<Row> jdbc(String url, String table, String columnName, long lowerBound, long upperBound, int numPartitions, Properties connectionProperties) {
        this.extraOptions().$plus$plus$eq((TraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_PARTITION_COLUMN()), (Object)columnName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_LOWER_BOUND()), (Object)((Object)BoxesRunTime.boxToLong((long)lowerBound)).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_UPPER_BOUND()), (Object)((Object)BoxesRunTime.boxToLong((long)upperBound)).toString()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)JDBCOptions$.MODULE$.JDBC_NUM_PARTITIONS()), (Object)((Object)BoxesRunTime.boxToInteger((int)numPartitions)).toString())})));
        return this.jdbc(url, table, connectionProperties);
    }

    public Dataset<Row> jdbc(String url, String table, String[] predicates, Properties connectionProperties) {
        this.assertNoSpecifiedSchema("jdbc");
        scala.collection.immutable.Map params = this.extraOptions().toMap(Predef$.MODULE$.$conforms()).$plus$plus((GenTraversableOnce)((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(connectionProperties).asScala()).toMap(Predef$.MODULE$.$conforms()));
        JDBCOptions options = new JDBCOptions(url, table, (scala.collection.immutable.Map<String, String>)params);
        Partition[] parts = (Partition[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])predicates)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String part = (String)tuple2._1();
            int i = tuple2._2$mcI$sp();
            JDBCPartition jDBCPartition = new JDBCPartition(part, i);
            return jDBCPartition;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Partition.class)));
        JDBCRelation relation = JDBCRelation$.MODULE$.apply(parts, options, this.sparkSession);
        return this.sparkSession.baseRelationToDataFrame(relation);
    }

    public Dataset<Row> json(String path) {
        return this.json((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{path}))));
    }

    public Dataset<Row> json(Seq<String> paths) {
        return this.format("json").load(paths);
    }

    public Dataset<Row> json(JavaRDD<String> jsonRDD) {
        return this.json((RDD<String>)jsonRDD.rdd());
    }

    public Dataset<Row> json(RDD<String> jsonRDD) {
        return this.json(this.sparkSession.createDataset(jsonRDD, Encoders$.MODULE$.STRING()));
    }

    public Dataset<Row> json(Dataset<String> jsonDataset) {
        JSONOptions parsedOptions = new JSONOptions(this.extraOptions().toMap(Predef$.MODULE$.$conforms()), this.sparkSession.sessionState().conf().sessionLocalTimeZone(), this.sparkSession.sessionState().conf().columnNameOfCorruptRecord());
        StructType schema = (StructType)this.userSpecifiedSchema().getOrElse((Function0 & Serializable & scala.Serializable)() -> TextInputJsonDataSource$.MODULE$.inferFromDataset(jsonDataset, parsedOptions));
        ExprUtils$.MODULE$.verifyColumnNameOfCorruptRecord(schema, parsedOptions.columnNameOfCorruptRecord());
        StructType actualSchema = StructType$.MODULE$.apply((Seq)schema.filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DataFrameReader.$anonfun$json$2(parsedOptions, x$1))));
        Function2 & Serializable & scala.Serializable createParser = (Function2 & Serializable & scala.Serializable)(jsonFactory, record) -> CreateJacksonParser$.MODULE$.string(jsonFactory, record);
        RDD parsed = jsonDataset.rdd().mapPartitions((Function1 & Serializable & scala.Serializable)iter -> {
            JacksonParser rawParser = new JacksonParser((DataType)actualSchema, parsedOptions, true);
            FailureSafeParser parser = new FailureSafeParser((Function1 & Serializable & scala.Serializable)input -> rawParser.parse(input, createParser, (Function1 & Serializable & scala.Serializable)x$1 -> UTF8String.fromString((String)x$1)), parsedOptions.parseMode(), schema, parsedOptions.columnNameOfCorruptRecord());
            return iter.flatMap((Function1 & Serializable & scala.Serializable)input -> parser.parse(input));
        }, jsonDataset.rdd().mapPartitions$default$2(), ClassTag$.MODULE$.apply(InternalRow.class));
        return this.sparkSession.internalCreateDataFrame((RDD<InternalRow>)parsed, schema, jsonDataset.isStreaming());
    }

    public Dataset<Row> csv(String path) {
        return this.csv((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{path}))));
    }

    public Dataset<Row> csv(Dataset<String> csvDataset) {
        CSVOptions parsedOptions = new CSVOptions(this.extraOptions().toMap(Predef$.MODULE$.$conforms()), this.sparkSession.sessionState().conf().csvColumnPruning(), this.sparkSession.sessionState().conf().sessionLocalTimeZone());
        Dataset<String> filteredLines = CSVUtils$.MODULE$.filterCommentAndEmpty(csvDataset, parsedOptions);
        None$ maybeFirstLine = this.userSpecifiedSchema().isEmpty() || parsedOptions.headerFlag() ? new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])filteredLines.take(1))).headOption() : None$.MODULE$;
        StructType schema = (StructType)this.userSpecifiedSchema().getOrElse(() -> DataFrameReader.$anonfun$csv$1(this, csvDataset, (Option)maybeFirstLine, parsedOptions));
        ExprUtils$.MODULE$.verifyColumnNameOfCorruptRecord(schema, parsedOptions.columnNameOfCorruptRecord());
        StructType actualSchema = StructType$.MODULE$.apply((Seq)schema.filterNot((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DataFrameReader.$anonfun$csv$2(parsedOptions, x$2))));
        RDD linesWithoutHeader = (RDD)maybeFirstLine.map((Function1 & Serializable & scala.Serializable)firstLine -> {
            CSVHeaderChecker headerChecker = new CSVHeaderChecker(actualSchema, parsedOptions, new StringBuilder(12).append("CSV source: ").append(csvDataset).toString(), CSVHeaderChecker$.MODULE$.$lessinit$greater$default$4());
            headerChecker.checkHeaderColumnNames(firstLine);
            return filteredLines.rdd().mapPartitions((Function1 & Serializable & scala.Serializable)x$3 -> CSVUtils$.MODULE$.filterHeaderLine((Iterator<String>)x$3, (String)firstLine, parsedOptions), filteredLines.rdd().mapPartitions$default$2(), ClassTag$.MODULE$.apply(String.class));
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> filteredLines.rdd());
        RDD parsed = linesWithoutHeader.mapPartitions((Function1 & Serializable & scala.Serializable)iter -> {
            UnivocityParser rawParser = new UnivocityParser(actualSchema, parsedOptions);
            FailureSafeParser parser = new FailureSafeParser((Function1 & Serializable & scala.Serializable)input -> (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InternalRow[]{rawParser.parse(input)})), parsedOptions.parseMode(), schema, parsedOptions.columnNameOfCorruptRecord());
            return iter.flatMap((Function1 & Serializable & scala.Serializable)input -> parser.parse(input));
        }, linesWithoutHeader.mapPartitions$default$2(), ClassTag$.MODULE$.apply(InternalRow.class));
        return this.sparkSession.internalCreateDataFrame((RDD<InternalRow>)parsed, schema, csvDataset.isStreaming());
    }

    public Dataset<Row> csv(Seq<String> paths) {
        return this.format("csv").load(paths);
    }

    public Dataset<Row> parquet(String path) {
        return this.parquet((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{path}))));
    }

    public Dataset<Row> parquet(Seq<String> paths) {
        return this.format("parquet").load(paths);
    }

    public Dataset<Row> orc(String path) {
        return this.orc((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{path}))));
    }

    public Dataset<Row> orc(Seq<String> paths) {
        return this.format("orc").load(paths);
    }

    public Dataset<Row> table(String tableName) {
        this.assertNoSpecifiedSchema("table");
        return this.sparkSession.table(tableName);
    }

    public Dataset<Row> text(String path) {
        return this.text((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{path}))));
    }

    public Dataset<Row> text(Seq<String> paths) {
        return this.format("text").load(paths);
    }

    public Dataset<String> textFile(String path) {
        return this.textFile((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{path}))));
    }

    public Dataset<String> textFile(Seq<String> paths) {
        this.assertNoSpecifiedSchema("textFile");
        return this.text(paths).select("value", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).as(this.sparkSession.implicits().newStringEncoder());
    }

    private void assertNoSpecifiedSchema(String operation) {
        if (this.userSpecifiedSchema().nonEmpty()) {
            throw new AnalysisException(new StringBuilder(43).append("User specified schema not supported with `").append(operation).append("`").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
    }

    private String source() {
        return this.source;
    }

    private void source_$eq(String x$1) {
        this.source = x$1;
    }

    private Option<StructType> userSpecifiedSchema() {
        return this.userSpecifiedSchema;
    }

    private void userSpecifiedSchema_$eq(Option<StructType> x$1) {
        this.userSpecifiedSchema = x$1;
    }

    private HashMap<String, String> extraOptions() {
        return this.extraOptions;
    }

    public static final /* synthetic */ boolean $anonfun$json$2(JSONOptions parsedOptions$1, StructField x$1) {
        String string = x$1.name();
        String string2 = parsedOptions$1.columnNameOfCorruptRecord();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ StructType $anonfun$csv$1(DataFrameReader $this, Dataset csvDataset$1, Option maybeFirstLine$1, CSVOptions parsedOptions$2) {
        return TextInputCSVDataSource$.MODULE$.inferFromDataset($this.sparkSession, csvDataset$1, (Option<String>)maybeFirstLine$1, parsedOptions$2);
    }

    public static final /* synthetic */ boolean $anonfun$csv$2(CSVOptions parsedOptions$2, StructField x$2) {
        String string = x$2.name();
        String string2 = parsedOptions$2.columnNameOfCorruptRecord();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public DataFrameReader(SparkSession sparkSession) {
        this.sparkSession = sparkSession;
        Logging.$init$((Logging)this);
        this.source = sparkSession.sessionState().conf().defaultDataSourceName();
        this.userSpecifiedSchema = None$.MODULE$;
        this.extraOptions = new HashMap();
    }
}

