/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.streaming;

import java.io.Serializable;
import java.util.UUID;
import javax.annotation.concurrent.GuardedBy;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkException;
import org.apache.spark.annotation.InterfaceStability;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.analysis.UnsupportedOperationChecker$;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.streaming.BaseStreamingSink;
import org.apache.spark.sql.execution.streaming.MicroBatchExecution;
import org.apache.spark.sql.execution.streaming.StreamingQueryListenerBus;
import org.apache.spark.sql.execution.streaming.StreamingQueryWrapper;
import org.apache.spark.sql.execution.streaming.continuous.ContinuousExecution;
import org.apache.spark.sql.execution.streaming.continuous.ContinuousTrigger;
import org.apache.spark.sql.execution.streaming.state.StateStoreCoordinatorRef;
import org.apache.spark.sql.execution.streaming.state.StateStoreCoordinatorRef$;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.internal.StaticSQLConf$;
import org.apache.spark.sql.sources.v2.StreamWriteSupport;
import org.apache.spark.sql.streaming.OutputMode;
import org.apache.spark.sql.streaming.ProcessingTime;
import org.apache.spark.sql.streaming.StreamingQuery;
import org.apache.spark.sql.streaming.StreamingQueryException;
import org.apache.spark.sql.streaming.StreamingQueryListener;
import org.apache.spark.sql.streaming.Trigger;
import org.apache.spark.util.Clock;
import org.apache.spark.util.SystemClock;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.HashMap;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@InterfaceStability.Evolving
@ScalaSignature(bytes="\u0006\u0001\t5f\u0001B\u0001\u0003\u00015\u0011Qc\u0015;sK\u0006l\u0017N\\4Rk\u0016\u0014\u00180T1oC\u001e,'O\u0003\u0002\u0004\t\u0005I1\u000f\u001e:fC6Lgn\u001a\u0006\u0003\u000b\u0019\t1a]9m\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0004\u00019!\u0002CA\b\u0013\u001b\u0005\u0001\"\"A\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0001\"AB!osJ+g\r\u0005\u0002\u001615\taC\u0003\u0002\u0018\r\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002\u001a-\t9Aj\\4hS:<\u0007\u0002C\u000e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000f\u0002\u0019M\u0004\u0018M]6TKN\u001c\u0018n\u001c8\u0011\u0005uqR\"\u0001\u0003\n\u0005}!!\u0001D*qCJ\\7+Z:tS>t\u0007BB\u0011\u0001\t\u0003!!%\u0001\u0004=S:LGO\u0010\u000b\u0003G\u0015\u0002\"\u0001\n\u0001\u000e\u0003\tAQa\u0007\u0011A\u0002qA\u0001b\n\u0001C\u0002\u0013\u0005A\u0001K\u0001\u0016gR\fG/Z*u_J,7i\\8sI&t\u0017\r^8s+\u0005I\u0003C\u0001\u00161\u001b\u0005Y#B\u0001\u0017.\u0003\u0015\u0019H/\u0019;f\u0015\t\u0019aF\u0003\u00020\t\u0005IQ\r_3dkRLwN\\\u0005\u0003c-\u0012\u0001d\u0015;bi\u0016\u001cFo\u001c:f\u0007>|'\u000fZ5oCR|'OU3g\u0011\u0019\u0019\u0004\u0001)A\u0005S\u000512\u000f^1uKN#xN]3D_>\u0014H-\u001b8bi>\u0014\b\u0005C\u00046\u0001\t\u0007I\u0011\u0002\u001c\u0002\u00171L7\u000f^3oKJ\u0014Uo]\u000b\u0002oA\u0011\u0001(O\u0007\u0002[%\u0011!(\f\u0002\u001a'R\u0014X-Y7j]\u001e\fV/\u001a:z\u0019&\u001cH/\u001a8fe\n+8\u000f\u0003\u0004=\u0001\u0001\u0006IaN\u0001\rY&\u001cH/\u001a8fe\n+8\u000f\t\u0005\b}\u0001\u0011\r\u0011\"\u0003@\u00035\t7\r^5wKF+XM]5fgV\t\u0001\t\u0005\u0003B\r\"\u0003V\"\u0001\"\u000b\u0005\r#\u0015aB7vi\u0006\u0014G.\u001a\u0006\u0003\u000bB\t!bY8mY\u0016\u001cG/[8o\u0013\t9%IA\u0004ICNDW*\u00199\u0011\u0005%sU\"\u0001&\u000b\u0005-c\u0015\u0001B;uS2T\u0011!T\u0001\u0005U\u00064\u0018-\u0003\u0002P\u0015\n!Q+V%E!\t!\u0013+\u0003\u0002S\u0005\tq1\u000b\u001e:fC6LgnZ)vKJL\bB\u0002+\u0001A\u0003%\u0001)\u0001\bbGRLg/Z)vKJLWm\u001d\u0011)\tM3\u0006-\u0019\t\u0003/zk\u0011\u0001\u0017\u0006\u00033j\u000b!bY8oGV\u0014(/\u001a8u\u0015\tYF,\u0001\u0006b]:|G/\u0019;j_:T\u0011!X\u0001\u0006U\u00064\u0018\r_\u0005\u0003?b\u0013\u0011bR;be\u0012,GMQ=\u0002\u000bY\fG.^3\"\u0003\t\f\u0011#Y2uSZ,\u0017+^3sS\u0016\u001cHj\\2l\u0011\u001d\u0011\u0007A1A\u0005\n\u0011,\u0012!\u001a\t\u0003M&l\u0011a\u001a\u0006\u0003Q2\u000bA\u0001\\1oO&\u0011!n\u001a\u0002\u0007\u001f\nTWm\u0019;\t\r1\u0004\u0001\u0015!\u0003f\u0003I\t7\r^5wKF+XM]5fg2{7m\u001b\u0011\t\u000f9\u0004!\u0019!C\u0005I\u0006!\u0012m^1jiR+'/\\5oCRLwN\u001c'pG.Da\u0001\u001d\u0001!\u0002\u0013)\u0017!F1xC&$H+\u001a:nS:\fG/[8o\u0019>\u001c7\u000e\t\u0005\be\u0002\u0001\r\u0011\"\u0003t\u0003Ma\u0017m\u001d;UKJl\u0017N\\1uK\u0012\fV/\u001a:z+\u0005\u0001\u0006bB;\u0001\u0001\u0004%IA^\u0001\u0018Y\u0006\u001cH\u000fV3s[&t\u0017\r^3e#V,'/_0%KF$\"a\u001e>\u0011\u0005=A\u0018BA=\u0011\u0005\u0011)f.\u001b;\t\u000fm$\u0018\u0011!a\u0001!\u0006\u0019\u0001\u0010J\u0019\t\ru\u0004\u0001\u0015)\u0003Q\u0003Qa\u0017m\u001d;UKJl\u0017N\\1uK\u0012\fV/\u001a:zA!\"AP\u00161\u0000C\u0005q\u0007bBA\u0002\u0001\u0011\u0005\u0011QA\u0001\u0007C\u000e$\u0018N^3\u0016\u0005\u0005\u001d\u0001\u0003B\b\u0002\nAK1!a\u0003\u0011\u0005\u0015\t%O]1z\u0011\u001d\ty\u0001\u0001C\u0001\u0003#\t1aZ3u)\r\u0001\u00161\u0003\u0005\b\u0003+\ti\u00011\u0001I\u0003\tIG\rC\u0004\u0002\u0010\u0001!\t!!\u0007\u0015\u0007A\u000bY\u0002\u0003\u0005\u0002\u0016\u0005]\u0001\u0019AA\u000f!\u0011\ty\"!\f\u000f\t\u0005\u0005\u0012\u0011\u0006\t\u0004\u0003G\u0001RBAA\u0013\u0015\r\t9\u0003D\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005-\u0002#\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003_\t\tD\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003W\u0001\u0002bBA\u001b\u0001\u0011\u0005\u0011qG\u0001\u0014C^\f\u0017\u000e^!osR+'/\\5oCRLwN\u001c\u000b\u0002o\"2\u00111GA\u001e\u0003\u000f\u0002RaDA\u001f\u0003\u0003J1!a\u0010\u0011\u0005\u0019!\bN]8xgB\u0019A%a\u0011\n\u0007\u0005\u0015#AA\fTiJ,\u0017-\\5oOF+XM]=Fq\u000e,\u0007\u000f^5p]F:a$!\b\u0002J\u0005m\u0014'C\u0012\u0002L\u0005M\u0013\u0011OA++\u0011\ti%a\u0014\u0016\u0005\u0005uAaBA)\u0019\t\u0007\u00111\f\u0002\u0002)&!\u0011QKA,\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%c)\u0019\u0011\u0011\f\t\u0002\rQD'o\\<t#\u0011\ti&a\u0019\u0011\u0007=\ty&C\u0002\u0002bA\u0011qAT8uQ&tw\r\u0005\u0003\u0002f\u0005-dbA\b\u0002h%\u0019\u0011\u0011\u000e\t\u0002\u000fA\f7m[1hK&!\u0011QNA8\u0005%!\u0006N]8xC\ndWMC\u0002\u0002jA\t\u0014bIA:\u0003k\n9(!\u0017\u000f\u0007=\t)(C\u0002\u0002ZA\tTAI\b\u0011\u0003s\u0012Qa]2bY\u0006\f4AJA!\u0011\u001d\t)\u0004\u0001C\u0001\u0003\u007f\"B!!!\u0002\bB\u0019q\"a!\n\u0007\u0005\u0015\u0005CA\u0004C_>dW-\u00198\t\u0011\u0005%\u0015Q\u0010a\u0001\u0003\u0017\u000b\u0011\u0002^5nK>,H/T:\u0011\u0007=\ti)C\u0002\u0002\u0010B\u0011A\u0001T8oO\"2\u0011QPA\u001e\u0003'\u000btAHA\u000f\u0003+\u000bY*M\u0005$\u0003\u0017\n\u0019&a&\u0002VEJ1%a\u001d\u0002v\u0005e\u0015\u0011L\u0019\u0006E=\u0001\u0012\u0011P\u0019\u0004M\u0005\u0005\u0003bBAP\u0001\u0011\u0005\u0011qG\u0001\u0010e\u0016\u001cX\r\u001e+fe6Lg.\u0019;fI\"9\u00111\u0015\u0001\u0005\u0002\u0005\u0015\u0016aC1eI2K7\u000f^3oKJ$2a^AT\u0011!\tI+!)A\u0002\u0005-\u0016\u0001\u00037jgR,g.\u001a:\u0011\u0007\u0011\ni+C\u0002\u00020\n\u0011ac\u0015;sK\u0006l\u0017N\\4Rk\u0016\u0014\u0018\u0010T5ti\u0016tWM\u001d\u0005\b\u0003g\u0003A\u0011AA[\u00039\u0011X-\\8wK2K7\u000f^3oKJ$2a^A\\\u0011!\tI+!-A\u0002\u0005-\u0006\u0002CA^\u0001\u0011\u0005A!!0\u0002#A|7\u000f\u001e'jgR,g.\u001a:Fm\u0016tG\u000fF\u0002x\u0003\u007fC\u0001\"!1\u0002:\u0002\u0007\u00111Y\u0001\u0006KZ,g\u000e\u001e\t\u0005\u0003\u000b\fYMD\u0002%\u0003\u000fL1!!3\u0003\u0003Y\u0019FO]3b[&tw-U;fefd\u0015n\u001d;f]\u0016\u0014\u0018\u0002BAg\u0003\u001f\u0014Q!\u0012<f]RT1!!3\u0003\u0011\u001d\t\u0019\u000e\u0001C\u0005\u0003+\f1b\u0019:fCR,\u0017+^3ssR1\u0012q[Ao\u0003O\fYOa\u0003\u0003\u0016\t}!\u0011\u0006B\u0017\u0005c\u0011Y\u0004E\u00029\u00033L1!a7.\u0005U\u0019FO]3b[&tw-U;fef<&/\u00199qKJD\u0001\"a8\u0002R\u0002\u0007\u0011\u0011]\u0001\u0012kN,'o\u00159fG&4\u0017.\u001a3OC6,\u0007#B\b\u0002d\u0006u\u0011bAAs!\t1q\n\u001d;j_:D\u0001\"!;\u0002R\u0002\u0007\u0011\u0011]\u0001 kN,'o\u00159fG&4\u0017.\u001a3DQ\u0016\u001c7\u000e]8j]RdunY1uS>t\u0007\u0002CAw\u0003#\u0004\r!a<\u0002\u0005\u00114\u0007\u0003BAy\u0005\u000bqA!a=\u0003\u00049!\u0011Q\u001fB\u0001\u001d\u0011\t90a@\u000f\t\u0005e\u0018Q \b\u0005\u0003G\tY0C\u0001\f\u0013\tI!\"\u0003\u0002\b\u0011%\u0011QAB\u0005\u0004\u0003S\"\u0011\u0002\u0002B\u0004\u0005\u0013\u0011\u0011\u0002R1uC\u001a\u0013\u0018-\\3\u000b\u0007\u0005%D\u0001\u0003\u0005\u0003\u000e\u0005E\u0007\u0019\u0001B\b\u00031)\u0007\u0010\u001e:b\u001fB$\u0018n\u001c8t!!\tyB!\u0005\u0002\u001e\u0005u\u0011\u0002\u0002B\n\u0003c\u00111!T1q\u0011!\u00119\"!5A\u0002\te\u0011\u0001B:j].\u00042\u0001\u000fB\u000e\u0013\r\u0011i\"\f\u0002\u0012\u0005\u0006\u001cXm\u0015;sK\u0006l\u0017N\\4TS:\\\u0007\u0002\u0003B\u0011\u0003#\u0004\rAa\t\u0002\u0015=,H\u000f];u\u001b>$W\rE\u0002%\u0005KI1Aa\n\u0003\u0005)yU\u000f\u001e9vi6{G-\u001a\u0005\t\u0005W\t\t\u000e1\u0001\u0002\u0002\u0006IRo]3UK6\u00048\t[3dWB|\u0017N\u001c;M_\u000e\fG/[8o\u0011!\u0011y#!5A\u0002\u0005\u0005\u0015!\b:fG>4XM\u001d$s_6\u001c\u0005.Z2la>Lg\u000e\u001e'pG\u0006$\u0018n\u001c8\t\u0011\tM\u0012\u0011\u001ba\u0001\u0005k\tq\u0001\u001e:jO\u001e,'\u000fE\u0002%\u0005oI1A!\u000f\u0003\u0005\u001d!&/[4hKJD\u0001B!\u0010\u0002R\u0002\u0007!qH\u0001\riJLwmZ3s\u00072|7m\u001b\t\u0005\u0005\u0003\u0012)%\u0004\u0002\u0003D)\u00111JB\u0005\u0005\u0005\u000f\u0012\u0019EA\u0003DY>\u001c7\u000e\u0003\u0005\u0003L\u0001!\t\u0001\u0002B'\u0003)\u0019H/\u0019:u#V,'/\u001f\u000b\u0016!\n=#\u0011\u000bB*\u0005+\u00129F!\u0017\u0003\\\tu#q\fB1\u0011!\tyN!\u0013A\u0002\u0005\u0005\b\u0002CAu\u0005\u0013\u0002\r!!9\t\u0011\u00055(\u0011\na\u0001\u0003_D\u0001B!\u0004\u0003J\u0001\u0007!q\u0002\u0005\t\u0005/\u0011I\u00051\u0001\u0003\u001a!A!\u0011\u0005B%\u0001\u0004\u0011\u0019\u0003\u0003\u0006\u0003,\t%\u0003\u0013!a\u0001\u0003\u0003C!Ba\f\u0003JA\u0005\t\u0019AAA\u0011)\u0011\u0019D!\u0013\u0011\u0002\u0003\u0007!Q\u0007\u0005\u000b\u0005{\u0011I\u0005%AA\u0002\t}\u0002\u0002\u0003B3\u0001\u0011\u0005AAa\u001a\u0002-9|G/\u001b4z#V,'/\u001f+fe6Lg.\u0019;j_:$2a\u001eB5\u0011\u001d\u0011YGa\u0019A\u0002A\u000bq\u0002^3s[&t\u0017\r^3e#V,'/\u001f\u0005\u000b\u0005_\u0002\u0011\u0013!C\u0001\t\tE\u0014\u0001F:uCJ$\u0018+^3ss\u0012\"WMZ1vYR$s'\u0006\u0002\u0003t)\"\u0011\u0011\u0011B;W\t\u00119\b\u0005\u0003\u0003z\t\u0005UB\u0001B>\u0015\u0011\u0011iHa \u0002\u0013Ut7\r[3dW\u0016$'BA.\u0011\u0013\u0011\u0011\u0019Ia\u001f\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r\u0003\u0006\u0003\b\u0002\t\n\u0011\"\u0001\u0005\u0005c\nAc\u001d;beR\fV/\u001a:zI\u0011,g-Y;mi\u0012B\u0004B\u0003BF\u0001E\u0005I\u0011\u0001\u0003\u0003\u000e\u0006!2\u000f^1siF+XM]=%I\u00164\u0017-\u001e7uIe*\"Aa$+\t\tU\"Q\u000f\u0005\u000b\u0005'\u0003\u0011\u0013!C\u0001\t\tU\u0015!F:uCJ$\u0018+^3ss\u0012\"WMZ1vYR$\u0013\u0007M\u000b\u0003\u0005/SCAa\u0010\u0003v!\u001a\u0001Aa'\u0011\t\tu%q\u0015\b\u0005\u0005?\u0013\u0019+\u0004\u0002\u0003\"*\u00111LB\u0005\u0005\u0005K\u0013\t+\u0001\nJ]R,'OZ1dKN#\u0018MY5mSRL\u0018\u0002\u0002BU\u0005W\u0013\u0001\"\u0012<pYZLgn\u001a\u0006\u0005\u0005K\u0013\t\u000b")
public class StreamingQueryManager
implements Logging {
    private final SparkSession sparkSession;
    private final StateStoreCoordinatorRef stateStoreCoordinator;
    private final StreamingQueryListenerBus listenerBus;
    @GuardedBy(value="activeQueriesLock")
    private final HashMap<UUID, StreamingQuery> activeQueries;
    private final Object activeQueriesLock;
    private final Object awaitTerminationLock;
    @GuardedBy(value="awaitTerminationLock")
    private StreamingQuery lastTerminatedQuery;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public StateStoreCoordinatorRef stateStoreCoordinator() {
        return this.stateStoreCoordinator;
    }

    private StreamingQueryListenerBus listenerBus() {
        return this.listenerBus;
    }

    private HashMap<UUID, StreamingQuery> activeQueries() {
        return this.activeQueries;
    }

    private Object activeQueriesLock() {
        return this.activeQueriesLock;
    }

    private Object awaitTerminationLock() {
        return this.awaitTerminationLock;
    }

    private StreamingQuery lastTerminatedQuery() {
        return this.lastTerminatedQuery;
    }

    private void lastTerminatedQuery_$eq(StreamingQuery x$1) {
        this.lastTerminatedQuery = x$1;
    }

    public StreamingQuery[] active() {
        StreamingQuery[] streamingQueryArray;
        Object object = this.activeQueriesLock();
        synchronized (object) {
            streamingQueryArray = (StreamingQuery[])this.activeQueries().values().toArray(ClassTag$.MODULE$.apply(StreamingQuery.class));
        }
        return streamingQueryArray;
    }

    public StreamingQuery get(UUID id) {
        StreamingQuery streamingQuery;
        Object object = this.activeQueriesLock();
        synchronized (object) {
            streamingQuery = (StreamingQuery)this.activeQueries().get((Object)id).orNull(Predef$.MODULE$.$conforms());
        }
        return streamingQuery;
    }

    public StreamingQuery get(String id) {
        return this.get(UUID.fromString(id));
    }

    public void awaitAnyTermination() throws StreamingQueryException {
        Object object = this.awaitTerminationLock();
        synchronized (object) {
            while (this.lastTerminatedQuery() == null) {
                this.awaitTerminationLock().wait(10L);
            }
            if (this.lastTerminatedQuery() != null && this.lastTerminatedQuery().exception().nonEmpty()) {
                throw (Throwable)this.lastTerminatedQuery().exception().get();
            }
        }
    }

    public boolean awaitAnyTermination(long timeoutMs) throws StreamingQueryException {
        boolean bl;
        long startTime = System.currentTimeMillis();
        Object object = this.awaitTerminationLock();
        synchronized (object) {
            while (!StreamingQueryManager.isTimedout$1(timeoutMs, startTime) && this.lastTerminatedQuery() == null) {
                this.awaitTerminationLock().wait(10L);
            }
            if (this.lastTerminatedQuery() != null && this.lastTerminatedQuery().exception().nonEmpty()) {
                throw (Throwable)this.lastTerminatedQuery().exception().get();
            }
            bl = this.lastTerminatedQuery() != null;
        }
        return bl;
    }

    public void resetTerminated() {
        Object object = this.awaitTerminationLock();
        synchronized (object) {
            this.lastTerminatedQuery_$eq(null);
        }
    }

    public void addListener(StreamingQueryListener listener) {
        this.listenerBus().addListener(listener);
    }

    public void removeListener(StreamingQueryListener listener) {
        this.listenerBus().removeListener(listener);
    }

    public void postListenerEvent(StreamingQueryListener.Event event) {
        this.listenerBus().post(event);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private StreamingQueryWrapper createQuery(Option<String> userSpecifiedName, Option<String> userSpecifiedCheckpointLocation, Dataset<Row> df, Map<String, String> extraOptions, BaseStreamingSink sink, OutputMode outputMode, boolean useTempCheckpointLocation, boolean recoverFromCheckpointLocation, Trigger trigger, Clock triggerClock) {
        Tuple2 tuple2;
        Path checkpointPath;
        FileSystem fs;
        BooleanRef deleteCheckpointOnStop = BooleanRef.create((boolean)false);
        String checkpointLocation = (String)userSpecifiedCheckpointLocation.map((Function1 & Serializable & scala.Serializable)userSpecified -> new Path(userSpecified).toUri().toString()).orElse((Function0 & Serializable & scala.Serializable)() -> df.sparkSession().sessionState().conf().checkpointLocation().map((Function1 & Serializable & scala.Serializable)location -> new Path(location, (String)userSpecifiedName.getOrElse((Function0 & Serializable & scala.Serializable)() -> UUID.randomUUID().toString())).toUri().toString())).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            if (!useTempCheckpointLocation) {
                throw new AnalysisException(new StringBuilder(89).append("checkpointLocation must be specified either through option(\"checkpointLocation\", ...) or ").append(new StringBuilder(30).append("SparkSession.conf.set(\"").append(SQLConf$.MODULE$.CHECKPOINT_LOCATION().key()).append("\", ...)").toString()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            deleteCheckpointOnStop$1.elem = true;
            String x$3 = "temporary";
            String x$4 = Utils$.MODULE$.createTempDir$default$1();
            return Utils$.MODULE$.createTempDir(x$4, x$3).getCanonicalPath();
        });
        if (!recoverFromCheckpointLocation && (fs = (checkpointPath = new Path(checkpointLocation, "offsets")).getFileSystem(df.sparkSession().sessionState().newHadoopConf())).exists(checkpointPath)) {
            throw new AnalysisException(new StringBuilder(65).append("This query does not support recovering from checkpoint location. ").append(new StringBuilder(22).append("Delete ").append(checkpointPath).append(" to start over.").toString()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        LogicalPlan analyzedPlan = df.queryExecution().analyzed();
        df.queryExecution().assertAnalyzed();
        if (this.sparkSession.sessionState().conf().isUnsupportedOperationCheckEnabled()) {
            UnsupportedOperationChecker$.MODULE$.checkForStreaming(analyzedPlan, outputMode);
        }
        if (this.sparkSession.sessionState().conf().adaptiveExecutionEnabled()) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(72).append(SQLConf$.MODULE$.ADAPTIVE_EXECUTION_ENABLED().key()).append(" ").append("is not supported in streaming DataFrames/Datasets and will be disabled.").toString());
        }
        if ((tuple2 = new Tuple2((Object)sink, (Object)trigger)) == null) return new StreamingQueryWrapper(new MicroBatchExecution(this.sparkSession, (String)userSpecifiedName.orNull(Predef$.MODULE$.$conforms()), checkpointLocation, analyzedPlan, sink, trigger, triggerClock, outputMode, extraOptions, deleteCheckpointOnStop.elem));
        BaseStreamingSink v2Sink = (BaseStreamingSink)tuple2._1();
        Trigger trigger2 = (Trigger)tuple2._2();
        if (!(v2Sink instanceof StreamWriteSupport)) return new StreamingQueryWrapper(new MicroBatchExecution(this.sparkSession, (String)userSpecifiedName.orNull(Predef$.MODULE$.$conforms()), checkpointLocation, analyzedPlan, sink, trigger, triggerClock, outputMode, extraOptions, deleteCheckpointOnStop.elem));
        StreamWriteSupport streamWriteSupport = (StreamWriteSupport)v2Sink;
        if (!(trigger2 instanceof ContinuousTrigger)) return new StreamingQueryWrapper(new MicroBatchExecution(this.sparkSession, (String)userSpecifiedName.orNull(Predef$.MODULE$.$conforms()), checkpointLocation, analyzedPlan, sink, trigger, triggerClock, outputMode, extraOptions, deleteCheckpointOnStop.elem));
        ContinuousTrigger continuousTrigger = (ContinuousTrigger)trigger2;
        if (!this.sparkSession.sessionState().conf().isUnsupportedOperationCheckEnabled()) return new StreamingQueryWrapper(new ContinuousExecution(this.sparkSession, (String)userSpecifiedName.orNull(Predef$.MODULE$.$conforms()), checkpointLocation, analyzedPlan, streamWriteSupport, continuousTrigger, triggerClock, outputMode, extraOptions, deleteCheckpointOnStop.elem));
        UnsupportedOperationChecker$.MODULE$.checkForContinuous(analyzedPlan, outputMode);
        return new StreamingQueryWrapper(new ContinuousExecution(this.sparkSession, (String)userSpecifiedName.orNull(Predef$.MODULE$.$conforms()), checkpointLocation, analyzedPlan, streamWriteSupport, continuousTrigger, triggerClock, outputMode, extraOptions, deleteCheckpointOnStop.elem));
    }

    public StreamingQuery startQuery(Option<String> userSpecifiedName, Option<String> userSpecifiedCheckpointLocation, Dataset<Row> df, Map<String, String> extraOptions, BaseStreamingSink sink, OutputMode outputMode, boolean useTempCheckpointLocation, boolean recoverFromCheckpointLocation, Trigger trigger, Clock triggerClock) {
        StreamingQueryWrapper query = this.createQuery(userSpecifiedName, userSpecifiedCheckpointLocation, df, extraOptions, sink, outputMode, useTempCheckpointLocation, recoverFromCheckpointLocation, trigger, triggerClock);
        Object object = this.activeQueriesLock();
        synchronized (object) {
            userSpecifiedName.foreach((Function1 & Serializable & scala.Serializable)name -> {
                StreamingQueryManager.$anonfun$startQuery$1(this, name);
                return BoxedUnit.UNIT;
            });
            if (this.activeQueries().values().exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)StreamingQueryManager.$anonfun$startQuery$3(query, x$2)))) {
                throw new IllegalStateException(new StringBuilder(162).append("Cannot start query with id ").append(query.id()).append(" as another query with same id is ").append("already active. Perhaps you are attempting to restart a query from checkpoint ").append("that is already active.").toString());
            }
            this.activeQueries().put((Object)query.id(), (Object)query);
        }
        try {
            query.streamingQuery().start();
        }
        catch (Throwable e) {
            Object object2 = this.activeQueriesLock();
            synchronized (object2) {
                this.activeQueries().$minus$eq((Object)query.id());
            }
            throw e;
        }
        return query;
    }

    public boolean startQuery$default$7() {
        return false;
    }

    public boolean startQuery$default$8() {
        return true;
    }

    public Trigger startQuery$default$9() {
        return new ProcessingTime(0L);
    }

    public Clock startQuery$default$10() {
        return new SystemClock();
    }

    public void notifyQueryTermination(StreamingQuery terminatedQuery) {
        Object object = this.activeQueriesLock();
        synchronized (object) {
            this.activeQueries().$minus$eq((Object)terminatedQuery.id());
        }
        Object object2 = this.awaitTerminationLock();
        synchronized (object2) {
            if (this.lastTerminatedQuery() == null || terminatedQuery.exception().nonEmpty()) {
                this.lastTerminatedQuery_$eq(terminatedQuery);
            }
            this.awaitTerminationLock().notifyAll();
        }
        this.stateStoreCoordinator().deactivateInstances(terminatedQuery.runId());
    }

    public static final /* synthetic */ void $anonfun$new$2(StreamingQueryManager $this, StreamingQueryListener listener) {
        $this.addListener(listener);
        $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Registered listener ").append(listener.getClass().getName()).toString());
    }

    public static final /* synthetic */ void $anonfun$new$1(StreamingQueryManager $this, Seq classNames) {
        Utils$.MODULE$.loadExtensions(StreamingQueryListener.class, classNames, $this.sparkSession.sparkContext().conf()).foreach((Function1 & Serializable & scala.Serializable)listener -> {
            StreamingQueryManager.$anonfun$new$2($this, listener);
            return BoxedUnit.UNIT;
        });
    }

    private static final boolean isTimedout$1(long timeoutMs$1, long startTime$1) {
        return System.currentTimeMillis() - startTime$1 >= timeoutMs$1;
    }

    public static final /* synthetic */ boolean $anonfun$startQuery$2(String name$1, StreamingQuery x$1) {
        String string = x$1.name();
        String string2 = name$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$startQuery$1(StreamingQueryManager $this, String name) {
        if ($this.activeQueries().values().exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)StreamingQueryManager.$anonfun$startQuery$2(name, x$1)))) {
            throw new IllegalArgumentException(new StringBuilder(73).append("Cannot start query with name ").append(name).append(" as a query with that name is already active").toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$startQuery$3(StreamingQueryWrapper query$1, StreamingQuery x$2) {
        UUID uUID = x$2.id();
        UUID uUID2 = query$1.id();
        return !(uUID != null ? !((Object)uUID).equals(uUID2) : uUID2 != null);
    }

    public StreamingQueryManager(SparkSession sparkSession) {
        this.sparkSession = sparkSession;
        Logging.$init$((Logging)this);
        this.stateStoreCoordinator = StateStoreCoordinatorRef$.MODULE$.forDriver(sparkSession.sparkContext().env());
        this.listenerBus = new StreamingQueryListenerBus(sparkSession.sparkContext().listenerBus());
        this.activeQueries = new HashMap();
        this.activeQueriesLock = new Object();
        this.awaitTerminationLock = new Object();
        this.lastTerminatedQuery = null;
        try {
            ((Option)sparkSession.sparkContext().conf().get((ConfigEntry)StaticSQLConf$.MODULE$.STREAMING_QUERY_LISTENERS())).foreach((Function1 & Serializable & scala.Serializable)classNames -> {
                StreamingQueryManager.$anonfun$new$1(this, classNames);
                return BoxedUnit.UNIT;
            });
        }
        catch (Exception e) {
            throw new SparkException("Exception when registering StreamingQueryListener", (Throwable)e);
        }
    }
}

