/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.expressions;

import java.io.Serializable;
import org.apache.spark.annotation.InterfaceStability;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Column$;
import org.apache.spark.sql.catalyst.expressions.Ascending$;
import org.apache.spark.sql.catalyst.expressions.CurrentRow$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.FrameType;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.RangeFrame$;
import org.apache.spark.sql.catalyst.expressions.RowFrame$;
import org.apache.spark.sql.catalyst.expressions.SortDirection;
import org.apache.spark.sql.catalyst.expressions.SortOrder;
import org.apache.spark.sql.catalyst.expressions.SortOrder$;
import org.apache.spark.sql.catalyst.expressions.SpecifiedWindowFrame;
import org.apache.spark.sql.catalyst.expressions.UnboundedFollowing$;
import org.apache.spark.sql.catalyst.expressions.UnboundedPreceding$;
import org.apache.spark.sql.catalyst.expressions.WindowExpression;
import org.apache.spark.sql.catalyst.expressions.WindowFrame;
import org.apache.spark.sql.catalyst.expressions.WindowSpecDefinition;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@InterfaceStability.Stable
@ScalaSignature(bytes="\u0006\u0001\u0005\u001db\u0001B\u0001\u0003\u00015\u0011!bV5oI><8\u000b]3d\u0015\t\u0019A!A\u0006fqB\u0014Xm]:j_:\u001c(BA\u0003\u0007\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u00011C\u0001\u0001\u000f!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fM\"AQ\u0003\u0001B\u0001B\u0003%a#A\u0007qCJ$\u0018\u000e^5p]N\u0003Xm\u0019\t\u0004/}\u0011cB\u0001\r\u001e\u001d\tIB$D\u0001\u001b\u0015\tYB\"\u0001\u0004=e>|GOP\u0005\u0002#%\u0011a\u0004E\u0001\ba\u0006\u001c7.Y4f\u0013\t\u0001\u0013EA\u0002TKFT!A\b\t\u0011\u0005\r:S\"\u0001\u0013\u000b\u0005\r)#B\u0001\u0014\u0005\u0003!\u0019\u0017\r^1msN$\u0018B\u0001\u0015%\u0005))\u0005\u0010\u001d:fgNLwN\u001c\u0005\tU\u0001\u0011\t\u0011)A\u0005W\u0005IqN\u001d3feN\u0003Xm\u0019\t\u0004/}a\u0003CA\u0012.\u0013\tqCEA\u0005T_J$xJ\u001d3fe\"A\u0001\u0007\u0001B\u0001B\u0003%\u0011'A\u0003ge\u0006lW\r\u0005\u0002$e%\u00111\u0007\n\u0002\f/&tGm\\<Ge\u0006lW\r\u0003\u00046\u0001\u0011\u0005AAN\u0001\u0007y%t\u0017\u000e\u001e \u0015\t]J$h\u000f\t\u0003q\u0001i\u0011A\u0001\u0005\u0006+Q\u0002\rA\u0006\u0005\u0006UQ\u0002\ra\u000b\u0005\u0006aQ\u0002\r!\r\u0005\u0006{\u0001!\tAP\u0001\fa\u0006\u0014H/\u001b;j_:\u0014\u0015\u0010F\u00028\u007f%CQ\u0001\u0011\u001fA\u0002\u0005\u000bqaY8m\u001d\u0006lW\r\u0005\u0002C\r:\u00111\t\u0012\t\u00033AI!!\u0012\t\u0002\rA\u0013X\rZ3g\u0013\t9\u0005J\u0001\u0004TiJLgn\u001a\u0006\u0003\u000bBAQA\u0013\u001fA\u0002-\u000b\u0001bY8m\u001d\u0006lWm\u001d\t\u0004\u001f1\u000b\u0015BA'\u0011\u0005)a$/\u001a9fCR,GM\u0010\u0015\u0003y=\u0003\"\u0001U*\u000e\u0003ES!A\u0015\t\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002U#\n9a/\u0019:be\u001e\u001c\b\"B\u001f\u0001\t\u00031FCA\u001cX\u0011\u0015AV\u000b1\u0001Z\u0003\u0011\u0019w\u000e\\:\u0011\u0007=a%\f\u0005\u0002\\96\tA!\u0003\u0002^\t\t11i\u001c7v[:D#!V(\t\u000b\u0001\u0004A\u0011A1\u0002\u000f=\u0014H-\u001a:CsR\u0019qGY2\t\u000b\u0001{\u0006\u0019A!\t\u000b){\u0006\u0019A&)\u0005}{\u0005\"\u00021\u0001\t\u00031GCA\u001ch\u0011\u0015AV\r1\u0001ZQ\t)w\nC\u0003k\u0001\u0011\u00051.A\u0006s_^\u001c()\u001a;xK\u0016tGcA\u001cmc\")Q.\u001ba\u0001]\u0006)1\u000f^1siB\u0011qb\\\u0005\u0003aB\u0011A\u0001T8oO\")!/\u001ba\u0001]\u0006\u0019QM\u001c3\t\u000bQ\u0004A\u0011A;\u0002\u0019I\fgnZ3CKR<X-\u001a8\u0015\u0007]2x\u000fC\u0003ng\u0002\u0007a\u000eC\u0003sg\u0002\u0007a\u000eC\u0003u\u0001\u0011\u0005\u0011\u0010F\u00028unDQ!\u001c=A\u0002iCQA\u001d=A\u0002iCc\u0001_?\u0002\u0002\u0005\u0015\u0001CA\b\u007f\u0013\ty\bC\u0001\u0006eKB\u0014XmY1uK\u0012\f#!a\u0001\u0002SU\u001bX\r\t;iK\u00022XM]:j_:\u0004s/\u001b;iA1{gn\u001a\u0011qCJ\fW.\u001a;fe\u0002\"\u0018\u0010]3tC\t\t9!A\u00033]Qr\u0003\u0007\u0003\u0005\u0002\f\u0001!\t\u0001BA\u0007\u000359\u0018\u000e\u001e5BO\u001e\u0014XmZ1uKR\u0019!,a\u0004\t\u000f\u0005E\u0011\u0011\u0002a\u00015\u0006I\u0011mZ4sK\u001e\fG/\u001a\u0015\u0004\u0001\u0005U\u0001\u0003BA\f\u0003CqA!!\u0007\u0002\u001e5\u0011\u00111\u0004\u0006\u0003%\u001aIA!a\b\u0002\u001c\u0005\u0011\u0012J\u001c;fe\u001a\f7-Z*uC\nLG.\u001b;z\u0013\u0011\t\u0019#!\n\u0003\rM#\u0018M\u00197f\u0015\u0011\ty\"a\u0007")
public class WindowSpec {
    private final Seq<Expression> partitionSpec;
    private final Seq<SortOrder> orderSpec;
    private final WindowFrame frame;

    public WindowSpec partitionBy(String colName, String ... colNames) {
        return this.partitionBy(colName, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colNames));
    }

    public WindowSpec partitionBy(Column ... cols) {
        return this.partitionBy((Seq<Column>)Predef$.MODULE$.wrapRefArray((Object[])cols));
    }

    public WindowSpec orderBy(String colName, String ... colNames) {
        return this.orderBy(colName, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colNames));
    }

    public WindowSpec orderBy(Column ... cols) {
        return this.orderBy((Seq<Column>)Predef$.MODULE$.wrapRefArray((Object[])cols));
    }

    public WindowSpec partitionBy(String colName, Seq<String> colNames) {
        String string = colName;
        return this.partitionBy((Seq<Column>)((Seq)((TraversableLike)colNames.$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$2 -> Column$.MODULE$.apply((String)x$2), Seq$.MODULE$.canBuildFrom())));
    }

    public WindowSpec partitionBy(Seq<Column> cols) {
        return new WindowSpec((Seq<Expression>)((Seq)cols.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.expr(), Seq$.MODULE$.canBuildFrom())), this.orderSpec, this.frame);
    }

    public WindowSpec orderBy(String colName, Seq<String> colNames) {
        String string = colName;
        return this.orderBy((Seq<Column>)((Seq)((TraversableLike)colNames.$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$5 -> Column$.MODULE$.apply((String)x$5), Seq$.MODULE$.canBuildFrom())));
    }

    public WindowSpec orderBy(Seq<Column> cols) {
        Seq sortOrder = (Seq)cols.map((Function1 & Serializable & scala.Serializable)col -> {
            SortOrder sortOrder;
            Expression expression = col.expr();
            if (expression instanceof SortOrder) {
                SortOrder sortOrder2;
                sortOrder = sortOrder2 = (SortOrder)expression;
            } else if (expression != null) {
                Expression expression2 = expression;
                sortOrder = SortOrder$.MODULE$.apply(expression2, (SortDirection)Ascending$.MODULE$, SortOrder$.MODULE$.apply$default$3());
            } else {
                throw new MatchError((Object)expression);
            }
            return sortOrder;
        }, Seq$.MODULE$.canBuildFrom());
        return new WindowSpec(this.partitionSpec, (Seq<SortOrder>)sortOrder, this.frame);
    }

    public WindowSpec rowsBetween(long start, long end) {
        CurrentRow$ currentRow$;
        CurrentRow$ currentRow$2;
        long l = start;
        if (0L == l) {
            currentRow$2 = CurrentRow$.MODULE$;
        } else if (Long.MIN_VALUE == l) {
            currentRow$2 = UnboundedPreceding$.MODULE$;
        } else if (Integer.MIN_VALUE <= l && l <= Integer.MAX_VALUE) {
            currentRow$2 = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)((int)l)));
        } else {
            throw new AnalysisException(new StringBuilder(39).append("Boundary start is not a valid integer: ").append(l).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        CurrentRow$ boundaryStart = currentRow$2;
        long l2 = end;
        if (0L == l2) {
            currentRow$ = CurrentRow$.MODULE$;
        } else if (Long.MAX_VALUE == l2) {
            currentRow$ = UnboundedFollowing$.MODULE$;
        } else if (Integer.MIN_VALUE <= l2 && l2 <= Integer.MAX_VALUE) {
            currentRow$ = Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)((int)l2)));
        } else {
            throw new AnalysisException(new StringBuilder(37).append("Boundary end is not a valid integer: ").append(l2).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        CurrentRow$ boundaryEnd = currentRow$;
        return new WindowSpec(this.partitionSpec, this.orderSpec, (WindowFrame)new SpecifiedWindowFrame((FrameType)RowFrame$.MODULE$, (Expression)boundaryStart, (Expression)boundaryEnd));
    }

    public WindowSpec rangeBetween(long start, long end) {
        long l = start;
        Object object = 0L == l ? CurrentRow$.MODULE$ : (Long.MIN_VALUE == l ? UnboundedPreceding$.MODULE$ : Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)l)));
        CurrentRow$ boundaryStart = object;
        long l2 = end;
        Object object2 = 0L == l2 ? CurrentRow$.MODULE$ : (Long.MAX_VALUE == l2 ? UnboundedFollowing$.MODULE$ : Literal$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)l2)));
        CurrentRow$ boundaryEnd = object2;
        return new WindowSpec(this.partitionSpec, this.orderSpec, (WindowFrame)new SpecifiedWindowFrame((FrameType)RangeFrame$.MODULE$, (Expression)boundaryStart, (Expression)boundaryEnd));
    }

    public WindowSpec rangeBetween(Column start, Column end) {
        return new WindowSpec(this.partitionSpec, this.orderSpec, (WindowFrame)new SpecifiedWindowFrame((FrameType)RangeFrame$.MODULE$, start.expr(), end.expr()));
    }

    public Column withAggregate(Column aggregate) {
        WindowSpecDefinition spec = new WindowSpecDefinition(this.partitionSpec, this.orderSpec, this.frame);
        return new Column((Expression)new WindowExpression(aggregate.expr(), spec));
    }

    public WindowSpec(Seq<Expression> partitionSpec, Seq<SortOrder> orderSpec, WindowFrame frame) {
        this.partitionSpec = partitionSpec;
        this.orderSpec = orderSpec;
        this.frame = frame;
    }
}

