/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.streaming;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ConcurrentModificationException;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.streaming.CheckpointFileManager;
import org.apache.spark.sql.execution.streaming.CheckpointFileManager$;
import org.apache.spark.sql.execution.streaming.HDFSMetadataLog$;
import org.apache.spark.sql.execution.streaming.MetadataLog;
import org.json4s.Formats;
import org.json4s.NoTypeHints$;
import org.json4s.TypeHints;
import org.json4s.jackson.Serialization$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.StringOps$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t5b\u0001B\u0001\u0003\u0001=\u0011q\u0002\u0013#G'6+G/\u00193bi\u0006dun\u001a\u0006\u0003\u0007\u0011\t\u0011b\u001d;sK\u0006l\u0017N\\4\u000b\u0005\u00151\u0011!C3yK\u000e,H/[8o\u0015\t9\u0001\"A\u0002tc2T!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001+\t\u0001Rd\u0005\u0003\u0001#]\u0019\u0003C\u0001\n\u0016\u001b\u0005\u0019\"\"\u0001\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u0019\"AB!osJ+g\rE\u0002\u00193mi\u0011AA\u0005\u00035\t\u00111\"T3uC\u0012\fG/\u0019'pOB\u0011A$\b\u0007\u0001\t\u0015q\u0002A1\u0001 \u0005\u0005!\u0016C\u0001\u0011\u0012!\t\u0011\u0012%\u0003\u0002#'\t9aj\u001c;iS:<\u0007C\u0001\u0013(\u001b\u0005)#B\u0001\u0014\t\u0003!Ig\u000e^3s]\u0006d\u0017B\u0001\u0015&\u0005\u001daunZ4j]\u001eD\u0001B\u000b\u0001\u0003\u0002\u0003\u0006IaK\u0001\rgB\f'o[*fgNLwN\u001c\t\u0003Y5j\u0011AB\u0005\u0003]\u0019\u0011Ab\u00159be.\u001cVm]:j_:D\u0001\u0002\r\u0001\u0003\u0002\u0003\u0006I!M\u0001\u0005a\u0006$\b\u000e\u0005\u00023s9\u00111g\u000e\t\u0003iMi\u0011!\u000e\u0006\u0003m9\ta\u0001\u0010:p_Rt\u0014B\u0001\u001d\u0014\u0003\u0019\u0001&/\u001a3fM&\u0011!h\u000f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005a\u001a\u0002\u0002C\u001f\u0001\u0005\u0007\u0005\u000b1\u0002 \u0002\u0015\u00154\u0018\u000eZ3oG\u0016$\u0013\u0007E\u0002@\u0005ni\u0011\u0001\u0011\u0006\u0003\u0003N\tqA]3gY\u0016\u001cG/\u0003\u0002D\u0001\nA1\t\\1tgR\u000bw\rC\u0003F\u0001\u0011\u0005a)\u0001\u0004=S:LGO\u0010\u000b\u0004\u000f*[EC\u0001%J!\rA\u0002a\u0007\u0005\u0006{\u0011\u0003\u001dA\u0010\u0005\u0006U\u0011\u0003\ra\u000b\u0005\u0006a\u0011\u0003\r!\r\u0005\b\u001b\u0002\u0011\r\u0011b\u0003O\u0003\u001d1wN]7biN,\u0012a\u0014\n\u0004!F9f\u0001B)\u0001\u0001=\u0013A\u0002\u0010:fM&tW-\\3oizJ!!T*\n\u0005Q+&!D*fe&\fG.\u001b>bi&|gN\u0003\u0002W\u0019\u00051!n]8oiM\u0004\"\u0001W-\u000e\u0003UK!AW+\u0003\u000f\u0019{'/\\1ug\"9A\f\u0015b\u0001\n\u0003i\u0016A\u00033bi\u00164uN]7biV\ta\f\u0005\u0002Y?&\u0011\u0001-\u0016\u0002\u000b\t\u0006$XMR8s[\u0006$\bb\u00022Q\u0005\u0004%\teY\u0001\nif\u0004X\rS5oiN,\u0012\u0001\u001a\t\u00031\u0016L!AZ+\u0003\u0013QK\b/\u001a%j]R\u001c\bB\u00025\u0001A\u0003%q*\u0001\u0005g_Jl\u0017\r^:!\u0011\u001dQ\u0007A1A\u0005\f-\f\u0001\"\\1oS\u001a,7\u000f^\u000b\u0002YB\u0019q(\\\u000e\n\u00059\u0004%\u0001C'b]&4Wm\u001d;\t\rA\u0004\u0001\u0015!\u0003m\u0003%i\u0017M\\5gKN$\b\u0005C\u0004s\u0001\t\u0007I\u0011A:\u0002\u00195,G/\u00193bi\u0006\u0004\u0016\r\u001e5\u0016\u0003Q\u0004\"!\u001e>\u000e\u0003YT!a\u001e=\u0002\u0005\u0019\u001c(BA=\u000b\u0003\u0019A\u0017\rZ8pa&\u00111P\u001e\u0002\u0005!\u0006$\b\u000e\u0003\u0004~\u0001\u0001\u0006I\u0001^\u0001\u000e[\u0016$\u0018\rZ1uCB\u000bG\u000f\u001b\u0011\t\u0011}\u0004!\u0019!C\t\u0003\u0003\t1BZ5mK6\u000bg.Y4feV\u0011\u00111\u0001\t\u00041\u0005\u0015\u0011bAA\u0004\u0005\t)2\t[3dWB|\u0017N\u001c;GS2,W*\u00198bO\u0016\u0014\b\u0002CA\u0006\u0001\u0001\u0006I!a\u0001\u0002\u0019\u0019LG.Z'b]\u0006<WM\u001d\u0011\t\u0013\u0005=\u0001A1A\u0005\u0012\u0005E\u0011\u0001\u00052bi\u000eDg)\u001b7fg\u001aKG\u000e^3s+\t\t\u0019B\u0005\u0004\u0002\u0016\u0005m\u00111\u0006\u0004\u0007#\u0006]\u0001!a\u0005\t\u0011\u0005e\u0001\u0001)A\u0005\u0003'\t\u0011CY1uG\"4\u0015\u000e\\3t\r&dG/\u001a:!!\u0011\ti\"a\n\u000e\u0005\u0005}!\u0002BA\u0011\u0003G\tA\u0001\\1oO*\u0011\u0011QE\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002*\u0005}!AB(cU\u0016\u001cG\u000fE\u0002v\u0003[I1!a\fw\u0005)\u0001\u0016\r\u001e5GS2$XM\u001d\u0005\b\u0003g\u0001A\u0011CA\u001b\u00035\u0011\u0017\r^2i\u0013\u0012$v\u000eU1uQR\u0019A/a\u000e\t\u0011\u0005e\u0012\u0011\u0007a\u0001\u0003w\tqAY1uG\"LE\rE\u0002\u0013\u0003{I1!a\u0010\u0014\u0005\u0011auN\\4\t\u000f\u0005\r\u0003\u0001\"\u0005\u0002F\u0005i\u0001/\u0019;i)>\u0014\u0015\r^2i\u0013\u0012$B!a\u000f\u0002H!1\u0001'!\u0011A\u0002QDq!a\u0013\u0001\t#\ti%A\u0006jg\n\u000bGo\u00195GS2,G\u0003BA(\u0003+\u00022AEA)\u0013\r\t\u0019f\u0005\u0002\b\u0005>|G.Z1o\u0011\u0019\u0001\u0014\u0011\na\u0001i\"9\u0011\u0011\f\u0001\u0005\u0012\u0005m\u0013!C:fe&\fG.\u001b>f)\u0019\ti&a\u0019\u0002hA\u0019!#a\u0018\n\u0007\u0005\u00054C\u0001\u0003V]&$\bbBA3\u0003/\u0002\raG\u0001\t[\u0016$\u0018\rZ1uC\"A\u0011\u0011NA,\u0001\u0004\tY'A\u0002pkR\u0004B!!\u001c\u0002t5\u0011\u0011q\u000e\u0006\u0005\u0003c\n\u0019#\u0001\u0002j_&!\u0011QOA8\u00051yU\u000f\u001e9viN#(/Z1n\u0011\u001d\tI\b\u0001C\t\u0003w\n1\u0002Z3tKJL\u0017\r\\5{KR\u00191$! \t\u0011\u0005}\u0014q\u000fa\u0001\u0003\u0003\u000b!!\u001b8\u0011\t\u00055\u00141Q\u0005\u0005\u0003\u000b\u000byGA\u0006J]B,Ho\u0015;sK\u0006l\u0007bBAE\u0001\u0011\u0005\u00131R\u0001\u0004C\u0012$GCBA(\u0003\u001b\u000by\t\u0003\u0005\u0002:\u0005\u001d\u0005\u0019AA\u001e\u0011\u001d\t)'a\"A\u0002mAq!a%\u0001\t\u0013\t)*\u0001\txe&$XMQ1uG\"$vNR5mKR1\u0011QLAL\u00033Cq!!\u001a\u0002\u0012\u0002\u00071\u0004\u0003\u00041\u0003#\u0003\r\u0001\u001e\u0005\b\u0003;\u0003A\u0011IAP\u0003\r9W\r\u001e\u000b\u0005\u0003C\u000b9\u000b\u0005\u0003\u0013\u0003G[\u0012bAAS'\t1q\n\u001d;j_:D\u0001\"!\u000f\u0002\u001c\u0002\u0007\u00111\b\u0005\b\u0003;\u0003A\u0011IAV)\u0019\ti+!/\u0002@B)!#a,\u00024&\u0019\u0011\u0011W\n\u0003\u000b\u0005\u0013(/Y=\u0011\rI\t),a\u000f\u001c\u0013\r\t9l\u0005\u0002\u0007)V\u0004H.\u001a\u001a\t\u0011\u0005m\u0016\u0011\u0016a\u0001\u0003{\u000bqa\u001d;beRLE\rE\u0003\u0013\u0003G\u000bY\u0004\u0003\u0005\u0002B\u0006%\u0006\u0019AA_\u0003\u0015)g\u000eZ%e\u0011\u001d\t)\r\u0001C!\u0003\u000f\f\u0011bZ3u\u0019\u0006$Xm\u001d;\u0015\u0005\u0005%\u0007#\u0002\n\u0002$\u0006M\u0006bBAg\u0001\u0011\u0005\u0011qZ\u0001\u0015O\u0016$xJ\u001d3fe\u0016$')\u0019;dQ\u001aKG.Z:\u0015\u0005\u0005E\u0007#\u0002\n\u00020\u0006M\u0007cA;\u0002V&\u0019\u0011q\u001b<\u0003\u0015\u0019KG.Z*uCR,8\u000fC\u0004\u0002\\\u0002!\t%!8\u0002\u000bA,(oZ3\u0015\t\u0005u\u0013q\u001c\u0005\t\u0003C\fI\u000e1\u0001\u0002<\u0005\u0001B\u000f\u001b:fg\"|G\u000e\u001a\"bi\u000eD\u0017\n\u001a\u0005\b\u0003K\u0004A\u0011AAt\u0003)\u0001XO]4f\u0003\u001a$XM\u001d\u000b\u0005\u0003;\nI\u000f\u0003\u0005\u0002b\u0006\r\b\u0019AA\u001e\u0011!\ti\u000f\u0001C\u0001\r\u0005=\u0018\u0001\u00049beN,g+\u001a:tS>tGCBAy\u0003o\fY\u0010E\u0002\u0013\u0003gL1!!>\u0014\u0005\rIe\u000e\u001e\u0005\b\u0003s\fY\u000f1\u00012\u0003\u0011!X\r\u001f;\t\u0011\u0005u\u00181\u001ea\u0001\u0003c\f1#\\1y'V\u0004\bo\u001c:uK\u00124VM]:j_:<qA!\u0001\u0003\u0011\u0003\u0011\u0019!A\bI\t\u001a\u001bV*\u001a;bI\u0006$\u0018\rT8h!\rA\"Q\u0001\u0004\u0007\u0003\tA\tAa\u0002\u0014\u0007\t\u0015\u0011\u0003C\u0004F\u0005\u000b!\tAa\u0003\u0015\u0005\t\r\u0001\u0002\u0003B\b\u0005\u000b!\tA!\u0005\u0002\u001dY,'/\u001b4z\u0005\u0006$8\r[%egRA\u0011Q\fB\n\u0005S\u0011Y\u0003\u0003\u0005\u0003\u0016\t5\u0001\u0019\u0001B\f\u0003!\u0011\u0017\r^2i\u0013\u0012\u001c\bC\u0002B\r\u0005G\tYD\u0004\u0003\u0003\u001c\t}ab\u0001\u001b\u0003\u001e%\tA#C\u0002\u0003\"M\tq\u0001]1dW\u0006<W-\u0003\u0003\u0003&\t\u001d\"aA*fc*\u0019!\u0011E\n\t\u0011\u0005m&Q\u0002a\u0001\u0003{C\u0001\"!1\u0003\u000e\u0001\u0007\u0011Q\u0018")
public class HDFSMetadataLog<T>
implements MetadataLog<T>,
Logging {
    private final Formats formats;
    private final Manifest<T> manifest;
    private final Path metadataPath;
    private final CheckpointFileManager fileManager;
    private final PathFilter batchFilesFilter;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static void verifyBatchIds(Seq<Object> seq, Option<Object> option, Option<Object> option2) {
        HDFSMetadataLog$.MODULE$.verifyBatchIds(seq, option, option2);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Formats formats() {
        return this.formats;
    }

    private Manifest<T> manifest() {
        return this.manifest;
    }

    public Path metadataPath() {
        return this.metadataPath;
    }

    public CheckpointFileManager fileManager() {
        return this.fileManager;
    }

    public PathFilter batchFilesFilter() {
        return this.batchFilesFilter;
    }

    public Path batchIdToPath(long batchId) {
        return new Path(this.metadataPath(), ((Object)BoxesRunTime.boxToLong((long)batchId)).toString());
    }

    public long pathToBatchId(Path path) {
        return new StringOps(Predef$.MODULE$.augmentString(path.getName())).toLong();
    }

    public boolean isBatchFile(Path path) {
        boolean bl;
        try {
            new StringOps(Predef$.MODULE$.augmentString(path.getName())).toLong();
            bl = true;
        }
        catch (NumberFormatException numberFormatException) {
            bl = false;
        }
        return bl;
    }

    public void serialize(T metadata, OutputStream out) {
        Serialization$.MODULE$.write(metadata, out, this.formats());
    }

    public T deserialize(InputStream in) {
        InputStreamReader reader = new InputStreamReader(in, StandardCharsets.UTF_8);
        return (T)Serialization$.MODULE$.read((Reader)reader, this.formats(), this.manifest());
    }

    @Override
    public boolean add(long batchId, T metadata) {
        Predef$.MODULE$.require(metadata != null, (Function0 & Serializable & scala.Serializable)() -> "'null' metadata cannot written to a metadata log");
        return BoxesRunTime.unboxToBoolean((Object)this.get(batchId).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)HDFSMetadataLog.$anonfun$add$2(x$1))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            this.writeBatchToFile(metadata, this.batchIdToPath(batchId));
            return true;
        }));
    }

    private void writeBatchToFile(T metadata, Path path) {
        CheckpointFileManager.CancellableFSDataOutputStream output = this.fileManager().createAtomic(path, false);
        try {
            this.serialize(metadata, (OutputStream)((Object)output));
            output.close();
        }
        catch (FileAlreadyExistsException e) {
            throw new ConcurrentModificationException(new StringBuilder(50).append("Multiple streaming queries are concurrently using ").append(path).toString(), e);
        }
        finally {
            output.cancel();
        }
    }

    @Override
    public Option<T> get(long batchId) {
        None$ none$;
        block6: {
            Path batchMetadataFile = this.batchIdToPath(batchId);
            if (this.fileManager().exists(batchMetadataFile)) {
                FSDataInputStream input = this.fileManager().open(batchMetadataFile);
                try {
                    try {
                        none$ = new Some(this.deserialize((InputStream)input));
                        break block6;
                    }
                    catch (IllegalStateException ise) {
                        throw new IllegalStateException(new StringBuilder(26).append("Failed to read log file ").append(batchMetadataFile).append(". ").append(ise.getMessage()).toString(), ise);
                    }
                }
                finally {
                    IOUtils.closeQuietly((InputStream)input);
                }
            }
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Unable to find batch ").append(batchMetadataFile).toString());
            none$ = None$.MODULE$;
        }
        return none$;
    }

    @Override
    public Tuple2<Object, T>[] get(Option<Object> startId, Option<Object> endId) {
        Predef$.MODULE$.assert(startId.isEmpty() || endId.isEmpty() || BoxesRunTime.unboxToLong((Object)startId.get()) <= BoxesRunTime.unboxToLong((Object)endId.get()));
        FileStatus[] files = this.fileManager().list(this.metadataPath(), this.batchFilesFilter());
        long[] batchIds = (long[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)).map((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToLong((long)this.pathToBatchId(f.getPath())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).filter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)batchId -> !(!endId.isEmpty() && batchId > BoxesRunTime.unboxToLong((Object)endId.get()) || !startId.isEmpty() && batchId < BoxesRunTime.unboxToLong((Object)startId.get()))))).sorted((Ordering)Ordering.Long$.MODULE$);
        HDFSMetadataLog$.MODULE$.verifyBatchIds((Seq<Object>)Predef$.MODULE$.wrapLongArray(batchIds), startId, endId);
        return (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(batchIds)).map((Function1 & Serializable & scala.Serializable)batchId -> HDFSMetadataLog.$anonfun$get$4(this, BoxesRunTime.unboxToLong((Object)batchId)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)HDFSMetadataLog.$anonfun$get$5(x$2))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            long batchId = tuple2._1$mcJ$sp();
            Option metadataOption = (Option)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)batchId), metadataOption.get());
            return tuple22;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
    }

    @Override
    public Option<Tuple2<Object, T>> getLatest() {
        Option option;
        Object object = new Object();
        try {
            long[] batchIds = (long[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.fileManager().list(this.metadataPath(), this.batchFilesFilter()))).map((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToLong((long)this.pathToBatchId(f.getPath())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).sorted((Ordering)Ordering.Long$.MODULE$))).reverse();
            new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(batchIds)).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)batchId -> {
                Option batch = this.get(batchId);
                if (batch.isDefined()) {
                    throw new NonLocalReturnControl(object, (Object)new Some((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)batchId), batch.get())));
                }
            });
            option = None$.MODULE$;
        }
        catch (NonLocalReturnControl ex) {
            if (ex.key() == object) {
                option = (Option)ex.value();
            }
            throw ex;
        }
        return option;
    }

    public FileStatus[] getOrderedBatchFiles() {
        return (FileStatus[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.fileManager().list(this.metadataPath(), this.batchFilesFilter()))).sortBy((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToLong((long)this.pathToBatchId(f.getPath())), (Ordering)Ordering.Long$.MODULE$))).reverse();
    }

    @Override
    public void purge(long thresholdBatchId) {
        long[] batchIds = (long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.fileManager().list(this.metadataPath(), this.batchFilesFilter()))).map((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToLong((long)this.pathToBatchId(f.getPath())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()));
        new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(batchIds)).withFilter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)batchId -> batchId < thresholdBatchId).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)batchId -> {
            Path path = this.batchIdToPath(batchId);
            this.fileManager().delete(path);
            this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Removed metadata log file: ").append(path).toString());
        });
    }

    public void purgeAfter(long thresholdBatchId) {
        long[] batchIds = (long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.fileManager().list(this.metadataPath(), this.batchFilesFilter()))).map((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToLong((long)this.pathToBatchId(f.getPath())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long()));
        new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(batchIds)).withFilter((Function1)(JFunction1.mcZJ.sp & Serializable & scala.Serializable)batchId -> batchId > thresholdBatchId).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)batchId -> {
            Path path = this.batchIdToPath(batchId);
            this.fileManager().delete(path);
            this.logTrace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Removed metadata log file: ").append(path).toString());
        });
    }

    public int parseVersion(String text, int maxSupportedVersion) {
        if (text.length() > 0 && StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(text), 0) == 'v') {
            int n;
            try {
                n = new StringOps(Predef$.MODULE$.augmentString(text.substring(1, text.length()))).toInt();
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalStateException(new StringBuilder(51).append("Log file was malformed: failed to read correct log ").append(new StringBuilder(14).append("version from ").append(text).append(".").toString()).toString());
            }
            int version = n;
            if (version > 0) {
                if (version > maxSupportedVersion) {
                    throw new IllegalStateException(new StringBuilder(132).append("UnsupportedLogVersion: maximum supported log version ").append(new StringBuilder(51).append("is v").append(maxSupportedVersion).append(", but encountered v").append(version).append(". The log file was produced ").toString()).append("by a newer version of Spark and cannot be read by this version. Please upgrade.").toString());
                }
                return version;
            }
        }
        throw new IllegalStateException(new StringBuilder(51).append("Log file was malformed: failed to read correct log ").append(new StringBuilder(14).append("version from ").append(text).append(".").toString()).toString());
    }

    public static final /* synthetic */ boolean $anonfun$add$2(Object x$1) {
        return false;
    }

    public static final /* synthetic */ Tuple2 $anonfun$get$4(HDFSMetadataLog $this, long batchId) {
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)batchId), $this.get(batchId));
    }

    public static final /* synthetic */ boolean $anonfun$get$5(Tuple2 x$2) {
        return ((Option)x$2._2()).isDefined();
    }

    public HDFSMetadataLog(SparkSession sparkSession, String path, ClassTag<T> evidence$1) {
        Logging.$init$((Logging)this);
        this.formats = Serialization$.MODULE$.formats((TypeHints)NoTypeHints$.MODULE$);
        this.manifest = Predef$.MODULE$.Manifest().classType(((ClassTag)Predef$.MODULE$.implicitly(evidence$1)).runtimeClass());
        Class clazz = ((ClassTag)Predef$.MODULE$.implicitly(this.manifest())).runtimeClass();
        Class<Seq> clazz2 = Seq.class;
        Predef$.MODULE$.require(clazz == null ? clazz2 != null : !clazz.equals(clazz2), (Function0 & Serializable & scala.Serializable)() -> "Should not create a log with type Seq, use Arrays instead - see SPARK-17372");
        this.metadataPath = new Path(path);
        this.fileManager = CheckpointFileManager$.MODULE$.create(this.metadataPath(), sparkSession.sessionState().newHadoopConf());
        if (!this.fileManager().exists(this.metadataPath())) {
            this.fileManager().mkdirs(this.metadataPath());
        }
        this.batchFilesFilter = new PathFilter(this){
            private final /* synthetic */ HDFSMetadataLog $outer;

            public boolean accept(Path path) {
                return this.$outer.isBatchFile(path);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }
}

