/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.python;

import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.python.RowQueue;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.unsafe.memory.MemoryBlock;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001-4a!\u0001\u0002\u0002\u0002\tq!\u0001E%o\u001b\u0016lwN]=S_^\fV/Z;f\u0015\t\u0019A!\u0001\u0004qsRDwN\u001c\u0006\u0003\u000b\u0019\t\u0011\"\u001a=fGV$\u0018n\u001c8\u000b\u0005\u001dA\u0011aA:rY*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xmE\u0002\u0001\u001fU\u0001\"\u0001E\n\u000e\u0003EQ\u0011AE\u0001\u0006g\u000e\fG.Y\u0005\u0003)E\u0011a!\u00118z%\u00164\u0007C\u0001\f\u0018\u001b\u0005\u0011\u0011B\u0001\r\u0003\u0005!\u0011vn^)vKV,\u0007\u0002\u0003\u000e\u0001\u0005\u000b\u0007I\u0011\u0001\u000f\u0002\tA\fw-Z\u0002\u0001+\u0005i\u0002C\u0001\u0010$\u001b\u0005y\"B\u0001\u0011\"\u0003\u0019iW-\\8ss*\u0011!\u0005C\u0001\u0007k:\u001c\u0018MZ3\n\u0005\u0011z\"aC'f[>\u0014\u0018P\u00117pG.D\u0001B\n\u0001\u0003\u0002\u0003\u0006I!H\u0001\u0006a\u0006<W\r\t\u0005\tQ\u0001\u0011\t\u0011)A\u0005S\u0005Ia.^7GS\u0016dGm\u001d\t\u0003!)J!aK\t\u0003\u0007%sG\u000fC\u0003.\u0001\u0011\u0005a&\u0001\u0004=S:LGO\u0010\u000b\u0004_A\n\u0004C\u0001\f\u0001\u0011\u0015QB\u00061\u0001\u001e\u0011\u0015AC\u00061\u0001*\u0011\u001d\u0019\u0004A1A\u0005\nQ\nAAY1tKV\tq\u0002\u0003\u00047\u0001\u0001\u0006IaD\u0001\u0006E\u0006\u001cX\r\t\u0005\bq\u0001\u0011\r\u0011\"\u0003:\u0003%)g\u000eZ(g!\u0006<W-F\u0001;!\t\u00012(\u0003\u0002=#\t!Aj\u001c8h\u0011\u0019q\u0004\u0001)A\u0005u\u0005QQM\u001c3PMB\u000bw-\u001a\u0011\t\u000f\u0001\u0003\u0001\u0019!C\u0005s\u0005YqO]5uK>3gm]3u\u0011\u001d\u0011\u0005\u00011A\u0005\n\r\u000bqb\u001e:ji\u0016|eMZ:fi~#S-\u001d\u000b\u0003\t\u001e\u0003\"\u0001E#\n\u0005\u0019\u000b\"\u0001B+oSRDq\u0001S!\u0002\u0002\u0003\u0007!(A\u0002yIEBaA\u0013\u0001!B\u0013Q\u0014\u0001D<sSR,wJ\u001a4tKR\u0004\u0003b\u0002'\u0001\u0001\u0004%I!O\u0001\u000be\u0016\fGm\u00144gg\u0016$\bb\u0002(\u0001\u0001\u0004%IaT\u0001\u000fe\u0016\fGm\u00144gg\u0016$x\fJ3r)\t!\u0005\u000bC\u0004I\u001b\u0006\u0005\t\u0019\u0001\u001e\t\rI\u0003\u0001\u0015)\u0003;\u0003-\u0011X-\u00193PM\u001a\u001cX\r\u001e\u0011\t\u000fQ\u0003!\u0019!C\u0005+\u0006I!/Z:vYR\u0014vn^\u000b\u0002-B\u0011q\u000bX\u0007\u00021*\u0011\u0011LW\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\\\r\u0005A1-\u0019;bYf\u001cH/\u0003\u0002^1\nIQK\\:bM\u0016\u0014vn\u001e\u0005\u0007?\u0002\u0001\u000b\u0011\u0002,\u0002\u0015I,7/\u001e7u%><\b\u0005C\u0003b\u0001\u0011\u0005!-A\u0002bI\u0012$\"a\u00194\u0011\u0005A!\u0017BA3\u0012\u0005\u001d\u0011un\u001c7fC:DQa\u001a1A\u0002Y\u000b1A]8x\u0011\u0015I\u0007\u0001\"\u0001k\u0003\u0019\u0011X-\\8wKR\ta\u000b")
public abstract class InMemoryRowQueue
implements RowQueue {
    private final MemoryBlock page;
    private final Object base;
    private final long endOfPage;
    private long writeOffset;
    private long readOffset;
    private final UnsafeRow resultRow;

    public MemoryBlock page() {
        return this.page;
    }

    private Object base() {
        return this.base;
    }

    private long endOfPage() {
        return this.endOfPage;
    }

    private long writeOffset() {
        return this.writeOffset;
    }

    private void writeOffset_$eq(long x$1) {
        this.writeOffset = x$1;
    }

    private long readOffset() {
        return this.readOffset;
    }

    private void readOffset_$eq(long x$1) {
        this.readOffset = x$1;
    }

    private UnsafeRow resultRow() {
        return this.resultRow;
    }

    @Override
    public synchronized boolean add(UnsafeRow row) {
        boolean bl;
        int size = row.getSizeInBytes();
        if (this.writeOffset() + 4L + (long)size > this.endOfPage()) {
            if (this.writeOffset() + 4L <= this.endOfPage()) {
                Platform.putInt((Object)this.base(), (long)this.writeOffset(), (int)-1);
            }
            bl = false;
        } else {
            Platform.putInt((Object)this.base(), (long)this.writeOffset(), (int)size);
            Platform.copyMemory((Object)row.getBaseObject(), (long)row.getBaseOffset(), (Object)this.base(), (long)(this.writeOffset() + 4L), (long)size);
            this.writeOffset_$eq(this.writeOffset() + (long)(4 + size));
            bl = true;
        }
        return bl;
    }

    @Override
    public synchronized UnsafeRow remove() {
        UnsafeRow unsafeRow;
        Predef$.MODULE$.assert(this.readOffset() <= this.writeOffset(), (Function0 & java.io.Serializable & Serializable)() -> "reader should not go beyond writer");
        if (this.readOffset() + 4L > this.endOfPage() || Platform.getInt((Object)this.base(), (long)this.readOffset()) < 0) {
            unsafeRow = null;
        } else {
            int size = Platform.getInt((Object)this.base(), (long)this.readOffset());
            this.resultRow().pointTo(this.base(), this.readOffset() + 4L, size);
            this.readOffset_$eq(this.readOffset() + (long)(4 + size));
            unsafeRow = this.resultRow();
        }
        return unsafeRow;
    }

    public InMemoryRowQueue(MemoryBlock page, int numFields) {
        this.page = page;
        this.base = page.getBaseObject();
        this.endOfPage = page.getBaseOffset() + page.size();
        this.writeOffset = page.getBaseOffset();
        this.readOffset = page.getBaseOffset();
        this.resultRow = new UnsafeRow(numFields);
    }
}

