/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.command;

import java.io.Serializable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogColumnStat;
import org.apache.spark.sql.catalyst.catalog.CatalogStatistics;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Alias$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeMap;
import org.apache.spark.sql.catalyst.expressions.AttributeMap$;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.Ceil;
import org.apache.spark.sql.catalyst.expressions.Coalesce;
import org.apache.spark.sql.catalyst.expressions.CreateNamedStruct;
import org.apache.spark.sql.catalyst.expressions.CreateStruct$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Least;
import org.apache.spark.sql.catalyst.expressions.Length;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.Subtract;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateExpression;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateFunction;
import org.apache.spark.sql.catalyst.expressions.aggregate.ApproxCountDistinctForIntervals;
import org.apache.spark.sql.catalyst.expressions.aggregate.ApproxCountDistinctForIntervals$;
import org.apache.spark.sql.catalyst.expressions.aggregate.ApproximatePercentile;
import org.apache.spark.sql.catalyst.expressions.aggregate.Average;
import org.apache.spark.sql.catalyst.expressions.aggregate.Count;
import org.apache.spark.sql.catalyst.expressions.aggregate.Count$;
import org.apache.spark.sql.catalyst.expressions.aggregate.HyperLogLogPlusPlus;
import org.apache.spark.sql.catalyst.expressions.aggregate.HyperLogLogPlusPlus$;
import org.apache.spark.sql.catalyst.expressions.aggregate.Max;
import org.apache.spark.sql.catalyst.expressions.aggregate.Min;
import org.apache.spark.sql.catalyst.plans.logical.Aggregate;
import org.apache.spark.sql.catalyst.plans.logical.ColumnStat;
import org.apache.spark.sql.catalyst.plans.logical.ColumnStat$;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.Histogram;
import org.apache.spark.sql.catalyst.plans.logical.HistogramBin;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.command.AnalyzeColumnCommand$;
import org.apache.spark.sql.execution.command.CommandUtils$;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SessionState;
import org.apache.spark.sql.types.ArrayType$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegralType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TimestampType$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashMap$;
import scala.math.BigInt;
import scala.math.BigInt$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t\u0015c\u0001B\u0001\u0003\u0001>\u0011A#\u00118bYfTXmQ8mk6t7i\\7nC:$'BA\u0002\u0005\u0003\u001d\u0019w.\\7b]\u0012T!!\u0002\u0004\u0002\u0013\u0015DXmY;uS>t'BA\u0004\t\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u0013)\tQa\u001d9be.T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sO\u000e\u00011#\u0002\u0001\u00115y!\u0003CA\t\u0019\u001b\u0005\u0011\"BA\n\u0015\u0003\u001dawnZ5dC2T!!\u0006\f\u0002\u000bAd\u0017M\\:\u000b\u0005]1\u0011\u0001C2bi\u0006d\u0017p\u001d;\n\u0005e\u0011\"a\u0003'pO&\u001c\u0017\r\u001c)mC:\u0004\"a\u0007\u000f\u000e\u0003\tI!!\b\u0002\u0003\u001fI+hN\\1cY\u0016\u001cu.\\7b]\u0012\u0004\"a\b\u0012\u000e\u0003\u0001R\u0011!I\u0001\u0006g\u000e\fG.Y\u0005\u0003G\u0001\u0012q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002 K%\u0011a\u0005\t\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\tQ\u0001\u0011)\u001a!C\u0001S\u0005QA/\u00192mK&#WM\u001c;\u0016\u0003)\u0002\"a\u000b\u0017\u000e\u0003YI!!\f\f\u0003\u001fQ\u000b'\r\\3JI\u0016tG/\u001b4jKJD\u0001b\f\u0001\u0003\u0012\u0003\u0006IAK\u0001\fi\u0006\u0014G.Z%eK:$\b\u0005\u0003\u00052\u0001\tU\r\u0011\"\u00013\u0003-\u0019w\u000e\\;n]:\u000bW.Z:\u0016\u0003M\u00022\u0001\u000e\u001f@\u001d\t)$H\u0004\u00027s5\tqG\u0003\u00029\u001d\u00051AH]8pizJ\u0011!I\u0005\u0003w\u0001\nq\u0001]1dW\u0006<W-\u0003\u0002>}\t\u00191+Z9\u000b\u0005m\u0002\u0003C\u0001!E\u001d\t\t%\t\u0005\u00027A%\u00111\tI\u0001\u0007!J,G-\u001a4\n\u0005\u00153%AB*ue&twM\u0003\u0002DA!A\u0001\n\u0001B\tB\u0003%1'\u0001\u0007d_2,XN\u001c(b[\u0016\u001c\b\u0005C\u0003K\u0001\u0011\u00051*\u0001\u0004=S:LGO\u0010\u000b\u0004\u00196s\u0005CA\u000e\u0001\u0011\u0015A\u0013\n1\u0001+\u0011\u0015\t\u0014\n1\u00014\u0011\u0015\u0001\u0006\u0001\"\u0011R\u0003\r\u0011XO\u001c\u000b\u0003%^\u00032\u0001\u000e\u001fT!\t!V+D\u0001\u0007\u0013\t1fAA\u0002S_^DQ\u0001W(A\u0002e\u000bAb\u001d9be.\u001cVm]:j_:\u0004\"\u0001\u0016.\n\u0005m3!\u0001D*qCJ\\7+Z:tS>t\u0007\"B/\u0001\t\u0013q\u0016AE2p[B,H/Z\"pYVlgn\u0015;biN$Ba\u00188paB!q\u0004\u00192f\u0013\t\t\u0007E\u0001\u0004UkBdWM\r\t\u0003?\rL!\u0001\u001a\u0011\u0003\t1{gn\u001a\t\u0005\u0001\u001a|\u0004.\u0003\u0002h\r\n\u0019Q*\u00199\u0011\u0005%dW\"\u00016\u000b\u0005-4\u0012aB2bi\u0006dwnZ\u0005\u0003[*\u0014\u0011cQ1uC2|wmQ8mk6t7\u000b^1u\u0011\u0015AF\f1\u0001Z\u0011\u0015AC\f1\u0001+\u0011\u0015\tD\f1\u00014\u0011\u0015\u0011\b\u0001\"\u0003t\u0003I\u0019w.\u001c9vi\u0016\u0004VM]2f]RLG.Z:\u0015\u000fQ\f\t!!\u0004\u0002\u0010A\u0019Q\u000f\u001f>\u000e\u0003YT!a\u001e\f\u0002\u0017\u0015D\bO]3tg&|gn]\u0005\u0003sZ\u0014A\"\u0011;ue&\u0014W\u000f^3NCB\u0004\"a\u001f@\u000e\u0003qT!! \f\u0002\tU$\u0018\u000e\\\u0005\u0003\u007fr\u0014\u0011\"\u0011:sCf$\u0015\r^1\t\u000f\u0005\r\u0011\u000f1\u0001\u0002\u0006\u0005\u0019\u0012\r\u001e;sS\n,H/Z:U_\u0006s\u0017\r\\={KB!A\u0007PA\u0004!\r)\u0018\u0011B\u0005\u0004\u0003\u00171(!C!uiJL'-\u001e;f\u0011\u0015A\u0016\u000f1\u0001Z\u0011\u0019\t\t\"\u001da\u0001!\u0005A!/\u001a7bi&|g\u000eC\u0004\u0002\u0016\u0001!I!a\u0006\u0002\u0019M,\b\u000f]8siN$\u0016\u0010]3\u0015\t\u0005e\u0011q\u0004\t\u0004?\u0005m\u0011bAA\u000fA\t9!i\\8mK\u0006t\u0007\u0002CA\u0011\u0003'\u0001\r!a\t\u0002\u0011\u0011\fG/\u0019+za\u0016\u0004B!!\n\u0002,5\u0011\u0011q\u0005\u0006\u0004\u0003S1\u0011!\u0002;za\u0016\u001c\u0018\u0002BA\u0017\u0003O\u0011\u0001\u0002R1uCRK\b/\u001a\u0005\b\u0003c\u0001A\u0011BA\u001a\u0003E\u0019X\u000f\u001d9peR\u001c\b*[:u_\u001e\u0014\u0018-\u001c\u000b\u0005\u00033\t)\u0004\u0003\u0005\u0002\"\u0005=\u0002\u0019AA\u0012\u0011\u001d\tI\u0004\u0001C\u0005\u0003w\t\u0011b\u001d;bi\u0016C\bO]:\u0015\u0011\u0005u\u00121IA$\u0003/\u00022!^A \u0013\r\t\tE\u001e\u0002\u0012\u0007J,\u0017\r^3OC6,Gm\u0015;sk\u000e$\b\u0002CA#\u0003o\u0001\r!a\u0002\u0002\u0007\r|G\u000e\u0003\u0005\u0002J\u0005]\u0002\u0019AA&\u0003\u0011\u0019wN\u001c4\u0011\t\u00055\u00131K\u0007\u0003\u0003\u001fR1!!\u0015\u0007\u0003!Ig\u000e^3s]\u0006d\u0017\u0002BA+\u0003\u001f\u0012qaU)M\u0007>tg\rC\u0004\u0002Z\u0005]\u0002\u0019\u0001;\u0002\u001d\r|G\u000eU3sG\u0016tG/\u001b7fg\"9\u0011Q\f\u0001\u0005\n\u0005}\u0013a\u0004:poR{7i\u001c7v[:\u001cF/\u0019;\u0015\u0015\u0005\u0005\u0014qMA9\u0003k\nI\bE\u0002\u0012\u0003GJ1!!\u001a\u0013\u0005)\u0019u\u000e\\;n]N#\u0018\r\u001e\u0005\t\u0003S\nY\u00061\u0001\u0002l\u0005\u0019!o\\<\u0011\u0007-\ni'C\u0002\u0002pY\u00111\"\u00138uKJt\u0017\r\u001c*po\"A\u00111OA.\u0001\u0004\t9!\u0001\u0003biR\u0014\bbBA<\u00037\u0002\rAY\u0001\te><8i\\;oi\"A\u00111PA.\u0001\u0004\ti(A\u0006qKJ\u001cWM\u001c;jY\u0016\u001c\b\u0003B\u0010\u0002\u0000iL1!!!!\u0005\u0019y\u0005\u000f^5p]\"I\u0011Q\u0011\u0001\u0002\u0002\u0013\u0005\u0011qQ\u0001\u0005G>\u0004\u0018\u0010F\u0003M\u0003\u0013\u000bY\t\u0003\u0005)\u0003\u0007\u0003\n\u00111\u0001+\u0011!\t\u00141\u0011I\u0001\u0002\u0004\u0019\u0004\"CAH\u0001E\u0005I\u0011AAI\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!a%+\u0007)\n)j\u000b\u0002\u0002\u0018B!\u0011\u0011TAR\u001b\t\tYJ\u0003\u0003\u0002\u001e\u0006}\u0015!C;oG\",7m[3e\u0015\r\t\t\u000bI\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAS\u00037\u0013\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\tI\u000bAI\u0001\n\u0003\tY+\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u00055&fA\u001a\u0002\u0016\"I\u0011\u0011\u0017\u0001\u0002\u0002\u0013\u0005\u00131W\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005U\u0006\u0003BA\\\u0003\u0003l!!!/\u000b\t\u0005m\u0016QX\u0001\u0005Y\u0006twM\u0003\u0002\u0002@\u0006!!.\u0019<b\u0013\r)\u0015\u0011\u0018\u0005\n\u0003\u000b\u0004\u0011\u0011!C\u0001\u0003\u000f\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!3\u0011\u0007}\tY-C\u0002\u0002N\u0002\u00121!\u00138u\u0011%\t\t\u000eAA\u0001\n\u0003\t\u0019.\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005U\u00171\u001c\t\u0004?\u0005]\u0017bAAmA\t\u0019\u0011I\\=\t\u0015\u0005u\u0017qZA\u0001\u0002\u0004\tI-A\u0002yIEB\u0011\"!9\u0001\u0003\u0003%\t%a9\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!:\u0011\r\u0005\u001d\u0018Q^Ak\u001b\t\tIOC\u0002\u0002l\u0002\n!bY8mY\u0016\u001cG/[8o\u0013\u0011\ty/!;\u0003\u0011%#XM]1u_JD\u0011\"a=\u0001\u0003\u0003%\t!!>\u0002\u0011\r\fg.R9vC2$B!!\u0007\u0002x\"Q\u0011Q\\Ay\u0003\u0003\u0005\r!!6\t\u0013\u0005m\b!!A\u0005B\u0005u\u0018AB3rk\u0006d7\u000f\u0006\u0003\u0002\u001a\u0005}\bBCAo\u0003s\f\t\u00111\u0001\u0002V\u001eI!1\u0001\u0002\u0002\u0002#\u0005!QA\u0001\u0015\u0003:\fG.\u001f>f\u0007>dW/\u001c8D_6l\u0017M\u001c3\u0011\u0007m\u00119A\u0002\u0005\u0002\u0005\u0005\u0005\t\u0012\u0001B\u0005'\u0015\u00119Aa\u0003%!\u001d\u0011iAa\u0005+g1k!Aa\u0004\u000b\u0007\tE\u0001%A\u0004sk:$\u0018.\\3\n\t\tU!q\u0002\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\u0014\u0004b\u0002&\u0003\b\u0011\u0005!\u0011\u0004\u000b\u0003\u0005\u000bA!B!\b\u0003\b\u0005\u0005IQ\tB\u0010\u0003!!xn\u0015;sS:<GCAA[\u0011)\u0011\u0019Ca\u0002\u0002\u0002\u0013\u0005%QE\u0001\u0006CB\u0004H.\u001f\u000b\u0006\u0019\n\u001d\"\u0011\u0006\u0005\u0007Q\t\u0005\u0002\u0019\u0001\u0016\t\rE\u0012\t\u00031\u00014\u0011)\u0011iCa\u0002\u0002\u0002\u0013\u0005%qF\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011\tD!\u000e\u0011\u000b}\tyHa\r\u0011\t}\u0001'f\r\u0005\n\u0005o\u0011Y#!AA\u00021\u000b1\u0001\u001f\u00131\u0011)\u0011YDa\u0002\u0002\u0002\u0013%!QH\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003@A!\u0011q\u0017B!\u0013\u0011\u0011\u0019%!/\u0003\r=\u0013'.Z2u\u0001")
public class AnalyzeColumnCommand
extends LogicalPlan
implements RunnableCommand,
scala.Serializable {
    private final TableIdentifier tableIdent;
    private final Seq<String> columnNames;
    private Map<String, SQLMetric> metrics;
    private volatile boolean bitmap$0;

    public static Option<Tuple2<TableIdentifier, Seq<String>>> unapply(AnalyzeColumnCommand analyzeColumnCommand) {
        return AnalyzeColumnCommand$.MODULE$.unapply(analyzeColumnCommand);
    }

    public static Function1<Tuple2<TableIdentifier, Seq<String>>, AnalyzeColumnCommand> tupled() {
        return AnalyzeColumnCommand$.MODULE$.tupled();
    }

    public static Function1<TableIdentifier, Function1<Seq<String>, AnalyzeColumnCommand>> curried() {
        return AnalyzeColumnCommand$.MODULE$.curried();
    }

    public Seq<Attribute> output() {
        return Command.output$((Command)this);
    }

    public Seq<LogicalPlan> children() {
        return Command.children$((Command)this);
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        AnalyzeColumnCommand analyzeColumnCommand = this;
        synchronized (analyzeColumnCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.metrics$(this);
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    @Override
    public Map<String, SQLMetric> metrics() {
        return !this.bitmap$0 ? this.metrics$lzycompute() : this.metrics;
    }

    public TableIdentifier tableIdent() {
        return this.tableIdent;
    }

    public Seq<String> columnNames() {
        return this.columnNames;
    }

    @Override
    public Seq<Row> run(SparkSession sparkSession) {
        SessionState sessionState = sparkSession.sessionState();
        String db = (String)this.tableIdent().database().getOrElse((Function0 & Serializable & scala.Serializable)() -> sessionState.catalog().getCurrentDatabase());
        TableIdentifier tableIdentWithDB = new TableIdentifier(this.tableIdent().table(), (Option)new Some((Object)db));
        CatalogTable tableMeta = sessionState.catalog().getTableMetadata(tableIdentWithDB);
        CatalogTableType catalogTableType = tableMeta.tableType();
        CatalogTableType catalogTableType2 = CatalogTableType$.MODULE$.VIEW();
        if (!(catalogTableType != null ? !catalogTableType.equals(catalogTableType2) : catalogTableType2 != null)) {
            throw new AnalysisException("ANALYZE TABLE is not supported on views.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        BigInt sizeInBytes = CommandUtils$.MODULE$.calculateTotalSize(sparkSession, tableMeta);
        Tuple2<Object, Map<String, CatalogColumnStat>> tuple2 = this.computeColumnStats(sparkSession, tableIdentWithDB, this.columnNames());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        long rowCount = tuple2._1$mcJ$sp();
        Map newColStats = (Map)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)rowCount), (Object)newColStats);
        Tuple2 tuple23 = tuple22;
        long rowCount2 = tuple23._1$mcJ$sp();
        Map newColStats2 = (Map)tuple23._2();
        CatalogStatistics statistics = new CatalogStatistics(sizeInBytes, (Option)new Some((Object)BigInt$.MODULE$.long2bigInt(rowCount2)), ((MapLike)tableMeta.stats().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.colStats()).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty())).$plus$plus((GenTraversableOnce)newColStats2));
        sessionState.catalog().alterTableStats(tableIdentWithDB, (Option)new Some((Object)statistics));
        return (Seq)Seq$.MODULE$.empty();
    }

    private Tuple2<Object, Map<String, CatalogColumnStat>> computeColumnStats(SparkSession sparkSession, TableIdentifier tableIdent, Seq<String> columnNames) {
        SQLConf conf = sparkSession.sessionState().conf();
        LogicalPlan relation = sparkSession.table(tableIdent).logicalPlan();
        Seq attributesToAnalyze = (Seq)columnNames.map((Function1 & Serializable & scala.Serializable)col -> {
            Option exprOption = relation.output().find((Function1 & Serializable & scala.Serializable)attr -> BoxesRunTime.boxToBoolean((boolean)AnalyzeColumnCommand.$anonfun$computeColumnStats$2(conf, col, attr)));
            return (Attribute)exprOption.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                throw new AnalysisException(new StringBuilder(23).append("Column ").append((String)col).append(" does not exist.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            });
        }, Seq$.MODULE$.canBuildFrom());
        attributesToAnalyze.foreach((Function1 & Serializable & scala.Serializable)attr -> {
            AnalyzeColumnCommand.$anonfun$computeColumnStats$4(this, tableIdent, attr);
            return BoxedUnit.UNIT;
        });
        AttributeMap<ArrayData> attributePercentiles = this.computePercentiles((Seq<Attribute>)attributesToAnalyze, sparkSession, relation);
        AggregateExpression aggregateExpression = Count$.MODULE$.apply((Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)1))).toAggregateExpression();
        Seq expressions = (Seq)((SeqLike)attributesToAnalyze.map((Function1 & Serializable & scala.Serializable)x$3 -> this.statExprs((Attribute)x$3, conf, attributePercentiles), Seq$.MODULE$.canBuildFrom())).$plus$colon((Object)aggregateExpression, Seq$.MODULE$.canBuildFrom());
        Seq namedExpressions = (Seq)expressions.map((Function1 & Serializable & scala.Serializable)e -> {
            Expression x$6 = e;
            String x$7 = e.toString();
            ExprId x$8 = Alias$.MODULE$.apply$default$3(x$6, x$7);
            Seq x$9 = Alias$.MODULE$.apply$default$4(x$6, x$7);
            Option x$10 = Alias$.MODULE$.apply$default$5(x$6, x$7);
            return new Alias(x$6, x$7, x$8, x$9, x$10);
        }, Seq$.MODULE$.canBuildFrom());
        InternalRow statsRow = (InternalRow)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new QueryExecution(sparkSession, (LogicalPlan)new Aggregate((Seq)Nil$.MODULE$, namedExpressions, relation)).executedPlan().executeTake(1))).head();
        long rowCount = statsRow.getLong(0);
        Map columnStats = ((TraversableOnce)((TraversableLike)attributesToAnalyze.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Attribute attr = (Attribute)tuple2._1();
            int i = tuple2._2$mcI$sp();
            Tuple2 tuple22 = new Tuple2((Object)attr.name(), (Object)this.rowToColumnStat(statsRow.getStruct(i + 1, 7), attr, rowCount, (Option<ArrayData>)attributePercentiles.get(attr)).toCatalogColumnStat(attr.name(), attr.dataType()));
            return tuple22;
        }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        return new Tuple2((Object)BoxesRunTime.boxToLong((long)rowCount), (Object)columnStats);
    }

    private AttributeMap<ArrayData> computePercentiles(Seq<Attribute> attributesToAnalyze, SparkSession sparkSession, LogicalPlan relation) {
        HashMap attributePercentiles;
        block0: {
            Nil$ attrsToGenHistogram = this.conf().histogramEnabled() ? (Seq)attributesToAnalyze.filter((Function1 & Serializable & scala.Serializable)a -> BoxesRunTime.boxToBoolean((boolean)this.supportsHistogram(a.dataType()))) : Nil$.MODULE$;
            attributePercentiles = (HashMap)HashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
            if (!attrsToGenHistogram.nonEmpty()) break block0;
            double[] percentiles = (double[])((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), this.conf().histogramNumBins()).map((Function1)(JFunction1.mcDI.sp & Serializable & scala.Serializable)i -> (double)i / (double)this.conf().histogramNumBins(), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double());
            Seq namedExprs = (Seq)attrsToGenHistogram.map((Function1 & Serializable & scala.Serializable)attr -> {
                AggregateExpression expr;
                ApproximatePercentile aggFunc = new ApproximatePercentile((Expression)attr, (Expression)Literal$.MODULE$.apply((Object)percentiles), (Expression)Literal$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)this.conf().percentileAccuracy())));
                AggregateExpression x$11 = expr = aggFunc.toAggregateExpression();
                String x$12 = expr.toString();
                ExprId x$13 = Alias$.MODULE$.apply$default$3((Expression)x$11, x$12);
                Seq x$14 = Alias$.MODULE$.apply$default$4((Expression)x$11, x$12);
                Option x$15 = Alias$.MODULE$.apply$default$5((Expression)x$11, x$12);
                return new Alias((Expression)x$11, x$12, x$13, x$14, x$15);
            }, Seq$.MODULE$.canBuildFrom());
            InternalRow percentilesRow = (InternalRow)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new QueryExecution(sparkSession, (LogicalPlan)new Aggregate((Seq)Nil$.MODULE$, namedExprs, relation)).executedPlan().executeTake(1))).head();
            ((IterableLike)attrsToGenHistogram.zipWithIndex(Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Attribute attr = (Attribute)tuple2._1();
                int i = tuple2._2$mcI$sp();
                ArrayData percentiles = percentilesRow.getArray(i);
                BoxedUnit boxedUnit = percentiles != null ? attributePercentiles.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)attr), (Object)percentiles)) : BoxedUnit.UNIT;
                return boxedUnit;
            });
        }
        return AttributeMap$.MODULE$.apply(attributePercentiles.toSeq());
    }

    private boolean supportsType(DataType dataType) {
        boolean bl;
        boolean bl2;
        DataType dataType2 = dataType;
        boolean bl3 = dataType2 instanceof IntegralType ? true : (dataType2 instanceof DecimalType ? true : ((bl2 = DoubleType$.MODULE$.equals(dataType2) ? true : FloatType$.MODULE$.equals(dataType2)) ? true : (BooleanType$.MODULE$.equals(dataType2) ? true : (DateType$.MODULE$.equals(dataType2) ? true : (TimestampType$.MODULE$.equals(dataType2) ? true : (bl = BinaryType$.MODULE$.equals(dataType2) ? true : StringType$.MODULE$.equals(dataType2)))))));
        return bl3;
    }

    private boolean supportsHistogram(DataType dataType) {
        boolean bl;
        DataType dataType2 = dataType;
        boolean bl2 = dataType2 instanceof IntegralType ? true : (dataType2 instanceof DecimalType ? true : ((bl = DoubleType$.MODULE$.equals(dataType2) ? true : FloatType$.MODULE$.equals(dataType2)) ? true : (DateType$.MODULE$.equals(dataType2) ? true : TimestampType$.MODULE$.equals(dataType2))));
        return bl2;
    }

    private CreateNamedStruct statExprs(Attribute col, SQLConf conf, AttributeMap<ArrayData> colPercentiles) {
        CreateNamedStruct createNamedStruct;
        Literal one = new Literal((Object)BoxesRunTime.boxToInteger((int)1), (DataType)LongType$.MODULE$);
        Count numNonNulls = col.nullable() ? Count$.MODULE$.apply((Expression)col) : Count$.MODULE$.apply((Expression)one);
        Least ndv = new Least((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new AggregateFunction[]{new HyperLogLogPlusPlus((Expression)col, conf.ndvMaxError(), HyperLogLogPlusPlus$.MODULE$.apply$default$3(), HyperLogLogPlusPlus$.MODULE$.apply$default$4()), numNonNulls})));
        Subtract numNulls = new Subtract((Expression)Count$.MODULE$.apply((Expression)one), (Expression)numNonNulls);
        Literal defaultSize = new Literal((Object)BoxesRunTime.boxToInteger((int)col.dataType().defaultSize()), (DataType)LongType$.MODULE$);
        Literal nullArray = new Literal(null, (DataType)ArrayType$.MODULE$.apply((DataType)LongType$.MODULE$));
        DataType dataType = col.dataType();
        if (dataType instanceof IntegralType) {
            createNamedStruct = this.fixedLenTypeStruct$1(col, conf, colPercentiles, ndv, numNulls, defaultSize, nullArray);
        } else if (dataType instanceof DecimalType) {
            createNamedStruct = this.fixedLenTypeStruct$1(col, conf, colPercentiles, ndv, numNulls, defaultSize, nullArray);
        } else {
            boolean bl = DoubleType$.MODULE$.equals(dataType) ? true : FloatType$.MODULE$.equals(dataType);
            if (bl) {
                createNamedStruct = this.fixedLenTypeStruct$1(col, conf, colPercentiles, ndv, numNulls, defaultSize, nullArray);
            } else if (BooleanType$.MODULE$.equals(dataType)) {
                createNamedStruct = this.fixedLenTypeStruct$1(col, conf, colPercentiles, ndv, numNulls, defaultSize, nullArray);
            } else if (DateType$.MODULE$.equals(dataType)) {
                createNamedStruct = this.fixedLenTypeStruct$1(col, conf, colPercentiles, ndv, numNulls, defaultSize, nullArray);
            } else if (TimestampType$.MODULE$.equals(dataType)) {
                createNamedStruct = this.fixedLenTypeStruct$1(col, conf, colPercentiles, ndv, numNulls, defaultSize, nullArray);
            } else {
                boolean bl2 = BinaryType$.MODULE$.equals(dataType) ? true : StringType$.MODULE$.equals(dataType);
                if (bl2) {
                    Literal nullLit = new Literal(null, col.dataType());
                    createNamedStruct = AnalyzeColumnCommand.struct$1((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{ndv, nullLit, nullLit, numNulls, new Coalesce((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{new Ceil((Expression)new Average((Expression)new Length((Expression)col))), defaultSize}))), new Coalesce((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{new Cast((Expression)new Max((Expression)new Length((Expression)col)), (DataType)LongType$.MODULE$, Cast$.MODULE$.apply$default$3()), defaultSize}))), nullArray}));
                } else {
                    throw new AnalysisException(new StringBuilder(56).append("Analyzing column statistics is not supported for column ").append(new StringBuilder(16).append(col.name()).append(" of data type: ").append(col.dataType()).append(".").toString()).toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                }
            }
        }
        return createNamedStruct;
    }

    private ColumnStat rowToColumnStat(InternalRow row, Attribute attr, long rowCount, Option<ArrayData> percentiles) {
        ColumnStat columnStat;
        ColumnStat cs = new ColumnStat(Option$.MODULE$.apply((Object)package$.MODULE$.BigInt().apply(row.getLong(0))), Option$.MODULE$.apply(row.get(1, attr.dataType())), Option$.MODULE$.apply(row.get(2, attr.dataType())), Option$.MODULE$.apply((Object)package$.MODULE$.BigInt().apply(row.getLong(3))), Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)row.getLong(4))), Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)row.getLong(5))), ColumnStat$.MODULE$.apply$default$7());
        if (row.isNullAt(6) || cs.nullCount().isEmpty()) {
            columnStat = cs;
        } else {
            long[] ndvs = row.getArray(6).toLongArray();
            Predef$.MODULE$.assert(((ArrayData)percentiles.get()).numElements() == ndvs.length + 1);
            double[] endpoints = (double[])Predef$.MODULE$.genericArrayOps(((ArrayData)percentiles.get()).toArray(attr.dataType(), ClassTag$.MODULE$.Any())).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToDouble((double)AnalyzeColumnCommand.$anonfun$rowToColumnStat$1(x$5)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
            HistogramBin[] bins = (HistogramBin[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(ndvs)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                long ndv = tuple2._1$mcJ$sp();
                int i = tuple2._2$mcI$sp();
                HistogramBin histogramBin = new HistogramBin(endpoints[i], endpoints[i + 1], ndv);
                return histogramBin;
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(HistogramBin.class)));
            BigInt nonNullRows = BigInt$.MODULE$.long2bigInt(rowCount).$minus((BigInt)cs.nullCount().get());
            Histogram histogram = new Histogram(nonNullRows.toDouble() / (double)ndvs.length, bins);
            Some x$16 = new Some((Object)histogram);
            Option x$17 = cs.copy$default$1();
            Option x$18 = cs.copy$default$2();
            Option x$19 = cs.copy$default$3();
            Option x$20 = cs.copy$default$4();
            Option x$21 = cs.copy$default$5();
            Option x$22 = cs.copy$default$6();
            columnStat = cs.copy(x$17, x$18, x$19, x$20, x$21, x$22, (Option)x$16);
        }
        return columnStat;
    }

    public AnalyzeColumnCommand copy(TableIdentifier tableIdent, Seq<String> columnNames) {
        return new AnalyzeColumnCommand(tableIdent, columnNames);
    }

    public TableIdentifier copy$default$1() {
        return this.tableIdent();
    }

    public Seq<String> copy$default$2() {
        return this.columnNames();
    }

    public String productPrefix() {
        return "AnalyzeColumnCommand";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Seq<String> seq;
        int n = x$1;
        switch (n) {
            case 0: {
                seq = this.tableIdent();
                break;
            }
            case 1: {
                seq = this.columnNames();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return seq;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof AnalyzeColumnCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof AnalyzeColumnCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        AnalyzeColumnCommand analyzeColumnCommand = (AnalyzeColumnCommand)x$1;
        TableIdentifier tableIdentifier = this.tableIdent();
        TableIdentifier tableIdentifier2 = analyzeColumnCommand.tableIdent();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        Seq<String> seq = this.columnNames();
        Seq<String> seq2 = analyzeColumnCommand.columnNames();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (!analyzeColumnCommand.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$computeColumnStats$2(SQLConf conf$1, String col$2, Attribute attr) {
        return BoxesRunTime.unboxToBoolean((Object)conf$1.resolver().apply((Object)attr.name(), (Object)col$2));
    }

    public static final /* synthetic */ void $anonfun$computeColumnStats$4(AnalyzeColumnCommand $this, TableIdentifier tableIdent$1, Attribute attr) {
        if (!$this.supportsType(attr.dataType())) {
            throw new AnalysisException(new StringBuilder(100).append("Column ").append(attr.name()).append(" in table ").append(tableIdent$1).append(" is of type ").append(attr.dataType()).append(", ").append("and Spark does not support statistics collection on this column type.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
    }

    private static final CreateNamedStruct struct$1(Seq exprs) {
        return CreateStruct$.MODULE$.apply((Seq)exprs.map((Function1 & Serializable & scala.Serializable)expr -> (Expression)expr.transformUp((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Expression, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof AggregateFunction) {
                    AggregateFunction aggregateFunction = (AggregateFunction)A1;
                    object = aggregateFunction.toAggregateExpression();
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Expression x1) {
                Expression expression = x1;
                boolean bl = expression instanceof AggregateFunction;
                return bl;
            }
        }), Seq$.MODULE$.canBuildFrom()));
    }

    private final CreateNamedStruct fixedLenTypeStruct$1(Attribute col$1, SQLConf conf$2, AttributeMap colPercentiles$1, Least ndv$1, Subtract numNulls$1, Literal defaultSize$1, Literal nullArray$1) {
        boolean genHistogram = this.supportsHistogram(col$1.dataType()) && colPercentiles$1.contains(col$1);
        Literal intervalNdvsExpr = genHistogram ? new ApproxCountDistinctForIntervals((Expression)col$1, (Expression)new Literal(colPercentiles$1.apply((Object)col$1), (DataType)ArrayType$.MODULE$.apply(col$1.dataType())), conf$2.ndvMaxError(), ApproxCountDistinctForIntervals$.MODULE$.apply$default$4(), ApproxCountDistinctForIntervals$.MODULE$.apply$default$5()) : nullArray$1;
        return AnalyzeColumnCommand.struct$1((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Expression[]{ndv$1, new Cast((Expression)new Min((Expression)col$1), col$1.dataType(), Cast$.MODULE$.apply$default$3()), new Cast((Expression)new Max((Expression)col$1), col$1.dataType(), Cast$.MODULE$.apply$default$3()), numNulls$1, defaultSize$1, defaultSize$1, intervalNdvsExpr}));
    }

    public static final /* synthetic */ double $anonfun$rowToColumnStat$1(Object x$5) {
        return new StringOps(Predef$.MODULE$.augmentString(x$5.toString())).toDouble();
    }

    public AnalyzeColumnCommand(TableIdentifier tableIdent, Seq<String> columnNames) {
        this.tableIdent = tableIdent;
        this.columnNames = columnNames;
        Command.$init$((Command)this);
        RunnableCommand.$init$(this);
    }
}

