/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.columnar;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.ByteBuffer;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.network.util.JavaUtils;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.InternalRow$;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.execution.columnar.CachedBatch;
import org.apache.spark.sql.execution.columnar.CachedRDDBuilder$;
import org.apache.spark.sql.execution.columnar.ColumnBuilder;
import org.apache.spark.sql.execution.columnar.ColumnBuilder$;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.util.LongAccumulator;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\tUb\u0001B\u0001\u0003\u0001>\u0011\u0001cQ1dQ\u0016$'\u000b\u0012#Ck&dG-\u001a:\u000b\u0005\r!\u0011\u0001C2pYVlg.\u0019:\u000b\u0005\u00151\u0011!C3yK\u000e,H/[8o\u0015\t9\u0001\"A\u0002tc2T!!\u0003\u0006\u0002\u000bM\u0004\u0018M]6\u000b\u0005-a\u0011AB1qC\u000eDWMC\u0001\u000e\u0003\ry'oZ\u0002\u0001'\u0011\u0001\u0001CF\r\u0011\u0005E!R\"\u0001\n\u000b\u0003M\tQa]2bY\u0006L!!\u0006\n\u0003\r\u0005s\u0017PU3g!\t\tr#\u0003\u0002\u0019%\t9\u0001K]8ek\u000e$\bCA\t\u001b\u0013\tY\"C\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0003\u0005\u001e\u0001\tU\r\u0011\"\u0001\u001f\u00039)8/Z\"p[B\u0014Xm]:j_:,\u0012a\b\t\u0003#\u0001J!!\t\n\u0003\u000f\t{w\u000e\\3b]\"A1\u0005\u0001B\tB\u0003%q$A\bvg\u0016\u001cu.\u001c9sKN\u001c\u0018n\u001c8!\u0011!)\u0003A!f\u0001\n\u00031\u0013!\u00032bi\u000eD7+\u001b>f+\u00059\u0003CA\t)\u0013\tI#CA\u0002J]RD\u0001b\u000b\u0001\u0003\u0012\u0003\u0006IaJ\u0001\u000bE\u0006$8\r[*ju\u0016\u0004\u0003\u0002C\u0017\u0001\u0005+\u0007I\u0011\u0001\u0018\u0002\u0019M$xN]1hK2+g/\u001a7\u0016\u0003=\u0002\"\u0001M\u001a\u000e\u0003ER!A\r\u0005\u0002\u000fM$xN]1hK&\u0011A'\r\u0002\r'R|'/Y4f\u0019\u00164X\r\u001c\u0005\tm\u0001\u0011\t\u0012)A\u0005_\u0005i1\u000f^8sC\u001e,G*\u001a<fY\u0002B\u0001\u0002\u000f\u0001\u0003\u0016\u0004%\t!O\u0001\u000bG\u0006\u001c\u0007.\u001a3QY\u0006tW#\u0001\u001e\u0011\u0005mbT\"\u0001\u0003\n\u0005u\"!!C*qCJ\\\u0007\u000b\\1o\u0011!y\u0004A!E!\u0002\u0013Q\u0014aC2bG\",G\r\u00157b]\u0002B#AP!\u0011\u0005E\u0011\u0015BA\"\u0013\u0005%!(/\u00198tS\u0016tG\u000f\u0003\u0005F\u0001\tU\r\u0011\"\u0001G\u0003%!\u0018M\u00197f\u001d\u0006lW-F\u0001H!\r\t\u0002JS\u0005\u0003\u0013J\u0011aa\u00149uS>t\u0007CA&S\u001d\ta\u0005\u000b\u0005\u0002N%5\taJ\u0003\u0002P\u001d\u00051AH]8pizJ!!\u0015\n\u0002\rA\u0013X\rZ3g\u0013\t\u0019FK\u0001\u0004TiJLgn\u001a\u0006\u0003#JA\u0001B\u0016\u0001\u0003\u0012\u0003\u0006IaR\u0001\u000bi\u0006\u0014G.\u001a(b[\u0016\u0004\u0003\u0002\u0003-\u0001\u0005\u0003\u0007I\u0011B-\u0002)}\u001b\u0017m\u00195fI\u000e{G.^7o\u0005V4g-\u001a:t+\u0005Q\u0006cA._A6\tAL\u0003\u0002^\u0011\u0005\u0019!\u000f\u001a3\n\u0005}c&a\u0001*E\tB\u0011\u0011MY\u0007\u0002\u0005%\u00111M\u0001\u0002\f\u0007\u0006\u001c\u0007.\u001a3CCR\u001c\u0007\u000e\u0003\u0005f\u0001\t\u0005\r\u0011\"\u0003g\u0003ay6-Y2iK\u0012\u001cu\u000e\\;n]\n+hMZ3sg~#S-\u001d\u000b\u0003O*\u0004\"!\u00055\n\u0005%\u0014\"\u0001B+oSRDqa\u001b3\u0002\u0002\u0003\u0007!,A\u0002yIEB\u0001\"\u001c\u0001\u0003\u0002\u0003\u0006KAW\u0001\u0016?\u000e\f7\r[3e\u0007>dW/\u001c8Ck\u001a4WM]:!Q\ta\u0017\tC\u0003q\u0001\u0011\u0005\u0011/\u0001\u0004=S:LGO\u0010\u000b\u0007eV4x\u000f_=\u0015\u0005M$\bCA1\u0001\u0011\u001dAv\u000e%AA\u0002iCQ!H8A\u0002}AQ!J8A\u0002\u001dBQ!L8A\u0002=BQ\u0001O8A\u0002iBQ!R8A\u0002\u001dCqa\u001f\u0001C\u0002\u0013\u0005A0\u0001\ttSj,\u0017J\u001c\"zi\u0016\u001c8\u000b^1ugV\tQ\u0010E\u0002\u007f\u0003\u0007i\u0011a \u0006\u0004\u0003\u0003A\u0011\u0001B;uS2L1!!\u0002\u0000\u0005=auN\\4BG\u000e,X.\u001e7bi>\u0014\bbBA\u0005\u0001\u0001\u0006I!`\u0001\u0012g&TX-\u00138CsR,7o\u0015;biN\u0004\u0003BBA\u0007\u0001\u0011\u0005\u0011,A\ndC\u000eDW\rZ\"pYVlgNQ;gM\u0016\u00148\u000fC\u0004\u0002\u0012\u0001!\t!a\u0005\u0002\u0015\rdW-\u0019:DC\u000eDW\rF\u0002h\u0003+A\u0011\"a\u0006\u0002\u0010A\u0005\t\u0019A\u0010\u0002\u0011\tdwnY6j]\u001eDq!a\u0007\u0001\t\u0003\ti\"\u0001\bxSRD7)Y2iK\u0012\u0004F.\u00198\u0015\u0007M\fy\u0002\u0003\u00049\u00033\u0001\rA\u000f\u0005\b\u0003G\u0001A\u0011BA\u0013\u00031\u0011W/\u001b7e\u0005V4g-\u001a:t)\u0005Q\u0006\"CA\u0015\u0001\u0005\u0005I\u0011AA\u0016\u0003\u0011\u0019w\u000e]=\u0015\u0019\u00055\u0012\u0011GA\u001a\u0003k\t9$!\u000f\u0015\u0007M\fy\u0003\u0003\u0004Y\u0003O\u0001\rA\u0017\u0005\t;\u0005\u001d\u0002\u0013!a\u0001?!AQ%a\n\u0011\u0002\u0003\u0007q\u0005\u0003\u0005.\u0003O\u0001\n\u00111\u00010\u0011!A\u0014q\u0005I\u0001\u0002\u0004Q\u0004\u0002C#\u0002(A\u0005\t\u0019A$\t\u0013\u0005u\u0002!%A\u0005\u0002\u0005}\u0012\u0001F2mK\u0006\u00148)Y2iK\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002B)\u001aq$a\u0011,\u0005\u0005\u0015\u0003\u0003BA$\u0003#j!!!\u0013\u000b\t\u0005-\u0013QJ\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\u0014\u0013\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003'\nIEA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016D\u0011\"a\u0016\u0001#\u0003%\t!a\u0010\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%c!I\u00111\f\u0001\u0012\u0002\u0013\u0005\u0011QL\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\tyFK\u0002(\u0003\u0007B\u0011\"a\u0019\u0001#\u0003%\t!!\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011q\r\u0016\u0004_\u0005\r\u0003\"CA6\u0001E\u0005I\u0011AA7\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQ*\"!a\u001c+\u0007i\n\u0019\u0005C\u0005\u0002t\u0001\t\n\u0011\"\u0001\u0002v\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012*TCAA<U\r9\u00151\t\u0005\n\u0003w\u0002\u0011\u0011!C!\u0003{\nQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA@!\u0011\t\t)a#\u000e\u0005\u0005\r%\u0002BAC\u0003\u000f\u000bA\u0001\\1oO*\u0011\u0011\u0011R\u0001\u0005U\u00064\u0018-C\u0002T\u0003\u0007C\u0001\"a$\u0001\u0003\u0003%\tAJ\u0001\raJ|G-^2u\u0003JLG/\u001f\u0005\n\u0003'\u0003\u0011\u0011!C\u0001\u0003+\u000ba\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002\u0018\u0006u\u0005cA\t\u0002\u001a&\u0019\u00111\u0014\n\u0003\u0007\u0005s\u0017\u0010\u0003\u0005l\u0003#\u000b\t\u00111\u0001(\u0011%\t\t\u000bAA\u0001\n\u0003\n\u0019+A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t)\u000b\u0005\u0004\u0002(\u00065\u0016qS\u0007\u0003\u0003SS1!a+\u0013\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003_\u000bIK\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011%\t\u0019\fAA\u0001\n\u0003\t),\u0001\u0005dC:,\u0015/^1m)\ry\u0012q\u0017\u0005\nW\u0006E\u0016\u0011!a\u0001\u0003/C\u0011\"a/\u0001\u0003\u0003%\t%!0\u0002\u0011!\f7\u000f[\"pI\u0016$\u0012a\n\u0005\n\u0003\u0003\u0004\u0011\u0011!C!\u0003\u0007\f\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003\u007fB\u0011\"a2\u0001\u0003\u0003%\t%!3\u0002\r\u0015\fX/\u00197t)\ry\u00121\u001a\u0005\nW\u0006\u0015\u0017\u0011!a\u0001\u0003/;\u0011\"a4\u0003\u0003\u0003E\t!!5\u0002!\r\u000b7\r[3e%\u0012#%)^5mI\u0016\u0014\bcA1\u0002T\u001aA\u0011AAA\u0001\u0012\u0003\t)n\u0005\u0003\u0002TBI\u0002b\u00029\u0002T\u0012\u0005\u0011\u0011\u001c\u000b\u0003\u0003#D!\"!1\u0002T\u0006\u0005IQIAb\u0011)\ty.a5\u0002\u0002\u0013\u0005\u0015\u0011]\u0001\u0006CB\u0004H.\u001f\u000b\r\u0003G\f9/!;\u0002l\u00065\u0018q\u001e\u000b\u0004g\u0006\u0015\b\u0002\u0003-\u0002^B\u0005\t\u0019\u0001.\t\ru\ti\u000e1\u0001 \u0011\u0019)\u0013Q\u001ca\u0001O!1Q&!8A\u0002=Ba\u0001OAo\u0001\u0004Q\u0004BB#\u0002^\u0002\u0007q\t\u0003\u0006\u0002t\u0006M\u0017\u0011!CA\u0003k\fq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002x\u0006}\b\u0003B\tI\u0003s\u0004\u0002\"EA~?\u001dz#hR\u0005\u0004\u0003{\u0014\"A\u0002+va2,W\u0007C\u0005\u0003\u0002\u0005E\u0018\u0011!a\u0001g\u0006\u0019\u0001\u0010\n\u0019\t\u0015\t\u0015\u00111[I\u0001\n\u0003\u00119!A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HE\u000e\u000b\r\u0005\u0013\u0011YA!\u0004\u0003\u0010\tE!Q\u0003\u0016\u00045\u0006\r\u0003BB\u000f\u0003\u0004\u0001\u0007q\u0004\u0003\u0004&\u0005\u0007\u0001\ra\n\u0005\u0007[\t\r\u0001\u0019A\u0018\t\ra\u0012\u0019\u00011\u0001;Q\r\u0011\t\"\u0011\u0005\u0007\u000b\n\r\u0001\u0019A$\t\u0015\te\u00111[I\u0001\n\u0003\u0011Y\"A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00137)1\u0011IA!\b\u0003 \t\u0005\"1\u0005B\u0014\u0011\u0019i\"q\u0003a\u0001?!1QEa\u0006A\u0002\u001dBa!\fB\f\u0001\u0004y\u0003B\u0002\u001d\u0003\u0018\u0001\u0007!\bK\u0002\u0003$\u0005Ca!\u0012B\f\u0001\u00049\u0005B\u0003B\u0016\u0003'\f\t\u0011\"\u0003\u0003.\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0011y\u0003\u0005\u0003\u0002\u0002\nE\u0012\u0002\u0002B\u001a\u0003\u0007\u0013aa\u00142kK\u000e$\b")
public class CachedRDDBuilder
implements Product,
scala.Serializable {
    private final boolean useCompression;
    private final int batchSize;
    private final StorageLevel storageLevel;
    private final transient SparkPlan cachedPlan;
    private final Option<String> tableName;
    private transient RDD<CachedBatch> _cachedColumnBuffers;
    private final LongAccumulator sizeInBytesStats;

    public static RDD<CachedBatch> apply$default$6(boolean bl, int n, StorageLevel storageLevel, SparkPlan sparkPlan, Option<String> option) {
        return CachedRDDBuilder$.MODULE$.apply$default$6(bl, n, storageLevel, sparkPlan, option);
    }

    public static RDD<CachedBatch> $lessinit$greater$default$6(boolean bl, int n, StorageLevel storageLevel, SparkPlan sparkPlan, Option<String> option) {
        return CachedRDDBuilder$.MODULE$.$lessinit$greater$default$6(bl, n, storageLevel, sparkPlan, option);
    }

    public static Option<Tuple5<Object, Object, StorageLevel, SparkPlan, Option<String>>> unapply(CachedRDDBuilder cachedRDDBuilder) {
        return CachedRDDBuilder$.MODULE$.unapply(cachedRDDBuilder);
    }

    public static CachedRDDBuilder apply(boolean bl, int n, StorageLevel storageLevel, SparkPlan sparkPlan, Option<String> option, RDD<CachedBatch> rDD) {
        return CachedRDDBuilder$.MODULE$.apply(bl, n, storageLevel, sparkPlan, option, rDD);
    }

    public boolean useCompression() {
        return this.useCompression;
    }

    public int batchSize() {
        return this.batchSize;
    }

    public StorageLevel storageLevel() {
        return this.storageLevel;
    }

    public SparkPlan cachedPlan() {
        return this.cachedPlan;
    }

    public Option<String> tableName() {
        return this.tableName;
    }

    private RDD<CachedBatch> _cachedColumnBuffers() {
        return this._cachedColumnBuffers;
    }

    private void _cachedColumnBuffers_$eq(RDD<CachedBatch> x$1) {
        this._cachedColumnBuffers = x$1;
    }

    public LongAccumulator sizeInBytesStats() {
        return this.sizeInBytesStats;
    }

    public RDD<CachedBatch> cachedColumnBuffers() {
        if (this._cachedColumnBuffers() == null) {
            CachedRDDBuilder cachedRDDBuilder = this;
            synchronized (cachedRDDBuilder) {
                if (this._cachedColumnBuffers() == null) {
                    this._cachedColumnBuffers_$eq(this.buildBuffers());
                }
            }
        }
        return this._cachedColumnBuffers();
    }

    public void clearCache(boolean blocking) {
        if (this._cachedColumnBuffers() != null) {
            CachedRDDBuilder cachedRDDBuilder = this;
            synchronized (cachedRDDBuilder) {
                if (this._cachedColumnBuffers() != null) {
                    this._cachedColumnBuffers().unpersist(blocking);
                    this._cachedColumnBuffers_$eq(null);
                }
            }
        }
    }

    public boolean clearCache$default$1() {
        return true;
    }

    public CachedRDDBuilder withCachedPlan(SparkPlan cachedPlan) {
        return new CachedRDDBuilder(this.useCompression(), this.batchSize(), this.storageLevel(), cachedPlan, this.tableName(), this._cachedColumnBuffers());
    }

    /*
     * WARNING - void declaration
     */
    private RDD<CachedBatch> buildBuffers() {
        void var2_5;
        Seq output = this.cachedPlan().output();
        RDD<InternalRow> qual$1 = this.cachedPlan().execute();
        Function1 & Serializable & scala.Serializable x$4 = (Function1 & Serializable & scala.Serializable)rowIterator -> new Iterator<CachedBatch>(this, output, rowIterator){
            private final /* synthetic */ CachedRDDBuilder $outer;
            private final Seq output$1;
            private final Iterator rowIterator$1;

            public Iterator<CachedBatch> seq() {
                return Iterator.seq$((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.isEmpty$((Iterator)this);
            }

            public boolean isTraversableAgain() {
                return Iterator.isTraversableAgain$((Iterator)this);
            }

            public boolean hasDefiniteSize() {
                return Iterator.hasDefiniteSize$((Iterator)this);
            }

            public Iterator<CachedBatch> take(int n) {
                return Iterator.take$((Iterator)this, (int)n);
            }

            public Iterator<CachedBatch> drop(int n) {
                return Iterator.drop$((Iterator)this, (int)n);
            }

            public Iterator<CachedBatch> slice(int from, int until) {
                return Iterator.slice$((Iterator)this, (int)from, (int)until);
            }

            public Iterator<CachedBatch> sliceIterator(int from, int until) {
                return Iterator.sliceIterator$((Iterator)this, (int)from, (int)until);
            }

            public <B> Iterator<B> map(Function1<CachedBatch, B> f) {
                return Iterator.map$((Iterator)this, f);
            }

            public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                return Iterator.$plus$plus$((Iterator)this, that);
            }

            public <B> Iterator<B> flatMap(Function1<CachedBatch, GenTraversableOnce<B>> f) {
                return Iterator.flatMap$((Iterator)this, f);
            }

            public Iterator<CachedBatch> filter(Function1<CachedBatch, Object> p) {
                return Iterator.filter$((Iterator)this, p);
            }

            public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<CachedBatch, B, Object> p) {
                return Iterator.corresponds$((Iterator)this, that, p);
            }

            public Iterator<CachedBatch> withFilter(Function1<CachedBatch, Object> p) {
                return Iterator.withFilter$((Iterator)this, p);
            }

            public Iterator<CachedBatch> filterNot(Function1<CachedBatch, Object> p) {
                return Iterator.filterNot$((Iterator)this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<CachedBatch, B> pf) {
                return Iterator.collect$((Iterator)this, pf);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, CachedBatch, B> op) {
                return Iterator.scanLeft$((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<CachedBatch, B, B> op) {
                return Iterator.scanRight$((Iterator)this, z, op);
            }

            public Iterator<CachedBatch> takeWhile(Function1<CachedBatch, Object> p) {
                return Iterator.takeWhile$((Iterator)this, p);
            }

            public Tuple2<Iterator<CachedBatch>, Iterator<CachedBatch>> partition(Function1<CachedBatch, Object> p) {
                return Iterator.partition$((Iterator)this, p);
            }

            public Tuple2<Iterator<CachedBatch>, Iterator<CachedBatch>> span(Function1<CachedBatch, Object> p) {
                return Iterator.span$((Iterator)this, p);
            }

            public Iterator<CachedBatch> dropWhile(Function1<CachedBatch, Object> p) {
                return Iterator.dropWhile$((Iterator)this, p);
            }

            public <B> Iterator<Tuple2<CachedBatch, B>> zip(Iterator<B> that) {
                return Iterator.zip$((Iterator)this, that);
            }

            public <A1> Iterator<A1> padTo(int len, A1 elem) {
                return Iterator.padTo$((Iterator)this, (int)len, elem);
            }

            public Iterator<Tuple2<CachedBatch, Object>> zipWithIndex() {
                return Iterator.zipWithIndex$((Iterator)this);
            }

            public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                return Iterator.zipAll$((Iterator)this, that, thisElem, thatElem);
            }

            public <U> void foreach(Function1<CachedBatch, U> f) {
                Iterator.foreach$((Iterator)this, f);
            }

            public boolean forall(Function1<CachedBatch, Object> p) {
                return Iterator.forall$((Iterator)this, p);
            }

            public boolean exists(Function1<CachedBatch, Object> p) {
                return Iterator.exists$((Iterator)this, p);
            }

            public boolean contains(Object elem) {
                return Iterator.contains$((Iterator)this, (Object)elem);
            }

            public Option<CachedBatch> find(Function1<CachedBatch, Object> p) {
                return Iterator.find$((Iterator)this, p);
            }

            public int indexWhere(Function1<CachedBatch, Object> p) {
                return Iterator.indexWhere$((Iterator)this, p);
            }

            public int indexWhere(Function1<CachedBatch, Object> p, int from) {
                return Iterator.indexWhere$((Iterator)this, p, (int)from);
            }

            public <B> int indexOf(B elem) {
                return Iterator.indexOf$((Iterator)this, elem);
            }

            public <B> int indexOf(B elem, int from) {
                return Iterator.indexOf$((Iterator)this, elem, (int)from);
            }

            public BufferedIterator<CachedBatch> buffered() {
                return Iterator.buffered$((Iterator)this);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size) {
                return Iterator.grouped$((Iterator)this, (int)size);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                return Iterator.sliding$((Iterator)this, (int)size, (int)step);
            }

            public int length() {
                return Iterator.length$((Iterator)this);
            }

            public Tuple2<Iterator<CachedBatch>, Iterator<CachedBatch>> duplicate() {
                return Iterator.duplicate$((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.patch$((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <B> void copyToArray(Object xs, int start, int len) {
                Iterator.copyToArray$((Iterator)this, (Object)xs, (int)start, (int)len);
            }

            public boolean sameElements(Iterator<?> that) {
                return Iterator.sameElements$((Iterator)this, that);
            }

            public Traversable<CachedBatch> toTraversable() {
                return Iterator.toTraversable$((Iterator)this);
            }

            public Iterator<CachedBatch> toIterator() {
                return Iterator.toIterator$((Iterator)this);
            }

            public Stream<CachedBatch> toStream() {
                return Iterator.toStream$((Iterator)this);
            }

            public String toString() {
                return Iterator.toString$((Iterator)this);
            }

            public <B> int sliding$default$2() {
                return Iterator.sliding$default$2$((Iterator)this);
            }

            public List<CachedBatch> reversed() {
                return TraversableOnce.reversed$((TraversableOnce)this);
            }

            public int size() {
                return TraversableOnce.size$((TraversableOnce)this);
            }

            public boolean nonEmpty() {
                return TraversableOnce.nonEmpty$((TraversableOnce)this);
            }

            public int count(Function1<CachedBatch, Object> p) {
                return TraversableOnce.count$((TraversableOnce)this, p);
            }

            public <B> Option<B> collectFirst(PartialFunction<CachedBatch, B> pf) {
                return TraversableOnce.collectFirst$((TraversableOnce)this, pf);
            }

            public <B> B $div$colon(B z, Function2<B, CachedBatch, B> op) {
                return (B)TraversableOnce.$div$colon$((TraversableOnce)this, z, op);
            }

            public <B> B $colon$bslash(B z, Function2<CachedBatch, B, B> op) {
                return (B)TraversableOnce.$colon$bslash$((TraversableOnce)this, z, op);
            }

            public <B> B foldLeft(B z, Function2<B, CachedBatch, B> op) {
                return (B)TraversableOnce.foldLeft$((TraversableOnce)this, z, op);
            }

            public <B> B foldRight(B z, Function2<CachedBatch, B, B> op) {
                return (B)TraversableOnce.foldRight$((TraversableOnce)this, z, op);
            }

            public <B> B reduceLeft(Function2<B, CachedBatch, B> op) {
                return (B)TraversableOnce.reduceLeft$((TraversableOnce)this, op);
            }

            public <B> B reduceRight(Function2<CachedBatch, B, B> op) {
                return (B)TraversableOnce.reduceRight$((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, CachedBatch, B> op) {
                return TraversableOnce.reduceLeftOption$((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<CachedBatch, B, B> op) {
                return TraversableOnce.reduceRightOption$((TraversableOnce)this, op);
            }

            public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.reduce$((TraversableOnce)this, op);
            }

            public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                return TraversableOnce.reduceOption$((TraversableOnce)this, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.fold$((TraversableOnce)this, z, op);
            }

            public <B> B aggregate(Function0<B> z, Function2<B, CachedBatch, B> seqop, Function2<B, B, B> combop) {
                return (B)TraversableOnce.aggregate$((TraversableOnce)this, z, seqop, combop);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)TraversableOnce.sum$((TraversableOnce)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)TraversableOnce.product$((TraversableOnce)this, num);
            }

            public Object min(Ordering cmp) {
                return TraversableOnce.min$((TraversableOnce)this, (Ordering)cmp);
            }

            public Object max(Ordering cmp) {
                return TraversableOnce.max$((TraversableOnce)this, (Ordering)cmp);
            }

            public Object maxBy(Function1 f, Ordering cmp) {
                return TraversableOnce.maxBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public Object minBy(Function1 f, Ordering cmp) {
                return TraversableOnce.minBy$((TraversableOnce)this, (Function1)f, (Ordering)cmp);
            }

            public <B> void copyToBuffer(Buffer<B> dest) {
                TraversableOnce.copyToBuffer$((TraversableOnce)this, dest);
            }

            public <B> void copyToArray(Object xs, int start) {
                TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs, (int)start);
            }

            public <B> void copyToArray(Object xs) {
                TraversableOnce.copyToArray$((TraversableOnce)this, (Object)xs);
            }

            public <B> Object toArray(ClassTag<B> evidence$1) {
                return TraversableOnce.toArray$((TraversableOnce)this, evidence$1);
            }

            public List<CachedBatch> toList() {
                return TraversableOnce.toList$((TraversableOnce)this);
            }

            public Iterable<CachedBatch> toIterable() {
                return TraversableOnce.toIterable$((TraversableOnce)this);
            }

            public Seq<CachedBatch> toSeq() {
                return TraversableOnce.toSeq$((TraversableOnce)this);
            }

            public IndexedSeq<CachedBatch> toIndexedSeq() {
                return TraversableOnce.toIndexedSeq$((TraversableOnce)this);
            }

            public <B> Buffer<B> toBuffer() {
                return TraversableOnce.toBuffer$((TraversableOnce)this);
            }

            public <B> Set<B> toSet() {
                return TraversableOnce.toSet$((TraversableOnce)this);
            }

            public Vector<CachedBatch> toVector() {
                return TraversableOnce.toVector$((TraversableOnce)this);
            }

            public <Col> Col to(CanBuildFrom<Nothing$, CachedBatch, Col> cbf) {
                return (Col)TraversableOnce.to$((TraversableOnce)this, cbf);
            }

            public <T, U> Map<T, U> toMap(Predef.$less$colon$less<CachedBatch, Tuple2<T, U>> ev) {
                return TraversableOnce.toMap$((TraversableOnce)this, ev);
            }

            public String mkString(String start, String sep, String end) {
                return TraversableOnce.mkString$((TraversableOnce)this, (String)start, (String)sep, (String)end);
            }

            public String mkString(String sep) {
                return TraversableOnce.mkString$((TraversableOnce)this, (String)sep);
            }

            public String mkString() {
                return TraversableOnce.mkString$((TraversableOnce)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public StringBuilder addString(StringBuilder b, String sep) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b, (String)sep);
            }

            public StringBuilder addString(StringBuilder b) {
                return TraversableOnce.addString$((TraversableOnce)this, (StringBuilder)b);
            }

            public int sizeHintIfCheap() {
                return GenTraversableOnce.sizeHintIfCheap$((GenTraversableOnce)this);
            }

            public CachedBatch next() {
                int rowCount;
                ColumnBuilder[] columnBuilders = (ColumnBuilder[])((TraversableOnce)this.output$1.map((Function1 & Serializable & scala.Serializable)attribute -> ColumnBuilder$.MODULE$.apply(attribute.dataType(), $this.$outer.batchSize(), attribute.name(), $this.$outer.useCompression()), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ColumnBuilder.class));
                long totalSize = 0L;
                for (rowCount = 0; this.rowIterator$1.hasNext() && rowCount < this.$outer.batchSize() && totalSize < ColumnBuilder$.MODULE$.MAX_BATCH_SIZE_IN_BYTE(); ++rowCount) {
                    InternalRow row = (InternalRow)this.rowIterator$1.next();
                    Predef$.MODULE$.assert(row.numFields() == columnBuilders.length, (Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(47).append("Row column number mismatch, expected ").append($this.output$1.size()).append(" columns, ").append(new java.lang.StringBuilder(9).append("but got ").append(row.numFields()).append(".").toString()).append(new java.lang.StringBuilder(14).append("\nRow content: ").append(row).toString()).toString());
                    totalSize = 0L;
                    for (int i = 0; i < row.numFields(); ++i) {
                        columnBuilders[i].appendFrom(row, i);
                        totalSize += columnBuilders[i].columnStats().sizeInBytes();
                    }
                }
                this.$outer.sizeInBytesStats().add(totalSize);
                InternalRow stats = InternalRow$.MODULE$.fromSeq((Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])columnBuilders)).flatMap((Function1 & Serializable & scala.Serializable)x$1 -> Predef$.MODULE$.genericArrayOps((Object)x$1.columnStats().collectedStatistics()), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit())));
                return new CachedBatch(rowCount, (byte[][])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])columnBuilders)).map((Function1 & Serializable & scala.Serializable)builder -> JavaUtils.bufferToArray((ByteBuffer)builder.build()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)))), stats);
            }

            public boolean hasNext() {
                return this.rowIterator$1.hasNext();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.output$1 = output$1;
                this.rowIterator$1 = rowIterator$1;
                GenTraversableOnce.$init$((GenTraversableOnce)this);
                TraversableOnce.$init$((TraversableOnce)this);
                Iterator.$init$((Iterator)this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$next$1(org.apache.spark.sql.execution.columnar.CachedRDDBuilder$$anon$1 org.apache.spark.sql.catalyst.expressions.Attribute ), $anonfun$next$2(org.apache.spark.sql.execution.columnar.CachedRDDBuilder$$anon$1 org.apache.spark.sql.catalyst.InternalRow ), $anonfun$next$3(org.apache.spark.sql.execution.columnar.ColumnBuilder ), $anonfun$next$4(org.apache.spark.sql.execution.columnar.ColumnBuilder )}, serializedLambda);
            }
        };
        boolean x$5 = qual$1.mapPartitionsInternal$default$2();
        RDD cached = qual$1.mapPartitionsInternal((Function1)x$4, x$5, ClassTag$.MODULE$.apply(CachedBatch.class)).persist(this.storageLevel());
        cached.setName((String)this.tableName().map((Function1 & Serializable & scala.Serializable)n -> new java.lang.StringBuilder(16).append("In-memory table ").append((String)n).toString()).getOrElse((Function0 & Serializable & scala.Serializable)() -> StringUtils.abbreviate((String)this.cachedPlan().toString(), (int)1024)));
        return var2_5;
    }

    public CachedRDDBuilder copy(boolean useCompression, int batchSize, StorageLevel storageLevel, SparkPlan cachedPlan, Option<String> tableName, RDD<CachedBatch> _cachedColumnBuffers) {
        return new CachedRDDBuilder(useCompression, batchSize, storageLevel, cachedPlan, tableName, _cachedColumnBuffers);
    }

    public boolean copy$default$1() {
        return this.useCompression();
    }

    public int copy$default$2() {
        return this.batchSize();
    }

    public StorageLevel copy$default$3() {
        return this.storageLevel();
    }

    public SparkPlan copy$default$4() {
        return this.cachedPlan();
    }

    public Option<String> copy$default$5() {
        return this.tableName();
    }

    public String productPrefix() {
        return "CachedRDDBuilder";
    }

    public int productArity() {
        return 5;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = BoxesRunTime.boxToBoolean((boolean)this.useCompression());
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToInteger((int)this.batchSize());
                break;
            }
            case 2: {
                object = this.storageLevel();
                break;
            }
            case 3: {
                object = this.cachedPlan();
                break;
            }
            case 4: {
                object = this.tableName();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CachedRDDBuilder;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)(this.useCompression() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)this.batchSize());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.storageLevel()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)((Object)this.cachedPlan())));
        n = Statics.mix((int)n, (int)Statics.anyHash(this.tableName()));
        return Statics.finalizeHash((int)n, (int)5);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CachedRDDBuilder)) return false;
        boolean bl = true;
        if (!bl) return false;
        CachedRDDBuilder cachedRDDBuilder = (CachedRDDBuilder)x$1;
        if (this.useCompression() != cachedRDDBuilder.useCompression()) return false;
        if (this.batchSize() != cachedRDDBuilder.batchSize()) return false;
        StorageLevel storageLevel = this.storageLevel();
        StorageLevel storageLevel2 = cachedRDDBuilder.storageLevel();
        if (storageLevel == null) {
            if (storageLevel2 != null) {
                return false;
            }
        } else if (!storageLevel.equals(storageLevel2)) return false;
        SparkPlan sparkPlan = this.cachedPlan();
        SparkPlan sparkPlan2 = cachedRDDBuilder.cachedPlan();
        if (sparkPlan == null) {
            if (sparkPlan2 != null) {
                return false;
            }
        } else if (!((Object)((Object)sparkPlan)).equals((Object)sparkPlan2)) return false;
        Option<String> option = this.tableName();
        Option<String> option2 = cachedRDDBuilder.tableName();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!cachedRDDBuilder.canEqual(this)) return false;
        return true;
    }

    public CachedRDDBuilder(boolean useCompression, int batchSize, StorageLevel storageLevel, SparkPlan cachedPlan, Option<String> tableName, RDD<CachedBatch> _cachedColumnBuffers) {
        this.useCompression = useCompression;
        this.batchSize = batchSize;
        this.storageLevel = storageLevel;
        this.cachedPlan = cachedPlan;
        this.tableName = tableName;
        this._cachedColumnBuffers = _cachedColumnBuffers;
        Product.$init$((Product)this);
        this.sizeInBytesStats = cachedPlan.sqlContext().sparkContext().longAccumulator();
    }
}

