/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.Serializable;
import java.util.Locale;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import org.apache.spark.annotation.InterfaceStability;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.AnalysisException$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.EliminateSubqueryAliases$;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation;
import org.apache.spark.sql.catalyst.catalog.BucketSpec;
import org.apache.spark.sql.catalyst.catalog.CatalogStorageFormat;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTable$;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.catalyst.catalog.HiveTableRelation;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.catalyst.expressions.package$;
import org.apache.spark.sql.catalyst.plans.logical.InsertIntoTable;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.SQLExecution$;
import org.apache.spark.sql.execution.command.DDLUtils$;
import org.apache.spark.sql.execution.datasources.CreateTable;
import org.apache.spark.sql.execution.datasources.DataSource;
import org.apache.spark.sql.execution.datasources.DataSource$;
import org.apache.spark.sql.execution.datasources.LogicalRelation;
import org.apache.spark.sql.execution.datasources.v2.DataSourceV2Utils$;
import org.apache.spark.sql.execution.datasources.v2.WriteToDataSourceV2;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.v2.DataSourceOptions;
import org.apache.spark.sql.sources.v2.DataSourceV2;
import org.apache.spark.sql.sources.v2.WriteSupport;
import org.apache.spark.sql.sources.v2.writer.DataSourceWriter;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.HashMap;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@InterfaceStability.Stable
@ScalaSignature(bytes="\u0006\u0001\t\u0015g\u0001B\u0001\u0003\u0005-\u0011q\u0002R1uC\u001a\u0013\u0018-\\3Xe&$XM\u001d\u0006\u0003\u0007\u0011\t1a]9m\u0015\t)a!A\u0003ta\u0006\u00148N\u0003\u0002\b\u0011\u00051\u0011\r]1dQ\u0016T\u0011!C\u0001\u0004_J<7\u0001A\u000b\u0003\u0019m\u0019\"\u0001A\u0007\u0011\u00059\tR\"A\b\u000b\u0003A\tQa]2bY\u0006L!AE\b\u0003\r\u0005s\u0017PU3g\u0011!!\u0002A!A!\u0002\u0013)\u0012A\u00013t!\r1r#G\u0007\u0002\u0005%\u0011\u0001D\u0001\u0002\b\t\u0006$\u0018m]3u!\tQ2\u0004\u0004\u0001\u0005\u000bq\u0001!\u0019A\u000f\u0003\u0003Q\u000b\"AH\u0011\u0011\u00059y\u0012B\u0001\u0011\u0010\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"A\u0004\u0012\n\u0005\rz!aA!os\"1Q\u0005\u0001C\u0001\u0005\u0019\na\u0001P5oSRtDCA\u0014)!\r1\u0002!\u0007\u0005\u0006)\u0011\u0002\r!\u0006\u0005\bU\u0001\u0011\r\u0011\"\u0003,\u0003\t!g-F\u0001-!\ti\u0003G\u0004\u0002\u0017]%\u0011qFA\u0001\ba\u0006\u001c7.Y4f\u0013\t\t$GA\u0005ECR\fgI]1nK*\u0011qF\u0001\u0005\u0007i\u0001\u0001\u000b\u0011\u0002\u0017\u0002\u0007\u00114\u0007\u0005C\u00037\u0001\u0011\u0005q'\u0001\u0003n_\u0012,GCA\u00149\u0011\u0015IT\u00071\u0001;\u0003!\u0019\u0018M^3N_\u0012,\u0007C\u0001\f<\u0013\ta$A\u0001\u0005TCZ,Wj\u001c3f\u0011\u00151\u0004\u0001\"\u0001?)\t9s\bC\u0003:{\u0001\u0007\u0001\t\u0005\u0002B\u0011:\u0011!I\u0012\t\u0003\u0007>i\u0011\u0001\u0012\u0006\u0003\u000b*\ta\u0001\u0010:p_Rt\u0014BA$\u0010\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011J\u0013\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u001d{\u0001\"\u0002'\u0001\t\u0003i\u0015A\u00024pe6\fG\u000f\u0006\u0002(\u001d\")qj\u0013a\u0001\u0001\u000611o\\;sG\u0016DQ!\u0015\u0001\u0005\u0002I\u000baa\u001c9uS>tGcA\u0014T+\")A\u000b\u0015a\u0001\u0001\u0006\u00191.Z=\t\u000bY\u0003\u0006\u0019\u0001!\u0002\u000bY\fG.^3\t\u000bE\u0003A\u0011\u0001-\u0015\u0007\u001dJ&\fC\u0003U/\u0002\u0007\u0001\tC\u0003W/\u0002\u00071\f\u0005\u0002\u000f9&\u0011Ql\u0004\u0002\b\u0005>|G.Z1o\u0011\u0015\t\u0006\u0001\"\u0001`)\r9\u0003-\u0019\u0005\u0006)z\u0003\r\u0001\u0011\u0005\u0006-z\u0003\rA\u0019\t\u0003\u001d\rL!\u0001Z\b\u0003\t1{gn\u001a\u0005\u0006#\u0002!\tA\u001a\u000b\u0004O\u001dD\u0007\"\u0002+f\u0001\u0004\u0001\u0005\"\u0002,f\u0001\u0004I\u0007C\u0001\bk\u0013\tYwB\u0001\u0004E_V\u0014G.\u001a\u0005\u0006[\u0002!\tA\\\u0001\b_B$\u0018n\u001c8t)\t9s\u000eC\u0003nY\u0002\u0007\u0001\u000f\u0005\u0003ri\u0002\u0003U\"\u0001:\u000b\u0005M|\u0011AC2pY2,7\r^5p]&\u0011QO\u001d\u0002\u0004\u001b\u0006\u0004\b\"B7\u0001\t\u00039HCA\u0014y\u0011\u0015ig\u000f1\u0001z!\u0011Qx\u0010\u0011!\u000e\u0003mT!\u0001`?\u0002\tU$\u0018\u000e\u001c\u0006\u0002}\u0006!!.\u0019<b\u0013\t)8\u0010C\u0004\u0002\u0004\u0001!\t!!\u0002\u0002\u0017A\f'\u000f^5uS>t')\u001f\u000b\u0004O\u0005\u001d\u0001\u0002CA\u0005\u0003\u0003\u0001\r!a\u0003\u0002\u0011\r|GNT1nKN\u0004BADA\u0007\u0001&\u0019\u0011qB\b\u0003\u0015q\u0012X\r]3bi\u0016$g\b\u000b\u0003\u0002\u0002\u0005M\u0001\u0003BA\u000b\u00037i!!a\u0006\u000b\u0007\u0005eq\"\u0001\u0006b]:|G/\u0019;j_:LA!!\b\u0002\u0018\t9a/\u0019:be\u001e\u001c\bbBA\u0011\u0001\u0011\u0005\u00111E\u0001\tEV\u001c7.\u001a;CsR9q%!\n\u00020\u0005M\u0002\u0002CA\u0014\u0003?\u0001\r!!\u000b\u0002\u00159,XNQ;dW\u0016$8\u000fE\u0002\u000f\u0003WI1!!\f\u0010\u0005\rIe\u000e\u001e\u0005\b\u0003c\ty\u00021\u0001A\u0003\u001d\u0019w\u000e\u001c(b[\u0016D\u0001\"!\u0003\u0002 \u0001\u0007\u00111\u0002\u0015\u0005\u0003?\t\u0019\u0002C\u0004\u0002:\u0001!\t!a\u000f\u0002\rM|'\u000f\u001e\"z)\u00159\u0013QHA \u0011\u001d\t\t$a\u000eA\u0002\u0001C\u0001\"!\u0003\u00028\u0001\u0007\u00111\u0002\u0015\u0005\u0003o\t\u0019\u0002C\u0004\u0002F\u0001!\t!a\u0012\u0002\tM\fg/\u001a\u000b\u0005\u0003\u0013\ny\u0005E\u0002\u000f\u0003\u0017J1!!\u0014\u0010\u0005\u0011)f.\u001b;\t\u000f\u0005E\u00131\ta\u0001\u0001\u0006!\u0001/\u0019;i\u0011\u001d\t)\u0005\u0001C\u0001\u0003+\"\"!!\u0013\t\u000f\u0005e\u0003\u0001\"\u0003\u0002V\u0005q1/\u0019<f)>4\u0016gU8ve\u000e,\u0007bBA/\u0001\u0011\u0005\u0011qL\u0001\u000bS:\u001cXM\u001d;J]R|G\u0003BA%\u0003CBq!a\u0019\u0002\\\u0001\u0007\u0001)A\u0005uC\ndWMT1nK\"9\u0011Q\f\u0001\u0005\n\u0005\u001dD\u0003BA%\u0003SB\u0001\"a\u001b\u0002f\u0001\u0007\u0011QN\u0001\u000bi\u0006\u0014G.Z%eK:$\b\u0003BA8\u0003kj!!!\u001d\u000b\u0007\u0005M$!\u0001\u0005dCR\fG._:u\u0013\u0011\t9(!\u001d\u0003\u001fQ\u000b'\r\\3JI\u0016tG/\u001b4jKJDq!a\u001f\u0001\t\u0013\ti(A\u0007hKR\u0014UoY6fiN\u0003XmY\u000b\u0003\u0003\u007f\u0002RADAA\u0003\u000bK1!a!\u0010\u0005\u0019y\u0005\u000f^5p]B!\u0011qQAG\u001b\t\tII\u0003\u0003\u0002\f\u0006E\u0014aB2bi\u0006dwnZ\u0005\u0005\u0003\u001f\u000bII\u0001\u0006Ck\u000e\\W\r^*qK\u000eDq!a%\u0001\t\u0013\t)*A\tbgN,'\u000f\u001e(pi\n+8m[3uK\u0012$B!!\u0013\u0002\u0018\"9\u0011\u0011TAI\u0001\u0004\u0001\u0015!C8qKJ\fG/[8o\u0011\u001d\ti\n\u0001C\u0005\u0003?\u000bA#Y:tKJ$hj\u001c;QCJ$\u0018\u000e^5p]\u0016$G\u0003BA%\u0003CCq!!'\u0002\u001c\u0002\u0007\u0001\tC\u0004\u0002&\u0002!\t!a*\u0002\u0017M\fg/Z!t)\u0006\u0014G.\u001a\u000b\u0005\u0003\u0013\nI\u000bC\u0004\u0002d\u0005\r\u0006\u0019\u0001!\t\u000f\u0005\u0015\u0006\u0001\"\u0003\u0002.R!\u0011\u0011JAX\u0011!\tY'a+A\u0002\u00055\u0004bBAZ\u0001\u0011%\u0011QW\u0001\fGJ,\u0017\r^3UC\ndW\r\u0006\u0003\u0002J\u0005]\u0006\u0002CA6\u0003c\u0003\r!!\u001c\t\u000f\u0005m\u0006\u0001\"\u0001\u0002>\u0006!!\u000e\u001a2d)!\tI%a0\u0002D\u0006\u001d\u0007bBAa\u0003s\u0003\r\u0001Q\u0001\u0004kJd\u0007bBAc\u0003s\u0003\r\u0001Q\u0001\u0006i\u0006\u0014G.\u001a\u0005\t\u0003\u0013\fI\f1\u0001\u0002L\u0006!2m\u001c8oK\u000e$\u0018n\u001c8Qe>\u0004XM\u001d;jKN\u00042A_Ag\u0013\r\tym\u001f\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\bbBAj\u0001\u0011\u0005\u0011Q[\u0001\u0005UN|g\u000e\u0006\u0003\u0002J\u0005]\u0007bBA)\u0003#\u0004\r\u0001\u0011\u0005\b\u00037\u0004A\u0011AAo\u0003\u001d\u0001\u0018M]9vKR$B!!\u0013\u0002`\"9\u0011\u0011KAm\u0001\u0004\u0001\u0005bBAr\u0001\u0011\u0005\u0011Q]\u0001\u0004_J\u001cG\u0003BA%\u0003ODq!!\u0015\u0002b\u0002\u0007\u0001\tC\u0004\u0002l\u0002!\t!!<\u0002\tQ,\u0007\u0010\u001e\u000b\u0005\u0003\u0013\ny\u000fC\u0004\u0002R\u0005%\b\u0019\u0001!\t\u000f\u0005M\b\u0001\"\u0001\u0002v\u0006\u00191m\u001d<\u0015\t\u0005%\u0013q\u001f\u0005\b\u0003#\n\t\u00101\u0001A\u0011\u001d\tY\u0010\u0001C\u0005\u0003{\f!B];o\u0007>lW.\u00198e)\u0019\tyP!\u0006\u0003 Q!\u0011\u0011\nB\u0001\u0011!\u0011\u0019!!?A\u0002\t\u0015\u0011aB2p[6\fg\u000e\u001a\t\u0005\u0005\u000f\u0011\t\"\u0004\u0002\u0003\n)!!1\u0002B\u0007\u0003\u001dawnZ5dC2TAAa\u0004\u0002r\u0005)\u0001\u000f\\1og&!!1\u0003B\u0005\u0005-aunZ5dC2\u0004F.\u00198\t\u0011\t]\u0011\u0011 a\u0001\u00053\tqa]3tg&|g\u000eE\u0002\u0017\u00057I1A!\b\u0003\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0011\u001d\u0011\t#!?A\u0002\u0001\u000bAA\\1nK\"Aq\n\u0001a\u0001\n\u0013\u0011)#F\u0001A\u0011%\u0011I\u0003\u0001a\u0001\n\u0013\u0011Y#\u0001\u0006t_V\u00148-Z0%KF$B!!\u0013\u0003.!I!q\u0006B\u0014\u0003\u0003\u0005\r\u0001Q\u0001\u0004q\u0012\n\u0004b\u0002B\u001a\u0001\u0001\u0006K\u0001Q\u0001\bg>,(oY3!\u0011!1\u0004\u00011A\u0005\n\t]R#\u0001\u001e\t\u0013\tm\u0002\u00011A\u0005\n\tu\u0012\u0001C7pI\u0016|F%Z9\u0015\t\u0005%#q\b\u0005\n\u0005_\u0011I$!AA\u0002iBqAa\u0011\u0001A\u0003&!(A\u0003n_\u0012,\u0007\u0005C\u0005\u0003H\u0001\u0011\r\u0011\"\u0003\u0003J\u0005aQ\r\u001f;sC>\u0003H/[8ogV\u0011!1\n\t\u0007\u0005\u001b\u0012\u0019\u0006\u0011!\u000e\u0005\t=#b\u0001B)e\u00069Q.\u001e;bE2,\u0017\u0002\u0002B+\u0005\u001f\u0012q\u0001S1tQ6\u000b\u0007\u000f\u0003\u0005\u0003Z\u0001\u0001\u000b\u0011\u0002B&\u00035)\u0007\u0010\u001e:b\u001fB$\u0018n\u001c8tA!I!Q\f\u0001A\u0002\u0013%!qL\u0001\u0014a\u0006\u0014H/\u001b;j_:LgnZ\"pYVlgn]\u000b\u0003\u0005C\u0002RADAA\u0005G\u0002RA!\u001a\u0003n\u0001sAAa\u001a\u0003l9\u00191I!\u001b\n\u0003AI!aL\b\n\t\t=$\u0011\u000f\u0002\u0004'\u0016\f(BA\u0018\u0010\u0011%\u0011)\b\u0001a\u0001\n\u0013\u00119(A\fqCJ$\u0018\u000e^5p]&twmQ8mk6t7o\u0018\u0013fcR!\u0011\u0011\nB=\u0011)\u0011yCa\u001d\u0002\u0002\u0003\u0007!\u0011\r\u0005\t\u0005{\u0002\u0001\u0015)\u0003\u0003b\u0005!\u0002/\u0019:uSRLwN\\5oO\u000e{G.^7og\u0002B\u0011B!!\u0001\u0001\u0004%IAa\u0018\u0002#\t,8m[3u\u0007>dW/\u001c8OC6,7\u000fC\u0005\u0003\u0006\u0002\u0001\r\u0011\"\u0003\u0003\b\u0006)\"-^2lKR\u001cu\u000e\\;n]:\u000bW.Z:`I\u0015\fH\u0003BA%\u0005\u0013C!Ba\f\u0003\u0004\u0006\u0005\t\u0019\u0001B1\u0011!\u0011i\t\u0001Q!\n\t\u0005\u0014A\u00052vG.,GoQ8mk6tg*Y7fg\u0002B\u0011\"a\n\u0001\u0001\u0004%IA!%\u0016\u0005\tM\u0005#\u0002\b\u0002\u0002\u0006%\u0002\"\u0003BL\u0001\u0001\u0007I\u0011\u0002BM\u00039qW/\u001c\"vG.,Go]0%KF$B!!\u0013\u0003\u001c\"Q!q\u0006BK\u0003\u0003\u0005\rAa%\t\u0011\t}\u0005\u0001)Q\u0005\u0005'\u000b1B\\;n\u0005V\u001c7.\u001a;tA!I!1\u0015\u0001A\u0002\u0013%!qL\u0001\u0010g>\u0014HoQ8mk6tg*Y7fg\"I!q\u0015\u0001A\u0002\u0013%!\u0011V\u0001\u0014g>\u0014HoQ8mk6tg*Y7fg~#S-\u001d\u000b\u0005\u0003\u0013\u0012Y\u000b\u0003\u0006\u00030\t\u0015\u0016\u0011!a\u0001\u0005CB\u0001Ba,\u0001A\u0003&!\u0011M\u0001\u0011g>\u0014HoQ8mk6tg*Y7fg\u0002B3\u0001\u0001BZ!\u0011\u0011)La0\u000f\t\t]&1X\u0007\u0003\u0005sS1!!\u0007\u0005\u0013\u0011\u0011iL!/\u0002%%sG/\u001a:gC\u000e,7\u000b^1cS2LG/_\u0005\u0005\u0005\u0003\u0014\u0019M\u0001\u0004Ti\u0006\u0014G.\u001a\u0006\u0005\u0005{\u0013I\f")
public final class DataFrameWriter<T> {
    private final Dataset<Row> df;
    private String source;
    private SaveMode mode;
    private final HashMap<String, String> extraOptions;
    private Option<Seq<String>> partitioningColumns;
    private Option<Seq<String>> bucketColumnNames;
    private Option<Object> numBuckets;
    private Option<Seq<String>> sortColumnNames;

    public DataFrameWriter<T> partitionBy(String ... colNames) {
        return this.partitionBy((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colNames));
    }

    public DataFrameWriter<T> bucketBy(int numBuckets, String colName, String ... colNames) {
        return this.bucketBy(numBuckets, colName, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colNames));
    }

    public DataFrameWriter<T> sortBy(String colName, String ... colNames) {
        return this.sortBy(colName, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])colNames));
    }

    private Dataset<Row> df() {
        return this.df;
    }

    public DataFrameWriter<T> mode(SaveMode saveMode) {
        this.mode_$eq(saveMode);
        return this;
    }

    public DataFrameWriter<T> mode(String saveMode) {
        SaveMode saveMode2;
        String string = saveMode.toLowerCase(Locale.ROOT);
        if ("overwrite".equals(string)) {
            saveMode2 = SaveMode.Overwrite;
        } else if ("append".equals(string)) {
            saveMode2 = SaveMode.Append;
        } else if ("ignore".equals(string)) {
            saveMode2 = SaveMode.Ignore;
        } else {
            boolean bl = "error".equals(string) ? true : ("errorifexists".equals(string) ? true : "default".equals(string));
            if (bl) {
                saveMode2 = SaveMode.ErrorIfExists;
            } else {
                throw new IllegalArgumentException(new StringBuilder(103).append("Unknown save mode: ").append(saveMode).append(". ").append("Accepted save modes are 'overwrite', 'append', 'ignore', 'error', 'errorifexists'.").toString());
            }
        }
        this.mode_$eq(saveMode2);
        return this;
    }

    public DataFrameWriter<T> format(String source) {
        this.source_$eq(source);
        return this;
    }

    public DataFrameWriter<T> option(String key, String value) {
        this.extraOptions().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)value));
        return this;
    }

    public DataFrameWriter<T> option(String key, boolean value) {
        return this.option(key, ((Object)BoxesRunTime.boxToBoolean((boolean)value)).toString());
    }

    public DataFrameWriter<T> option(String key, long value) {
        return this.option(key, ((Object)BoxesRunTime.boxToLong((long)value)).toString());
    }

    public DataFrameWriter<T> option(String key, double value) {
        return this.option(key, ((Object)BoxesRunTime.boxToDouble((double)value)).toString());
    }

    public DataFrameWriter<T> options(Map<String, String> options) {
        this.extraOptions().$plus$plus$eq(options);
        return this;
    }

    public DataFrameWriter<T> options(java.util.Map<String, String> options) {
        this.options((Map<String, String>)((Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(options).asScala()));
        return this;
    }

    public DataFrameWriter<T> partitionBy(Seq<String> colNames) {
        this.partitioningColumns_$eq((Option<Seq<String>>)Option$.MODULE$.apply(colNames));
        return this;
    }

    public DataFrameWriter<T> bucketBy(int numBuckets, String colName, Seq<String> colNames) {
        this.numBuckets_$eq((Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)numBuckets)));
        String string = colName;
        this.bucketColumnNames_$eq((Option<Seq<String>>)Option$.MODULE$.apply(colNames.$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom())));
        return this;
    }

    public DataFrameWriter<T> sortBy(String colName, Seq<String> colNames) {
        String string = colName;
        this.sortColumnNames_$eq((Option<Seq<String>>)Option$.MODULE$.apply(colNames.$plus$colon((Object)string, Seq$.MODULE$.canBuildFrom())));
        return this;
    }

    public void save(String path) {
        this.extraOptions().$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"path"), (Object)path));
        this.save();
    }

    public void save() {
        String string = this.source().toLowerCase(Locale.ROOT);
        String string2 = DDLUtils$.MODULE$.HIVE_PROVIDER();
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            throw new AnalysisException("Hive data source can only be used with tables, you can not write files of Hive data source directly.", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        this.assertNotBucketed("save");
        Class<?> cls = DataSource$.MODULE$.lookupDataSource(this.source(), this.df().sparkSession().sessionState().conf());
        if (DataSourceV2.class.isAssignableFrom(cls)) {
            DataSourceV2 source = (DataSourceV2)cls.newInstance();
            DataSourceV2 dataSourceV2 = source;
            if (dataSourceV2 instanceof WriteSupport) {
                BoxedUnit boxedUnit;
                WriteSupport writeSupport = (WriteSupport)dataSourceV2;
                scala.collection.immutable.Map<String, String> sessionOptions = DataSourceV2Utils$.MODULE$.extractSessionConfigs(source, this.df().sparkSession().sessionState().conf());
                scala.collection.immutable.Map options = sessionOptions.$plus$plus(this.extraOptions());
                Optional<DataSourceWriter> writer = writeSupport.createWriter(UUID.randomUUID().toString(), package$.MODULE$.AttributeSeq(this.df().logicalPlan().output()).toStructType(), this.mode(), new DataSourceOptions((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)options).asJava()));
                if (writer.isPresent()) {
                    this.runCommand(this.df().sparkSession(), "save", new WriteToDataSourceV2(writer.get(), this.df().logicalPlan()));
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            } else {
                this.saveToV1Source();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            this.saveToV1Source();
        }
    }

    private void saveToV1Source() {
        SparkSession x$3 = this.df().sparkSession();
        String x$4 = this.source();
        Seq x$5 = (Seq)this.partitioningColumns().getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
        scala.collection.immutable.Map x$6 = this.extraOptions().toMap(Predef$.MODULE$.$conforms());
        Seq<String> x$7 = DataSource$.MODULE$.apply$default$3();
        Option<StructType> x$8 = DataSource$.MODULE$.apply$default$4();
        Option<BucketSpec> x$9 = DataSource$.MODULE$.apply$default$6();
        Option<CatalogTable> x$10 = DataSource$.MODULE$.apply$default$8();
        this.runCommand(this.df().sparkSession(), "save", new DataSource(x$3, x$4, x$7, x$8, (Seq<String>)x$5, x$9, (scala.collection.immutable.Map<String, String>)x$6, x$10).planForWriting(this.mode(), this.df().logicalPlan()));
    }

    public void insertInto(String tableName) {
        this.insertInto(this.df().sparkSession().sessionState().sqlParser().parseTableIdentifier(tableName));
    }

    private void insertInto(TableIdentifier tableIdent) {
        this.assertNotBucketed("insertInto");
        if (this.partitioningColumns().isDefined()) {
            throw new AnalysisException("insertInto() can't be used together with partitionBy(). Partition columns have already been defined for the table. It is not necessary to use partitionBy().", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        SaveMode saveMode = this.mode();
        SaveMode saveMode2 = SaveMode.Overwrite;
        this.runCommand(this.df().sparkSession(), "insertInto", (LogicalPlan)new InsertIntoTable((LogicalPlan)new UnresolvedRelation(tableIdent), Predef$.MODULE$.Map().empty(), this.df().logicalPlan(), !(saveMode != null ? !((Object)((Object)saveMode)).equals((Object)saveMode2) : saveMode2 != null), false));
    }

    private Option<BucketSpec> getBucketSpec() {
        if (this.sortColumnNames().isDefined() && this.numBuckets().isEmpty()) {
            throw new AnalysisException("sortBy must be used together with bucketBy", AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
        return this.numBuckets().map((Function1 & Serializable & scala.Serializable)n -> DataFrameWriter.$anonfun$getBucketSpec$1(this, BoxesRunTime.unboxToInt((Object)n)));
    }

    private void assertNotBucketed(String operation) {
        if (this.getBucketSpec().isDefined()) {
            if (this.sortColumnNames().isEmpty()) {
                throw new AnalysisException(new StringBuilder(38).append("'").append(operation).append("' does not support bucketBy right now").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
            throw new AnalysisException(new StringBuilder(49).append("'").append(operation).append("' does not support bucketBy and sortBy right now").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
    }

    private void assertNotPartitioned(String operation) {
        if (this.partitioningColumns().isDefined()) {
            throw new AnalysisException(new StringBuilder(32).append("'").append(operation).append("' does not support partitioning").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
        }
    }

    public void saveAsTable(String tableName) {
        this.saveAsTable(this.df().sparkSession().sessionState().sqlParser().parseTableIdentifier(tableName));
    }

    /*
     * Enabled aggressive block sorting
     */
    private void saveAsTable(TableIdentifier tableIdent) {
        SessionCatalog catalog = this.df().sparkSession().sessionState().catalog();
        boolean tableExists = catalog.tableExists(tableIdent);
        String db = (String)tableIdent.database().getOrElse((Function0 & Serializable & scala.Serializable)() -> catalog.getCurrentDatabase());
        Some x$11 = new Some((Object)db);
        String x$12 = tableIdent.copy$default$1();
        TableIdentifier tableIdentWithDB = tableIdent.copy(x$12, (Option)x$11);
        String tableName = tableIdentWithDB.unquotedString();
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)tableExists), (Object)this.mode());
        if (tuple2 != null) {
            boolean bl = tuple2._1$mcZ$sp();
            SaveMode saveMode = (SaveMode)((Object)tuple2._2());
            if (bl && ((Object)((Object)SaveMode.Ignore)).equals((Object)saveMode)) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (tuple2 != null) {
            boolean bl = tuple2._1$mcZ$sp();
            SaveMode saveMode = (SaveMode)((Object)tuple2._2());
            if (bl && ((Object)((Object)SaveMode.ErrorIfExists)).equals((Object)saveMode)) {
                throw new AnalysisException(new StringBuilder(22).append("Table ").append(tableIdent).append(" already exists.").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
            }
        }
        if (tuple2 != null) {
            boolean bl = tuple2._1$mcZ$sp();
            SaveMode saveMode = (SaveMode)((Object)tuple2._2());
            if (bl && ((Object)((Object)SaveMode.Overwrite)).equals((Object)saveMode)) {
                HiveTableRelation hiveTableRelation;
                BaseRelation baseRelation;
                LogicalRelation logicalRelation;
                BaseRelation dest;
                Seq srcRelations = this.df().logicalPlan().collect((PartialFunction)new scala.Serializable(null){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Object object;
                        LogicalRelation logicalRelation;
                        BaseRelation src;
                        A1 A1 = x1;
                        if (A1 instanceof LogicalRelation && (src = (logicalRelation = (LogicalRelation)A1).relation()) != null) {
                            BaseRelation baseRelation = src;
                            object = baseRelation;
                        } else if (A1 instanceof HiveTableRelation) {
                            HiveTableRelation hiveTableRelation = (HiveTableRelation)A1;
                            object = hiveTableRelation.tableMeta().identifier();
                        } else {
                            object = function1.apply(x1);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(LogicalPlan x1) {
                        LogicalRelation logicalRelation;
                        BaseRelation src;
                        LogicalPlan logicalPlan2 = x1;
                        boolean bl = logicalPlan2 instanceof LogicalRelation && (src = (logicalRelation = (LogicalRelation)logicalPlan2).relation()) != null ? true : logicalPlan2 instanceof HiveTableRelation;
                        return bl;
                    }
                });
                LogicalPlan tableRelation = this.df().sparkSession().table(tableIdentWithDB).queryExecution().analyzed();
                LogicalPlan logicalPlan2 = EliminateSubqueryAliases$.MODULE$.apply(tableRelation);
                if (logicalPlan2 instanceof LogicalRelation && (dest = (logicalRelation = (LogicalRelation)logicalPlan2).relation()) != null && srcRelations.contains((Object)(baseRelation = dest))) {
                    throw new AnalysisException(new StringBuilder(52).append("Cannot overwrite table ").append(tableName).append(" that is also being read from").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                }
                if (logicalPlan2 instanceof HiveTableRelation && srcRelations.contains((Object)(hiveTableRelation = (HiveTableRelation)logicalPlan2).tableMeta().identifier())) {
                    throw new AnalysisException(new StringBuilder(52).append("Cannot overwrite table ").append(tableName).append(" that is also being read from").toString(), AnalysisException$.MODULE$.$lessinit$greater$default$2(), AnalysisException$.MODULE$.$lessinit$greater$default$3(), AnalysisException$.MODULE$.$lessinit$greater$default$4(), AnalysisException$.MODULE$.$lessinit$greater$default$5());
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                catalog.dropTable(tableIdentWithDB, true, false);
                this.createTable(tableIdentWithDB);
                catalog.refreshTable(tableIdentWithDB);
                BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                return;
            }
        }
        this.createTable(tableIdent);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private void createTable(TableIdentifier tableIdent) {
        CatalogStorageFormat storage = DataSource$.MODULE$.buildStorageFormatFromOptions((scala.collection.immutable.Map<String, String>)this.extraOptions().toMap(Predef$.MODULE$.$conforms()));
        CatalogTableType tableType = storage.locationUri().isDefined() ? CatalogTableType$.MODULE$.EXTERNAL() : CatalogTableType$.MODULE$.MANAGED();
        CatalogTable tableDesc = new CatalogTable(tableIdent, tableType, storage, new StructType(), (Option)new Some((Object)this.source()), (Seq)this.partitioningColumns().getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$), this.getBucketSpec(), CatalogTable$.MODULE$.apply$default$8(), CatalogTable$.MODULE$.apply$default$9(), CatalogTable$.MODULE$.apply$default$10(), CatalogTable$.MODULE$.apply$default$11(), CatalogTable$.MODULE$.apply$default$12(), CatalogTable$.MODULE$.apply$default$13(), CatalogTable$.MODULE$.apply$default$14(), CatalogTable$.MODULE$.apply$default$15(), CatalogTable$.MODULE$.apply$default$16(), CatalogTable$.MODULE$.apply$default$17(), CatalogTable$.MODULE$.apply$default$18(), CatalogTable$.MODULE$.apply$default$19());
        this.runCommand(this.df().sparkSession(), "saveAsTable", new CreateTable(tableDesc, this.mode(), (Option<LogicalPlan>)new Some((Object)this.df().logicalPlan())));
    }

    public void jdbc(String url, String table, Properties connectionProperties) {
        this.assertNotPartitioned("jdbc");
        this.assertNotBucketed("jdbc");
        this.extraOptions().$plus$plus$eq((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(connectionProperties).asScala());
        this.extraOptions().$plus$eq((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"url"), (Object)url), (Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"dbtable"), (Object)table), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
        this.format("jdbc").save();
    }

    public void json(String path) {
        this.format("json").save(path);
    }

    public void parquet(String path) {
        this.format("parquet").save(path);
    }

    public void orc(String path) {
        this.format("orc").save(path);
    }

    public void text(String path) {
        this.format("text").save(path);
    }

    public void csv(String path) {
        this.format("csv").save(path);
    }

    private void runCommand(SparkSession session, String name, LogicalPlan command) {
        QueryExecution qe = session.sessionState().executePlan(command);
        try {
            long start = System.nanoTime();
            SQLExecution$.MODULE$.withNewExecutionId(session, qe, (Function0 & Serializable & scala.Serializable)() -> qe.toRdd());
            long end = System.nanoTime();
            session.listenerManager().onSuccess(name, qe, end - start);
        }
        catch (Exception e) {
            session.listenerManager().onFailure(name, qe, e);
            throw e;
        }
    }

    private String source() {
        return this.source;
    }

    private void source_$eq(String x$1) {
        this.source = x$1;
    }

    private SaveMode mode() {
        return this.mode;
    }

    private void mode_$eq(SaveMode x$1) {
        this.mode = x$1;
    }

    private HashMap<String, String> extraOptions() {
        return this.extraOptions;
    }

    private Option<Seq<String>> partitioningColumns() {
        return this.partitioningColumns;
    }

    private void partitioningColumns_$eq(Option<Seq<String>> x$1) {
        this.partitioningColumns = x$1;
    }

    private Option<Seq<String>> bucketColumnNames() {
        return this.bucketColumnNames;
    }

    private void bucketColumnNames_$eq(Option<Seq<String>> x$1) {
        this.bucketColumnNames = x$1;
    }

    private Option<Object> numBuckets() {
        return this.numBuckets;
    }

    private void numBuckets_$eq(Option<Object> x$1) {
        this.numBuckets = x$1;
    }

    private Option<Seq<String>> sortColumnNames() {
        return this.sortColumnNames;
    }

    private void sortColumnNames_$eq(Option<Seq<String>> x$1) {
        this.sortColumnNames = x$1;
    }

    public static final /* synthetic */ BucketSpec $anonfun$getBucketSpec$1(DataFrameWriter $this, int n) {
        return new BucketSpec(n, (Seq)$this.bucketColumnNames().get(), (Seq)$this.sortColumnNames().getOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$));
    }

    public DataFrameWriter(Dataset<T> ds) {
        this.df = ds.toDF();
        this.source = this.df().sparkSession().sessionState().conf().defaultDataSourceName();
        this.mode = SaveMode.ErrorIfExists;
        this.extraOptions = new HashMap();
        this.partitioningColumns = None$.MODULE$;
        this.bucketColumnNames = None$.MODULE$;
        this.numBuckets = None$.MODULE$;
        this.sortColumnNames = None$.MODULE$;
    }
}

