/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.Serializable;
import java.net.URL;
import org.apache.spark.ErrorClassesJsonReader;
import org.apache.spark.ErrorMessageFormat$;
import org.apache.spark.QueryContext;
import org.apache.spark.QueryContextType;
import org.apache.spark.SparkThrowable;
import org.apache.spark.util.JsonUtils$;
import org.apache.spark.util.SparkClassUtils$;
import scala.;
import scala.$less$colon$less$;
import scala.Enumeration;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;

public final class SparkThrowableHelper$ {
    public static final SparkThrowableHelper$ MODULE$ = new SparkThrowableHelper$();
    private static final ErrorClassesJsonReader errorReader = new ErrorClassesJsonReader((Seq<URL>)new .colon.colon((Object)SparkClassUtils$.MODULE$.getSparkClassLoader().getResource("error/error-conditions.json"), (List)Nil$.MODULE$));

    public ErrorClassesJsonReader errorReader() {
        return errorReader;
    }

    public String getMessage(String errorClass, Map<String, String> messageParameters) {
        return this.getMessage(errorClass, messageParameters, "");
    }

    public String getMessage(String errorClass, java.util.Map<String, String> messageParameters) {
        return this.getMessage(errorClass, (Map<String, String>)CollectionConverters$.MODULE$.MapHasAsScala(messageParameters).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()), "");
    }

    public String getMessage(String errorClass, Map<String, String> messageParameters, String context) {
        String displayMessage = this.errorReader().getErrorMessage(errorClass, messageParameters);
        String sqlState = this.getSqlState(errorClass);
        Object displaySqlState = sqlState == null ? "" : " SQLSTATE: " + sqlState;
        String displayQueryContext = (context.isEmpty() ? "" : "\n") + context;
        Object prefix = errorClass.startsWith("_LEGACY_ERROR_") ? "" : "[" + errorClass + "] ";
        return (String)prefix + displayMessage + (String)displaySqlState + displayQueryContext;
    }

    public String getSqlState(String errorClass) {
        return this.errorReader().getSqlState(errorClass);
    }

    public boolean isValidErrorClass(String errorClass) {
        return this.errorReader().isValidErrorClass(errorClass);
    }

    public Seq<String> getMessageParameters(String errorClass) {
        return this.errorReader().getMessageParameters(errorClass);
    }

    public boolean isInternalError(String errorClass) {
        return errorClass != null && errorClass.startsWith("INTERNAL_ERROR");
    }

    public String getMessage(Throwable e, Enumeration.Value format) {
        boolean bl;
        boolean bl2;
        Enumeration.Value value = format;
        Enumeration.Value value2 = ErrorMessageFormat$.MODULE$.PRETTY();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            return e.getMessage();
        }
        Enumeration.Value value4 = ErrorMessageFormat$.MODULE$.MINIMAL();
        Enumeration.Value value5 = value;
        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
            bl2 = true;
        } else {
            Enumeration.Value value6 = ErrorMessageFormat$.MODULE$.STANDARD();
            Enumeration.Value value7 = value;
            bl2 = !(value6 != null ? !value6.equals(value7) : value7 != null);
        }
        if (bl2 && ((SparkThrowable)((Object)e)).getErrorClass() == null) {
            return JsonUtils$.MODULE$.toJsonString((Function1<JsonGenerator, BoxedUnit>)(Function1 & Serializable)generator -> {
                SparkThrowableHelper$.$anonfun$getMessage$1(e, generator);
                return BoxedUnit.UNIT;
            });
        }
        Enumeration.Value value8 = ErrorMessageFormat$.MODULE$.MINIMAL();
        Enumeration.Value value9 = value;
        if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
            bl = true;
        } else {
            Enumeration.Value value10 = ErrorMessageFormat$.MODULE$.STANDARD();
            Enumeration.Value value11 = value;
            bl = !(value10 != null ? !value10.equals(value11) : value11 != null);
        }
        if (bl) {
            String errorClass = ((SparkThrowable)((Object)e)).getErrorClass();
            return JsonUtils$.MODULE$.toJsonString((Function1<JsonGenerator, BoxedUnit>)(Function1 & Serializable)generator -> {
                SparkThrowableHelper$.$anonfun$getMessage$2(errorClass, format, e, generator);
                return BoxedUnit.UNIT;
            });
        }
        throw new MatchError((Object)value);
    }

    public static final /* synthetic */ void $anonfun$getMessage$1(Throwable e$1, JsonGenerator generator) {
        JsonGenerator g = generator.useDefaultPrettyPrinter();
        g.writeStartObject();
        g.writeStringField("errorClass", "LEGACY");
        g.writeObjectFieldStart("messageParameters");
        g.writeStringField("message", e$1.getMessage());
        g.writeEndObject();
        g.writeEndObject();
    }

    public static final /* synthetic */ void $anonfun$getMessage$4(JsonGenerator g$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String name = (String)tuple2._1();
            String value = (String)tuple2._2();
            g$1.writeStringField(name, value.replaceAll("#\\d+", "#x"));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$getMessage$5(JsonGenerator g$1, QueryContext c) {
        g$1.writeStartObject();
        QueryContextType queryContextType = c.contextType();
        if (((Object)((Object)QueryContextType.SQL)).equals((Object)queryContextType)) {
            int stopIndex;
            g$1.writeStringField("objectType", c.objectType());
            g$1.writeStringField("objectName", c.objectName());
            int startIndex = c.startIndex() + 1;
            if (startIndex > 0) {
                g$1.writeNumberField("startIndex", startIndex);
            }
            if ((stopIndex = c.stopIndex() + 1) > 0) {
                g$1.writeNumberField("stopIndex", stopIndex);
            }
            g$1.writeStringField("fragment", c.fragment());
        } else if (((Object)((Object)QueryContextType.DataFrame)).equals((Object)queryContextType)) {
            g$1.writeStringField("fragment", c.fragment());
            g$1.writeStringField("callSite", c.callSite());
        } else {
            throw new MatchError((Object)queryContextType);
        }
        g$1.writeEndObject();
    }

    public static final /* synthetic */ void $anonfun$getMessage$2(String errorClass$1, Enumeration.Value format$1, Throwable e$1, JsonGenerator generator) {
        QueryContext[] queryContext;
        java.util.Map<String, String> messageParameters;
        String sqlState;
        JsonGenerator g = generator.useDefaultPrettyPrinter();
        g.writeStartObject();
        g.writeStringField("errorClass", errorClass$1);
        Enumeration.Value value = format$1;
        Enumeration.Value value2 = ErrorMessageFormat$.MODULE$.STANDARD();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            g.writeStringField("messageTemplate", MODULE$.errorReader().getMessageTemplate(errorClass$1));
        }
        if ((sqlState = ((SparkThrowable)((Object)e$1)).getSqlState()) != null) {
            g.writeStringField("sqlState", sqlState);
        }
        if (!(messageParameters = ((SparkThrowable)((Object)e$1)).getMessageParameters()).isEmpty()) {
            g.writeObjectFieldStart("messageParameters");
            ((IterableOnceOps)CollectionConverters$.MODULE$.MapHasAsScala(messageParameters).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()).toSeq().sortBy((Function1 & Serializable)x$1 -> (String)x$1._1(), (Ordering)Ordering.String$.MODULE$)).foreach((Function1 & Serializable)x0$1 -> {
                SparkThrowableHelper$.$anonfun$getMessage$4(g, x0$1);
                return BoxedUnit.UNIT;
            });
            g.writeEndObject();
        }
        if (!ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])(queryContext = ((SparkThrowable)((Object)e$1)).getQueryContext())))) {
            g.writeArrayFieldStart("queryContext");
            ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])((SparkThrowable)((Object)e$1)).getQueryContext()), (Function1 & Serializable)c -> {
                SparkThrowableHelper$.$anonfun$getMessage$5(g, c);
                return BoxedUnit.UNIT;
            });
            g.writeEndArray();
        }
        g.writeEndObject();
    }

    private SparkThrowableHelper$() {
    }
}

