/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.CharArrayWriter;
import java.io.Serializable;
import java.time.ZoneId;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.csv.CSVOptions;
import org.apache.spark.sql.catalyst.csv.UnivocityGenerator;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.ExprUtils$;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.StructsToCsv$;
import org.apache.spark.sql.catalyst.expressions.TimeZoneAwareExpression;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Enumeration;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(expr[, options]) - Returns a CSV string with a given struct value", examples="\n    Examples:\n      > SELECT _FUNC_(named_struct('a', 1, 'b', 2));\n       1,2\n      > SELECT _FUNC_(named_struct('time', to_timestamp('2015-08-26', 'yyyy-MM-dd')), map('timestampFormat', 'dd/MM/yyyy'));\n       26/08/2015\n  ", since="3.0.0", group="csv_funcs")
@ScalaSignature(bytes="\u0006\u0005\tee\u0001B\u0016-\u0001fB\u0001\u0002\u0018\u0001\u0003\u0016\u0004%\t!\u0018\u0005\tS\u0002\u0011\t\u0012)A\u0005=\"A!\u000e\u0001BK\u0002\u0013\u00051\u000e\u0003\u0005p\u0001\tE\t\u0015!\u0003m\u0011!\u0001\bA!f\u0001\n\u0003\t\b\u0002C;\u0001\u0005#\u0005\u000b\u0011\u0002:\t\u000bY\u0004A\u0011A<\t\u000bq\u0004A\u0011I?\t\rY\u0004A\u0011AA\u0002\u0011\u00191\b\u0001\"\u0001\u0002\n!1a\u000f\u0001C\u0001\u0003\u001bA!\"a\u0005\u0001\u0011\u000b\u0007I\u0011AA\u000b\u0011)\ty\u0003\u0001EC\u0002\u0013\u0005\u0011\u0011\u0007\u0005\u000b\u0003\u0003\u0002\u0001R1A\u0005\u0002\u0005\r\u0003BCA*\u0001!\u0015\r\u0011\"\u0001\u0002V!9\u00111\u000f\u0001\u0005B\u0005U\u0004bBA?\u0001\u0011\u0005\u0013q\u0010\u0005\b\u0003\u0007\u0003A\u0011IAC\u0011\u001d\tY\t\u0001C!\u0003\u001bCq!a'\u0001\t\u0003\ni\nC\u0004\u0002 \u0002!\t&!)\t\u000f\u0005\u001d\u0006\u0001\"\u0015\u0002*\"I\u0011Q\u0019\u0001\u0002\u0002\u0013\u0005\u0011q\u0019\u0005\n\u0003\u001f\u0004\u0011\u0013!C\u0001\u0003#D\u0011\"a:\u0001#\u0003%\t!!;\t\u0013\u00055\b!%A\u0005\u0002\u0005=\b\"CAz\u0001\u0005\u0005I\u0011IA{\u0011%\u0011\t\u0001AA\u0001\n\u0003\u0011\u0019\u0001C\u0005\u0003\f\u0001\t\t\u0011\"\u0001\u0003\u000e!I!1\u0003\u0001\u0002\u0002\u0013\u0005#Q\u0003\u0005\n\u0005G\u0001\u0011\u0011!C\u0001\u0005KA\u0011B!\u000b\u0001\u0003\u0003%\tEa\u000b\t\u0013\t=\u0002!!A\u0005B\tEr!\u0003B+Y\u0005\u0005\t\u0012\u0001B,\r!YC&!A\t\u0002\te\u0003B\u0002<$\t\u0003\u0011Y\u0007C\u0005\u0003n\r\n\t\u0011\"\u0012\u0003p!I!\u0011O\u0012\u0002\u0002\u0013\u0005%1\u000f\u0005\n\u0005w\u001a\u0013\u0013!C\u0001\u0003_D\u0011B! $\u0003\u0003%\tIa \t\u0013\t55%%A\u0005\u0002\u0005=\b\"\u0003BHG\u0005\u0005I\u0011\u0002BI\u00051\u0019FO];diN$vnQ:w\u0015\tic&A\u0006fqB\u0014Xm]:j_:\u001c(BA\u00181\u0003!\u0019\u0017\r^1msN$(BA\u00193\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003gQ\nQa\u001d9be.T!!\u000e\u001c\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00059\u0014aA8sO\u000e\u00011c\u0002\u0001;}\u0005#5*\u0015\t\u0003wqj\u0011\u0001L\u0005\u0003{1\u0012q\"\u00168bef,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003w}J!\u0001\u0011\u0017\u0003/QKW.\u001a.p]\u0016\fu/\u0019:f\u000bb\u0004(/Z:tS>t\u0007CA\u001eC\u0013\t\u0019EFA\tFqB,7\r^:J]B,H\u000fV=qKN\u0004\"!\u0012%\u000f\u0005m2\u0015BA$-\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u0013&\u0003\u001d9+H\u000e\\%oi>dWM]1oi*\u0011q\t\f\t\u0003\u0019>k\u0011!\u0014\u0006\u0002\u001d\u0006)1oY1mC&\u0011\u0001+\u0014\u0002\b!J|G-^2u!\t\u0011\u0016L\u0004\u0002T1:\u0011AkV\u0007\u0002+*\u0011a\u000bO\u0001\u0007yI|w\u000e\u001e \n\u00039K!aR'\n\u0005i[&\u0001D*fe&\fG.\u001b>bE2,'BA$N\u0003\u001dy\u0007\u000f^5p]N,\u0012A\u0018\t\u0005?\u000e4gM\u0004\u0002aCB\u0011A+T\u0005\u0003E6\u000ba\u0001\u0015:fI\u00164\u0017B\u00013f\u0005\ri\u0015\r\u001d\u0006\u0003E6\u0003\"aX4\n\u0005!,'AB*ue&tw-\u0001\u0005paRLwN\\:!\u0003\u0015\u0019\u0007.\u001b7e+\u0005a\u0007CA\u001en\u0013\tqGF\u0001\u0006FqB\u0014Xm]:j_:\faa\u00195jY\u0012\u0004\u0013A\u0003;j[\u0016TvN\\3JIV\t!\u000fE\u0002Mg\u001aL!\u0001^'\u0003\r=\u0003H/[8o\u0003-!\u0018.\\3[_:,\u0017\n\u001a\u0011\u0002\rqJg.\u001b;?)\u0011A\u0018P_>\u0011\u0005m\u0002\u0001\"\u0002/\b\u0001\u0004q\u0006\"\u00026\b\u0001\u0004a\u0007b\u00029\b!\u0003\u0005\rA]\u0001\t]VdG.\u00192mKV\ta\u0010\u0005\u0002M\u007f&\u0019\u0011\u0011A'\u0003\u000f\t{w\u000e\\3b]R)\u00010!\u0002\u0002\b!)A,\u0003a\u0001=\")!.\u0003a\u0001YR\u0019\u00010a\u0003\t\u000b)T\u0001\u0019\u00017\u0015\u000ba\fy!!\u0005\t\u000b)\\\u0001\u0019\u00017\t\u000bq[\u0001\u0019\u00017\u0002\r]\u0014\u0018\u000e^3s+\t\t9\u0002\u0005\u0003\u0002\u001a\u0005\rRBAA\u000e\u0015\u0011\ti\"a\b\u0002\u0005%|'BAA\u0011\u0003\u0011Q\u0017M^1\n\t\u0005\u0015\u00121\u0004\u0002\u0010\u0007\"\f'/\u0011:sCf<&/\u001b;fe\"\u001aA\"!\u000b\u0011\u00071\u000bY#C\u0002\u0002.5\u0013\u0011\u0002\u001e:b]NLWM\u001c;\u0002\u0017%t\u0007/\u001e;TG\",W.Y\u000b\u0003\u0003g\u0001B!!\u000e\u0002<5\u0011\u0011q\u0007\u0006\u0004\u0003s\u0001\u0014!\u0002;za\u0016\u001c\u0018\u0002BA\u001f\u0003o\u0011!b\u0015;sk\u000e$H+\u001f9fQ\ri\u0011\u0011F\u0001\u0004O\u0016tWCAA#!\u0011\t9%!\u0014\u000e\u0005\u0005%#bAA&]\u0005\u00191m\u001d<\n\t\u0005=\u0013\u0011\n\u0002\u0013+:Lgo\\2jif<UM\\3sCR|'\u000fK\u0002\u000f\u0003S\t\u0011bY8om\u0016\u0014H/\u001a:\u0016\u0005\u0005]\u0003c\u0002'\u0002Z\u0005u\u00131M\u0005\u0004\u00037j%!\u0003$v]\u000e$\u0018n\u001c82!\ra\u0015qL\u0005\u0004\u0003Cj%aA!osB!\u0011QMA7\u001b\t\t9G\u0003\u0003\u0002:\u0005%$bAA6e\u00051QO\\:bM\u0016LA!a\u001c\u0002h\tQQ\u000b\u0016$9'R\u0014\u0018N\\4)\u0007=\tI#\u0001\u0005eCR\fG+\u001f9f+\t\t9\b\u0005\u0003\u00026\u0005e\u0014\u0002BA>\u0003o\u0011\u0001\u0002R1uCRK\b/Z\u0001\ro&$\b\u000eV5nKj{g.\u001a\u000b\u0004}\u0005\u0005\u0005\"\u00029\u0012\u0001\u00041\u0017\u0001\u00048vY2\u001c\u0016MZ3Fm\u0006dG\u0003BA/\u0003\u000fCq!!#\u0013\u0001\u0004\ti&A\u0003wC2,X-\u0001\u0006j]B,H\u000fV=qKN,\"!a$\u0011\u000bI\u000b\t*!&\n\u0007\u0005M5LA\u0002TKF\u0004B!!\u000e\u0002\u0018&!\u0011\u0011TA\u001c\u0005A\t%m\u001d;sC\u000e$H)\u0019;b)f\u0004X-\u0001\u0006qe\u0016$H/\u001f(b[\u0016,\u0012AZ\u0001\u0015o&$\bNT3x\u0007\"LG\u000eZ%oi\u0016\u0014h.\u00197\u0015\u0007a\f\u0019\u000b\u0003\u0004\u0002&V\u0001\r\u0001\\\u0001\t]\u0016<8\t[5mI\u0006IAm\\$f]\u000e{G-\u001a\u000b\u0007\u0003W\u000b9,!1\u0011\t\u00055\u00161W\u0007\u0003\u0003_S1!!--\u0003\u001d\u0019w\u000eZ3hK:LA!!.\u00020\nAQ\t\u001f9s\u0007>$W\rC\u0004\u0002:Z\u0001\r!a/\u0002\u0007\r$\b\u0010\u0005\u0003\u0002.\u0006u\u0016\u0002BA`\u0003_\u0013abQ8eK\u001e,gnQ8oi\u0016DH\u000fC\u0004\u0002DZ\u0001\r!a+\u0002\u0005\u00154\u0018\u0001B2paf$r\u0001_Ae\u0003\u0017\fi\rC\u0004]/A\u0005\t\u0019\u00010\t\u000f)<\u0002\u0013!a\u0001Y\"9\u0001o\u0006I\u0001\u0002\u0004\u0011\u0018AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003'T3AXAkW\t\t9\u000e\u0005\u0003\u0002Z\u0006\rXBAAn\u0015\u0011\ti.a8\u0002\u0013Ut7\r[3dW\u0016$'bAAq\u001b\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u0015\u00181\u001c\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003WT3\u0001\\Ak\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIM*\"!!=+\u0007I\f).A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003o\u0004B!!?\u0002\u00006\u0011\u00111 \u0006\u0005\u0003{\fy\"\u0001\u0003mC:<\u0017b\u00015\u0002|\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011!Q\u0001\t\u0004\u0019\n\u001d\u0011b\u0001B\u0005\u001b\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011Q\fB\b\u0011%\u0011\t\"HA\u0001\u0002\u0004\u0011)!A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0005/\u0001bA!\u0007\u0003 \u0005uSB\u0001B\u000e\u0015\r\u0011i\"T\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002B\u0011\u00057\u0011\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR\u0019aPa\n\t\u0013\tEq$!AA\u0002\u0005u\u0013A\u00059s_\u0012,8\r^#mK6,g\u000e\u001e(b[\u0016$B!a>\u0003.!I!\u0011\u0003\u0011\u0002\u0002\u0003\u0007!QA\u0001\u0007KF,\u0018\r\\:\u0015\u0007y\u0014\u0019\u0004C\u0005\u0003\u0012\u0005\n\t\u00111\u0001\u0002^!\u001a\u0002Aa\u000e\u0003>\t}\"1\tB#\u0005\u0013\u0012YEa\u0014\u0003RA\u00191H!\u000f\n\u0007\tmBFA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\t\u0005\u0013\u0001S0G+:\u001bu\fK3yaJ\\F\u0006I8qi&|gn]/*A5\u0002#+\u001a;ve:\u001c\b%\u0019\u0011D'Z\u00033\u000f\u001e:j]\u001e\u0004s/\u001b;iA\u0005\u0004s-\u001b<f]\u0002\u001aHO];di\u00022\u0018\r\\;f\u0003!)\u00070Y7qY\u0016\u001c\u0018E\u0001B$\u0003\u0005\u0005'\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000bI0G+:\u001bu\f\u000b8b[\u0016$wl\u001d;sk\u000e$\bfJ1(Y\u0001\nD\u0006I\u0014cO1\u0002#'K\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AEb#G\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015oC6,GmX:ueV\u001cG\u000fK\u0014uS6,w\u0005\f\u0011u_~#\u0018.\\3ti\u0006l\u0007\u000fK\u00143aE*T\u0006\r\u001d.eY:C\u0006I\u0014zsfLX&T'.I\u0012<\u0013&\u000b\u0017![\u0006\u0004\bf\n;j[\u0016\u001cH/Y7q\r>\u0014X.\u0019;(Y\u0001:C\rZ\u0018N\u001b>J\u00180_=(S%Z$\u0002\t\u0011!A\u0001\u0002\u0003E\r\u001c0aaz#\u0007M\u00196\u0015\u0001\u0002\u0013!B:j]\u000e,\u0017E\u0001B'\u0003\u0015\u0019d\u0006\r\u00181\u0003\u00159'o\\;qC\t\u0011\u0019&A\u0005dgZ|f-\u001e8dg\u0006a1\u000b\u001e:vGR\u001cHk\\\"tmB\u00111hI\n\u0006G\tm#q\r\t\t\u0005;\u0012\u0019G\u00187sq6\u0011!q\f\u0006\u0004\u0005Cj\u0015a\u0002:v]RLW.Z\u0005\u0005\u0005K\u0012yFA\tBEN$(/Y2u\rVt7\r^5p]N\u0002B!!\u0007\u0003j%\u0019!,a\u0007\u0015\u0005\t]\u0013\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005]\u0018!B1qa2LHc\u0002=\u0003v\t]$\u0011\u0010\u0005\u00069\u001a\u0002\rA\u0018\u0005\u0006U\u001a\u0002\r\u0001\u001c\u0005\ba\u001a\u0002\n\u00111\u0001s\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\u001a\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0005\u0003\u0013I\t\u0005\u0003Mg\n\r\u0005C\u0002'\u0003\u0006zc'/C\u0002\u0003\b6\u0013a\u0001V;qY\u0016\u001c\u0004\u0002\u0003BFQ\u0005\u0005\t\u0019\u0001=\u0002\u0007a$\u0003'A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$HeM\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0005'\u0003B!!?\u0003\u0016&!!qSA~\u0005\u0019y%M[3di\u0002")
public class StructsToCsv
extends UnaryExpression
implements TimeZoneAwareExpression,
ExpectsInputTypes,
package.NullIntolerant,
Serializable {
    private transient CharArrayWriter writer;
    private transient StructType inputSchema;
    private transient UnivocityGenerator gen;
    private transient Function1<Object, UTF8String> converter;
    private final Map<String, String> options;
    private final Expression child;
    private final Option<String> timeZoneId;
    private boolean resolved;
    private Seq<Enumeration.Value> nodePatterns;
    private transient ZoneId zoneId;
    private volatile transient byte bitmap$trans$0;
    private volatile boolean bitmap$0;

    public static Option<String> $lessinit$greater$default$3() {
        return StructsToCsv$.MODULE$.$lessinit$greater$default$3();
    }

    public static Option<Tuple3<Map<String, String>, Expression, Option<String>>> unapply(StructsToCsv x$0) {
        return StructsToCsv$.MODULE$.unapply(x$0);
    }

    public static Option<String> apply$default$3() {
        return StructsToCsv$.MODULE$.apply$default$3();
    }

    public static Function1<Tuple3<Map<String, String>, Expression, Option<String>>, StructsToCsv> tupled() {
        return StructsToCsv$.MODULE$.tupled();
    }

    public static Function1<Map<String, String>, Function1<Expression, Function1<Option<String>, StructsToCsv>>> curried() {
        return StructsToCsv$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Seq<Enumeration.Value> nodePatternsInternal() {
        return TimeZoneAwareExpression.nodePatternsInternal$(this);
    }

    @Override
    public ZoneId zoneIdForType(DataType dataType) {
        return TimeZoneAwareExpression.zoneIdForType$(this, dataType);
    }

    private boolean resolved$lzycompute() {
        StructsToCsv structsToCsv = this;
        synchronized (structsToCsv) {
            if (!this.bitmap$0) {
                this.resolved = TimeZoneAwareExpression.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return !this.bitmap$0 ? this.resolved$lzycompute() : this.resolved;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private ZoneId zoneId$lzycompute() {
        StructsToCsv structsToCsv = this;
        synchronized (structsToCsv) {
            if ((byte)(this.bitmap$trans$0 & 0x10) == 0) {
                this.zoneId = TimeZoneAwareExpression.zoneId$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 0x10);
            }
        }
        return this.zoneId;
    }

    @Override
    public ZoneId zoneId() {
        return (byte)(this.bitmap$trans$0 & 0x10) == 0 ? this.zoneId$lzycompute() : this.zoneId;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$TimeZoneAwareExpression$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public Map<String, String> options() {
        return this.options;
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Option<String> timeZoneId() {
        return this.timeZoneId;
    }

    @Override
    public boolean nullable() {
        return true;
    }

    private CharArrayWriter writer$lzycompute() {
        StructsToCsv structsToCsv = this;
        synchronized (structsToCsv) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.writer = new CharArrayWriter();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.writer;
    }

    public CharArrayWriter writer() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.writer$lzycompute() : this.writer;
    }

    private StructType inputSchema$lzycompute() {
        StructsToCsv structsToCsv = this;
        synchronized (structsToCsv) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                StructType structType;
                DataType dataType = this.child().dataType();
                if (!(dataType instanceof StructType)) {
                    throw new IllegalArgumentException(new StringBuilder(23).append("Unsupported input type ").append(dataType.catalogString()).toString());
                }
                StructType structType2 = structType = (StructType)dataType;
                this.inputSchema = structType2;
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.inputSchema;
    }

    public StructType inputSchema() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.inputSchema$lzycompute() : this.inputSchema;
    }

    private UnivocityGenerator gen$lzycompute() {
        StructsToCsv structsToCsv = this;
        synchronized (structsToCsv) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.gen = new UnivocityGenerator(this.inputSchema(), this.writer(), new CSVOptions(this.options(), true, (String)this.timeZoneId().get()));
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.gen;
    }

    public UnivocityGenerator gen() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.gen$lzycompute() : this.gen;
    }

    private Function1<Object, UTF8String> converter$lzycompute() {
        StructsToCsv structsToCsv = this;
        synchronized (structsToCsv) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                this.converter = (Function1 & Serializable)row -> UTF8String.fromString((String)this.gen().writeToString((InternalRow)row));
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
        }
        return this.converter;
    }

    public Function1<Object, UTF8String> converter() {
        return (byte)(this.bitmap$trans$0 & 8) == 0 ? this.converter$lzycompute() : this.converter;
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public TimeZoneAwareExpression withTimeZone(String timeZoneId) {
        Option x$1 = Option$.MODULE$.apply((Object)timeZoneId);
        Map<String, String> x$2 = this.copy$default$1();
        Expression x$3 = this.copy$default$2();
        return this.copy(x$2, x$3, (Option<String>)x$1);
    }

    @Override
    public Object nullSafeEval(Object value) {
        return this.converter().apply(value);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        StructType$ structType$ = StructType$.MODULE$;
        return package$.MODULE$.Nil().$colon$colon((Object)structType$);
    }

    @Override
    public String prettyName() {
        return "to_csv";
    }

    @Override
    public StructsToCsv withNewChildInternal(Expression newChild) {
        Expression x$1 = newChild;
        Map<String, String> x$2 = this.copy$default$1();
        Option<String> x$3 = this.copy$default$3();
        return this.copy(x$2, x$1, x$3);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        String structsToCsv = ctx.addReferenceObj("structsToCsv", this, ctx.addReferenceObj$default$3());
        return this.nullSafeCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)eval -> new StringBuilder(37).append(ev.value()).append(" = (UTF8String) ").append(structsToCsv).append(".converter().apply(").append((String)eval).append(");").toString());
    }

    public StructsToCsv copy(Map<String, String> options, Expression child, Option<String> timeZoneId) {
        return new StructsToCsv(options, child, timeZoneId);
    }

    public Map<String, String> copy$default$1() {
        return this.options();
    }

    public Expression copy$default$2() {
        return this.child();
    }

    public Option<String> copy$default$3() {
        return this.timeZoneId();
    }

    @Override
    public String productPrefix() {
        return "StructsToCsv";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.options();
                break;
            }
            case 1: {
                object = this.child();
                break;
            }
            case 2: {
                object = this.timeZoneId();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StructsToCsv;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "options";
                break;
            }
            case 1: {
                string = "child";
                break;
            }
            case 2: {
                string = "timeZoneId";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StructsToCsv)) return false;
        boolean bl = true;
        if (!bl) return false;
        StructsToCsv structsToCsv = (StructsToCsv)x$1;
        Map<String, String> map = this.options();
        Map<String, String> map2 = structsToCsv.options();
        if (map == null) {
            if (map2 != null) {
                return false;
            }
        } else if (!map.equals(map2)) return false;
        Expression expression = this.child();
        Expression expression2 = structsToCsv.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<String> option = this.timeZoneId();
        Option<String> option2 = structsToCsv.timeZoneId();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!structsToCsv.canEqual(this)) return false;
        return true;
    }

    public StructsToCsv(Map<String, String> options, Expression child, Option<String> timeZoneId) {
        this.options = options;
        this.child = child;
        this.timeZoneId = timeZoneId;
        TimeZoneAwareExpression.$init$(this);
        ExpectsInputTypes.$init$(this);
        Statics.releaseFence();
    }

    public StructsToCsv(Map<String, String> options, Expression child) {
        this(options, child, (Option<String>)None$.MODULE$);
    }

    public StructsToCsv(Expression child) {
        this((Map<String, String>)Predef$.MODULE$.Map().empty(), child, (Option<String>)None$.MODULE$);
    }

    public StructsToCsv(Expression child, Expression options) {
        this(ExprUtils$.MODULE$.convertToMapData(options), child, (Option<String>)None$.MODULE$);
    }
}

