/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.memory.TaskMemoryManager;
import org.apache.spark.sql.catalyst.expressions.RowBasedKeyValueBatch;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.KVIterator;
import org.apache.spark.unsafe.Platform;

public final class FixedLengthRowBasedKeyValueBatch
extends RowBasedKeyValueBatch {
    private final int klen;
    private final int vlen;
    private final int recordLength;

    private long getKeyOffsetForFixedLengthRecords(int rowId) {
        return this.recordStartOffset + (long)rowId * (long)this.recordLength;
    }

    @Override
    public UnsafeRow appendRow(Object kbase, long koff, int klen, Object vbase, long voff, int vlen) {
        long offset;
        assert (vlen == this.vlen);
        assert (klen == this.klen);
        if (this.numRows >= this.capacity || this.page == null || this.page.size() - this.pageCursor < (long)this.recordLength) {
            return null;
        }
        long recordOffset = offset = this.page.getBaseOffset() + this.pageCursor;
        Platform.copyMemory((Object)kbase, (long)koff, (Object)this.base, (long)offset, (long)klen);
        Platform.copyMemory((Object)vbase, (long)voff, (Object)this.base, (long)(offset += (long)klen), (long)vlen);
        Platform.putLong((Object)this.base, (long)(offset += (long)vlen), (long)0L);
        this.pageCursor += (long)this.recordLength;
        this.keyRowId = this.numRows++;
        this.keyRow.pointTo(this.base, recordOffset, klen);
        this.valueRow.pointTo(this.base, recordOffset + (long)klen, vlen);
        return this.valueRow;
    }

    @Override
    public UnsafeRow getKeyRow(int rowId) {
        assert (rowId >= 0);
        assert (rowId < this.numRows);
        if (this.keyRowId != rowId) {
            long offset = this.getKeyOffsetForFixedLengthRecords(rowId);
            this.keyRow.pointTo(this.base, offset, this.klen);
            this.keyRowId = rowId;
        }
        return this.keyRow;
    }

    @Override
    protected UnsafeRow getValueFromKey(int rowId) {
        if (this.keyRowId != rowId) {
            this.getKeyRow(rowId);
        }
        assert (rowId >= 0);
        this.valueRow.pointTo(this.base, this.keyRow.getBaseOffset() + (long)this.klen, this.vlen);
        return this.valueRow;
    }

    @Override
    public KVIterator<UnsafeRow, UnsafeRow> rowIterator() {
        return new KVIterator<UnsafeRow, UnsafeRow>(){
            private final UnsafeRow key;
            private final UnsafeRow value;
            private long offsetInPage;
            private int recordsInPage;
            private boolean initialized;
            {
                this.key = new UnsafeRow(FixedLengthRowBasedKeyValueBatch.this.keySchema.length());
                this.value = new UnsafeRow(FixedLengthRowBasedKeyValueBatch.this.valueSchema.length());
                this.offsetInPage = 0L;
                this.recordsInPage = 0;
                this.initialized = false;
            }

            private void init() {
                if (FixedLengthRowBasedKeyValueBatch.this.page != null) {
                    this.offsetInPage = FixedLengthRowBasedKeyValueBatch.this.page.getBaseOffset();
                    this.recordsInPage = FixedLengthRowBasedKeyValueBatch.this.numRows;
                }
                this.initialized = true;
            }

            public boolean next() {
                if (!this.initialized) {
                    this.init();
                }
                if (this.recordsInPage == 0) {
                    this.freeCurrentPage();
                    return false;
                }
                this.key.pointTo(FixedLengthRowBasedKeyValueBatch.this.base, this.offsetInPage, FixedLengthRowBasedKeyValueBatch.this.klen);
                this.value.pointTo(FixedLengthRowBasedKeyValueBatch.this.base, this.offsetInPage + (long)FixedLengthRowBasedKeyValueBatch.this.klen, FixedLengthRowBasedKeyValueBatch.this.vlen);
                this.offsetInPage += (long)FixedLengthRowBasedKeyValueBatch.this.recordLength;
                --this.recordsInPage;
                return true;
            }

            public UnsafeRow getKey() {
                return this.key;
            }

            public UnsafeRow getValue() {
                return this.value;
            }

            public void close() {
            }

            private void freeCurrentPage() {
                if (FixedLengthRowBasedKeyValueBatch.this.page != null) {
                    FixedLengthRowBasedKeyValueBatch.this.freePage(FixedLengthRowBasedKeyValueBatch.this.page);
                    FixedLengthRowBasedKeyValueBatch.this.page = null;
                }
            }
        };
    }

    FixedLengthRowBasedKeyValueBatch(StructType keySchema, StructType valueSchema, int maxRows, TaskMemoryManager manager) {
        super(keySchema, valueSchema, maxRows, manager);
        int keySize = keySchema.size() * 8;
        int valueSize = valueSchema.size() * 8;
        this.klen = keySize + UnsafeRow.calculateBitSetWidthInBytes(keySchema.length());
        this.vlen = valueSize + UnsafeRow.calculateBitSetWidthInBytes(valueSchema.length());
        this.recordLength = this.klen + this.vlen + 8;
    }
}

