/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.datasketches.hll.HllSketch;
import org.apache.datasketches.hll.TgtHllType;
import org.apache.datasketches.hll.Union;
import org.apache.datasketches.memory.Memory;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.HllUnion$;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.TernaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.errors.QueryExecutionErrors$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AtomicType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.DataType;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(first, second, allowDifferentLgConfigK) - Merges two binary representations of\n    Datasketches HllSketch objects, using a Datasketches Union object. Set\n    allowDifferentLgConfigK to true to allow unions of sketches with different\n    lgConfigK values (defaults to false). ", examples="\n    Examples:\n      > SELECT hll_sketch_estimate(_FUNC_(hll_sketch_agg(col1), hll_sketch_agg(col2))) FROM VALUES (1, 4), (1, 4), (2, 5), (2, 5), (3, 6) tab(col1, col2);\n       6\n  ", group="misc_funcs", since="3.5.0")
@ScalaSignature(bytes="\u0006\u0005\t%b\u0001B\u0012%\u0001FB\u0001b\u0016\u0001\u0003\u0016\u0004%\t\u0001\u0017\u0005\t9\u0002\u0011\t\u0012)A\u00053\"AQ\f\u0001BK\u0002\u0013\u0005\u0001\f\u0003\u0005_\u0001\tE\t\u0015!\u0003Z\u0011!y\u0006A!f\u0001\n\u0003A\u0006\u0002\u00031\u0001\u0005#\u0005\u000b\u0011B-\t\u000b\u0005\u0004A\u0011\u00012\t\u000f\u001d\u0004!\u0019!C\u0005Q\"1\u0011\u000f\u0001Q\u0001\n%DQ!\u0019\u0001\u0005\u0002IDQ!\u0019\u0001\u0005\u0002UDQ\u0001 \u0001\u0005RuDq!!\u0003\u0001\t\u0003\nY\u0001C\u0004\u0002\u001e\u0001!\t%a\b\t\u000f\u0005M\u0002\u0001\"\u0011\u00026!9\u0011Q\b\u0001\u0005B\u0005}\u0002\"CA*\u0001\u0005\u0005I\u0011AA+\u0011%\ti\u0006AI\u0001\n\u0003\ty\u0006C\u0005\u0002v\u0001\t\n\u0011\"\u0001\u0002`!I\u0011q\u000f\u0001\u0012\u0002\u0013\u0005\u0011q\f\u0005\n\u0003s\u0002\u0011\u0011!C!\u0003wB\u0011\"a#\u0001\u0003\u0003%\t!!$\t\u0013\u0005U\u0005!!A\u0005\u0002\u0005]\u0005\"CAO\u0001\u0005\u0005I\u0011IAP\u0011%\ti\u000bAA\u0001\n\u0003\ty\u000bC\u0005\u00024\u0002\t\t\u0011\"\u0011\u00026\"I\u0011\u0011\u0018\u0001\u0002\u0002\u0013\u0005\u00131X\u0004\n\u0003?$\u0013\u0011!E\u0001\u0003C4\u0001b\t\u0013\u0002\u0002#\u0005\u00111\u001d\u0005\u0007Cv!\t!a?\t\u0013\u0005uX$!A\u0005F\u0005}\b\"\u0003B\u0001;\u0005\u0005I\u0011\u0011B\u0002\u0011%\u0011Y!HA\u0001\n\u0003\u0013i\u0001C\u0005\u0003 u\t\t\u0011\"\u0003\u0003\"\tA\u0001\n\u001c7V]&|gN\u0003\u0002&M\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t9\u0003&\u0001\u0005dCR\fG._:u\u0015\tI#&A\u0002tc2T!a\u000b\u0017\u0002\u000bM\u0004\u0018M]6\u000b\u00055r\u0013AB1qC\u000eDWMC\u00010\u0003\ry'oZ\u0002\u0001'\u001d\u0001!G\u000e\u001f@\r2\u0003\"a\r\u001b\u000e\u0003\u0011J!!\u000e\u0013\u0003#Q+'O\\1ss\u0016C\bO]3tg&|g\u000e\u0005\u00028u5\t\u0001H\u0003\u0002:I\u000591m\u001c3fO\u0016t\u0017BA\u001e9\u0005=\u0019u\u000eZ3hK:4\u0015\r\u001c7cC\u000e\\\u0007CA\u001a>\u0013\tqDEA\tFqB,7\r^:J]B,H\u000fV=qKN\u0004\"\u0001Q\"\u000f\u0005M\n\u0015B\u0001\"%\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001R#\u0003\u001d9+H\u000e\\%oi>dWM]1oi*\u0011!\t\n\t\u0003\u000f*k\u0011\u0001\u0013\u0006\u0002\u0013\u0006)1oY1mC&\u00111\n\u0013\u0002\b!J|G-^2u!\tiEK\u0004\u0002O':\u0011qJU\u0007\u0002!*\u0011\u0011\u000bM\u0001\u0007yI|w\u000e\u001e \n\u0003%K!A\u0011%\n\u0005U3&\u0001D*fe&\fG.\u001b>bE2,'B\u0001\"I\u0003\u00151\u0017N]:u+\u0005I\u0006CA\u001a[\u0013\tYFE\u0001\u0006FqB\u0014Xm]:j_:\faAZ5sgR\u0004\u0013AB:fG>tG-A\u0004tK\u000e|g\u000e\u001a\u0011\u0002\u000bQD\u0017N\u001d3\u0002\rQD\u0017N\u001d3!\u0003\u0019a\u0014N\\5u}Q!1\rZ3g!\t\u0019\u0004\u0001C\u0003X\u000f\u0001\u0007\u0011\fC\u0003^\u000f\u0001\u0007\u0011\fC\u0003`\u000f\u0001\u0007\u0011,\u0001\u0006uCJ<W\r\u001e+za\u0016,\u0012!\u001b\t\u0003U>l\u0011a\u001b\u0006\u0003Y6\f1\u0001\u001b7m\u0015\tqG&\u0001\u0007eCR\f7o[3uG\",7/\u0003\u0002qW\nQAk\u001a;IY2$\u0016\u0010]3\u0002\u0017Q\f'oZ3u)f\u0004X\r\t\u000b\u0004GN$\b\"B,\u000b\u0001\u0004I\u0006\"B/\u000b\u0001\u0004IF\u0003B2wobDQaV\u0006A\u0002eCQ!X\u0006A\u0002eCQaX\u0006A\u0002e\u0004\"a\u0012>\n\u0005mD%a\u0002\"p_2,\u0017M\\\u0001\u0018o&$\bNT3x\u0007\"LG\u000e\u001a:f]&sG/\u001a:oC2$ba\u0019@\u0002\u0002\u0005\u0015\u0001\"B@\r\u0001\u0004I\u0016\u0001\u00038fo\u001aK'o\u001d;\t\r\u0005\rA\u00021\u0001Z\u0003%qWm^*fG>tG\r\u0003\u0004\u0002\b1\u0001\r!W\u0001\t]\u0016<H\u000b[5sI\u0006Q\u0001O]3uift\u0015-\\3\u0016\u0005\u00055\u0001\u0003BA\b\u0003/qA!!\u0005\u0002\u0014A\u0011q\nS\u0005\u0004\u0003+A\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0002\u001a\u0005m!AB*ue&twMC\u0002\u0002\u0016!\u000b!\"\u001b8qkR$\u0016\u0010]3t+\t\t\t\u0003E\u0003N\u0003G\t9#C\u0002\u0002&Y\u00131aU3r!\u0011\tI#a\f\u000e\u0005\u0005-\"bAA\u0017Q\u0005)A/\u001f9fg&!\u0011\u0011GA\u0016\u0005A\t%m\u001d;sC\u000e$H)\u0019;b)f\u0004X-\u0001\u0005eCR\fG+\u001f9f+\t\t9\u0004\u0005\u0003\u0002*\u0005e\u0012\u0002BA\u001e\u0003W\u0011\u0001\u0002R1uCRK\b/Z\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\t\u0003\u0003\n9%a\u0013\u0002PA\u0019q)a\u0011\n\u0007\u0005\u0015\u0003JA\u0002B]fDq!!\u0013\u0011\u0001\u0004\t\t%\u0001\u0004wC2,X-\r\u0005\b\u0003\u001b\u0002\u0002\u0019AA!\u0003\u00191\u0018\r\\;fe!9\u0011\u0011\u000b\tA\u0002\u0005\u0005\u0013A\u0002<bYV,7'\u0001\u0003d_BLHcB2\u0002X\u0005e\u00131\f\u0005\b/F\u0001\n\u00111\u0001Z\u0011\u001di\u0016\u0003%AA\u0002eCqaX\t\u0011\u0002\u0003\u0007\u0011,\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005\u0005$fA-\u0002d-\u0012\u0011Q\r\t\u0005\u0003O\n\t(\u0004\u0002\u0002j)!\u00111NA7\u0003%)hn\u00195fG.,GMC\u0002\u0002p!\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\t\u0019(!\u001b\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%g\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!! \u0011\t\u0005}\u0014\u0011R\u0007\u0003\u0003\u0003SA!a!\u0002\u0006\u0006!A.\u00198h\u0015\t\t9)\u0001\u0003kCZ\f\u0017\u0002BA\r\u0003\u0003\u000bA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!a$\u0011\u0007\u001d\u000b\t*C\u0002\u0002\u0014\"\u00131!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!\u0011\u0002\u001a\"I\u00111T\f\u0002\u0002\u0003\u0007\u0011qR\u0001\u0004q\u0012\n\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005\u0005\u0006CBAR\u0003S\u000b\t%\u0004\u0002\u0002&*\u0019\u0011q\u0015%\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002,\u0006\u0015&\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$2!_AY\u0011%\tY*GA\u0001\u0002\u0004\t\t%\u0001\nqe>$Wo\u0019;FY\u0016lWM\u001c;OC6,G\u0003BA?\u0003oC\u0011\"a'\u001b\u0003\u0003\u0005\r!a$\u0002\r\u0015\fX/\u00197t)\rI\u0018Q\u0018\u0005\n\u00037[\u0012\u0011!a\u0001\u0003\u0003B3\u0003AAa\u0003\u000f\fI-!4\u0002P\u0006M\u0017Q[Am\u00037\u00042aMAb\u0013\r\t)\r\n\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\tY-\u0001B \u0015\u0001\u0002\u0003\u0005I0G+:\u001bu\f\u000b4jeN$H\u0006I:fG>tG\r\f\u0011bY2|w\u000fR5gM\u0016\u0014XM\u001c;MO\u000e{gNZ5h\u0017&\u0002S\u0006I'fe\u001e,7\u000f\t;x_\u0002\u0012\u0017N\\1ss\u0002\u0012X\r\u001d:fg\u0016tG/\u0019;j_:\u001c\be\u001c4\u000bA\u0001\u0002\u0003\u0005R1uCN\\W\r^2iKN\u0004\u0003\n\u001c7TW\u0016$8\r\u001b\u0011pE*,7\r^:-AU\u001c\u0018N\\4!C\u0002\"\u0015\r^1tW\u0016$8\r[3tAUs\u0017n\u001c8!_\nTWm\u0019;/AM+GO\u0003\u0011!A\u0001\nG\u000e\\8x\t&4g-\u001a:f]RdumQ8oM&<7\n\t;pAQ\u0014X/\u001a\u0011u_\u0002\nG\u000e\\8xAUt\u0017n\u001c8tA=4\u0007e]6fi\u000eDWm\u001d\u0011xSRD\u0007\u0005Z5gM\u0016\u0014XM\u001c;\u000bA\u0001\u0002\u0003\u0005\\4D_:4\u0017nZ&!m\u0006dW/Z:!Q\u0011,g-Y;miN\u0004Co\u001c\u0011gC2\u001cX-\u000b\u0018!\u0003!)\u00070Y7qY\u0016\u001c\u0018EAAi\u0003\u0005-$\u0002\t\u0011!A\u0015C\u0018-\u001c9mKNT$\u0002\t\u0011!A\u0001\u0002c\bI*F\u0019\u0016\u001bE\u000b\t5mY~\u001b8.\u001a;dQ~+7\u000f^5nCR,\u0007f\u0018$V\u001d\u000e{\u0006\u0006\u001b7m?N\\W\r^2i?\u0006<w\rK2pYFJC\u0006\t5mY~\u001b8.\u001a;dQ~\u000bwm\u001a\u0015d_2\u0014\u0014&K\u0015!\rJ{U\n\t,B\u0019V+5\u000b\t\u00152Y\u0001\"\u0014\u0006\f\u0011)c1\u0002C'\u000b\u0017!QIb\u0003%N\u0015-A!\u0012D\u0006I\u001b*Y\u0001B3\u0007\f\u00117S\u0001\"\u0018M\u0019\u0015d_2\fD\u0006I2pYJJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u001c\u000bA\u0001\nQa\u001a:pkB\f#!a6\u0002\u00155L7oY0gk:\u001c7/A\u0003tS:\u001cW-\t\u0002\u0002^\u0006)1GL\u001b/a\u0005A\u0001\n\u001c7V]&|g\u000e\u0005\u00024;M)Q$!:\u0002rBA\u0011q]Aw3fK6-\u0004\u0002\u0002j*\u0019\u00111\u001e%\u0002\u000fI,h\u000e^5nK&!\u0011q^Au\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\r\t\u0005\u0003g\fI0\u0004\u0002\u0002v*!\u0011q_AC\u0003\tIw.C\u0002V\u0003k$\"!!9\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!! \u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000f\r\u0014)Aa\u0002\u0003\n!)q\u000b\ta\u00013\")Q\f\ta\u00013\")q\f\ta\u00013\u00069QO\\1qa2LH\u0003\u0002B\b\u00057\u0001Ra\u0012B\t\u0005+I1Aa\u0005I\u0005\u0019y\u0005\u000f^5p]B1qIa\u0006Z3fK1A!\u0007I\u0005\u0019!V\u000f\u001d7fg!A!QD\u0011\u0002\u0002\u0003\u00071-A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"Aa\t\u0011\t\u0005}$QE\u0005\u0005\u0005O\t\tI\u0001\u0004PE*,7\r\u001e")
public class HllUnion
extends TernaryExpression
implements CodegenFallback,
ExpectsInputTypes,
package.NullIntolerant,
Serializable {
    private final Expression first;
    private final Expression second;
    private final Expression third;
    private final TgtHllType targetType;

    public static Option<Tuple3<Expression, Expression, Expression>> unapply(HllUnion x$0) {
        return HllUnion$.MODULE$.unapply(x$0);
    }

    public static Function1<Tuple3<Expression, Expression, Expression>, HllUnion> tupled() {
        return HllUnion$.MODULE$.tupled();
    }

    public static Function1<Expression, Function1<Expression, Function1<Expression, HllUnion>>> curried() {
        return HllUnion$.MODULE$.curried();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public Expression first() {
        return this.first;
    }

    @Override
    public Expression second() {
        return this.second;
    }

    @Override
    public Expression third() {
        return this.third;
    }

    private TgtHllType targetType() {
        return this.targetType;
    }

    @Override
    public HllUnion withNewChildrenInternal(Expression newFirst, Expression newSecond, Expression newThird) {
        return this.copy(newFirst, newSecond, newThird);
    }

    @Override
    public String prettyName() {
        return "hll_union";
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new AtomicType[]{BinaryType$.MODULE$, BinaryType$.MODULE$, BooleanType$.MODULE$}));
    }

    @Override
    public DataType dataType() {
        return BinaryType$.MODULE$;
    }

    @Override
    public Object nullSafeEval(Object value1, Object value2, Object value3) {
        HllSketch hllSketch;
        HllSketch hllSketch2;
        try {
            hllSketch2 = HllSketch.heapify((Memory)Memory.wrap((byte[])((byte[])value1)));
        }
        catch (Error error) {
            throw QueryExecutionErrors$.MODULE$.hllInvalidInputSketchBuffer(this.prettyName());
        }
        HllSketch sketch1 = hllSketch2;
        try {
            hllSketch = HllSketch.heapify((Memory)Memory.wrap((byte[])((byte[])value2)));
        }
        catch (Error error) {
            throw QueryExecutionErrors$.MODULE$.hllInvalidInputSketchBuffer(this.prettyName());
        }
        HllSketch sketch2 = hllSketch;
        boolean allowDifferentLgConfigK = BoxesRunTime.unboxToBoolean((Object)value3);
        if (!allowDifferentLgConfigK && sketch1.getLgConfigK() != sketch2.getLgConfigK()) {
            throw QueryExecutionErrors$.MODULE$.hllUnionDifferentLgK(sketch1.getLgConfigK(), sketch2.getLgConfigK(), this.prettyName());
        }
        Union union = new Union(Math.min(sketch1.getLgConfigK(), sketch2.getLgConfigK()));
        union.update(sketch1);
        union.update(sketch2);
        return union.getResult(this.targetType()).toUpdatableByteArray();
    }

    public HllUnion copy(Expression first, Expression second, Expression third) {
        return new HllUnion(first, second, third);
    }

    public Expression copy$default$1() {
        return this.first();
    }

    public Expression copy$default$2() {
        return this.second();
    }

    public Expression copy$default$3() {
        return this.third();
    }

    @Override
    public String productPrefix() {
        return "HllUnion";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.first();
                break;
            }
            case 1: {
                object = this.second();
                break;
            }
            case 2: {
                object = this.third();
                break;
            }
            default: {
                object = Statics.ioobe((int)x$1);
                break;
            }
        }
        return object;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof HllUnion;
    }

    @Override
    public String productElementName(int x$1) {
        String string;
        int n = x$1;
        switch (n) {
            case 0: {
                string = "first";
                break;
            }
            case 1: {
                string = "second";
                break;
            }
            case 2: {
                string = "third";
                break;
            }
            default: {
                string = (String)Statics.ioobe((int)x$1);
                break;
            }
        }
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof HllUnion)) return false;
        boolean bl = true;
        if (!bl) return false;
        HllUnion hllUnion = (HllUnion)x$1;
        Expression expression = this.first();
        Expression expression2 = hllUnion.first();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.second();
        Expression expression4 = hllUnion.second();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        Expression expression5 = this.third();
        Expression expression6 = hllUnion.third();
        if (expression5 == null) {
            if (expression6 != null) {
                return false;
            }
        } else if (!expression5.equals(expression6)) return false;
        if (!hllUnion.canEqual(this)) return false;
        return true;
    }

    public HllUnion(Expression first, Expression second, Expression third) {
        this.first = first;
        this.second = second;
        this.third = third;
        CodegenFallback.$init$(this);
        ExpectsInputTypes.$init$(this);
        this.targetType = TgtHllType.HLL_8;
    }

    public HllUnion(Expression first, Expression second) {
        this(first, second, Literal$.MODULE$.apply(BoxesRunTime.boxToBoolean((boolean)false)));
    }

    public HllUnion(Expression first, Expression second, boolean third) {
        this(first, second, Literal$.MODULE$.apply(BoxesRunTime.boxToBoolean((boolean)third)));
    }
}

