/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.spark.sql.errors.QueryExecutionErrors;
import org.apache.spark.unsafe.types.UTF8String;

public class ExpressionImplUtils {
    private static final SecureRandom secureRandom = new SecureRandom();
    private static final int GCM_IV_LEN = 12;
    private static final int GCM_TAG_LEN = 128;

    public static byte[] aesEncrypt(byte[] input, byte[] key, UTF8String mode, UTF8String padding) {
        return ExpressionImplUtils.aesInternal(input, key, mode.toString(), padding.toString(), 1);
    }

    public static byte[] aesDecrypt(byte[] input, byte[] key, UTF8String mode, UTF8String padding) {
        return ExpressionImplUtils.aesInternal(input, key, mode.toString(), padding.toString(), 2);
    }

    private static byte[] aesInternal(byte[] input, byte[] key, String mode, String padding, int opmode) {
        SecretKeySpec secretKey;
        switch (key.length) {
            case 16: 
            case 24: 
            case 32: {
                secretKey = new SecretKeySpec(key, 0, key.length, "AES");
                break;
            }
            default: {
                throw QueryExecutionErrors.invalidAesKeyLengthError(key.length);
            }
        }
        try {
            if (mode.equalsIgnoreCase("ECB") && (padding.equalsIgnoreCase("PKCS") || padding.equalsIgnoreCase("DEFAULT"))) {
                Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
                cipher.init(opmode, secretKey);
                return cipher.doFinal(input, 0, input.length);
            }
            if (mode.equalsIgnoreCase("GCM") && (padding.equalsIgnoreCase("NONE") || padding.equalsIgnoreCase("DEFAULT"))) {
                Cipher cipher = Cipher.getInstance("AES/GCM/NoPadding");
                if (opmode == 1) {
                    byte[] iv = new byte[12];
                    secureRandom.nextBytes(iv);
                    GCMParameterSpec parameterSpec = new GCMParameterSpec(128, iv);
                    cipher.init(1, (Key)secretKey, parameterSpec);
                    byte[] encrypted = cipher.doFinal(input, 0, input.length);
                    ByteBuffer byteBuffer = ByteBuffer.allocate(iv.length + encrypted.length);
                    byteBuffer.put(iv);
                    byteBuffer.put(encrypted);
                    return byteBuffer.array();
                }
                assert (opmode == 2);
                GCMParameterSpec parameterSpec = new GCMParameterSpec(128, input, 0, 12);
                cipher.init(2, (Key)secretKey, parameterSpec);
                return cipher.doFinal(input, 12, input.length - 12);
            }
            throw QueryExecutionErrors.aesModeUnsupportedError(mode, padding);
        }
        catch (GeneralSecurityException e) {
            throw QueryExecutionErrors.aesCryptoError(e.getMessage());
        }
    }
}

