/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connector.catalog;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.sql.catalyst.analysis.NoSuchNamespaceException;
import org.apache.spark.sql.catalyst.analysis.NoSuchViewException;
import org.apache.spark.sql.catalyst.analysis.ViewAlreadyExistsException;
import org.apache.spark.sql.connector.catalog.CatalogPlugin;
import org.apache.spark.sql.connector.catalog.Identifier;
import org.apache.spark.sql.connector.catalog.View;
import org.apache.spark.sql.connector.catalog.ViewChange;
import org.apache.spark.sql.types.StructType;

@DeveloperApi
public interface ViewCatalog
extends CatalogPlugin {
    public static final String PROP_COMMENT = "comment";
    public static final String PROP_OWNER = "owner";
    public static final String PROP_CREATE_ENGINE_VERSION = "create_engine_version";
    public static final String PROP_ENGINE_VERSION = "engine_version";
    public static final List<String> RESERVED_PROPERTIES = Arrays.asList("comment", "owner", "create_engine_version", "engine_version");

    public Identifier[] listViews(String ... var1) throws NoSuchNamespaceException;

    public View loadView(Identifier var1) throws NoSuchViewException;

    default public void invalidateView(Identifier ident) {
    }

    default public boolean viewExists(Identifier ident) {
        try {
            return this.loadView(ident) != null;
        }
        catch (NoSuchViewException e) {
            return false;
        }
    }

    public View createView(Identifier var1, String var2, String var3, String[] var4, StructType var5, String[] var6, String[] var7, String[] var8, Map<String, String> var9) throws ViewAlreadyExistsException, NoSuchNamespaceException;

    public View alterView(Identifier var1, ViewChange ... var2) throws NoSuchViewException, IllegalArgumentException;

    public boolean dropView(Identifier var1);

    public void renameView(Identifier var1, Identifier var2) throws NoSuchViewException, ViewAlreadyExistsException;
}

