/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult$TypeCheckSuccess$;
import org.apache.spark.sql.catalyst.expressions.ArrayBasedSimpleHigherOrderFunction;
import org.apache.spark.sql.catalyst.expressions.ArraySort$;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.HigherOrderFunction;
import org.apache.spark.sql.catalyst.expressions.LambdaFunction;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.NamedLambdaVariable;
import org.apache.spark.sql.catalyst.expressions.SimpleHigherOrderFunction;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.trees.BinaryLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.GenericArrayData;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.NullType$;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(expr, func) - Sorts the input array. If func is omitted, sort\n    in ascending order. The elements of the input array must be orderable.\n    NaN is greater than any non-NaN elements for double/float type.\n    Null elements will be placed at the end of the returned array.\n    Since 3.0.0 this function also sorts and returns the array based on the\n    given comparator function. The comparator will take two arguments representing\n    two elements of the array.\n    It returns -1, 0, or 1 as the first element is less than, equal to, or greater\n    than the second element. If the comparator function returns other\n    values (including null), the function will fail and raise an error.\n    ", examples="\n    Examples:\n      > SELECT _FUNC_(array(5, 6, 1), (left, right) -> case when left < right then -1 when left > right then 1 else 0 end);\n       [1,5,6]\n      > SELECT _FUNC_(array('bc', 'ab', 'dc'), (left, right) -> case when left is null and right is null then 0 when left is null then -1 when right is null then 1 when left < right then 1 when left > right then -1 else 0 end);\n       [\"dc\",\"bc\",\"ab\"]\n      > SELECT _FUNC_(array('b', 'd', null, 'c', 'a'));\n       [\"a\",\"b\",\"c\",\"d\",null]\n  ", since="2.4.0", group="lambda_funcs")
@ScalaSignature(bytes="\u0006\u0001\teb\u0001\u0002\u0013&\u0001JB\u0001\"\u0013\u0001\u0003\u0016\u0004%\tA\u0013\u0005\t\u0017\u0002\u0011\t\u0012)A\u0005g!AA\n\u0001BK\u0002\u0013\u0005!\n\u0003\u0005N\u0001\tE\t\u0015!\u00034\u0011\u0015q\u0005\u0001\"\u0001P\u0011\u0015q\u0005\u0001\"\u0001T\u0011!)\u0006\u0001#b\u0001\n\u00031\u0006\"B1\u0001\t\u0003\u0012\u0007\"\u00024\u0001\t\u0003:\u0007\"\u00028\u0001\t\u0003z\u0007\u0002DA\u000b\u0001A\u0005\tr1Q\u0005\n\u0005]\u0001BCA\u0011\u0001!\u0015\r\u0011\"\u0001\u0002$!Q\u0011q\u0005\u0001\t\u0006\u0004%\t!a\t\t\u000f\u0005-\u0002\u0001\"\u0001\u0002.!9\u0011\u0011\u000b\u0001\u0005B\u0005M\u0003bBA.\u0001\u0011\u0005\u0013Q\f\u0005\b\u0003_\u0002A\u0011KA9\u0011%\tY\bAA\u0001\n\u0003\ti\bC\u0005\u0002\u0004\u0002\t\n\u0011\"\u0001\u0002\u0006\"I\u00111\u0014\u0001\u0012\u0002\u0013\u0005\u0011Q\u0011\u0005\n\u0003;\u0003\u0011\u0011!C!\u0003?C\u0011\"a+\u0001\u0003\u0003%\t!!,\t\u0013\u0005U\u0006!!A\u0005\u0002\u0005]\u0006\"CA_\u0001\u0005\u0005I\u0011IA`\u0011%\ti\rAA\u0001\n\u0003\ty\rC\u0005\u0002T\u0002\t\t\u0011\"\u0011\u0002V\u001e9\u0011\u0011`\u0013\t\u0002\u0005mhA\u0002\u0013&\u0011\u0003\ti\u0010\u0003\u0004O9\u0011\u0005!Q\u0001\u0005\b\u0003WaB\u0011\u0001B\u0004\u0011%\u0011\t\u0002\bb\u0001\n\u0003\u0011\u0019\u0002\u0003\u0005\u0003\u0016q\u0001\u000b\u0011BA\b\u0011%\u00119\u0002HA\u0001\n\u0003\u0013I\u0002C\u0005\u0003 q\t\t\u0011\"!\u0003\"!I!q\u0006\u000f\u0002\u0002\u0013%!\u0011\u0007\u0002\n\u0003J\u0014\u0018-_*peRT!AJ\u0014\u0002\u0017\u0015D\bO]3tg&|gn\u001d\u0006\u0003Q%\n\u0001bY1uC2L8\u000f\u001e\u0006\u0003U-\n1a]9m\u0015\taS&A\u0003ta\u0006\u00148N\u0003\u0002/_\u00051\u0011\r]1dQ\u0016T\u0011\u0001M\u0001\u0004_J<7\u0001A\n\u0007\u0001M:$\b\u0011$\u0011\u0005Q*T\"A\u0013\n\u0005Y*#AC#yaJ,7o]5p]B\u0011A\u0007O\u0005\u0003s\u0015\u00121%\u0011:sCf\u0014\u0015m]3e'&l\u0007\u000f\\3IS\u001eDWM](sI\u0016\u0014h)\u001e8di&|g\u000e\u0005\u0002<}5\tAH\u0003\u0002>K\u000591m\u001c3fO\u0016t\u0017BA =\u0005=\u0019u\u000eZ3hK:4\u0015\r\u001c7cC\u000e\\\u0007CA!E\u001b\u0005\u0011%\"A\"\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0013%a\u0002)s_\u0012,8\r\u001e\t\u0003\u0003\u001eK!\u0001\u0013\"\u0003\u0019M+'/[1mSj\f'\r\\3\u0002\u0011\u0005\u0014x-^7f]R,\u0012aM\u0001\nCJ<W/\\3oi\u0002\n\u0001BZ;oGRLwN\\\u0001\nMVt7\r^5p]\u0002\na\u0001P5oSRtDc\u0001)R%B\u0011A\u0007\u0001\u0005\u0006\u0013\u0016\u0001\ra\r\u0005\u0006\u0019\u0016\u0001\ra\r\u000b\u0003!RCQ!\u0013\u0004A\u0002M\n1\"\u001a7f[\u0016tG\u000fV=qKV\tq\u000b\u0005\u0002Y76\t\u0011L\u0003\u0002[S\u0005)A/\u001f9fg&\u0011A,\u0017\u0002\t\t\u0006$\u0018\rV=qK\"\u0012qA\u0018\t\u0003\u0003~K!\u0001\u0019\"\u0003\u0013Q\u0014\u0018M\\:jK:$\u0018\u0001\u00033bi\u0006$\u0016\u0010]3\u0016\u0003\r\u0004\"\u0001\u00173\n\u0005\u0015L&!C!se\u0006LH+\u001f9f\u0003M\u0019\u0007.Z2l\u0013:\u0004X\u000f\u001e#bi\u0006$\u0016\u0010]3t)\u0005A\u0007CA5m\u001b\u0005Q'BA6(\u0003!\tg.\u00197zg&\u001c\u0018BA7k\u0005=!\u0016\u0010]3DQ\u0016\u001c7NU3tk2$\u0018\u0001\u00022j]\u0012$\"\u0001\u00159\t\u000bET\u0001\u0019\u0001:\u0002\u0003\u0019\u0004b!Q:4k\u0006=\u0011B\u0001;C\u0005%1UO\\2uS>t'\u0007\u0005\u0003w}\u0006\raBA<}\u001d\tA80D\u0001z\u0015\tQ\u0018'\u0001\u0004=e>|GOP\u0005\u0002\u0007&\u0011QPQ\u0001\ba\u0006\u001c7.Y4f\u0013\ry\u0018\u0011\u0001\u0002\u0004'\u0016\f(BA?C!\u0019\t\u0015QA,\u0002\n%\u0019\u0011q\u0001\"\u0003\rQ+\b\u000f\\33!\r\t\u00151B\u0005\u0004\u0003\u001b\u0011%a\u0002\"p_2,\u0017M\u001c\t\u0004i\u0005E\u0011bAA\nK\tqA*Y7cI\u00064UO\\2uS>t\u0017\u0001\u0002=%eE*\"!!\u0007\u0011\u000f\u0005\u000b)!a\u0007\u0002\u001cA\u0019A'!\b\n\u0007\u0005}QEA\nOC6,G\rT1nE\u0012\fg+\u0019:jC\ndW-\u0001\u0007gSJ\u001cH/\u00127f[Z\u000b'/\u0006\u0002\u0002\u001c!\u0012ABX\u0001\u000eg\u0016\u001cwN\u001c3FY\u0016lg+\u0019:)\u00055q\u0016AC2p[B\f'/\u0019;peR!\u0011qFA#!\u0019\t\t$a\u000f\u0002@5\u0011\u00111\u0007\u0006\u0005\u0003k\t9$\u0001\u0003vi&d'BAA\u001d\u0003\u0011Q\u0017M^1\n\t\u0005u\u00121\u0007\u0002\u000b\u0007>l\u0007/\u0019:bi>\u0014\bcA!\u0002B%\u0019\u00111\t\"\u0003\u0007\u0005s\u0017\u0010C\u0004\u0002H9\u0001\r!!\u0013\u0002\u0011%t\u0007/\u001e;S_^\u0004B!a\u0013\u0002N5\tq%C\u0002\u0002P\u001d\u00121\"\u00138uKJt\u0017\r\u001c*po\u0006aa.\u001e7m'\u00064W-\u0012<bYR1\u0011qHA+\u0003/Bq!a\u0012\u0010\u0001\u0004\tI\u0005C\u0004\u0002Z=\u0001\r!a\u0010\u0002\u001b\u0005\u0014x-^7f]R4\u0016\r\\;f\u0003)\u0001(/\u001a;us:\u000bW.Z\u000b\u0003\u0003?\u0002B!!\u0019\u0002j9!\u00111MA3!\tA()C\u0002\u0002h\t\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA6\u0003[\u0012aa\u0015;sS:<'bAA4\u0005\u00069r/\u001b;i\u001d\u0016<8\t[5mIJ,g.\u00138uKJt\u0017\r\u001c\u000b\u0006!\u0006M\u0014q\u000f\u0005\u0007\u0003k\n\u0002\u0019A\u001a\u0002\u000f9,w\u000fT3gi\"1\u0011\u0011P\tA\u0002M\n\u0001B\\3x%&<\u0007\u000e^\u0001\u0005G>\u0004\u0018\u0010F\u0003Q\u0003\u007f\n\t\tC\u0004J%A\u0005\t\u0019A\u001a\t\u000f1\u0013\u0002\u0013!a\u0001g\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAADU\r\u0019\u0014\u0011R\u0016\u0003\u0003\u0017\u0003B!!$\u0002\u00186\u0011\u0011q\u0012\u0006\u0005\u0003#\u000b\u0019*A\u0005v]\u000eDWmY6fI*\u0019\u0011Q\u0013\"\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002\u001a\u0006=%!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0014!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002\"B!\u00111UAU\u001b\t\t)K\u0003\u0003\u0002(\u0006]\u0012\u0001\u00027b]\u001eLA!a\u001b\u0002&\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011q\u0016\t\u0004\u0003\u0006E\u0016bAAZ\u0005\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011qHA]\u0011%\tYlFA\u0001\u0002\u0004\ty+A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003\u0003\u0004b!a1\u0002J\u0006}RBAAc\u0015\r\t9MQ\u0001\u000bG>dG.Z2uS>t\u0017\u0002BAf\u0003\u000b\u0014\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!\u0011\u0011BAi\u0011%\tY,GA\u0001\u0002\u0004\ty$\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003\u0013\t9\u000eC\u0005\u0002<j\t\t\u00111\u0001\u0002@!\u001a\u0002!a7\u0002b\u0006\r\u0018q]Au\u0003[\fy/a=\u0002vB\u0019A'!8\n\u0007\u0005}WEA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005\u0015\u0018!\"\u001e`\rVs5i\u0018\u0015fqB\u0014H\u0006\t4v]\u000eL\u0003%\f\u0011T_J$8\u000f\t;iK\u0002Jg\u000e];uA\u0005\u0014(/Y=/A%3\u0007EZ;oG\u0002J7\u000fI8nSR$X\r\u001a\u0017!g>\u0014HO\u0003\u0011!A\u0001Jg\u000eI1tG\u0016tG-\u001b8hA=\u0014H-\u001a:/AQCW\rI3mK6,g\u000e^:!_\u001a\u0004C\u000f[3!S:\u0004X\u000f\u001e\u0011beJ\f\u0017\u0010I7vgR\u0004#-\u001a\u0011pe\u0012,'/\u00192mK:R\u0001\u0005\t\u0011!\u001d\u0006t\u0005%[:!OJ,\u0017\r^3sAQD\u0017M\u001c\u0011b]f\u0004cn\u001c8.\u001d\u0006t\u0005%\u001a7f[\u0016tGo\u001d\u0011g_J\u0004Cm\\;cY\u0016|c\r\\8bi\u0002\"\u0018\u0010]3/\u0015\u0001\u0002\u0003\u0005\t(vY2\u0004S\r\\3nK:$8\u000fI<jY2\u0004#-\u001a\u0011qY\u0006\u001cW\r\u001a\u0011bi\u0002\"\b.\u001a\u0011f]\u0012\u0004sN\u001a\u0011uQ\u0016\u0004#/\u001a;ve:,G\rI1se\u0006LhF\u0003\u0011!A\u0001\u001a\u0016N\\2fAMr\u0003G\f\u0019!i\"L7\u000f\t4v]\u000e$\u0018n\u001c8!C2\u001cx\u000eI:peR\u001c\b%\u00198eAI,G/\u001e:og\u0002\"\b.\u001a\u0011beJ\f\u0017\u0010\t2bg\u0016$\u0007e\u001c8!i\",'\u0002\t\u0011!A\u001dLg/\u001a8!G>l\u0007/\u0019:bi>\u0014\bEZ;oGRLwN\u001c\u0018!)\",\u0007eY8na\u0006\u0014\u0018\r^8sA]LG\u000e\u001c\u0011uC.,\u0007\u0005^<pA\u0005\u0014x-^7f]R\u001c\bE]3qe\u0016\u001cXM\u001c;j]\u001eT\u0001\u0005\t\u0011!i^|\u0007%\u001a7f[\u0016tGo\u001d\u0011pM\u0002\"\b.\u001a\u0011beJ\f\u0017P\f\u0006!A\u0001\u0002\u0013\n\u001e\u0011sKR,(O\\:![Eb\u0003\u0005\r\u0017!_J\u0004\u0013\u0007I1tAQDW\r\t4jeN$\b%\u001a7f[\u0016tG\u000fI5tA1,7o\u001d\u0011uQ\u0006tG\u0006I3rk\u0006d\u0007\u0005^8-A=\u0014\be\u001a:fCR,'O\u0003\u0011!A\u0001\"\b.\u00198!i\",\u0007e]3d_:$\u0007%\u001a7f[\u0016tGO\f\u0011JM\u0002\"\b.\u001a\u0011d_6\u0004\u0018M]1u_J\u0004c-\u001e8di&|g\u000e\t:fiV\u0014hn\u001d\u0011pi\",'O\u0003\u0011!A\u00012\u0018\r\\;fg\u0002B\u0013N\\2mk\u0012Lgn\u001a\u0011ok2d\u0017\u0006\f\u0011uQ\u0016\u0004c-\u001e8di&|g\u000eI<jY2\u0004c-Y5mA\u0005tG\r\t:bSN,\u0007%\u00198!KJ\u0014xN\u001d\u0018\u000bA\u0001\u0002\u0003%\u0001\u0005fq\u0006l\u0007\u000f\\3tC\t\tY/ABo\u0015\u0001\u0002\u0003\u0005I#yC6\u0004H.Z:;\u0015\u0001\u0002\u0003\u0005\t\u0011!}\u0001\u001aV\tT#D)\u0002zf)\u0016(D?\"\n'O]1zQUb\u0003E\u000e\u0017!c%b\u0003\u0005\u000b7fMRd\u0003E]5hQRL\u0003%\f !G\u0006\u001cX\rI<iK:\u0004C.\u001a4uAq\u0002#/[4ii\u0002\"\b.\u001a8![E\u0002s\u000f[3oA1,g\r\u001e\u0011?AILw\r\u001b;!i\",g\u000eI\u0019!K2\u001cX\r\t\u0019!K:$\u0017f\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0011\\c1*DFN/\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u0005\u0014(/Y=)O\t\u001cw\u0005\f\u0011(C\n<C\u0006I\u0014eG\u001eJC\u0006\t\u0015mK\u001a$H\u0006\t:jO\"$\u0018\u0006I\u0017?A\r\f7/\u001a\u0011xQ\u0016t\u0007\u0005\\3gi\u0002J7\u000f\t8vY2\u0004\u0013M\u001c3!e&<\u0007\u000e\u001e\u0011jg\u0002rW\u000f\u001c7!i\",g\u000e\t\u0019!o\",g\u000e\t7fMR\u0004\u0013n\u001d\u0011ok2d\u0007\u0005\u001e5f]\u0002j\u0013\u0007I<iK:\u0004#/[4ii\u0002J7\u000f\t8vY2\u0004C\u000f[3oAE\u0002s\u000f[3oA1,g\r\u001e\u0011=AILw\r\u001b;!i\",g\u000eI\u0019!o\",g\u000e\t7fMR\u0004c\b\t:jO\"$\b\u0005\u001e5f]\u0002j\u0013\u0007I3mg\u0016\u0004\u0003\u0007I3oI&Z$\u0002\t\u0011!A\u0001\u0002\u0003e\u0017\u0012eG\nb#EY2#Y\t\n'MI/\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u0005\u0014(/Y=)O\t<C\u0006I\u0014eO1\u0002c.\u001e7mY\u0001:3m\n\u0017!O\u0005<\u0013&K\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011!7\n\n'\u0005\f\u0012cE1\u00123M\t\u0017#I\nbc.\u001e7m;*\u0001\u0003%A\u0003tS:\u001cW-\t\u0002\u0002r\u0006)!G\f\u001b/a\u0005)qM]8va\u0006\u0012\u0011q_\u0001\rY\u0006l'\rZ1`MVt7m]\u0001\n\u0003J\u0014\u0018-_*peR\u0004\"\u0001\u000e\u000f\u0014\tq\tyP\u0012\t\u0004\u0003\n\u0005\u0011b\u0001B\u0002\u0005\n1\u0011I\\=SK\u001a$\"!a?\u0015\u000bM\u0012IA!\u0004\t\r\t-a\u00041\u00014\u0003\u0011aWM\u001a;\t\r\t=a\u00041\u00014\u0003\u0015\u0011\u0018n\u001a5u\u0003E!WMZ1vYR\u001cu.\u001c9be\u0006$xN]\u000b\u0003\u0003\u001f\t!\u0003Z3gCVdGoQ8na\u0006\u0014\u0018\r^8sA\u0005)\u0011\r\u001d9msR)\u0001Ka\u0007\u0003\u001e!)\u0011*\ta\u0001g!)A*\ta\u0001g\u00059QO\\1qa2LH\u0003\u0002B\u0012\u0005W\u0001R!\u0011B\u0013\u0005SI1Aa\nC\u0005\u0019y\u0005\u000f^5p]B)\u0011)!\u00024g!A!Q\u0006\u0012\u0002\u0002\u0003\u0007\u0001+A\u0002yIA\n1B]3bIJ+7o\u001c7wKR\u0011!1\u0007\t\u0005\u0003G\u0013)$\u0003\u0003\u00038\u0005\u0015&AB(cU\u0016\u001cG\u000f")
public class ArraySort
extends Expression
implements ArrayBasedSimpleHigherOrderFunction,
CodegenFallback,
Serializable {
    private transient DataType elementType;
    private Tuple2<NamedLambdaVariable, NamedLambdaVariable> x$21;
    private transient NamedLambdaVariable firstElemVar;
    private transient NamedLambdaVariable secondElemVar;
    private final Expression argument;
    private final Expression function;
    private transient Seq<Expression> children;
    private final Seq<Enumeration.Value> nodePatterns;
    private boolean argumentsResolved;
    private boolean resolved;
    private transient Seq<Expression> functionsForEval;
    private Expression preCanonicalized;
    private volatile transient byte bitmap$trans$0;
    private volatile byte bitmap$0;

    public static Option<Tuple2<Expression, Expression>> unapply(ArraySort arraySort) {
        return ArraySort$.MODULE$.unapply(arraySort);
    }

    public static LambdaFunction defaultComparator() {
        return ArraySort$.MODULE$.defaultComparator();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public AbstractDataType argumentType() {
        return ArrayBasedSimpleHigherOrderFunction.argumentType$(this);
    }

    @Override
    public Seq<Expression> arguments() {
        return SimpleHigherOrderFunction.arguments$(this);
    }

    @Override
    public Seq<AbstractDataType> argumentTypes() {
        return SimpleHigherOrderFunction.argumentTypes$(this);
    }

    @Override
    public Seq<Expression> functions() {
        return SimpleHigherOrderFunction.functions$(this);
    }

    @Override
    public AbstractDataType functionType() {
        return SimpleHigherOrderFunction.functionType$(this);
    }

    @Override
    public Seq<AbstractDataType> functionTypes() {
        return SimpleHigherOrderFunction.functionTypes$(this);
    }

    @Override
    public Expression functionForEval() {
        return SimpleHigherOrderFunction.functionForEval$(this);
    }

    @Override
    public Expression left() {
        return SimpleHigherOrderFunction.left$(this);
    }

    @Override
    public Expression right() {
        return SimpleHigherOrderFunction.right$(this);
    }

    @Override
    public Object eval(InternalRow inputRow) {
        return SimpleHigherOrderFunction.eval$(this, inputRow);
    }

    @Override
    public final TreeNode mapChildren(Function1 f) {
        return BinaryLike.mapChildren$(this, f);
    }

    @Override
    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return BinaryLike.withNewChildrenInternal$(this, newChildren);
    }

    @Override
    public boolean nullable() {
        return HigherOrderFunction.nullable$(this);
    }

    @Override
    public TypeCheckResult checkArgumentDataTypes() {
        return HigherOrderFunction.checkArgumentDataTypes$(this);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return HigherOrderFunction.inputTypes$(this);
    }

    private Seq<Expression> children$lzycompute() {
        ArraySort arraySort = this;
        synchronized (arraySort) {
            if ((byte)(this.bitmap$trans$0 & 8) == 0) {
                this.children = BinaryLike.children$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 8);
            }
        }
        return this.children;
    }

    @Override
    public final Seq<Expression> children() {
        return (byte)(this.bitmap$trans$0 & 8) == 0 ? this.children$lzycompute() : this.children;
    }

    @Override
    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    private boolean argumentsResolved$lzycompute() {
        ArraySort arraySort = this;
        synchronized (arraySort) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.argumentsResolved = HigherOrderFunction.argumentsResolved$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.argumentsResolved;
    }

    @Override
    public boolean argumentsResolved() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.argumentsResolved$lzycompute() : this.argumentsResolved;
    }

    private boolean resolved$lzycompute() {
        ArraySort arraySort = this;
        synchronized (arraySort) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.resolved = HigherOrderFunction.resolved$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.resolved$lzycompute() : this.resolved;
    }

    private Seq<Expression> functionsForEval$lzycompute() {
        ArraySort arraySort = this;
        synchronized (arraySort) {
            if ((byte)(this.bitmap$trans$0 & 0x10) == 0) {
                this.functionsForEval = HigherOrderFunction.functionsForEval$(this);
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 0x10);
            }
        }
        return this.functionsForEval;
    }

    @Override
    public Seq<Expression> functionsForEval() {
        return (byte)(this.bitmap$trans$0 & 0x10) == 0 ? this.functionsForEval$lzycompute() : this.functionsForEval;
    }

    private Expression preCanonicalized$lzycompute() {
        ArraySort arraySort = this;
        synchronized (arraySort) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.preCanonicalized = HigherOrderFunction.preCanonicalized$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.preCanonicalized;
    }

    @Override
    public Expression preCanonicalized() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.preCanonicalized$lzycompute() : this.preCanonicalized;
    }

    @Override
    public final void org$apache$spark$sql$catalyst$expressions$HigherOrderFunction$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    @Override
    public Expression argument() {
        return this.argument;
    }

    @Override
    public Expression function() {
        return this.function;
    }

    private DataType elementType$lzycompute() {
        ArraySort arraySort = this;
        synchronized (arraySort) {
            if ((byte)(this.bitmap$trans$0 & 1) == 0) {
                this.elementType = ((ArrayType)this.argument().dataType()).elementType();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 1);
            }
        }
        return this.elementType;
    }

    public DataType elementType() {
        return (byte)(this.bitmap$trans$0 & 1) == 0 ? this.elementType$lzycompute() : this.elementType;
    }

    @Override
    public ArrayType dataType() {
        return (ArrayType)this.argument().dataType();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        TypeCheckResult typeCheckResult;
        TypeCheckResult typeCheckResult2 = this.checkArgumentDataTypes();
        if (TypeCheckResult$TypeCheckSuccess$.MODULE$.equals(typeCheckResult2)) {
            TypeCheckResult typeCheckResult3;
            DataType dataType = this.argument().dataType();
            if (dataType instanceof ArrayType) {
                DataType dataType2 = this.function().dataType();
                IntegerType$ integerType$ = IntegerType$.MODULE$;
                typeCheckResult3 = !(dataType2 != null ? !dataType2.equals(integerType$) : integerType$ != null) ? TypeCheckResult$TypeCheckSuccess$.MODULE$ : new TypeCheckResult.TypeCheckFailure("Return type of the given function has to be IntegerType");
            } else {
                typeCheckResult3 = new TypeCheckResult.TypeCheckFailure(new StringBuilder(27).append(this.prettyName()).append(" only supports array input.").toString());
            }
            typeCheckResult = typeCheckResult3;
        } else {
            typeCheckResult = typeCheckResult2;
        }
        return typeCheckResult;
    }

    @Override
    public ArraySort bind(Function2<Expression, Seq<Tuple2<DataType, Object>>, LambdaFunction> f) {
        DataType dataType = this.argument().dataType();
        if (!(dataType instanceof ArrayType)) {
            throw new MatchError((Object)dataType);
        }
        ArrayType arrayType = (ArrayType)dataType;
        DataType elementType = arrayType.elementType();
        boolean containsNull = arrayType.containsNull();
        Tuple2 tuple2 = new Tuple2((Object)elementType, (Object)BoxesRunTime.boxToBoolean((boolean)containsNull));
        Tuple2 tuple22 = tuple2;
        DataType elementType2 = (DataType)tuple22._1();
        boolean containsNull2 = tuple22._2$mcZ$sp();
        Tuple2 tuple23 = new Tuple2((Object)elementType2, (Object)BoxesRunTime.boxToBoolean((boolean)containsNull2));
        Tuple2 tuple24 = new Tuple2((Object)elementType2, (Object)BoxesRunTime.boxToBoolean((boolean)containsNull2));
        LambdaFunction x$1 = (LambdaFunction)f.apply((Object)this.function(), (Object)Nil$.MODULE$.$colon$colon((Object)tuple24).$colon$colon((Object)tuple23));
        Expression x$2 = this.copy$default$1();
        return this.copy(x$2, x$1);
    }

    private Tuple2<NamedLambdaVariable, NamedLambdaVariable> x$21$lzycompute() {
        block5: {
            ArraySort arraySort = this;
            synchronized (arraySort) {
                NamedLambdaVariable namedLambdaVariable;
                NamedExpression secondElemVar;
                block7: {
                    Expression expression;
                    block6: {
                        LambdaFunction lambdaFunction;
                        Seq<NamedExpression> seq;
                        Some some;
                        if ((byte)(this.bitmap$0 & 1) != 0) break block5;
                        expression = this.function();
                        if (!(expression instanceof LambdaFunction) || (some = Seq$.MODULE$.unapplySeq(seq = (lambdaFunction = (LambdaFunction)expression).arguments())).isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) break block6;
                        NamedExpression firstElemVar = (NamedExpression)((SeqLike)some.get()).apply(0);
                        secondElemVar = (NamedExpression)((SeqLike)some.get()).apply(1);
                        if (!(firstElemVar instanceof NamedLambdaVariable)) break block6;
                        namedLambdaVariable = (NamedLambdaVariable)firstElemVar;
                        if (secondElemVar instanceof NamedLambdaVariable) break block7;
                    }
                    throw new MatchError((Object)expression);
                }
                NamedLambdaVariable namedLambdaVariable2 = (NamedLambdaVariable)secondElemVar;
                Tuple2 tuple2 = new Tuple2((Object)namedLambdaVariable, (Object)namedLambdaVariable2);
                this.x$21 = tuple2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.x$21;
    }

    private /* synthetic */ Tuple2 x$21() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.x$21$lzycompute() : this.x$21;
    }

    private NamedLambdaVariable firstElemVar$lzycompute() {
        ArraySort arraySort = this;
        synchronized (arraySort) {
            if ((byte)(this.bitmap$trans$0 & 2) == 0) {
                this.firstElemVar = (NamedLambdaVariable)this.x$21()._1();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 2);
            }
        }
        return this.firstElemVar;
    }

    public NamedLambdaVariable firstElemVar() {
        return (byte)(this.bitmap$trans$0 & 2) == 0 ? this.firstElemVar$lzycompute() : this.firstElemVar;
    }

    private NamedLambdaVariable secondElemVar$lzycompute() {
        ArraySort arraySort = this;
        synchronized (arraySort) {
            if ((byte)(this.bitmap$trans$0 & 4) == 0) {
                this.secondElemVar = (NamedLambdaVariable)this.x$21()._2();
                this.bitmap$trans$0 = (byte)(this.bitmap$trans$0 | 4);
            }
        }
        return this.secondElemVar;
    }

    public NamedLambdaVariable secondElemVar() {
        return (byte)(this.bitmap$trans$0 & 4) == 0 ? this.secondElemVar$lzycompute() : this.secondElemVar;
    }

    public Comparator<Object> comparator(InternalRow inputRow) {
        Expression f = this.functionForEval();
        return (o1, o2) -> {
            this.firstElemVar().value().set(o1);
            this.secondElemVar().value().set(o2);
            return BoxesRunTime.unboxToInt((Object)f.eval(inputRow));
        };
    }

    @Override
    public Object nullSafeEval(InternalRow inputRow, Object argumentValue) {
        Object[] arr = (Object[])((ArrayData)argumentValue).toArray(this.elementType(), ClassTag$.MODULE$.AnyRef());
        DataType dataType = this.elementType();
        NullType$ nullType$ = NullType$.MODULE$;
        if (dataType == null ? nullType$ != null : !dataType.equals(nullType$)) {
            Arrays.sort(arr, this.comparator(inputRow));
        }
        return new GenericArrayData(arr);
    }

    @Override
    public String prettyName() {
        return "array_sort";
    }

    @Override
    public ArraySort withNewChildrenInternal(Expression newLeft, Expression newRight) {
        return this.copy(newLeft, newRight);
    }

    public ArraySort copy(Expression argument, Expression function) {
        return new ArraySort(argument, function);
    }

    public Expression copy$default$1() {
        return this.argument();
    }

    public Expression copy$default$2() {
        return this.function();
    }

    @Override
    public String productPrefix() {
        return "ArraySort";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.argument();
                break;
            }
            case 1: {
                expression = this.function();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ArraySort;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ArraySort)) return false;
        boolean bl = true;
        if (!bl) return false;
        ArraySort arraySort = (ArraySort)x$1;
        Expression expression = this.argument();
        Expression expression2 = arraySort.argument();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.function();
        Expression expression4 = arraySort.function();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!arraySort.canEqual(this)) return false;
        return true;
    }

    public ArraySort(Expression argument, Expression function) {
        this.argument = argument;
        this.function = function;
        ExpectsInputTypes.$init$(this);
        HigherOrderFunction.$init$(this);
        BinaryLike.$init$(this);
        SimpleHigherOrderFunction.$init$(this);
        ArrayBasedSimpleHigherOrderFunction.$init$(this);
        CodegenFallback.$init$(this);
    }

    public ArraySort(Expression argument) {
        this(argument, ArraySort$.MODULE$.defaultComparator());
    }
}

