/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.String2TrimExpression;
import org.apache.spark.sql.catalyst.expressions.StringTrimRight$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.unsafe.types.UTF8String;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(str) - Removes the trailing space characters from `str`.\n  ", arguments="\n    Arguments:\n      * str - a string expression\n      * trimStr - the trim string characters to trim, the default value is a single space\n  ", examples="\n    Examples:\n      > SELECT _FUNC_('    SparkSQL   ');\n       SparkSQL\n  ", since="1.5.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0001\u0005mw!\u0002\u0012$\u0011\u0003\u0001d!\u0002\u001a$\u0011\u0003\u0019\u0004\"B\u001f\u0002\t\u0003q\u0004\"B \u0002\t\u0003\u0001\u0005BB \u0002\t\u0003\t\u0019\f\u0003\u0005@\u0003\u0005\u0005I\u0011QA\\\u0011%\ti,AI\u0001\n\u0003\t9\u0004C\u0005\u0002@\u0006\t\t\u0011\"!\u0002B\"I\u0011qZ\u0001\u0012\u0002\u0013\u0005\u0011q\u0007\u0005\n\u0003#\f\u0011\u0011!C\u0005\u0003'4AAM\u0012A\u0005\"AAJ\u0003BK\u0002\u0013\u0005Q\n\u0003\u0005O\u0015\tE\t\u0015!\u0003D\u0011!y%B!f\u0001\n\u0003\u0001\u0006\u0002\u0003+\u000b\u0005#\u0005\u000b\u0011B)\t\u000buRA\u0011A+\t\u000buRA\u0011\u0001-\t\u000buRA\u0011A.\t\u000buSA\u0011\t0\t\u000b)TA\u0011\u000b0\t\u000b-TA\u0011\t7\t\u000b-TA\u0011I<\t\u000fmT!\u0019!C!=\"1AP\u0003Q\u0001\n}CQ! \u0006\u0005RyD\u0011\"!\u0006\u000b\u0003\u0003%\t!a\u0006\t\u0013\u0005u!\"%A\u0005\u0002\u0005}\u0001\"CA\u001b\u0015E\u0005I\u0011AA\u001c\u0011%\tYDCA\u0001\n\u0003\ni\u0004C\u0005\u0002N)\t\t\u0011\"\u0001\u0002P!I\u0011q\u000b\u0006\u0002\u0002\u0013\u0005\u0011\u0011\f\u0005\n\u0003KR\u0011\u0011!C!\u0003OB\u0011\"!\u001e\u000b\u0003\u0003%\t!a\u001e\t\u0013\u0005\u0005%\"!A\u0005B\u0005\r\u0015aD*ue&tw\r\u0016:j[JKw\r\u001b;\u000b\u0005\u0011*\u0013aC3yaJ,7o]5p]NT!AJ\u0014\u0002\u0011\r\fG/\u00197zgRT!\u0001K\u0015\u0002\u0007M\fHN\u0003\u0002+W\u0005)1\u000f]1sW*\u0011A&L\u0001\u0007CB\f7\r[3\u000b\u00039\n1a\u001c:h\u0007\u0001\u0001\"!M\u0001\u000e\u0003\r\u0012qb\u0015;sS:<GK]5n%&<\u0007\u000e^\n\u0004\u0003QR\u0004CA\u001b9\u001b\u00051$\"A\u001c\u0002\u000bM\u001c\u0017\r\\1\n\u0005e2$AB!osJ+g\r\u0005\u00026w%\u0011AH\u000e\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003A\nQ!\u00199qYf$R!QAW\u0003c\u0003\"!\r\u0006\u0014\u000b)\u0019e)\u0013\u001e\u0011\u0005E\"\u0015BA#$\u0005))\u0005\u0010\u001d:fgNLwN\u001c\t\u0003c\u001dK!\u0001S\u0012\u0003+M#(/\u001b8heQ\u0013\u0018.\\#yaJ,7o]5p]B\u0011QGS\u0005\u0003\u0017Z\u0012q\u0001\u0015:pIV\u001cG/\u0001\u0004te\u000e\u001cFO]\u000b\u0002\u0007\u000691O]2TiJ\u0004\u0013a\u0002;sS6\u001cFO]\u000b\u0002#B\u0019QGU\"\n\u0005M3$AB(qi&|g.\u0001\u0005ue&l7\u000b\u001e:!)\r\tek\u0016\u0005\u0006\u0019>\u0001\ra\u0011\u0005\b\u001f>\u0001\n\u00111\u0001R)\r\t\u0015L\u0017\u0005\u0006\u001fB\u0001\ra\u0011\u0005\u0006\u0019B\u0001\ra\u0011\u000b\u0003\u0003rCQ\u0001T\tA\u0002\r\u000b!\u0002\u001d:fiRLh*Y7f+\u0005y\u0006C\u00011h\u001d\t\tW\r\u0005\u0002cm5\t1M\u0003\u0002e_\u00051AH]8pizJ!A\u001a\u001c\u0002\rA\u0013X\rZ3g\u0013\tA\u0017N\u0001\u0004TiJLgn\u001a\u0006\u0003MZ\n\u0011\u0002Z5sK\u000e$\u0018n\u001c8\u0002\r\u0011|WI^1m)\tiW\u000f\u0005\u0002og6\tqN\u0003\u0002qc\u0006)A/\u001f9fg*\u0011!/K\u0001\u0007k:\u001c\u0018MZ3\n\u0005Q|'AC+U\rb\u001aFO]5oO\")a\u000f\u0006a\u0001[\u0006I1O]2TiJLgn\u001a\u000b\u0004[bL\b\"\u0002<\u0016\u0001\u0004i\u0007\"\u0002>\u0016\u0001\u0004i\u0017A\u0003;sS6\u001cFO]5oO\u0006QAO]5n\u001b\u0016$\bn\u001c3\u0002\u0017Q\u0014\u0018.\\'fi\"|G\rI\u0001\u0018o&$\bNT3x\u0007\"LG\u000e\u001a:f]&sG/\u001a:oC2$\"!Q@\t\u000f\u0005\u0005\u0001\u00041\u0001\u0002\u0004\u0005Ya.Z<DQ&dGM]3o!\u0015\t)!a\u0004D\u001d\u0011\t9!a\u0003\u000f\u0007\t\fI!C\u00018\u0013\r\tiAN\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\t\"a\u0005\u0003\u0015%sG-\u001a=fIN+\u0017OC\u0002\u0002\u000eY\nAaY8qsR)\u0011)!\u0007\u0002\u001c!9A*\u0007I\u0001\u0002\u0004\u0019\u0005bB(\u001a!\u0003\u0005\r!U\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t\tCK\u0002D\u0003GY#!!\n\u0011\t\u0005\u001d\u0012\u0011G\u0007\u0003\u0003SQA!a\u000b\u0002.\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003_1\u0014AC1o]>$\u0018\r^5p]&!\u00111GA\u0015\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\tIDK\u0002R\u0003G\tQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA !\u0011\t\t%a\u0013\u000e\u0005\u0005\r#\u0002BA#\u0003\u000f\nA\u0001\\1oO*\u0011\u0011\u0011J\u0001\u0005U\u00064\u0018-C\u0002i\u0003\u0007\nA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!\u0015\u0011\u0007U\n\u0019&C\u0002\u0002VY\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!a\u0017\u0002bA\u0019Q'!\u0018\n\u0007\u0005}cGA\u0002B]fD\u0011\"a\u0019\u001f\u0003\u0003\u0005\r!!\u0015\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\tI\u0007\u0005\u0004\u0002l\u0005E\u00141L\u0007\u0003\u0003[R1!a\u001c7\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003g\niG\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA=\u0003\u007f\u00022!NA>\u0013\r\tiH\u000e\u0002\b\u0005>|G.Z1o\u0011%\t\u0019\u0007IA\u0001\u0002\u0004\tY&\u0001\u0004fcV\fGn\u001d\u000b\u0005\u0003s\n)\tC\u0005\u0002d\u0005\n\t\u00111\u0001\u0002\\!:\"\"!#\u0002\u0010\u0006E\u0015QSAL\u00037\u000bi*!)\u0002$\u0006\u001d\u0016\u0011\u0016\t\u0004c\u0005-\u0015bAAGG\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAAJ\u0003\u001dS\u0001\u0005\t\u0011!?\u001a+fjQ0)gR\u0014\u0018\u0006I\u0017!%\u0016lwN^3tAQDW\r\t;sC&d\u0017N\\4!gB\f7-\u001a\u0011dQ\u0006\u0014\u0018m\u0019;feN\u0004cM]8nA\u0001\u001cHO\u001d1/\u0015\u0001\u0002\u0013!C1sOVlWM\u001c;tC\t\tI*AA\u000f\u0015\u0001\u0002\u0003\u0005I!sOVlWM\u001c;tu)\u0001\u0003\u0005\t\u0011!A)\u00023\u000f\u001e:![\u0001\n\u0007e\u001d;sS:<\u0007%\u001a=qe\u0016\u001c8/[8o\u0015\u0001\u0002\u0003\u0005\t\u0011!U\u0001\"(/[7TiJ\u0004S\u0006\t;iK\u0002\"(/[7!gR\u0014\u0018N\\4!G\"\f'/Y2uKJ\u001c\b\u0005^8!iJLW\u000e\f\u0011uQ\u0016\u0004C-\u001a4bk2$\bE^1mk\u0016\u0004\u0013n\u001d\u0011bAMLgn\u001a7fAM\u0004\u0018mY3\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003?\u000b1J\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u0015(A\u0001\u0002\u0003e\u00159be.\u001c\u0016\u000b\u0014\u0011!A\u001dJ3H\u0003\u0011!A\u0001\u0002\u0003\u0005I*qCJ\\7+\u0015'\u000bA\u0001\nQa]5oG\u0016\f#!!*\u0002\u000bErSG\f\u0019\u0002\u000b\u001d\u0014x.\u001e9\"\u0005\u0005-\u0016\u0001D:ue&twm\u00184v]\u000e\u001c\bBBAX\u0007\u0001\u00071)A\u0002tiJDQaT\u0002A\u0002\r#2!QA[\u0011\u0019\ty\u000b\u0002a\u0001\u0007R)\u0011)!/\u0002<\")A*\u0002a\u0001\u0007\"9q*\u0002I\u0001\u0002\u0004\t\u0016aD1qa2LH\u0005Z3gCVdG\u000f\n\u001a\u0002\u000fUt\u0017\r\u001d9msR!\u00111YAf!\u0011)$+!2\u0011\u000bU\n9mQ)\n\u0007\u0005%gG\u0001\u0004UkBdWM\r\u0005\t\u0003\u001b<\u0011\u0011!a\u0001\u0003\u0006\u0019\u0001\u0010\n\u0019\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005U\u0007\u0003BA!\u0003/LA!!7\u0002D\t1qJ\u00196fGR\u0004")
public class StringTrimRight
extends Expression
implements String2TrimExpression,
Serializable {
    private final Expression srcStr;
    private final Option<Expression> trimStr;
    private final String trimMethod;

    public static Option<Expression> $lessinit$greater$default$2() {
        return StringTrimRight$.MODULE$.$lessinit$greater$default$2();
    }

    public static Option<Tuple2<Expression, Option<Expression>>> unapply(StringTrimRight stringTrimRight) {
        return StringTrimRight$.MODULE$.unapply(stringTrimRight);
    }

    public static Option<Expression> apply$default$2() {
        return StringTrimRight$.MODULE$.apply$default$2();
    }

    @Override
    public /* synthetic */ String org$apache$spark$sql$catalyst$expressions$String2TrimExpression$$super$sql() {
        return super.sql();
    }

    @Override
    public Seq<Expression> children() {
        return String2TrimExpression.children$(this);
    }

    @Override
    public DataType dataType() {
        return String2TrimExpression.dataType$(this);
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return String2TrimExpression.inputTypes$(this);
    }

    @Override
    public boolean nullable() {
        return String2TrimExpression.nullable$(this);
    }

    @Override
    public boolean foldable() {
        return String2TrimExpression.foldable$(this);
    }

    @Override
    public Object eval(InternalRow input) {
        return String2TrimExpression.eval$(this, input);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return String2TrimExpression.doGenCode$(this, ctx, ev);
    }

    @Override
    public String sql() {
        return String2TrimExpression.sql$(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression srcStr() {
        return this.srcStr;
    }

    @Override
    public Option<Expression> trimStr() {
        return this.trimStr;
    }

    @Override
    public String prettyName() {
        return "rtrim";
    }

    @Override
    public String direction() {
        return "TRAILING";
    }

    @Override
    public UTF8String doEval(UTF8String srcString) {
        return srcString.trimRight();
    }

    @Override
    public UTF8String doEval(UTF8String srcString, UTF8String trimString) {
        return srcString.trimRight(trimString);
    }

    @Override
    public String trimMethod() {
        return this.trimMethod;
    }

    @Override
    public StringTrimRight withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.copy((Expression)newChildren.head(), (Option<Expression>)(this.trimStr().isDefined() ? new Some(newChildren.last()) : None$.MODULE$));
    }

    public StringTrimRight copy(Expression srcStr, Option<Expression> trimStr) {
        return new StringTrimRight(srcStr, trimStr);
    }

    public Expression copy$default$1() {
        return this.srcStr();
    }

    public Option<Expression> copy$default$2() {
        return this.trimStr();
    }

    @Override
    public String productPrefix() {
        return "StringTrimRight";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Option<Expression> option;
        int n = x$1;
        switch (n) {
            case 0: {
                option = this.srcStr();
                break;
            }
            case 1: {
                option = this.trimStr();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return option;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof StringTrimRight;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof StringTrimRight)) return false;
        boolean bl = true;
        if (!bl) return false;
        StringTrimRight stringTrimRight = (StringTrimRight)x$1;
        Expression expression = this.srcStr();
        Expression expression2 = stringTrimRight.srcStr();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Option<Expression> option = this.trimStr();
        Option<Expression> option2 = stringTrimRight.trimStr();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        if (!stringTrimRight.canEqual(this)) return false;
        return true;
    }

    public StringTrimRight(Expression srcStr, Option<Expression> trimStr) {
        this.srcStr = srcStr;
        this.trimStr = trimStr;
        ExpectsInputTypes.$init$(this);
        String2TrimExpression.$init$(this);
        this.trimMethod = "trimRight";
    }

    public StringTrimRight(Expression trimStr, Expression srcStr) {
        this(srcStr, (Option<Expression>)Option$.MODULE$.apply((Object)trimStr));
    }

    public StringTrimRight(Expression srcStr) {
        this(srcStr, (Option<Expression>)None$.MODULE$);
    }
}

