/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.NonSQLExpression;
import org.apache.spark.sql.catalyst.expressions.SessionWindow$;
import org.apache.spark.sql.catalyst.expressions.Unevaluable;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.AnyDataType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.TimestampType$;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_(time_column, gap_duration) - Generates session window given a timestamp specifying column and gap duration.\n      See <a href=\"https://spark.apache.org/docs/latest/structured-streaming-programming-guide.html#types-of-time-windows\">'Types of time windows'</a> in Structured Streaming guide doc for detailed explanation and examples.\n  ", arguments="\n    Arguments:\n      * time_column - The column or the expression to use as the timestamp for windowing by time. The time column must be of TimestampType.\n      * gap_duration - A string specifying the timeout of the session represented as \"interval value\"\n        (See <a href=\"https://spark.apache.org/docs/latest/sql-ref-literals.html#interval-literal\">Interval Literal</a> for more details.) for the fixed gap duration, or\n        an expression which is applied for each input and evaluated to the \"interval value\" for the dynamic gap duration.\n  ", examples="\n    Examples:\n      > SELECT a, session_window.start, session_window.end, count(*) as cnt FROM VALUES ('A1', '2021-01-01 00:00:00'), ('A1', '2021-01-01 00:04:30'), ('A1', '2021-01-01 00:10:00'), ('A2', '2021-01-01 00:01:00') AS tab(a, b) GROUP by a, _FUNC_(b, '5 minutes') ORDER BY a, start;\n        A1\t2021-01-01 00:00:00\t2021-01-01 00:09:30\t2\n        A1\t2021-01-01 00:10:00\t2021-01-01 00:15:00\t1\n        A2\t2021-01-01 00:01:00\t2021-01-01 00:06:00\t1\n      > SELECT a, session_window.start, session_window.end, count(*) as cnt FROM VALUES ('A1', '2021-01-01 00:00:00'), ('A1', '2021-01-01 00:04:30'), ('A1', '2021-01-01 00:10:00'), ('A2', '2021-01-01 00:01:00'), ('A2', '2021-01-01 00:04:30') AS tab(a, b) GROUP by a, _FUNC_(b, CASE WHEN a = 'A1' THEN '5 minutes' WHEN a = 'A2' THEN '1 minute' ELSE '10 minutes' END) ORDER BY a, start;\n        A1\t2021-01-01 00:00:00\t2021-01-01 00:09:30\t2\n        A1\t2021-01-01 00:10:00\t2021-01-01 00:15:00\t1\n        A2\t2021-01-01 00:01:00\t2021-01-01 00:02:00\t1\n        A2\t2021-01-01 00:04:30\t2021-01-01 00:05:30\t1\n  ", group="datetime_funcs", since="3.2.0")
@ScalaSignature(bytes="\u0006\u0001\u0005%g\u0001\u0002\u0010 \u00012B\u0001b\u0011\u0001\u0003\u0016\u0004%\t\u0001\u0012\u0005\t\u000b\u0002\u0011\t\u0012)A\u0005[!Aa\t\u0001BK\u0002\u0013\u0005A\t\u0003\u0005H\u0001\tE\t\u0015!\u0003.\u0011\u0015A\u0005\u0001\"\u0001J\u0011\u0015i\u0005\u0001\"\u0011O\u0011\u0015Y\u0006\u0001\"\u0011]\u0011\u0015!\u0007\u0001\"\u0011f\u0011!I\u0007\u0001#b\u0001\n\u0003R\u0007\"\u00028\u0001\t\u0003R\u0007\"B8\u0001\t#\u0002\bb\u0002<\u0001\u0003\u0003%\ta\u001e\u0005\bu\u0002\t\n\u0011\"\u0001|\u0011!\ti\u0001AI\u0001\n\u0003Y\b\"CA\b\u0001\u0005\u0005I\u0011IA\t\u0011%\t\u0019\u0003AA\u0001\n\u0003\t)\u0003C\u0005\u0002.\u0001\t\t\u0011\"\u0001\u00020!I\u00111\b\u0001\u0002\u0002\u0013\u0005\u0013Q\b\u0005\n\u0003\u0017\u0002\u0011\u0011!C\u0001\u0003\u001bB\u0011\"!\u0015\u0001\u0003\u0003%\t%a\u0015\b\u000f\u0005ut\u0004#\u0001\u0002\u0000\u00191ad\bE\u0001\u0003\u0003Ca\u0001\u0013\f\u0005\u0002\u0005%\u0005\"CAF-\t\u0007I\u0011AA\t\u0011!\tiI\u0006Q\u0001\n\u0005M\u0001bBAH-\u0011\u0005\u0011\u0011\u0013\u0005\n\u0003\u001f3\u0012\u0011!CA\u0003KC\u0011\"a+\u0017\u0003\u0003%\t)!,\t\u0013\u0005}f#!A\u0005\n\u0005\u0005'!D*fgNLwN\\,j]\u0012|wO\u0003\u0002!C\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t\u00113%\u0001\u0005dCR\fG._:u\u0015\t!S%A\u0002tc2T!AJ\u0014\u0002\u000bM\u0004\u0018M]6\u000b\u0005!J\u0013AB1qC\u000eDWMC\u0001+\u0003\ry'oZ\u0002\u0001'\u001d\u0001Q&\r\u001b8u\u0001\u0003\"AL\u0018\u000e\u0003}I!\u0001M\u0010\u0003\u0015\u0015C\bO]3tg&|g\u000e\u0005\u0002/e%\u00111g\b\u0002\u0017\u00136\u0004H.[2ji\u000e\u000b7\u000f^%oaV$H+\u001f9fgB\u0011a&N\u0005\u0003m}\u00111\"\u00168fm\u0006dW/\u00192mKB\u0011a\u0006O\u0005\u0003s}\u0011\u0001CT8o'FcU\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u0005mrT\"\u0001\u001f\u000b\u0003u\nQa]2bY\u0006L!a\u0010\u001f\u0003\u000fA\u0013x\u000eZ;diB\u00111(Q\u0005\u0003\u0005r\u0012AbU3sS\u0006d\u0017N_1cY\u0016\f!\u0002^5nK\u000e{G.^7o+\u0005i\u0013a\u0003;j[\u0016\u001cu\u000e\\;n]\u0002\n1bZ1q\tV\u0014\u0018\r^5p]\u0006aq-\u00199EkJ\fG/[8oA\u00051A(\u001b8jiz\"2AS&M!\tq\u0003\u0001C\u0003D\u000b\u0001\u0007Q\u0006C\u0003G\u000b\u0001\u0007Q&\u0001\u0005dQ&dGM]3o+\u0005y\u0005c\u0001)Y[9\u0011\u0011K\u0016\b\u0003%Vk\u0011a\u0015\u0006\u0003).\na\u0001\u0010:p_Rt\u0014\"A\u001f\n\u0005]c\u0014a\u00029bG.\fw-Z\u0005\u00033j\u00131aU3r\u0015\t9F(\u0001\u0006j]B,H\u000fV=qKN,\u0012!\u0018\t\u0004!bs\u0006CA0c\u001b\u0005\u0001'BA1$\u0003\u0015!\u0018\u0010]3t\u0013\t\u0019\u0007M\u0001\tBEN$(/Y2u\t\u0006$\u0018\rV=qK\u0006AA-\u0019;b)f\u0004X-F\u0001g!\tyv-\u0003\u0002iA\nAA)\u0019;b)f\u0004X-\u0001\u0005sKN|GN^3e+\u0005Y\u0007CA\u001em\u0013\tiGHA\u0004C_>dW-\u00198\u0002\u00119,H\u000e\\1cY\u0016\fqc^5uQ:+wo\u00115jY\u0012\u0014XM\\%oi\u0016\u0014h.\u00197\u0015\u00055\n\b\"\u0002:\f\u0001\u0004\u0019\u0018a\u00038fo\u000eC\u0017\u000e\u001c3sK:\u00042\u0001\u0015;.\u0013\t)(L\u0001\u0006J]\u0012,\u00070\u001a3TKF\fAaY8qsR\u0019!\n_=\t\u000f\rc\u0001\u0013!a\u0001[!9a\t\u0004I\u0001\u0002\u0004i\u0013AD2paf$C-\u001a4bk2$H%M\u000b\u0002y*\u0012Q&`\u0016\u0002}B\u0019q0!\u0003\u000e\u0005\u0005\u0005!\u0002BA\u0002\u0003\u000b\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u001dA(\u0001\u0006b]:|G/\u0019;j_:LA!a\u0003\u0002\u0002\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!a\u0005\u0011\t\u0005U\u0011qD\u0007\u0003\u0003/QA!!\u0007\u0002\u001c\u0005!A.\u00198h\u0015\t\ti\"\u0001\u0003kCZ\f\u0017\u0002BA\u0011\u0003/\u0011aa\u0015;sS:<\u0017\u0001\u00049s_\u0012,8\r^!sSRLXCAA\u0014!\rY\u0014\u0011F\u0005\u0004\u0003Wa$aA%oi\u0006q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA\u0019\u0003o\u00012aOA\u001a\u0013\r\t)\u0004\u0010\u0002\u0004\u0003:L\b\"CA\u001d#\u0005\u0005\t\u0019AA\u0014\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011q\b\t\u0007\u0003\u0003\n9%!\r\u000e\u0005\u0005\r#bAA#y\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005%\u00131\t\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000eF\u0002l\u0003\u001fB\u0011\"!\u000f\u0014\u0003\u0003\u0005\r!!\r\u0002\r\u0015\fX/\u00197t)\rY\u0017Q\u000b\u0005\n\u0003s!\u0012\u0011!a\u0001\u0003cAs\u0003AA-\u0003?\n\t'!\u001a\u0002h\u0005-\u0014QNA9\u0003g\n9(!\u001f\u0011\u00079\nY&C\u0002\u0002^}\u0011Q#\u0012=qe\u0016\u001c8/[8o\t\u0016\u001c8M]5qi&|g.A\u0003vg\u0006<W-\t\u0002\u0002d\u0005\u0011)L\u0003\u0011!A\u0001zf)\u0016(D?\"\"\u0018.\\3`G>dW/\u001c8-A\u001d\f\u0007o\u00183ve\u0006$\u0018n\u001c8*A5\u0002s)\u001a8fe\u0006$Xm\u001d\u0011tKN\u001c\u0018n\u001c8!o&tGm\\<!O&4XM\u001c\u0011bAQLW.Z:uC6\u0004\be\u001d9fG&4\u00170\u001b8hA\r|G.^7oA\u0005tG\rI4ba\u0002\"WO]1uS>tgF\u0003\u0011!A\u0001\u0002\u0003eU3fAq\n\u0007\u0005\u001b:fMv\u0012\u0003\u000e\u001e;qgjzsf\u001d9be.t\u0013\r]1dQ\u0016tsN]40I>\u001c7o\f7bi\u0016\u001cHoL:ueV\u001cG/\u001e:fI6\u001aHO]3b[&tw-\f9s_\u001e\u0014\u0018-\\7j]\u001els-^5eK:BG/\u001c7$if\u0004Xm]\u0017pM6\"\u0018.\\3.o&tGm\\<tEy:C+\u001f9fg\u0002zg\r\t;j[\u0016\u0004s/\u001b8e_^\u001cx\u0005P\u0018b}\u0001Jg\u000eI*ueV\u001cG/\u001e:fI\u0002\u001aFO]3b[&tw\rI4vS\u0012,\u0007\u0005Z8dA\u0019|'\u000f\t3fi\u0006LG.\u001a3!Kb\u0004H.\u00198bi&|g\u000eI1oI\u0002*\u00070Y7qY\u0016\u001chF\u0003\u0011!\u0003%\t'oZ;nK:$8/\t\u0002\u0002j\u0005!\tF\u0003\u0011!A\u0001\n%oZ;nK:$8O\u000f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!i&lWmX2pYVlg\u000eI\u0017!)\",\u0007eY8mk6t\u0007e\u001c:!i\",\u0007%\u001a=qe\u0016\u001c8/[8oAQ|\u0007%^:fA\u0005\u001c\b\u0005\u001e5fAQLW.Z:uC6\u0004\bEZ8sA]Lg\u000eZ8xS:<\u0007EY=!i&lWM\f\u0011UQ\u0016\u0004C/[7fA\r|G.^7oA5,8\u000f\u001e\u0011cK\u0002zg\r\t+j[\u0016\u001cH/Y7q)f\u0004XM\f\u0006!A\u0001\u0002\u0003\u0005\t\u0016!O\u0006\u0004x\fZ;sCRLwN\u001c\u0011.A\u0005\u00033\u000f\u001e:j]\u001e\u00043\u000f]3dS\u001aL\u0018N\\4!i\",\u0007\u0005^5nK>,H\u000fI8gAQDW\rI:fgNLwN\u001c\u0011sKB\u0014Xm]3oi\u0016$\u0007%Y:!E%tG/\u001a:wC2\u0004c/\u00197vK\nR\u0001\u0005\t\u0011!A\u0001\u0002\u0003\u0005K*fK\u0002b\u0014\r\t5sK\u001al$\u0005\u001b;uaNTtfL:qCJ\\g&\u00199bG\",gf\u001c:h_\u0011|7m]\u0018mCR,7\u000f^\u0018tc2l#/\u001a4.Y&$XM]1mg:BG/\u001c7$S:$XM\u001d<bY6b\u0017\u000e^3sC2\u0014c(\u00138uKJ4\u0018\r\u001c\u0011MSR,'/\u00197=_\u0005t\u0004EZ8sA5|'/\u001a\u0011eKR\f\u0017\u000e\\:/S\u00012wN\u001d\u0011uQ\u0016\u0004c-\u001b=fI\u0002:\u0017\r\u001d\u0011ekJ\fG/[8oY\u0001z'O\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011b]\u0002*\u0007\u0010\u001d:fgNLwN\u001c\u0011xQ&\u001c\u0007\u000eI5tA\u0005\u0004\b\u000f\\5fI\u00022wN\u001d\u0011fC\u000eD\u0007%\u001b8qkR\u0004\u0013M\u001c3!KZ\fG.^1uK\u0012\u0004Co\u001c\u0011uQ\u0016\u0004#%\u001b8uKJ4\u0018\r\u001c\u0011wC2,XM\t\u0011g_J\u0004C\u000f[3!Ift\u0017-\\5dA\u001d\f\u0007\u000f\t3ve\u0006$\u0018n\u001c8/\u0015\u0001\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005=\u0014\u0001c\u000e\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA\u0005d\u0003e]3tg&|gnX<j]\u0012|wOL:uCJ$H\u0006I:fgNLwN\\0xS:$wn\u001e\u0018f]\u0012d\u0003eY8v]RD#&\u000b\u0011bg\u0002\u001ag\u000e\u001e\u0011G%>k\u0005EV!M+\u0016\u001b\u0006\u0005K\u0014Bc\u001db\u0003e\n\u001a1eEj\u0003'M\u00171c\u0001\u0002\u0004G\u000f\u00191uA\u0002t%\u000b\u0017!Q\u001d\n\u0015g\n\u0017!OI\u0002$'M\u00171c5\u0002\u0014\u0007\t\u00191uA\"$h\r\u0019(S1\u0002\u0003fJ!2O1\u0002sE\r\u00193c5\u0002\u0014'\f\u00192AA\u0002$(\r\u0019;aA:\u0013\u0006\f\u0011)O\u0005\u0013t\u0005\f\u0011(eA\u0012\u0014'\f\u00192[A\n\u0004\u0005\r\u0019;aER\u0004\u0007M\u0014*A\u0005\u001b\u0006\u0005^1cQ\u0005d\u0003EY\u0015!\u000fJ{U\u000b\u0015\u0011cs\u0002\nG\u0006I0G+:\u001bu\f\u000b2-A\u001d*\u0004%\\5okR,7oJ\u0015!\u001fJ#UI\u0015\u0011C3\u0002\nG\u0006I:uCJ$8H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011Bc%\u0011\u0004GM\u0019.aEj\u0003'\r\u00111ai\u0002\u0004G\u000f\u00191\u0013I\u0002$'M\u00171c5\u0002\u0014\u0007\t\u00191uAJ$h\r\u0019\ne)\u0001\u0003\u0005\t\u0011!A\u0001\u0002\u0013)M\u00053aI\nT\u0006M\u0019.aE\u0002\u0003\u0007\r\u001e2ai\u0002\u0004'\u0003\u001a1eEj\u0003'M\u00171c\u0001\u0002\u0004GO\u00196uA\u0002\u0014\"\r\u0006!A\u0001\u0002\u0003\u0005\t\u0011!\u0003JJ!\u0007\r\u001a2[A\nT\u0006M\u0019!aAR\u0004'\r\u001e1a%\u0011\u0004GM\u0019.aEj\u0003'\r\u00111ai\u0002dG\u000f\u00191\u0013ER\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006%\u0019\u0017!g\u0016\u001c8/[8o?^Lg\u000eZ8x]M$\u0018M\u001d;-AM,7o]5p]~;\u0018N\u001c3po:*g\u000e\u001a\u0017!G>,h\u000e\u001e\u0015+S\u0001\n7\u000fI2oi\u00022%kT'!-\u0006cU+R*!Q\u001d\n\u0015g\n\u0017!OI\u0002$'M\u00171c5\u0002\u0014\u0007\t\u00191uA\u0002$\b\r\u0019(S1\u0002\u0003fJ!2O1\u0002sE\r\u00193c5\u0002\u0014'\f\u00192AA\u0002$\b\r\u001b;gA:\u0013\u0006\f\u0011)O\u0005\u000bt\u0005\f\u0011(eA\u0012\u0014'\f\u00192[A\n\u0004\u0005\r\u0019;cAR\u0004\u0007M\u0014*Y\u0001Bs%\u0011\u001a(Y\u0001:#\u0007\r\u001a2[A\nT\u0006M\u0019!aAR\u0004'\r\u001e1a\u001dJC\u0006\t\u0015(\u0003J:C\u0006I\u00143aI\nT\u0006M\u0019.aE\u0002\u0003\u0007\r\u001e1ii\u001a\u0004gJ\u0015!\u0003N\u0003C/\u00192)C2\u0002#-\u000b\u0011H%>+\u0006\u000b\t2zA\u0005d\u0003e\u0018$V\u001d\u000e{\u0006F\u0019\u0017!\u0007\u0006\u001bV\tI,I\u000b:\u0003\u0013\rI\u001f!O\u0005\u000bt\u0005\t+I\u000b:\u0003s%\u000e\u0011nS:,H/Z:(A]CUI\u0014\u0011bAu\u0002s%\u0011\u001a(AQCUI\u0014\u0011(c\u0001j\u0017N\\;uK\u001e\u0002S\tT*FA\u001d\n\u0004\u0007I7j]V$Xm]\u0014!\u000b:#\u0015\u0006I(S\t\u0016\u0013\u0006EQ-!C2\u00023\u000f^1sinR\u0001\u0005\t\u0011!A\u0001\u0002\u0003%Q\u0019\neA\u0012\u0014'\f\u00192[A\n\u0004\u0005\r\u0019;aAR\u0004\u0007M\u00053aI\nT\u0006M\u0019.aE\u0002\u0003\u0007\r\u001e1si\u001a\u0004'\u0003\u001a\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0005\u000b\u0014B\r\u00193c5\u0002\u0014'\f\u00192AA\u0002$(\r\u0019;aAJ!\u0007\r\u001a2[A\nT\u0006M\u0019!aAR\u0014'\u000e\u001e1a%\t$\u0002\t\u0011!A\u0001\u0002\u0003\u0005I!3\u0013I\u0002$'M\u00171c5\u0002\u0014\u0007\t\u00191uA\n$\b\r\u0019\neA\u0012\u0014'\f\u00192[A\n\u0004\u0005\r\u0019;aIR\u0004\u0007M\u00052\u0015\u0001\u0002\u0003\u0005\t\u0011!A\u0001\n%'\u0003\u001a1eEj\u0003'M\u00171c\u0001\u0002\u0004G\u000f\u00195uM\u0002\u0014B\r\u00193c5\u0002\u0014'\f\u00192AA\u0002$\bM\u001b;gAJ\u0011G\u0003\u0011!\u0003\u00159'o\\;qC\t\t)(\u0001\beCR,G/[7f?\u001a,hnY:\u0002\u000bMLgnY3\"\u0005\u0005m\u0014!B\u001a/e9\u0002\u0014!D*fgNLwN\\,j]\u0012|w\u000f\u0005\u0002/-M!a#a!A!\rY\u0014QQ\u0005\u0004\u0003\u000fc$AB!osJ+g\r\u0006\u0002\u0002\u0000\u00051Q.\u0019:lKJ\fq!\\1sW\u0016\u0014\b%A\u0003baBd\u0017\u0010F\u0003K\u0003'\u000b)\nC\u0003D5\u0001\u0007Q\u0006\u0003\u0004G5\u0001\u0007\u0011q\u0013\t\u0005\u00033\u000b\tK\u0004\u0003\u0002\u001c\u0006u\u0005C\u0001*=\u0013\r\ty\nP\u0001\u0007!J,G-\u001a4\n\t\u0005\u0005\u00121\u0015\u0006\u0004\u0003?cD#\u0002&\u0002(\u0006%\u0006\"B\"\u001c\u0001\u0004i\u0003\"\u0002$\u001c\u0001\u0004i\u0013aB;oCB\u0004H.\u001f\u000b\u0005\u0003_\u000bY\fE\u0003<\u0003c\u000b),C\u0002\u00024r\u0012aa\u00149uS>t\u0007#B\u001e\u000286j\u0013bAA]y\t1A+\u001e9mKJB\u0001\"!0\u001d\u0003\u0003\u0005\rAS\u0001\u0004q\u0012\u0002\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a1\u0011\t\u0005U\u0011QY\u0005\u0005\u0003\u000f\f9B\u0001\u0004PE*,7\r\u001e")
public class SessionWindow
extends Expression
implements ImplicitCastInputTypes,
Unevaluable,
NonSQLExpression,
Serializable {
    private boolean resolved;
    private final Expression timeColumn;
    private final Expression gapDuration;
    private volatile boolean bitmap$0;

    public static Option<Tuple2<Expression, Expression>> unapply(SessionWindow sessionWindow) {
        return SessionWindow$.MODULE$.unapply(sessionWindow);
    }

    public static String marker() {
        return SessionWindow$.MODULE$.marker();
    }

    @Override
    public final String sql() {
        return NonSQLExpression.sql$(this);
    }

    @Override
    public final boolean foldable() {
        return Unevaluable.foldable$(this);
    }

    @Override
    public final Object eval(InternalRow input) {
        return Unevaluable.eval$(this, input);
    }

    @Override
    public final InternalRow eval$default$1() {
        return Unevaluable.eval$default$1$(this);
    }

    @Override
    public final ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return Unevaluable.doGenCode$(this, ctx, ev);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    public Expression timeColumn() {
        return this.timeColumn;
    }

    public Expression gapDuration() {
        return this.gapDuration;
    }

    @Override
    public Seq<Expression> children() {
        return (Seq)new .colon.colon((Object)this.timeColumn(), (List)new .colon.colon((Object)this.gapDuration(), (List)Nil$.MODULE$));
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)new .colon.colon((Object)TimestampType$.MODULE$, (List)new .colon.colon((Object)AnyDataType$.MODULE$, (List)Nil$.MODULE$));
    }

    @Override
    public DataType dataType() {
        return new StructType().add(new StructField("start", TimestampType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())).add(new StructField("end", TimestampType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()));
    }

    private boolean resolved$lzycompute() {
        SessionWindow sessionWindow = this;
        synchronized (sessionWindow) {
            if (!this.bitmap$0) {
                this.resolved = false;
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return !this.bitmap$0 ? this.resolved$lzycompute() : this.resolved;
    }

    @Override
    public boolean nullable() {
        return false;
    }

    @Override
    public Expression withNewChildrenInternal(IndexedSeq<Expression> newChildren) {
        return this.copy((Expression)newChildren.apply(0), (Expression)newChildren.apply(1));
    }

    public SessionWindow copy(Expression timeColumn, Expression gapDuration) {
        return new SessionWindow(timeColumn, gapDuration);
    }

    public Expression copy$default$1() {
        return this.timeColumn();
    }

    public Expression copy$default$2() {
        return this.gapDuration();
    }

    @Override
    public String productPrefix() {
        return "SessionWindow";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Expression expression;
        int n = x$1;
        switch (n) {
            case 0: {
                expression = this.timeColumn();
                break;
            }
            case 1: {
                expression = this.gapDuration();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return expression;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof SessionWindow;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof SessionWindow)) return false;
        boolean bl = true;
        if (!bl) return false;
        SessionWindow sessionWindow = (SessionWindow)x$1;
        Expression expression = this.timeColumn();
        Expression expression2 = sessionWindow.timeColumn();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        Expression expression3 = this.gapDuration();
        Expression expression4 = sessionWindow.gapDuration();
        if (expression3 == null) {
            if (expression4 != null) {
                return false;
            }
        } else if (!expression3.equals(expression4)) return false;
        if (!sessionWindow.canEqual(this)) return false;
        return true;
    }

    public SessionWindow(Expression timeColumn, Expression gapDuration) {
        this.timeColumn = timeColumn;
        this.gapDuration = gapDuration;
        ExpectsInputTypes.$init$(this);
        Unevaluable.$init$(this);
        NonSQLExpression.$init$(this);
    }
}

