/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.util;

import java.time.ZoneId;
import java.util.Locale;
import org.apache.spark.sql.catalyst.util.DateFormatter;
import org.apache.spark.sql.catalyst.util.Iso8601DateFormatter;
import org.apache.spark.sql.catalyst.util.LegacyDateFormats$;
import org.apache.spark.sql.catalyst.util.LegacyDateFormatter;
import org.apache.spark.sql.catalyst.util.LegacyFastDateFormatter;
import org.apache.spark.sql.catalyst.util.LegacySimpleDateFormatter;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.internal.SQLConf$LegacyBehaviorPolicy$;
import scala.Enumeration;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;

public final class DateFormatter$
implements Serializable {
    public static DateFormatter$ MODULE$;
    private final Locale defaultLocale;
    private final String defaultPattern;

    static {
        new DateFormatter$();
    }

    public Locale defaultLocale() {
        return this.defaultLocale;
    }

    public String defaultPattern() {
        return this.defaultPattern;
    }

    private DateFormatter getFormatter(Option<String> format, ZoneId zoneId, Locale locale, Enumeration.Value legacyFormat, boolean isParsing) {
        DateFormatter dateFormatter;
        String pattern = (String)format.getOrElse((Function0 & java.io.Serializable & Serializable)() -> MODULE$.defaultPattern());
        Enumeration.Value value = SQLConf$.MODULE$.get().legacyTimeParserPolicy();
        Enumeration.Value value2 = SQLConf$LegacyBehaviorPolicy$.MODULE$.LEGACY();
        if (!(value != null ? !value.equals(value2) : value2 != null)) {
            dateFormatter = this.getLegacyFormatter(pattern, zoneId, locale, legacyFormat);
        } else {
            Iso8601DateFormatter df = new Iso8601DateFormatter(pattern, zoneId, locale, legacyFormat, isParsing);
            df.validatePatternString();
            dateFormatter = df;
        }
        return dateFormatter;
    }

    private Locale getFormatter$default$3() {
        return this.defaultLocale();
    }

    private Enumeration.Value getFormatter$default$4() {
        return LegacyDateFormats$.MODULE$.LENIENT_SIMPLE_DATE_FORMAT();
    }

    public DateFormatter getLegacyFormatter(String pattern, ZoneId zoneId, Locale locale, Enumeration.Value legacyFormat) {
        LegacyDateFormatter legacyDateFormatter;
        Enumeration.Value value = legacyFormat;
        Enumeration.Value value2 = LegacyDateFormats$.MODULE$.FAST_DATE_FORMAT();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            legacyDateFormatter = new LegacyFastDateFormatter(pattern, locale);
        } else {
            boolean bl;
            Enumeration.Value value4 = LegacyDateFormats$.MODULE$.SIMPLE_DATE_FORMAT();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                bl = true;
            } else {
                Enumeration.Value value6 = LegacyDateFormats$.MODULE$.LENIENT_SIMPLE_DATE_FORMAT();
                Enumeration.Value value7 = value;
                bl = !(value6 != null ? !value6.equals(value7) : value7 != null);
            }
            if (bl) {
                legacyDateFormatter = new LegacySimpleDateFormatter(pattern, locale);
            } else {
                throw new MatchError((Object)value);
            }
        }
        return legacyDateFormatter;
    }

    public DateFormatter apply(String format, ZoneId zoneId, Locale locale, Enumeration.Value legacyFormat, boolean isParsing) {
        return this.getFormatter((Option<String>)new Some((Object)format), zoneId, locale, legacyFormat, isParsing);
    }

    public DateFormatter apply(String format, ZoneId zoneId, boolean isParsing) {
        Some x$1 = new Some((Object)format);
        ZoneId x$2 = zoneId;
        boolean x$3 = isParsing;
        Locale x$4 = this.getFormatter$default$3();
        Enumeration.Value x$5 = this.getFormatter$default$4();
        return this.getFormatter((Option<String>)x$1, x$2, x$4, x$5, x$3);
    }

    public DateFormatter apply(ZoneId zoneId) {
        None$ x$1 = None$.MODULE$;
        ZoneId x$2 = zoneId;
        boolean x$3 = false;
        Locale x$4 = this.getFormatter$default$3();
        Enumeration.Value x$5 = this.getFormatter$default$4();
        return this.getFormatter((Option<String>)x$1, x$2, x$4, x$5, x$3);
    }

    public boolean apply$default$3() {
        return false;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private DateFormatter$() {
        MODULE$ = this;
        this.defaultLocale = Locale.US;
        this.defaultPattern = "yyyy-MM-dd";
    }
}

