/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.Hex$;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.expressions.package;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.TypeCollection;
import org.apache.spark.sql.types.TypeCollection$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="_FUNC_(expr) - Converts `expr` to hexadecimal.", examples="\n    Examples:\n      > SELECT _FUNC_(17);\n       11\n      > SELECT _FUNC_('Spark SQL');\n       537061726B2053514C\n  ", since="1.5.0")
@ScalaSignature(bytes="\u0006\u0001\u0005}w!B\u000f\u001f\u0011\u0003Yc!B\u0017\u001f\u0011\u0003q\u0003\"\u0002\u001d\u0002\t\u0003I\u0004b\u0002\u001e\u0002\u0005\u0004%\ta\u000f\u0005\u0007\u0005\u0006\u0001\u000b\u0011\u0002\u001f\t\u000f\r\u000b!\u0019!C\u0001w!1A)\u0001Q\u0001\nqBQ!R\u0001\u0005\u0002\u0019CQ!R\u0001\u0005\u0002ECQaV\u0001\u0005\u0002aCqAW\u0001\u0002\u0002\u0013\u00055\fC\u0005\u0002H\u0006\t\t\u0011\"!\u0002J\"I\u0011Q[\u0001\u0002\u0002\u0013%\u0011q\u001b\u0004\u0005[y\u0001U\f\u0003\u0005o\u001b\tU\r\u0011\"\u0001p\u0011!\u0019XB!E!\u0002\u0013\u0001\b\"\u0002\u001d\u000e\t\u0003!\b\"\u0002<\u000e\t\u0003:\bbBA\t\u001b\u0011\u0005\u00131\u0003\u0005\b\u00037iA\u0011KA\u000f\u0011\u001d\t9#\u0004C)\u0003SA\u0011\"!\u0012\u000e\u0003\u0003%\t!a\u0012\t\u0013\u0005-S\"%A\u0005\u0002\u00055\u0003\"CA2\u001b\u0005\u0005I\u0011IA3\u0011%\t9(DA\u0001\n\u0003\tI\bC\u0005\u0002\u00026\t\t\u0011\"\u0001\u0002\u0004\"I\u0011\u0011R\u0007\u0002\u0002\u0013\u0005\u00131\u0012\u0005\n\u00033k\u0011\u0011!C\u0001\u00037C\u0011\"!*\u000e\u0003\u0003%\t%a*\u0002\u0007!+\u0007P\u0003\u0002 A\u0005YQ\r\u001f9sKN\u001c\u0018n\u001c8t\u0015\t\t#%\u0001\u0005dCR\fG._:u\u0015\t\u0019C%A\u0002tc2T!!\n\u0014\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u001dB\u0013AB1qC\u000eDWMC\u0001*\u0003\ry'oZ\u0002\u0001!\ta\u0013!D\u0001\u001f\u0005\rAU\r_\n\u0004\u0003=*\u0004C\u0001\u00194\u001b\u0005\t$\"\u0001\u001a\u0002\u000bM\u001c\u0017\r\\1\n\u0005Q\n$AB!osJ+g\r\u0005\u00021m%\u0011q'\r\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003-\n\u0011\u0002[3y\t&<\u0017\u000e^:\u0016\u0003q\u00022\u0001M\u001f@\u0013\tq\u0014GA\u0003BeJ\f\u0017\u0010\u0005\u00021\u0001&\u0011\u0011)\r\u0002\u0005\u0005f$X-\u0001\u0006iKb$\u0015nZ5ug\u0002\n1\"\u001e8iKb$\u0015nZ5ug\u0006aQO\u001c5fq\u0012Kw-\u001b;tA\u0005\u0019\u0001.\u001a=\u0015\u0005\u001d{\u0005C\u0001%N\u001b\u0005I%B\u0001&L\u0003\u0015!\u0018\u0010]3t\u0015\taE%\u0001\u0004v]N\fg-Z\u0005\u0003\u001d&\u0013!\"\u0016+GqM#(/\u001b8h\u0011\u0015\u0001v\u00011\u0001=\u0003\u0015\u0011\u0017\u0010^3t)\t9%\u000bC\u0003T\u0011\u0001\u0007A+A\u0002ok6\u0004\"\u0001M+\n\u0005Y\u000b$\u0001\u0002'p]\u001e\fQ!\u001e8iKb$\"\u0001P-\t\u000bAK\u0001\u0019\u0001\u001f\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0007q\u000b)\r\u0005\u0002-\u001bM1QBX1eWV\u0002\"\u0001L0\n\u0005\u0001t\"aD+oCJLX\t\u001f9sKN\u001c\u0018n\u001c8\u0011\u00051\u0012\u0017BA2\u001f\u0005YIU\u000e\u001d7jG&$8)Y:u\u0013:\u0004X\u000f\u001e+za\u0016\u001c\bCA3i\u001d\tac-\u0003\u0002h=\u00059\u0001/Y2lC\u001e,\u0017BA5k\u00059qU\u000f\u001c7J]R|G.\u001a:b]RT!a\u001a\u0010\u0011\u0005Ab\u0017BA72\u0005\u001d\u0001&o\u001c3vGR\fQa\u00195jY\u0012,\u0012\u0001\u001d\t\u0003YEL!A\u001d\u0010\u0003\u0015\u0015C\bO]3tg&|g.\u0001\u0004dQ&dG\r\t\u000b\u00039VDQA\u001c\tA\u0002A\f!\"\u001b8qkR$\u0016\u0010]3t+\u0005A\b#B=\u0002\u0002\u0005\u001daB\u0001>\u0000\u001d\tYh0D\u0001}\u0015\ti(&\u0001\u0004=e>|GOP\u0005\u0002e%\u0011q-M\u0005\u0005\u0003\u0007\t)AA\u0002TKFT!aZ\u0019\u0011\t\u0005%\u0011QB\u0007\u0003\u0003\u0017Q!A\u0013\u0012\n\t\u0005=\u00111\u0002\u0002\u0011\u0003\n\u001cHO]1di\u0012\u000bG/\u0019+za\u0016\f\u0001\u0002Z1uCRK\b/Z\u000b\u0003\u0003+\u0001B!!\u0003\u0002\u0018%!\u0011\u0011DA\u0006\u0005!!\u0015\r^1UsB,\u0017\u0001\u00048vY2\u001c\u0016MZ3Fm\u0006dG\u0003BA\u0010\u0003K\u00012\u0001MA\u0011\u0013\r\t\u0019#\r\u0002\u0004\u0003:L\bBB*\u0014\u0001\u0004\ty\"A\u0005e_\u001e+gnQ8eKR1\u00111FA\u001c\u0003\u0003\u0002B!!\f\u000245\u0011\u0011q\u0006\u0006\u0004\u0003cq\u0012aB2pI\u0016<WM\\\u0005\u0005\u0003k\tyC\u0001\u0005FqB\u00148i\u001c3f\u0011\u001d\tI\u0004\u0006a\u0001\u0003w\t1a\u0019;y!\u0011\ti#!\u0010\n\t\u0005}\u0012q\u0006\u0002\u000f\u0007>$WmZ3o\u0007>tG/\u001a=u\u0011\u001d\t\u0019\u0005\u0006a\u0001\u0003W\t!!\u001a<\u0002\t\r|\u0007/\u001f\u000b\u00049\u0006%\u0003b\u00028\u0016!\u0003\u0005\r\u0001]\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\tyEK\u0002q\u0003#Z#!a\u0015\u0011\t\u0005U\u0013qL\u0007\u0003\u0003/RA!!\u0017\u0002\\\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003;\n\u0014AC1o]>$\u0018\r^5p]&!\u0011\u0011MA,\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005\u001d\u0004\u0003BA5\u0003gj!!a\u001b\u000b\t\u00055\u0014qN\u0001\u0005Y\u0006twM\u0003\u0002\u0002r\u0005!!.\u0019<b\u0013\u0011\t)(a\u001b\u0003\rM#(/\u001b8h\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\t\tY\bE\u00021\u0003{J1!a 2\u0005\rIe\u000e^\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\ty\"!\"\t\u0013\u0005\u001d\u0015$!AA\u0002\u0005m\u0014a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002\u000eB1\u0011qRAK\u0003?i!!!%\u000b\u0007\u0005M\u0015'\u0001\u0006d_2dWm\u0019;j_:LA!a&\u0002\u0012\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\ti*a)\u0011\u0007A\ny*C\u0002\u0002\"F\u0012qAQ8pY\u0016\fg\u000eC\u0005\u0002\bn\t\t\u00111\u0001\u0002 \u00051Q-];bYN$B!!(\u0002*\"I\u0011q\u0011\u000f\u0002\u0002\u0003\u0007\u0011q\u0004\u0015\u0010\u001b\u00055\u00161WA[\u0003s\u000bY,a0\u0002BB\u0019A&a,\n\u0007\u0005EfDA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005]\u0016AL0G+:\u001bu\fK3yaJL\u0003%\f\u0011D_:4XM\u001d;tA\u0001,\u0007\u0010\u001d:aAQ|\u0007\u0005[3yC\u0012,7-[7bY:\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003{\u000bAO\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u00152o%Z$\u0002\t\u0011!A\u0001\u0002\u0003%M\u0019\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`Q\u001d\u001a\u0006/\u0019:lAM\u000bFjJ\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AU\u001at\u0007\r\u001c2oI2$I\r\u00196gU\nDg\u0011\u0006!A\u0005)1/\u001b8dK\u0006\u0012\u00111Y\u0001\u0006c9*d\u0006\r\u0005\u0006]*\u0001\r\u0001]\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\tY-!5\u0011\tA\ni\r]\u0005\u0004\u0003\u001f\f$AB(qi&|g\u000e\u0003\u0005\u0002T.\t\t\u00111\u0001]\u0003\rAH\u0005M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002ZB!\u0011\u0011NAn\u0013\u0011\ti.a\u001b\u0003\r=\u0013'.Z2u\u0001")
public class Hex
extends UnaryExpression
implements ImplicitCastInputTypes,
package.NullIntolerant,
scala.Serializable {
    private final Expression child;

    public static Option<Expression> unapply(Hex hex) {
        return Hex$.MODULE$.unapply(hex);
    }

    public static byte[] unhex(byte[] byArray) {
        return Hex$.MODULE$.unhex(byArray);
    }

    public static UTF8String hex(long l) {
        return Hex$.MODULE$.hex(l);
    }

    public static UTF8String hex(byte[] byArray) {
        return Hex$.MODULE$.hex(byArray);
    }

    public static byte[] unhexDigits() {
        return Hex$.MODULE$.unhexDigits();
    }

    public static byte[] hexDigits() {
        return Hex$.MODULE$.hexDigits();
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TypeCollection[]{TypeCollection$.MODULE$.apply((Seq<AbstractDataType>)Predef$.MODULE$.wrapRefArray((Object[])new AbstractDataType[]{LongType$.MODULE$, BinaryType$.MODULE$, StringType$.MODULE$}))}));
    }

    @Override
    public DataType dataType() {
        return StringType$.MODULE$;
    }

    @Override
    public Object nullSafeEval(Object num) {
        UTF8String uTF8String;
        DataType dataType = this.child().dataType();
        if (LongType$.MODULE$.equals(dataType)) {
            uTF8String = Hex$.MODULE$.hex(BoxesRunTime.unboxToLong((Object)num));
        } else if (BinaryType$.MODULE$.equals(dataType)) {
            uTF8String = Hex$.MODULE$.hex((byte[])num);
        } else if (StringType$.MODULE$.equals(dataType)) {
            uTF8String = Hex$.MODULE$.hex(((UTF8String)num).getBytes());
        } else {
            throw new MatchError((Object)dataType);
        }
        return uTF8String;
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable & scala.Serializable)c -> {
            String hex = new StringOps(Predef$.MODULE$.augmentString(Hex$.MODULE$.getClass().getName())).stripSuffix("$");
            DataType dataType = this.child().dataType();
            String string = StringType$.MODULE$.equals(dataType) ? new StringBuilder(18).append(hex).append(".hex(").append((String)c).append(".getBytes());").toString() : new StringBuilder(7).append(hex).append(".hex(").append((String)c).append(");").toString();
            return new StringBuilder(3).append(ev.value()).append(" = ").append((Object)string).toString();
        });
    }

    public Hex copy(Expression child) {
        return new Hex(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "Hex";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.child();
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Hex;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Hex)) return false;
        boolean bl = true;
        if (!bl) return false;
        Hex hex = (Hex)x$1;
        Expression expression = this.child();
        Expression expression2 = hex.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!hex.canEqual(this)) return false;
        return true;
    }

    public Hex(Expression child) {
        this.child = child;
        ExpectsInputTypes.$init$(this);
    }
}

