/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution;

import java.io.IOException;
import java.util.function.Supplier;
import org.apache.spark.SparkEnv;
import org.apache.spark.TaskContext;
import org.apache.spark.internal.config.package$;
import org.apache.spark.memory.TaskMemoryManager;
import org.apache.spark.serializer.SerializerManager;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.storage.BlockManager;
import org.apache.spark.unsafe.Platform;
import org.apache.spark.util.collection.unsafe.sort.PrefixComparator;
import org.apache.spark.util.collection.unsafe.sort.RecordComparator;
import org.apache.spark.util.collection.unsafe.sort.UnsafeExternalSorter;
import org.apache.spark.util.collection.unsafe.sort.UnsafeSorterIterator;
import org.spark_project.guava.annotations.VisibleForTesting;
import scala.collection.AbstractIterator;
import scala.collection.Iterator;
import scala.math.Ordering;

public final class UnsafeExternalRowSorter {
    static final int DEFAULT_INITIAL_SORT_BUFFER_SIZE = 4096;
    private int testSpillFrequency = 0;
    private long numRowsInserted = 0L;
    private final StructType schema;
    private final PrefixComputer prefixComputer;
    private final UnsafeExternalSorter sorter;

    public static UnsafeExternalRowSorter createWithRecordComparator(StructType schema, Supplier<RecordComparator> recordComparatorSupplier, PrefixComparator prefixComparator, PrefixComputer prefixComputer, long pageSizeBytes, boolean canUseRadixSort) throws IOException {
        return new UnsafeExternalRowSorter(schema, recordComparatorSupplier, prefixComparator, prefixComputer, pageSizeBytes, canUseRadixSort);
    }

    public static UnsafeExternalRowSorter create(StructType schema, Ordering<InternalRow> ordering, PrefixComparator prefixComparator, PrefixComputer prefixComputer, long pageSizeBytes, boolean canUseRadixSort) throws IOException {
        Supplier<RecordComparator> recordComparatorSupplier = () -> new RowComparator(ordering, schema.length());
        return new UnsafeExternalRowSorter(schema, recordComparatorSupplier, prefixComparator, prefixComputer, pageSizeBytes, canUseRadixSort);
    }

    private UnsafeExternalRowSorter(StructType schema, Supplier<RecordComparator> recordComparatorSupplier, PrefixComparator prefixComparator, PrefixComputer prefixComputer, long pageSizeBytes, boolean canUseRadixSort) throws IOException {
        this.schema = schema;
        this.prefixComputer = prefixComputer;
        SparkEnv sparkEnv = SparkEnv.get();
        TaskContext taskContext = TaskContext.get();
        this.sorter = UnsafeExternalSorter.create((TaskMemoryManager)taskContext.taskMemoryManager(), (BlockManager)sparkEnv.blockManager(), (SerializerManager)sparkEnv.serializerManager(), (TaskContext)taskContext, recordComparatorSupplier, (PrefixComparator)prefixComparator, (int)sparkEnv.conf().getInt("spark.shuffle.sort.initialBufferSize", 4096), (long)pageSizeBytes, (int)((Integer)SparkEnv.get().conf().get(package$.MODULE$.SHUFFLE_SPILL_NUM_ELEMENTS_FORCE_SPILL_THRESHOLD())), (boolean)canUseRadixSort);
    }

    @VisibleForTesting
    void setTestSpillFrequency(int frequency) {
        assert (frequency > 0) : "Frequency must be positive";
        this.testSpillFrequency = frequency;
    }

    public void insertRow(UnsafeRow row) throws IOException {
        PrefixComputer.Prefix prefix = this.prefixComputer.computePrefix(row);
        this.sorter.insertRecord(row.getBaseObject(), row.getBaseOffset(), row.getSizeInBytes(), prefix.value, prefix.isNull);
        ++this.numRowsInserted;
        if (this.testSpillFrequency > 0 && this.numRowsInserted % (long)this.testSpillFrequency == 0L) {
            this.sorter.spill();
        }
    }

    public long getPeakMemoryUsage() {
        return this.sorter.getPeakMemoryUsedBytes();
    }

    public long getSortTimeNanos() {
        return this.sorter.getSortTimeNanos();
    }

    private void cleanupResources() {
        this.sorter.cleanupResources();
    }

    public Iterator<UnsafeRow> sort() throws IOException {
        try {
            final UnsafeSorterIterator sortedIterator = this.sorter.getSortedIterator();
            if (!sortedIterator.hasNext()) {
                this.cleanupResources();
            }
            return new AbstractIterator<UnsafeRow>(){
                private final int numFields;
                private UnsafeRow row;
                {
                    this.numFields = UnsafeExternalRowSorter.this.schema.length();
                    this.row = new UnsafeRow(this.numFields);
                }

                public boolean hasNext() {
                    return sortedIterator.hasNext();
                }

                public UnsafeRow next() {
                    try {
                        sortedIterator.loadNext();
                        this.row.pointTo(sortedIterator.getBaseObject(), sortedIterator.getBaseOffset(), sortedIterator.getRecordLength());
                        if (!this.hasNext()) {
                            UnsafeRow copy2 = this.row.copy();
                            this.row = null;
                            UnsafeExternalRowSorter.this.cleanupResources();
                            return copy2;
                        }
                        return this.row;
                    }
                    catch (IOException e) {
                        UnsafeExternalRowSorter.this.cleanupResources();
                        Platform.throwException((Throwable)e);
                        throw new RuntimeException("Exception should have been re-thrown in next()");
                    }
                }
            };
        }
        catch (IOException e) {
            this.cleanupResources();
            throw e;
        }
    }

    public Iterator<UnsafeRow> sort(Iterator<UnsafeRow> inputIterator) throws IOException {
        while (inputIterator.hasNext()) {
            this.insertRow((UnsafeRow)inputIterator.next());
        }
        return this.sort();
    }

    private static final class RowComparator
    extends RecordComparator {
        private final Ordering<InternalRow> ordering;
        private final UnsafeRow row1;
        private final UnsafeRow row2;

        RowComparator(Ordering<InternalRow> ordering, int numFields) {
            this.row1 = new UnsafeRow(numFields);
            this.row2 = new UnsafeRow(numFields);
            this.ordering = ordering;
        }

        public int compare(Object baseObj1, long baseOff1, int baseLen1, Object baseObj2, long baseOff2, int baseLen2) {
            this.row1.pointTo(baseObj1, baseOff1, 0);
            this.row2.pointTo(baseObj2, baseOff2, 0);
            return this.ordering.compare((Object)this.row1, (Object)this.row2);
        }
    }

    public static abstract class PrefixComputer {
        public abstract Prefix computePrefix(InternalRow var1);

        public static class Prefix {
            public long value;
            public boolean isNull;
        }
    }
}

