/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import org.apache.solr.analytics.function.mapping.ComparisonFunction;
import org.apache.solr.analytics.util.function.BooleanConsumer;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.analytics.value.BooleanValueStream;
import org.apache.solr.analytics.value.DoubleValue;
import org.apache.solr.analytics.value.DoubleValueStream;
import org.apache.solr.common.SolrException;

class CompareDoubleStreamFunction
extends BooleanValueStream.AbstractBooleanValueStream {
    private final DoubleValue baseExpr;
    private final DoubleValueStream compExpr;
    private final ComparisonFunction.CompResultFunction comp;
    private final String name;
    private final String funcStr;
    private final AnalyticsValueStream.ExpressionType funcType;

    public CompareDoubleStreamFunction(String name, DoubleValue baseExpr, DoubleValueStream compExpr, ComparisonFunction.CompResultFunction comp) throws SolrException {
        this.name = name;
        this.baseExpr = baseExpr;
        this.compExpr = compExpr;
        this.comp = comp;
        this.funcStr = AnalyticsValueStream.createExpressionString(name, baseExpr, compExpr);
        this.funcType = AnalyticsValueStream.determineMappingPhase(this.funcStr, baseExpr, compExpr);
    }

    @Override
    public void streamBooleans(BooleanConsumer cons) {
        double baseValue = this.baseExpr.getDouble();
        if (this.baseExpr.exists()) {
            this.compExpr.streamDoubles(compValue -> cons.accept(this.comp.apply(Double.compare(baseValue, compValue))));
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getExpressionStr() {
        return this.funcStr;
    }

    @Override
    public AnalyticsValueStream.ExpressionType getExpressionType() {
        return this.funcType;
    }
}

