/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.util.valuesource;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.docvalues.StrDocValues;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.mutable.MutableValue;
import org.apache.lucene.util.mutable.MutableValueStr;

public abstract class SingleStringFunction
extends ValueSource {
    protected final ValueSource source;

    public SingleStringFunction(ValueSource source) {
        this.source = source;
    }

    public String description() {
        return this.name() + "(" + this.source.description() + ")";
    }

    abstract String name();

    abstract CharSequence func(int var1, FunctionValues var2);

    public FunctionValues getValues(Map context, LeafReaderContext readerContext) throws IOException {
        final FunctionValues vals = this.source.getValues(context, readerContext);
        return new StrDocValues(this){

            public String strVal(int doc) {
                CharSequence cs = SingleStringFunction.this.func(doc, vals);
                return cs != null ? cs.toString() : null;
            }

            public boolean bytesVal(int doc, BytesRefBuilder bytes) {
                CharSequence cs = SingleStringFunction.this.func(doc, vals);
                if (cs != null) {
                    bytes.copyChars(SingleStringFunction.this.func(doc, vals));
                    return true;
                }
                bytes.clear();
                return false;
            }

            public Object objectVal(int doc) {
                return this.strVal(doc);
            }

            public boolean exists(int doc) {
                return vals.exists(doc);
            }

            public String toString(int doc) {
                return SingleStringFunction.this.name() + '(' + this.strVal(doc) + ')';
            }

            public FunctionValues.ValueFiller getValueFiller() {
                return new FunctionValues.ValueFiller(){
                    private final MutableValueStr mval = new MutableValueStr();

                    public MutableValue getValue() {
                        return this.mval;
                    }

                    public void fillValue(int doc) {
                        this.mval.exists = this.bytesVal(doc, this.mval.value);
                    }
                };
            }
        };
    }

    public boolean equals(Object o) {
        if (((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        SingleStringFunction other = (SingleStringFunction)((Object)o);
        return this.source.equals((Object)other.source);
    }

    public int hashCode() {
        return this.source.hashCode() + this.name().hashCode();
    }
}

