/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.util.valuesource;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.docvalues.LongDocValues;
import org.apache.lucene.util.mutable.MutableValue;
import org.apache.lucene.util.mutable.MutableValueDate;

public abstract class MultiDateFunction
extends ValueSource {
    protected final ValueSource[] sources;

    public MultiDateFunction(ValueSource[] sources) {
        this.sources = sources;
    }

    protected abstract String name();

    protected abstract long func(int var1, FunctionValues[] var2);

    public String description() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name()).append('(');
        boolean firstTime = true;
        for (ValueSource source : this.sources) {
            if (firstTime) {
                firstTime = false;
            } else {
                sb.append(',');
            }
            sb.append(source);
        }
        sb.append(')');
        return sb.toString();
    }

    public FunctionValues getValues(Map context, LeafReaderContext readerContext) throws IOException {
        final FunctionValues[] valsArr = new FunctionValues[this.sources.length];
        for (int i = 0; i < this.sources.length; ++i) {
            valsArr[i] = this.sources[i].getValues(context, readerContext);
        }
        return new LongDocValues(this){

            public long longVal(int doc) {
                return MultiDateFunction.this.func(doc, valsArr);
            }

            public boolean exists(int doc) {
                boolean exists = true;
                for (FunctionValues val : valsArr) {
                    exists &= val.exists(doc);
                }
                return exists;
            }

            public String toString(int doc) {
                StringBuilder sb = new StringBuilder();
                sb.append(MultiDateFunction.this.name()).append('(');
                boolean firstTime = true;
                for (FunctionValues vals : valsArr) {
                    if (firstTime) {
                        firstTime = false;
                    } else {
                        sb.append(',');
                    }
                    sb.append(vals.toString(doc));
                }
                sb.append(')');
                return sb.toString();
            }

            public FunctionValues.ValueFiller getValueFiller() {
                return new FunctionValues.ValueFiller(){
                    private final MutableValueDate mval = new MutableValueDate();

                    public MutableValue getValue() {
                        return this.mval;
                    }

                    public void fillValue(int doc) {
                        this.mval.value = this.longVal(doc);
                        this.mval.exists = this.exists(doc);
                    }
                };
            }
        };
    }

    public boolean equals(Object o) {
        if (((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        MultiDateFunction other = (MultiDateFunction)((Object)o);
        return this.name().equals(other.name()) && Arrays.equals(this.sources, other.sources);
    }

    public int hashCode() {
        return Arrays.hashCode(this.sources) + this.name().hashCode();
    }
}

