/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.util.valuesource;

import java.io.IOException;
import java.time.Instant;
import java.util.Date;
import java.util.Map;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.docvalues.LongDocValues;
import org.apache.lucene.queries.function.valuesource.LongFieldSource;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.LegacyNumericUtils;
import org.apache.lucene.util.mutable.MutableValue;
import org.apache.lucene.util.mutable.MutableValueDate;

public class DateFieldSource
extends LongFieldSource {
    public DateFieldSource(String field) {
        super(field);
    }

    public long externalToLong(String extVal) {
        return LegacyNumericUtils.prefixCodedToLong((BytesRef)new BytesRef((CharSequence)extVal));
    }

    public Object longToObject(long val) {
        return new Date(val);
    }

    public String longToString(long val) {
        return Instant.ofEpochMilli(val).toString();
    }

    public FunctionValues getValues(Map context, LeafReaderContext readerContext) throws IOException {
        final NumericDocValues arr = DocValues.getNumeric((LeafReader)readerContext.reader(), (String)this.field);
        final Bits valid = DocValues.getDocsWithField((LeafReader)readerContext.reader(), (String)this.field);
        return new LongDocValues((ValueSource)this){

            public long longVal(int doc) {
                return arr.get(doc);
            }

            public boolean exists(int doc) {
                return valid.get(doc);
            }

            public Object objectVal(int doc) {
                return this.exists(doc) ? DateFieldSource.this.longToObject(arr.get(doc)) : null;
            }

            public String strVal(int doc) {
                return this.exists(doc) ? DateFieldSource.this.longToString(arr.get(doc)) : null;
            }

            public FunctionValues.ValueFiller getValueFiller() {
                return new FunctionValues.ValueFiller(){
                    private final MutableValueDate mval = new MutableValueDate();

                    public MutableValue getValue() {
                        return this.mval;
                    }

                    public void fillValue(int doc) {
                        this.mval.value = arr.get(doc);
                        this.mval.exists = this.exists(doc);
                    }
                };
            }
        };
    }

    public boolean equals(Object o) {
        if (o.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        DateFieldSource other = (DateFieldSource)((Object)o);
        return this.field.equals(other.field);
    }

    public int hashCode() {
        int h = ((Object)((Object)this)).getClass().hashCode();
        return h += super.hashCode();
    }
}

