/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.logging.java;

import org.owasp.esapi.Logger;
import org.owasp.esapi.logging.java.JavaLogBridge;

public class JavaLogger
implements Logger {
    private final java.util.logging.Logger delegate;
    private final JavaLogBridge logBridge;
    private int maxLogLevel;

    public JavaLogger(java.util.logging.Logger JavaLogger2, JavaLogBridge bridge, int defaultEsapiLevel) {
        this.delegate = JavaLogger2;
        this.logBridge = bridge;
        this.maxLogLevel = defaultEsapiLevel;
    }

    private void log(int esapiLevel, Logger.EventType type, String message) {
        if (this.isEnabled(esapiLevel)) {
            this.logBridge.log(this.delegate, esapiLevel, type, message);
        }
    }

    private void log(int esapiLevel, Logger.EventType type, String message, Throwable throwable) {
        if (this.isEnabled(esapiLevel)) {
            this.logBridge.log(this.delegate, esapiLevel, type, message, throwable);
        }
    }

    private boolean isEnabled(int esapiLevel) {
        return esapiLevel <= this.maxLogLevel && this.maxLogLevel != Integer.MAX_VALUE || this.maxLogLevel == Integer.MIN_VALUE;
    }

    @Override
    public void always(Logger.EventType type, String message) {
        this.log(Integer.MIN_VALUE, type, message);
    }

    @Override
    public void always(Logger.EventType type, String message, Throwable throwable) {
        this.log(Integer.MIN_VALUE, type, message, throwable);
    }

    @Override
    public void trace(Logger.EventType type, String message) {
        this.log(100, type, message);
    }

    @Override
    public void trace(Logger.EventType type, String message, Throwable throwable) {
        this.log(100, type, message, throwable);
    }

    @Override
    public void debug(Logger.EventType type, String message) {
        this.log(200, type, message);
    }

    @Override
    public void debug(Logger.EventType type, String message, Throwable throwable) {
        this.log(200, type, message, throwable);
    }

    @Override
    public void info(Logger.EventType type, String message) {
        this.log(400, type, message);
    }

    @Override
    public void info(Logger.EventType type, String message, Throwable throwable) {
        this.log(400, type, message, throwable);
    }

    @Override
    public void warning(Logger.EventType type, String message) {
        this.log(600, type, message);
    }

    @Override
    public void warning(Logger.EventType type, String message, Throwable throwable) {
        this.log(600, type, message, throwable);
    }

    @Override
    public void error(Logger.EventType type, String message) {
        this.log(800, type, message);
    }

    @Override
    public void error(Logger.EventType type, String message, Throwable throwable) {
        this.log(800, type, message, throwable);
    }

    @Override
    public void fatal(Logger.EventType type, String message) {
        this.log(1000, type, message);
    }

    @Override
    public void fatal(Logger.EventType type, String message, Throwable throwable) {
        this.log(1000, type, message, throwable);
    }

    @Override
    public int getESAPILevel() {
        return this.maxLogLevel;
    }

    @Override
    public boolean isTraceEnabled() {
        return this.isEnabled(100);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.isEnabled(200);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.isEnabled(400);
    }

    @Override
    public boolean isWarningEnabled() {
        return this.isEnabled(600);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.isEnabled(800);
    }

    @Override
    public boolean isFatalEnabled() {
        return this.isEnabled(1000);
    }

    @Override
    public void setLevel(int level) {
        this.maxLogLevel = level;
    }
}

