/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.esapi.logging.appender;

import javax.servlet.http.HttpServletRequest;
import org.owasp.esapi.ESAPI;

public class ServerInfoSupplier {
    private boolean logServerIP = true;
    private boolean logAppName = true;
    private String applicationName = "";
    private final String logName;

    public ServerInfoSupplier(String logName) {
        this.logName = logName;
    }

    public String get() {
        StringBuilder appInfo = new StringBuilder();
        HttpServletRequest request = ESAPI.currentRequest();
        if (request != null && this.logServerIP) {
            appInfo.append(request.getLocalAddr()).append(":").append(request.getLocalPort());
        }
        if (this.logAppName) {
            appInfo.append("/").append(this.applicationName);
        }
        appInfo.append("/").append(this.logName);
        return appInfo.toString();
    }

    public void setLogServerIp(boolean log) {
        this.logServerIP = log;
    }

    public void setLogApplicationName(boolean log, String appName) {
        this.logAppName = log;
        this.applicationName = appName;
    }
}

