/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.net;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import javax.jcr.Session;
import org.apache.jackrabbit.net.JCRJarURLHandler;

class FileParts {
    private final String repository;
    private final String workspace;
    private final String path;
    private final String entryPath;

    FileParts(Session session, String path, String entryPath) {
        this.repository = "_";
        this.workspace = session.getWorkspace().getName();
        this.path = path == null ? "/" : path;
        this.entryPath = entryPath;
    }

    FileParts(String file) {
        int slash0;
        int slash1;
        if (!file.startsWith("/")) {
            if (file.startsWith("jcr:")) {
                file = this.strip(file);
            } else {
                throw this.failure("Not an absolute file", file);
            }
        }
        if ((slash1 = file.indexOf(47, slash0 = 1)) < 0 || slash1 - slash0 == 0) {
            throw this.failure("Missing repository name", file);
        }
        this.repository = this.decode(file.substring(slash0, slash1));
        slash0 = slash1 + 1;
        if ((slash1 = file.indexOf(47, slash0)) < 0 || slash1 - slash0 == 0) {
            throw this.failure("Missing workspace name", file);
        }
        this.workspace = this.decode(file.substring(slash0, slash1));
        String fullPath = file.substring(slash1);
        int bangSlash = JCRJarURLHandler.indexOfBangSlash(fullPath);
        if (bangSlash < 0) {
            this.path = fullPath;
            this.entryPath = null;
        } else {
            this.path = fullPath.substring(0, bangSlash - 1);
            this.entryPath = fullPath.substring(bangSlash + 1);
        }
    }

    String getRepository() {
        return this.repository;
    }

    String getWorkspace() {
        return this.workspace;
    }

    String getPath() {
        return this.path;
    }

    String getEntryPath() {
        return this.entryPath;
    }

    public int hashCode() {
        return this.getRepository().hashCode() + 17 * this.getWorkspace().hashCode() + 33 * this.getPath().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof FileParts) {
            FileParts other = (FileParts)obj;
            if (this.getEntryPath() == null && other.getEntryPath() != null) {
                return false;
            }
            return this.getPath().equals(other.getPath()) && this.getWorkspace().equals(other.getWorkspace()) && this.getRepository().equals(other.getRepository()) && this.getEntryPath().equals(other.getEntryPath());
        }
        return false;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append('/').append(this.encode(this.getRepository()));
        buf.append('/').append(this.encode(this.getWorkspace()));
        buf.append(this.getPath());
        if (this.getEntryPath() != null) {
            buf.append("!/").append(this.getEntryPath());
        }
        return buf.toString();
    }

    private String strip(String file) {
        int start = 4;
        if (file.length() >= start + 2 && file.charAt(start) == '/' && file.charAt(start + 1) == '/' && (start = file.indexOf(47, start + 2)) < 0) {
            throw this.failure("Missing path after authority", file);
        }
        return file.substring(start);
    }

    private String encode(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalError("UTF-8 not supported");
        }
    }

    private String decode(String value) {
        try {
            return URLDecoder.decode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalError("UTF-8 not supported");
        }
    }

    private IllegalArgumentException failure(String reason, String file) {
        return new IllegalArgumentException(reason + ": '" + file + "'");
    }
}

