/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.security.AccessControlException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.SlingException;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.SlingServletException;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceNotFoundException;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.ServletResolver;
import org.apache.sling.api.wrappers.SlingHttpServletResponseWrapper;
import org.apache.sling.engine.SlingRequestProcessor;
import org.apache.sling.engine.impl.DefaultErrorHandler;
import org.apache.sling.engine.impl.RequestProcessorMBeanImpl;
import org.apache.sling.engine.impl.SlingHttpServletResponseImpl;
import org.apache.sling.engine.impl.console.RequestHistoryConsolePlugin;
import org.apache.sling.engine.impl.filter.AbstractSlingFilterChain;
import org.apache.sling.engine.impl.filter.FilterHandle;
import org.apache.sling.engine.impl.filter.RequestSlingFilterChain;
import org.apache.sling.engine.impl.filter.ServletFilterManager;
import org.apache.sling.engine.impl.filter.SlingComponentFilterChain;
import org.apache.sling.engine.impl.parameters.ParameterSupport;
import org.apache.sling.engine.impl.request.ContentData;
import org.apache.sling.engine.impl.request.RequestData;
import org.apache.sling.engine.servlets.ErrorHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SlingRequestProcessorImpl
implements SlingRequestProcessor {
    private final Logger log = LoggerFactory.getLogger(SlingRequestProcessorImpl.class);
    private final DefaultErrorHandler errorHandler = new DefaultErrorHandler();
    private volatile ServletResolver servletResolver;
    private volatile ServletFilterManager filterManager;
    private volatile RequestProcessorMBeanImpl mbean;

    void setServerInfo(String serverInfo) {
        this.errorHandler.setServerInfo(serverInfo);
    }

    void setErrorHandler(ErrorHandler eh) {
        this.errorHandler.setDelegate(eh);
    }

    void unsetErrorHandler(ErrorHandler eh) {
        if (this.errorHandler.getDelegate() == eh) {
            this.errorHandler.setDelegate(null);
        }
    }

    void setServletResolver(ServletResolver servletResolver) {
        this.servletResolver = servletResolver;
    }

    void unsetServletResolver(ServletResolver servletResolver) {
        if (this.servletResolver == servletResolver) {
            this.servletResolver = null;
        }
    }

    void setFilterManager(ServletFilterManager filterManager) {
        this.filterManager = filterManager;
    }

    void setMBean(RequestProcessorMBeanImpl mbean) {
        this.mbean = mbean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doProcessRequest(HttpServletRequest servletRequest, HttpServletResponse servletResponse, ResourceResolver resourceResolver) throws IOException {
        RequestData requestData = new RequestData(this, servletRequest, servletResponse);
        SlingHttpServletRequest request = requestData.getSlingRequest();
        SlingHttpServletResponse response = requestData.getSlingResponse();
        RequestHistoryConsolePlugin.recordRequest(request);
        try {
            ServletResolver sr = this.servletResolver;
            if (resourceResolver == null) {
                throw new UnavailableException("ResourceResolver");
            }
            if (sr == null) {
                throw new UnavailableException("ServletResolver");
            }
            Resource resource = requestData.initResource(resourceResolver);
            requestData.initServlet(resource, sr);
            FilterHandle[] filters = this.filterManager.getFilters(ServletFilterManager.FilterChainType.REQUEST);
            if (filters != null) {
                RequestSlingFilterChain processor = new RequestSlingFilterChain(this, filters);
                request.getRequestProgressTracker().log("Applying " + (Object)((Object)ServletFilterManager.FilterChainType.REQUEST) + "filters");
                processor.doFilter((ServletRequest)request, (ServletResponse)response);
            } else {
                this.processComponent(request, response, ServletFilterManager.FilterChainType.COMPONENT);
            }
        }
        catch (SlingHttpServletResponseImpl.WriterAlreadyClosedException wace) {
            this.log.error("Writer has already been closed.", (Throwable)wace);
        }
        catch (ResourceNotFoundException rnfe) {
            this.log.info("service: Resource {} not found", (Object)rnfe.getResource());
            this.handleError(404, rnfe.getMessage(), request, response);
        }
        catch (SlingException se) {
            if (requestData.getActiveServletName() != null) {
                request.setAttribute("javax.servlet.error.servlet_name", (Object)requestData.getActiveServletName());
            }
            Throwable t = se;
            while (t instanceof SlingException && t.getCause() != null) {
                t = t.getCause();
            }
            this.log.error("service: Uncaught SlingException", t);
            this.handleError(t, request, response);
        }
        catch (AccessControlException ace) {
            this.log.info("service: Authenticated user {} does not have enough rights to executed requested action", (Object)request.getRemoteUser());
            this.handleError(403, null, request, response);
        }
        catch (UnavailableException ue) {
            int status = 503;
            String errorMessage = ue.getMessage() + " service missing, cannot service requests";
            this.log.error("{} , sending status {}", (Object)errorMessage, (Object)503);
            servletResponse.sendError(503, errorMessage);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Throwable t) {
            if (requestData.getActiveServletName() != null) {
                request.setAttribute("javax.servlet.error.servlet_name", (Object)requestData.getActiveServletName());
            }
            this.log.error("service: Uncaught Throwable", t);
            this.handleError(t, request, response);
        }
        finally {
            if (this.mbean != null) {
                this.mbean.addRequestData(requestData);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processRequest(HttpServletRequest servletRequest, HttpServletResponse servletResponse, ResourceResolver resourceResolver) throws IOException {
        Object oldValue = servletRequest.getAttribute(ParameterSupport.MARKER_IS_SERVICE_PROCESSING);
        servletRequest.setAttribute(ParameterSupport.MARKER_IS_SERVICE_PROCESSING, (Object)Boolean.TRUE);
        try {
            this.doProcessRequest(servletRequest, servletResponse, resourceResolver);
        }
        finally {
            if (oldValue != null) {
                servletRequest.setAttribute(ParameterSupport.MARKER_IS_SERVICE_PROCESSING, oldValue);
            } else {
                servletRequest.removeAttribute(ParameterSupport.MARKER_IS_SERVICE_PROCESSING);
            }
        }
    }

    public void processComponent(SlingHttpServletRequest request, SlingHttpServletResponse response, ServletFilterManager.FilterChainType filterChainType) throws IOException, ServletException {
        FilterHandle[] filters = this.filterManager.getFilters(filterChainType);
        if (filters != null) {
            SlingComponentFilterChain processor = new SlingComponentFilterChain(filters);
            request.getRequestProgressTracker().log("Applying " + (Object)((Object)filterChainType) + "filters");
            processor.doFilter((ServletRequest)request, (ServletResponse)response);
        } else {
            this.log.debug("service: No Resource level filters, calling servlet");
            RequestData.service(request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatchRequest(ServletRequest request, ServletResponse response, Resource resource, RequestPathInfo resolvedURL, boolean include) throws IOException, ServletException {
        SlingHttpServletRequest cRequest = RequestData.toSlingHttpServletRequest(request);
        SlingHttpServletResponse cResponse = RequestData.toSlingHttpServletResponse(response);
        RequestData requestData = RequestData.getRequestData(cRequest);
        ContentData oldContentData = requestData.getContentData();
        ContentData contentData = requestData.setContent(resource, resolvedURL);
        try {
            Servlet servlet = this.servletResolver.resolveServlet(cRequest);
            contentData.setServlet(servlet);
            ServletFilterManager.FilterChainType type = include ? ServletFilterManager.FilterChainType.INCLUDE : ServletFilterManager.FilterChainType.FORWARD;
            this.processComponent(cRequest, cResponse, type);
        }
        finally {
            requestData.resetContent(oldContentData);
        }
    }

    void handleError(final int status, final String message, SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        response = new ErrorResponseWrapper((SlingHttpServletResponse)response);
        FilterHandle[] filters = this.filterManager.getFilters(ServletFilterManager.FilterChainType.ERROR);
        if (filters != null && filters.length > 0) {
            AbstractSlingFilterChain processor = new AbstractSlingFilterChain(filters){

                @Override
                protected void render(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
                    SlingRequestProcessorImpl.this.errorHandler.handleError(status, message, request, response);
                }
            };
            request.getRequestProgressTracker().log("Applying " + (Object)((Object)ServletFilterManager.FilterChainType.ERROR) + " filters");
            try {
                processor.doFilter((ServletRequest)request, (ServletResponse)response);
            }
            catch (ServletException se) {
                throw new SlingServletException(se);
            }
        } else {
            this.errorHandler.handleError(status, message, request, (SlingHttpServletResponse)response);
        }
    }

    private void handleError(final Throwable throwable, SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
        response = new ErrorResponseWrapper((SlingHttpServletResponse)response);
        FilterHandle[] filters = this.filterManager.getFilters(ServletFilterManager.FilterChainType.ERROR);
        if (filters != null && filters.length > 0) {
            AbstractSlingFilterChain processor = new AbstractSlingFilterChain(filters){

                @Override
                protected void render(SlingHttpServletRequest request, SlingHttpServletResponse response) throws IOException {
                    SlingRequestProcessorImpl.this.errorHandler.handleError(throwable, request, response);
                }
            };
            request.getRequestProgressTracker().log("Applying " + (Object)((Object)ServletFilterManager.FilterChainType.ERROR) + " filters");
            try {
                processor.doFilter((ServletRequest)request, (ServletResponse)response);
            }
            catch (ServletException se) {
                throw new SlingServletException(se);
            }
        } else {
            this.errorHandler.handleError(throwable, request, (SlingHttpServletResponse)response);
        }
    }

    private static class ErrorResponseWrapper
    extends SlingHttpServletResponseWrapper {
        private PrintWriter writer;

        public ErrorResponseWrapper(SlingHttpServletResponse wrappedResponse) {
            super(wrappedResponse);
        }

        public PrintWriter getWriter() throws IOException {
            if (this.writer == null) {
                try {
                    this.writer = super.getWriter();
                }
                catch (IllegalStateException ise) {
                    ServletOutputStream out = this.getOutputStream();
                    String encoding = this.getCharacterEncoding();
                    if (encoding == null) {
                        encoding = "ISO-8859-1";
                        this.setCharacterEncoding(encoding);
                    }
                    OutputStreamWriter w = new OutputStreamWriter((OutputStream)out, encoding);
                    this.writer = new PrintWriter(w);
                }
            }
            return this.writer;
        }

        public void flushBuffer() throws IOException {
            if (this.writer != null) {
                this.writer.flush();
            }
            super.flushBuffer();
        }
    }
}

