/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.web.faces.tags;

import java.io.IOException;
import javax.el.ELException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagConfig;
import org.apache.shiro.web.faces.tags.SecureTagHandler;

public abstract class AuthenticationTagHandler
extends SecureTagHandler {
    public AuthenticationTagHandler(TagConfig config) {
        super(config);
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, ELException {
        if (this.showTagBody()) {
            this.nextHandler.apply(ctx, parent);
        }
    }

    protected abstract boolean checkAuthentication();

    protected boolean showTagBody() {
        if (this.checkAuthentication()) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Authentication successfully verified.  Tag body will be evaluated.");
            }
            return true;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Authentication verification failed.  Tag body will not be evaluated.");
        }
        return false;
    }
}

