/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.keys;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.encryption.EncryptedKey;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.encryption.XMLEncryptionException;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.keys.content.KeyName;
import org.apache.xml.security.keys.content.KeyValue;
import org.apache.xml.security.keys.content.MgmtData;
import org.apache.xml.security.keys.content.PGPData;
import org.apache.xml.security.keys.content.RetrievalMethod;
import org.apache.xml.security.keys.content.SPKIData;
import org.apache.xml.security.keys.content.X509Data;
import org.apache.xml.security.keys.content.keyvalues.DSAKeyValue;
import org.apache.xml.security.keys.content.keyvalues.RSAKeyValue;
import org.apache.xml.security.keys.keyresolver.KeyResolver;
import org.apache.xml.security.keys.keyresolver.KeyResolverException;
import org.apache.xml.security.keys.keyresolver.KeyResolverSpi;
import org.apache.xml.security.keys.storage.StorageResolver;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.utils.IdResolver;
import org.apache.xml.security.utils.SignatureElementProxy;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class KeyInfo
extends SignatureElementProxy {
    static Log log = LogFactory.getLog((String)KeyInfo.class.getName());
    List x509Datas = null;
    List encryptedKeys = null;
    static final List nullList;
    List _internalKeyResolvers = null;
    List _storageResolvers = nullList;
    static boolean _alreadyInitialized;

    public KeyInfo(Document doc) {
        super(doc);
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public KeyInfo(Element element, String BaseURI) throws XMLSecurityException {
        super(element, BaseURI);
    }

    public void setId(String Id) {
        if (Id != null) {
            this._constructionElement.setAttributeNS(null, "Id", Id);
            IdResolver.registerElementById(this._constructionElement, Id);
        }
    }

    public String getId() {
        return this._constructionElement.getAttributeNS(null, "Id");
    }

    public void addKeyName(String keynameString) {
        this.add(new KeyName(this._doc, keynameString));
    }

    public void add(KeyName keyname) {
        this._constructionElement.appendChild(keyname.getElement());
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public void addKeyValue(PublicKey pk) {
        this.add(new KeyValue(this._doc, pk));
    }

    public void addKeyValue(Element unknownKeyValueElement) {
        this.add(new KeyValue(this._doc, unknownKeyValueElement));
    }

    public void add(DSAKeyValue dsakeyvalue) {
        this.add(new KeyValue(this._doc, dsakeyvalue));
    }

    public void add(RSAKeyValue rsakeyvalue) {
        this.add(new KeyValue(this._doc, rsakeyvalue));
    }

    public void add(PublicKey pk) {
        this.add(new KeyValue(this._doc, pk));
    }

    public void add(KeyValue keyvalue) {
        this._constructionElement.appendChild(keyvalue.getElement());
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public void addMgmtData(String mgmtdata) {
        this.add(new MgmtData(this._doc, mgmtdata));
    }

    public void add(MgmtData mgmtdata) {
        this._constructionElement.appendChild(mgmtdata.getElement());
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public void add(PGPData pgpdata) {
        this._constructionElement.appendChild(pgpdata.getElement());
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public void addRetrievalMethod(String URI2, Transforms transforms, String Type2) {
        this.add(new RetrievalMethod(this._doc, URI2, transforms, Type2));
    }

    public void add(RetrievalMethod retrievalmethod) {
        this._constructionElement.appendChild(retrievalmethod.getElement());
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public void add(SPKIData spkidata) {
        this._constructionElement.appendChild(spkidata.getElement());
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public void add(X509Data x509data) {
        if (this.x509Datas == null) {
            this.x509Datas = new ArrayList();
        }
        this.x509Datas.add(x509data);
        this._constructionElement.appendChild(x509data.getElement());
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public void add(EncryptedKey encryptedKey) throws XMLEncryptionException {
        if (this.encryptedKeys == null) {
            this.encryptedKeys = new ArrayList();
        }
        this.encryptedKeys.add(encryptedKey);
        XMLCipher cipher = XMLCipher.getInstance();
        this._constructionElement.appendChild(cipher.martial(encryptedKey));
    }

    public void addUnknownElement(Element element) {
        this._constructionElement.appendChild(element);
        XMLUtils.addReturnToElement(this._constructionElement);
    }

    public int lengthKeyName() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "KeyName");
    }

    public int lengthKeyValue() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "KeyValue");
    }

    public int lengthMgmtData() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "MgmtData");
    }

    public int lengthPGPData() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "PGPData");
    }

    public int lengthRetrievalMethod() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "RetrievalMethod");
    }

    public int lengthSPKIData() {
        return this.length("http://www.w3.org/2000/09/xmldsig#", "SPKIData");
    }

    public int lengthX509Data() {
        if (this.x509Datas != null) {
            return this.x509Datas.size();
        }
        return this.length("http://www.w3.org/2000/09/xmldsig#", "X509Data");
    }

    public int lengthUnknownElement() {
        int res = 0;
        NodeList nl = this._constructionElement.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node current = nl.item(i);
            if (current.getNodeType() != 1 || !current.getNamespaceURI().equals("http://www.w3.org/2000/09/xmldsig#")) continue;
            ++res;
        }
        return res;
    }

    public KeyName itemKeyName(int i) throws XMLSecurityException {
        Element e = XMLUtils.selectDsNode(this._constructionElement.getFirstChild(), "KeyName", i);
        if (e != null) {
            return new KeyName(e, this._baseURI);
        }
        return null;
    }

    public KeyValue itemKeyValue(int i) throws XMLSecurityException {
        Element e = XMLUtils.selectDsNode(this._constructionElement.getFirstChild(), "KeyValue", i);
        if (e != null) {
            return new KeyValue(e, this._baseURI);
        }
        return null;
    }

    public MgmtData itemMgmtData(int i) throws XMLSecurityException {
        Element e = XMLUtils.selectDsNode(this._constructionElement.getFirstChild(), "MgmtData", i);
        if (e != null) {
            return new MgmtData(e, this._baseURI);
        }
        return null;
    }

    public PGPData itemPGPData(int i) throws XMLSecurityException {
        Element e = XMLUtils.selectDsNode(this._constructionElement.getFirstChild(), "PGPData", i);
        if (e != null) {
            return new PGPData(e, this._baseURI);
        }
        return null;
    }

    public RetrievalMethod itemRetrievalMethod(int i) throws XMLSecurityException {
        Element e = XMLUtils.selectDsNode(this._constructionElement.getFirstChild(), "RetrievalMethod", i);
        if (e != null) {
            return new RetrievalMethod(e, this._baseURI);
        }
        return null;
    }

    public SPKIData itemSPKIData(int i) throws XMLSecurityException {
        Element e = XMLUtils.selectDsNode(this._constructionElement.getFirstChild(), "SPKIData", i);
        if (e != null) {
            return new SPKIData(e, this._baseURI);
        }
        return null;
    }

    public X509Data itemX509Data(int i) throws XMLSecurityException {
        if (this.x509Datas != null) {
            return (X509Data)this.x509Datas.get(i);
        }
        Element e = XMLUtils.selectDsNode(this._constructionElement.getFirstChild(), "X509Data", i);
        if (e != null) {
            return new X509Data(e, this._baseURI);
        }
        return null;
    }

    public EncryptedKey itemEncryptedKey(int i) throws XMLSecurityException {
        if (this.encryptedKeys != null) {
            return (EncryptedKey)this.encryptedKeys.get(i);
        }
        Element e = XMLUtils.selectXencNode(this._constructionElement.getFirstChild(), "EncryptedKey", i);
        if (e != null) {
            XMLCipher cipher = XMLCipher.getInstance();
            cipher.init(4, null);
            return cipher.loadEncryptedKey(e);
        }
        return null;
    }

    public Element itemUnknownElement(int i) {
        NodeList nl = this._constructionElement.getChildNodes();
        int res = 0;
        for (int j = 0; j < nl.getLength(); ++j) {
            Node current = nl.item(j);
            if (current.getNodeType() != 1 || !current.getNamespaceURI().equals("http://www.w3.org/2000/09/xmldsig#") || ++res != i) continue;
            return (Element)current;
        }
        return null;
    }

    public boolean isEmpty() {
        return this._constructionElement.getFirstChild() == null;
    }

    public boolean containsKeyName() {
        return this.lengthKeyName() > 0;
    }

    public boolean containsKeyValue() {
        return this.lengthKeyValue() > 0;
    }

    public boolean containsMgmtData() {
        return this.lengthMgmtData() > 0;
    }

    public boolean containsPGPData() {
        return this.lengthPGPData() > 0;
    }

    public boolean containsRetrievalMethod() {
        return this.lengthRetrievalMethod() > 0;
    }

    public boolean containsSPKIData() {
        return this.lengthSPKIData() > 0;
    }

    public boolean containsUnknownElement() {
        return this.lengthUnknownElement() > 0;
    }

    public boolean containsX509Data() {
        return this.lengthX509Data() > 0;
    }

    public PublicKey getPublicKey() throws KeyResolverException {
        PublicKey pk = this.getPublicKeyFromInternalResolvers();
        if (pk != null) {
            log.debug((Object)"I could find a key using the per-KeyInfo key resolvers");
            return pk;
        }
        log.debug((Object)"I couldn't find a key using the per-KeyInfo key resolvers");
        pk = this.getPublicKeyFromStaticResolvers();
        if (pk != null) {
            log.debug((Object)"I could find a key using the system-wide key resolvers");
            return pk;
        }
        log.debug((Object)"I couldn't find a key using the system-wide key resolvers");
        return null;
    }

    PublicKey getPublicKeyFromStaticResolvers() throws KeyResolverException {
        int length = KeyResolver.length();
        int storageLength = this._storageResolvers.size();
        Iterator it = KeyResolver.iterator();
        for (int i = 0; i < length; ++i) {
            KeyResolverSpi keyResolver = (KeyResolverSpi)it.next();
            String uri = this.getBaseURI();
            for (Node currentChild = this._constructionElement.getFirstChild(); currentChild != null; currentChild = currentChild.getNextSibling()) {
                if (currentChild.getNodeType() != 1) continue;
                for (int k = 0; k < storageLength; ++k) {
                    StorageResolver storage = (StorageResolver)this._storageResolvers.get(k);
                    PublicKey pk = keyResolver.engineLookupAndResolvePublicKey((Element)currentChild, uri, storage);
                    if (pk == null) continue;
                    KeyResolver.hit(it);
                    return pk;
                }
            }
        }
        return null;
    }

    PublicKey getPublicKeyFromInternalResolvers() throws KeyResolverException {
        int length = this.lengthInternalKeyResolver();
        int storageLength = this._storageResolvers.size();
        for (int i = 0; i < length; ++i) {
            KeyResolverSpi keyResolver = this.itemInternalKeyResolver(i);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Try " + keyResolver.getClass().getName()));
            }
            String uri = this.getBaseURI();
            for (Node currentChild = this._constructionElement.getFirstChild(); currentChild != null; currentChild = currentChild.getNextSibling()) {
                if (currentChild.getNodeType() != 1) continue;
                for (int k = 0; k < storageLength; ++k) {
                    StorageResolver storage = (StorageResolver)this._storageResolvers.get(k);
                    PublicKey pk = keyResolver.engineLookupAndResolvePublicKey((Element)currentChild, uri, storage);
                    if (pk == null) continue;
                    return pk;
                }
            }
        }
        return null;
    }

    public X509Certificate getX509Certificate() throws KeyResolverException {
        X509Certificate cert = this.getX509CertificateFromInternalResolvers();
        if (cert != null) {
            log.debug((Object)"I could find a X509Certificate using the per-KeyInfo key resolvers");
            return cert;
        }
        log.debug((Object)"I couldn't find a X509Certificate using the per-KeyInfo key resolvers");
        cert = this.getX509CertificateFromStaticResolvers();
        if (cert != null) {
            log.debug((Object)"I could find a X509Certificate using the system-wide key resolvers");
            return cert;
        }
        log.debug((Object)"I couldn't find a X509Certificate using the system-wide key resolvers");
        return null;
    }

    X509Certificate getX509CertificateFromStaticResolvers() throws KeyResolverException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Start getX509CertificateFromStaticResolvers() with " + KeyResolver.length() + " resolvers"));
        }
        String uri = this.getBaseURI();
        int length = KeyResolver.length();
        int storageLength = this._storageResolvers.size();
        Iterator it = KeyResolver.iterator();
        for (int i = 0; i < length; ++i) {
            KeyResolverSpi keyResolver = (KeyResolverSpi)it.next();
            X509Certificate cert = this.applyCurrentResolver(uri, storageLength, keyResolver);
            if (cert == null) continue;
            KeyResolver.hit(it);
            return cert;
        }
        return null;
    }

    private X509Certificate applyCurrentResolver(String uri, int storageLength, KeyResolverSpi keyResolver) throws KeyResolverException {
        for (Node currentChild = this._constructionElement.getFirstChild(); currentChild != null; currentChild = currentChild.getNextSibling()) {
            if (currentChild.getNodeType() != 1) continue;
            for (int k = 0; k < storageLength; ++k) {
                StorageResolver storage = (StorageResolver)this._storageResolvers.get(k);
                X509Certificate cert = keyResolver.engineLookupResolveX509Certificate((Element)currentChild, uri, storage);
                if (cert == null) continue;
                return cert;
            }
        }
        return null;
    }

    X509Certificate getX509CertificateFromInternalResolvers() throws KeyResolverException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Start getX509CertificateFromInternalResolvers() with " + this.lengthInternalKeyResolver() + " resolvers"));
        }
        String uri = this.getBaseURI();
        int storageLength = this._storageResolvers.size();
        for (int i = 0; i < this.lengthInternalKeyResolver(); ++i) {
            X509Certificate cert;
            KeyResolverSpi keyResolver = this.itemInternalKeyResolver(i);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Try " + keyResolver.getClass().getName()));
            }
            if ((cert = this.applyCurrentResolver(uri, storageLength, keyResolver)) == null) continue;
            return cert;
        }
        return null;
    }

    public SecretKey getSecretKey() throws KeyResolverException {
        SecretKey sk = this.getSecretKeyFromInternalResolvers();
        if (sk != null) {
            log.debug((Object)"I could find a secret key using the per-KeyInfo key resolvers");
            return sk;
        }
        log.debug((Object)"I couldn't find a secret key using the per-KeyInfo key resolvers");
        sk = this.getSecretKeyFromStaticResolvers();
        if (sk != null) {
            log.debug((Object)"I could find a secret key using the system-wide key resolvers");
            return sk;
        }
        log.debug((Object)"I couldn't find a secret key using the system-wide key resolvers");
        return null;
    }

    SecretKey getSecretKeyFromStaticResolvers() throws KeyResolverException {
        int length = KeyResolver.length();
        int storageLength = this._storageResolvers.size();
        Iterator it = KeyResolver.iterator();
        for (int i = 0; i < length; ++i) {
            KeyResolverSpi keyResolver = (KeyResolverSpi)it.next();
            String uri = this.getBaseURI();
            for (Node currentChild = this._constructionElement.getFirstChild(); currentChild != null; currentChild = currentChild.getNextSibling()) {
                if (currentChild.getNodeType() != 1) continue;
                for (int k = 0; k < storageLength; ++k) {
                    StorageResolver storage = (StorageResolver)this._storageResolvers.get(k);
                    SecretKey sk = keyResolver.engineLookupAndResolveSecretKey((Element)currentChild, uri, storage);
                    if (sk == null) continue;
                    return sk;
                }
            }
        }
        return null;
    }

    SecretKey getSecretKeyFromInternalResolvers() throws KeyResolverException {
        int storageLength = this._storageResolvers.size();
        for (int i = 0; i < this.lengthInternalKeyResolver(); ++i) {
            KeyResolverSpi keyResolver = this.itemInternalKeyResolver(i);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Try " + keyResolver.getClass().getName()));
            }
            String uri = this.getBaseURI();
            for (Node currentChild = this._constructionElement.getFirstChild(); currentChild != null; currentChild = currentChild.getNextSibling()) {
                if (currentChild.getNodeType() != 1) continue;
                for (int k = 0; k < storageLength; ++k) {
                    StorageResolver storage = (StorageResolver)this._storageResolvers.get(k);
                    SecretKey sk = keyResolver.engineLookupAndResolveSecretKey((Element)currentChild, uri, storage);
                    if (sk == null) continue;
                    return sk;
                }
            }
        }
        return null;
    }

    public PrivateKey getPrivateKey() throws KeyResolverException {
        PrivateKey pk = this.getPrivateKeyFromInternalResolvers();
        if (pk != null) {
            log.debug((Object)"I could find a private key using the per-KeyInfo key resolvers");
            return pk;
        }
        log.debug((Object)"I couldn't find a secret key using the per-KeyInfo key resolvers");
        pk = this.getPrivateKeyFromStaticResolvers();
        if (pk != null) {
            log.debug((Object)"I could find a private key using the system-wide key resolvers");
            return pk;
        }
        log.debug((Object)"I couldn't find a private key using the system-wide key resolvers");
        return null;
    }

    PrivateKey getPrivateKeyFromStaticResolvers() throws KeyResolverException {
        int length = KeyResolver.length();
        Iterator it = KeyResolver.iterator();
        for (int i = 0; i < length; ++i) {
            KeyResolverSpi keyResolver = (KeyResolverSpi)it.next();
            String uri = this.getBaseURI();
            for (Node currentChild = this._constructionElement.getFirstChild(); currentChild != null; currentChild = currentChild.getNextSibling()) {
                StorageResolver storage;
                PrivateKey pk;
                if (currentChild.getNodeType() != 1 || (pk = keyResolver.engineLookupAndResolvePrivateKey((Element)currentChild, uri, storage = null)) == null) continue;
                return pk;
            }
        }
        return null;
    }

    PrivateKey getPrivateKeyFromInternalResolvers() throws KeyResolverException {
        for (int i = 0; i < this.lengthInternalKeyResolver(); ++i) {
            KeyResolverSpi keyResolver = this.itemInternalKeyResolver(i);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Try " + keyResolver.getClass().getName()));
            }
            String uri = this.getBaseURI();
            for (Node currentChild = this._constructionElement.getFirstChild(); currentChild != null; currentChild = currentChild.getNextSibling()) {
                StorageResolver storage;
                PrivateKey pk;
                if (currentChild.getNodeType() != 1 || (pk = keyResolver.engineLookupAndResolvePrivateKey((Element)currentChild, uri, storage = null)) == null) continue;
                return pk;
            }
        }
        return null;
    }

    public void registerInternalKeyResolver(KeyResolverSpi realKeyResolver) {
        if (this._internalKeyResolvers == null) {
            this._internalKeyResolvers = new ArrayList();
        }
        this._internalKeyResolvers.add(realKeyResolver);
    }

    int lengthInternalKeyResolver() {
        if (this._internalKeyResolvers == null) {
            return 0;
        }
        return this._internalKeyResolvers.size();
    }

    KeyResolverSpi itemInternalKeyResolver(int i) {
        return (KeyResolverSpi)this._internalKeyResolvers.get(i);
    }

    public void addStorageResolver(StorageResolver storageResolver) {
        if (this._storageResolvers == nullList) {
            this._storageResolvers = new ArrayList();
        }
        this._storageResolvers.add(storageResolver);
    }

    public static void init() {
        if (!_alreadyInitialized) {
            if (log == null) {
                log = LogFactory.getLog((String)KeyInfo.class.getName());
                log.error((Object)"Had to assign log in the init() function");
            }
            _alreadyInitialized = true;
        }
    }

    public String getBaseLocalName() {
        return "KeyInfo";
    }

    static {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(null);
        nullList = Collections.unmodifiableList(list);
        _alreadyInitialized = false;
    }
}

