/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.mp;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.apache.rat.api.Document;
import org.apache.rat.api.MetaData;
import org.apache.rat.api.RatException;
import org.apache.rat.document.impl.DocumentImplUtils;
import org.apache.rat.report.IReportable;
import org.apache.rat.report.RatReport;

class FilesReportable
implements IReportable {
    private final File basedir;
    private final String[] files;

    FilesReportable(File basedir, String[] files) throws IOException {
        File currentDir = new File(System.getProperty("user.dir")).getCanonicalFile();
        File f = basedir.getCanonicalFile();
        this.basedir = currentDir.equals(f) ? null : basedir;
        this.files = files;
    }

    public void run(RatReport report) throws RatException {
        FileDocument document = new FileDocument();
        for (String file : this.files) {
            document.setFile(new File(this.basedir, file));
            document.getMetaData().clear();
            report.report((Document)document);
        }
    }

    private static class FileDocument
    implements Document {
        private File file;
        private final MetaData metaData = new MetaData();

        private FileDocument() {
        }

        void setFile(File file) {
            this.file = file;
        }

        public boolean isComposite() {
            return DocumentImplUtils.isZip((File)this.file);
        }

        public Reader reader() throws IOException {
            InputStream in = Files.newInputStream(this.file.toPath(), new OpenOption[0]);
            return new InputStreamReader(in);
        }

        public String getName() {
            return DocumentImplUtils.toName((File)this.file);
        }

        public MetaData getMetaData() {
            return this.metaData;
        }

        public InputStream inputStream() throws IOException {
            return Files.newInputStream(this.file.toPath(), new OpenOption[0]);
        }

        public String toString() {
            return "File:" + this.file.getAbsolutePath();
        }
    }
}

