/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.jms.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.qpid.jms.util.PropertyUtil;
import org.apache.qpid.jms.util.ResourceNotFoundException;

public class FactoryFinder<T> {
    private static ObjectFactory objectFactory = new StandaloneObjectFactory();
    private final ConcurrentHashMap<String, T> cachedFactories = new ConcurrentHashMap();
    private final String path;
    private final Class<T> factoryType;

    public FactoryFinder(Class<T> factoryType, String path) {
        this.path = path;
        this.factoryType = factoryType;
    }

    public static ObjectFactory getObjectFactory() {
        return objectFactory;
    }

    public static void setObjectFactory(ObjectFactory objectFactory) {
        FactoryFinder.objectFactory = objectFactory;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public T newInstance(String key) throws IllegalAccessException, InstantiationException, IOException, ClassNotFoundException, ClassCastException, ResourceNotFoundException, InvocationTargetException, NoSuchMethodException, SecurityException {
        T factory = this.cachedFactories.get(key);
        if (factory != null) return factory;
        Object found = objectFactory.create(this.path + key);
        if (found == null) throw new ClassNotFoundException("Could not locate factory for class: " + key);
        if (!this.factoryType.isInstance(found)) throw new ClassCastException("Cannot cast " + found.getClass().getName() + " to " + this.factoryType.getName());
        factory = this.factoryType.cast(found);
        this.cachedFactories.putIfAbsent(key, factory);
        return factory;
    }

    public void registerProviderFactory(String scheme, T factory) {
        this.cachedFactories.put(scheme, factory);
    }

    protected static class StandaloneObjectFactory
    implements ObjectFactory {
        final ConcurrentHashMap<String, Class<?>> classMap = new ConcurrentHashMap();
        final ConcurrentHashMap<String, Properties> propertiesMap = new ConcurrentHashMap();

        protected StandaloneObjectFactory() {
        }

        @Override
        public Object create(String path) throws InstantiationException, IllegalAccessException, ClassNotFoundException, IOException, ResourceNotFoundException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
            Object factory;
            Class<?> clazz = this.classMap.get(path);
            Properties properties = this.propertiesMap.get(path);
            if (clazz == null) {
                Class<?> previousClass;
                properties = StandaloneObjectFactory.loadProperties(path);
                clazz = StandaloneObjectFactory.loadClass(properties);
                Properties previousProperties = this.propertiesMap.putIfAbsent(path, properties);
                if (previousProperties != null) {
                    properties = previousProperties;
                }
                if ((previousClass = this.classMap.putIfAbsent(path, clazz)) != null) {
                    clazz = previousClass;
                }
            }
            if (!PropertyUtil.setProperties(factory = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]), properties).isEmpty()) {
                String msg = " Not all provider options could be set on the found factory. Check the options are spelled correctly. Given parameters=[" + properties + "]. This provider instance cannot be started.";
                throw new IllegalArgumentException(msg);
            }
            return factory;
        }

        public static Class<?> loadClass(Properties properties) throws ClassNotFoundException, IOException {
            String className = properties.getProperty("class");
            if (className == null) {
                throw new IOException("Expected property is missing: class");
            }
            properties.remove("class");
            Class<?> clazz = null;
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            if (loader != null) {
                try {
                    clazz = loader.loadClass(className);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (clazz == null) {
                clazz = FactoryFinder.class.getClassLoader().loadClass(className);
            }
            return clazz;
        }

        public static Properties loadProperties(String uri) throws IOException, ResourceNotFoundException {
            InputStream in;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                classLoader = StandaloneObjectFactory.class.getClassLoader();
            }
            if ((in = classLoader.getResourceAsStream(uri)) == null && (in = FactoryFinder.class.getClassLoader().getResourceAsStream(uri)) == null) {
                throw new ResourceNotFoundException("Could not find factory resource: " + uri);
            }
            try (BufferedInputStream reader = new BufferedInputStream(in);){
                Properties properties = new Properties();
                properties.load(reader);
                Properties properties2 = properties;
                return properties2;
            }
        }
    }

    public static interface ObjectFactory {
        public Object create(String var1) throws IllegalAccessException, InstantiationException, IOException, ClassNotFoundException, ResourceNotFoundException, NoSuchMethodException, SecurityException, InvocationTargetException;
    }
}

