/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing.amqp_0_91;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.qpid.AMQException;
import org.apache.qpid.codec.MarkableDataInput;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQMethodBodyInstanceFactory;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.MethodDispatcher;
import org.apache.qpid.framing.QueuePurgeBody;
import org.apache.qpid.framing.amqp_0_91.AMQMethodBody_0_91;
import org.apache.qpid.framing.amqp_0_91.MethodDispatcher_0_91;

public class QueuePurgeBodyImpl
extends AMQMethodBody_0_91
implements QueuePurgeBody {
    private static final AMQMethodBodyInstanceFactory FACTORY_INSTANCE = new AMQMethodBodyInstanceFactory(){

        public AMQMethodBody newInstance(MarkableDataInput in, long size) throws AMQFrameDecodingException, IOException {
            return new QueuePurgeBodyImpl(in);
        }
    };
    public static final int CLASS_ID = 50;
    public static final int METHOD_ID = 30;
    private final int _ticket;
    private final AMQShortString _queue;
    private final byte _bitfield0;

    public static AMQMethodBodyInstanceFactory getFactory() {
        return FACTORY_INSTANCE;
    }

    public QueuePurgeBodyImpl(MarkableDataInput buffer) throws AMQFrameDecodingException, IOException {
        this._ticket = this.readUnsignedShort(buffer);
        this._queue = this.readAMQShortString(buffer);
        this._bitfield0 = this.readBitfield(buffer);
    }

    public QueuePurgeBodyImpl(int ticket, AMQShortString queue, boolean nowait) {
        this._ticket = ticket;
        this._queue = queue;
        byte bitfield0 = 0;
        if (nowait) {
            bitfield0 = (byte)(bitfield0 | 1);
        }
        this._bitfield0 = bitfield0;
    }

    public int getClazz() {
        return 50;
    }

    public int getMethod() {
        return 30;
    }

    public final int getTicket() {
        return this._ticket;
    }

    public final AMQShortString getQueue() {
        return this._queue;
    }

    public final boolean getNowait() {
        return (this._bitfield0 & 1) != 0;
    }

    protected int getBodySize() {
        int size = 3;
        return size += this.getSizeOf(this._queue);
    }

    public void writeMethodPayload(DataOutput buffer) throws IOException {
        this.writeUnsignedShort(buffer, this._ticket);
        this.writeAMQShortString(buffer, this._queue);
        this.writeBitfield(buffer, this._bitfield0);
    }

    public boolean execute(MethodDispatcher dispatcher, int channelId) throws AMQException {
        return ((MethodDispatcher_0_91)dispatcher).dispatchQueuePurge(this, channelId);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("[QueuePurgeBodyImpl: ");
        buf.append("ticket=");
        buf.append(this.getTicket());
        buf.append(", ");
        buf.append("queue=");
        buf.append(this.getQueue());
        buf.append(", ");
        buf.append("nowait=");
        buf.append(this.getNowait());
        buf.append("]");
        return buf.toString();
    }
}

