/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing.amqp_0_91;

import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.qpid.AMQException;
import org.apache.qpid.codec.MarkableDataInput;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQMethodBodyInstanceFactory;
import org.apache.qpid.framing.ChannelOpenOkBody;
import org.apache.qpid.framing.MethodDispatcher;
import org.apache.qpid.framing.amqp_0_91.AMQMethodBody_0_91;
import org.apache.qpid.framing.amqp_0_91.MethodDispatcher_0_91;

public class ChannelOpenOkBodyImpl
extends AMQMethodBody_0_91
implements ChannelOpenOkBody {
    private static final AMQMethodBodyInstanceFactory FACTORY_INSTANCE = new AMQMethodBodyInstanceFactory(){

        public AMQMethodBody newInstance(MarkableDataInput in, long size) throws AMQFrameDecodingException, IOException {
            return new ChannelOpenOkBodyImpl(in);
        }
    };
    public static final int CLASS_ID = 20;
    public static final int METHOD_ID = 11;
    private final byte[] _channelId;

    public static AMQMethodBodyInstanceFactory getFactory() {
        return FACTORY_INSTANCE;
    }

    public ChannelOpenOkBodyImpl(MarkableDataInput buffer) throws AMQFrameDecodingException, IOException {
        this._channelId = this.readBytes(buffer);
    }

    public ChannelOpenOkBodyImpl(byte[] channelId) {
        this._channelId = channelId;
    }

    public int getClazz() {
        return 20;
    }

    public int getMethod() {
        return 11;
    }

    public final byte[] getChannelId() {
        return this._channelId;
    }

    protected int getBodySize() {
        int size = 0;
        return size += this.getSizeOf(this._channelId);
    }

    public void writeMethodPayload(DataOutput buffer) throws IOException {
        this.writeBytes(buffer, this._channelId);
    }

    public boolean execute(MethodDispatcher dispatcher, int channelId) throws AMQException {
        return ((MethodDispatcher_0_91)dispatcher).dispatchChannelOpenOk(this, channelId);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("[ChannelOpenOkBodyImpl: ");
        buf.append("channelId=");
        buf.append(this.getChannelId() == null ? "null" : Arrays.toString(this.getChannelId()));
        buf.append("]");
        return buf.toString();
    }
}

