/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.configuration;

import org.apache.qpid.configuration.Accessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class QpidProperty<T> {
    private T defValue;
    private String[] names;
    private Accessor accessor;

    QpidProperty(T defValue, String ... names) {
        this(new Accessor.SystemPropertyAccessor(), defValue, names);
    }

    QpidProperty(Accessor accessor, T defValue, String ... names) {
        this.accessor = accessor;
        this.defValue = defValue;
        this.names = names;
    }

    public T get() {
        for (String name : this.names) {
            T obj = this.getByName(name);
            if (obj == null) continue;
            return obj;
        }
        return this.defValue;
    }

    protected abstract T getByName(String var1);

    public static QpidProperty<Boolean> booleanProperty(Boolean defaultValue, String ... names) {
        return new QpidBooleanProperty(defaultValue, names);
    }

    public static QpidProperty<Boolean> booleanProperty(Accessor accessor, Boolean defaultValue, String ... names) {
        return new QpidBooleanProperty(accessor, defaultValue, names);
    }

    public static QpidProperty<Integer> intProperty(Integer defaultValue, String ... names) {
        return new QpidIntProperty(defaultValue, names);
    }

    public static QpidProperty<Integer> intProperty(Accessor accessor, Integer defaultValue, String ... names) {
        return new QpidIntProperty(accessor, defaultValue, names);
    }

    public static QpidProperty<Long> longProperty(Long defaultValue, String ... names) {
        return new QpidLongProperty(defaultValue, names);
    }

    public static QpidProperty<Long> longProperty(Accessor accessor, Long defaultValue, String ... names) {
        return new QpidLongProperty(accessor, defaultValue, names);
    }

    public static QpidProperty<String> stringProperty(String defaultValue, String ... names) {
        return new QpidStringProperty(defaultValue, names);
    }

    public static QpidProperty<String> stringProperty(Accessor accessor, String defaultValue, String ... names) {
        return new QpidStringProperty(accessor, defaultValue, names);
    }

    protected Accessor getAccessor() {
        return this.accessor;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class QpidStringProperty
    extends QpidProperty<String> {
        QpidStringProperty(String defValue, String ... names) {
            super(defValue, names);
        }

        QpidStringProperty(Accessor accessor, String defValue, String ... names) {
            super(accessor, defValue, names);
        }

        @Override
        protected String getByName(String name) {
            return this.getAccessor().getString(name);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class QpidLongProperty
    extends QpidProperty<Long> {
        QpidLongProperty(Long defValue, String ... names) {
            super(defValue, names);
        }

        QpidLongProperty(Accessor accessor, Long defValue, String ... names) {
            super(accessor, defValue, names);
        }

        @Override
        protected Long getByName(String name) {
            return this.getAccessor().getLong(name);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class QpidIntProperty
    extends QpidProperty<Integer> {
        QpidIntProperty(Integer defValue, String ... names) {
            super(defValue, names);
        }

        QpidIntProperty(Accessor accessor, Integer defValue, String ... names) {
            super(accessor, defValue, names);
        }

        @Override
        protected Integer getByName(String name) {
            return this.getAccessor().getInt(name);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class QpidBooleanProperty
    extends QpidProperty<Boolean> {
        QpidBooleanProperty(Boolean defValue, String ... names) {
            super(defValue, names);
        }

        QpidBooleanProperty(Accessor accessor, Boolean defValue, String ... names) {
            super(accessor, defValue, names);
        }

        @Override
        protected Boolean getByName(String name) {
            return this.getAccessor().getBoolean(name);
        }
    }
}

