/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.transport.network.security.ssl;

import java.nio.ByteBuffer;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import org.apache.qpid.transport.ConnectionSettings;
import org.apache.qpid.transport.Receiver;
import org.apache.qpid.transport.TransportException;
import org.apache.qpid.transport.network.security.ssl.SSLSender;
import org.apache.qpid.transport.network.security.ssl.SSLUtil;
import org.apache.qpid.transport.util.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SSLReceiver
implements Receiver<ByteBuffer> {
    private Receiver<ByteBuffer> delegate;
    private SSLEngine engine;
    private SSLSender sender;
    private int sslBufSize;
    private ByteBuffer appData;
    private ByteBuffer localBuffer;
    private boolean dataCached = false;
    private final Object notificationToken;
    private ConnectionSettings settings;
    private static final Logger log = Logger.get(SSLReceiver.class);

    public SSLReceiver(SSLEngine engine, Receiver<ByteBuffer> delegate, SSLSender sender) {
        this.engine = engine;
        this.delegate = delegate;
        this.sender = sender;
        this.sslBufSize = engine.getSession().getApplicationBufferSize();
        this.appData = ByteBuffer.allocate(this.sslBufSize);
        this.localBuffer = ByteBuffer.allocate(this.sslBufSize);
        this.notificationToken = sender.getNotificationToken();
    }

    public void setConnectionSettings(ConnectionSettings settings) {
        this.settings = settings;
    }

    @Override
    public void closed() {
        this.delegate.closed();
    }

    @Override
    public void exception(Throwable t) {
        this.delegate.exception(t);
    }

    private ByteBuffer addPreviouslyUnreadData(ByteBuffer buf) {
        if (this.dataCached) {
            ByteBuffer b = ByteBuffer.allocate(this.localBuffer.remaining() + buf.remaining());
            b.put(this.localBuffer);
            b.put(buf);
            b.flip();
            this.dataCached = false;
            return b;
        }
        return buf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void received(ByteBuffer buf) {
        ByteBuffer netData = this.addPreviouslyUnreadData(buf);
        block26: while (netData.hasRemaining()) {
            try {
                SSLEngineResult result = this.engine.unwrap(netData, this.appData);
                Object object = this.notificationToken;
                synchronized (object) {
                    this.notificationToken.notifyAll();
                }
                int read = result.bytesProduced();
                SSLEngineResult.Status status = result.getStatus();
                SSLEngineResult.HandshakeStatus handshakeStatus = result.getHandshakeStatus();
                if (read > 0) {
                    int limit = this.appData.limit();
                    this.appData.limit(this.appData.position());
                    this.appData.position(this.appData.position() - read);
                    ByteBuffer data = this.appData.slice();
                    this.appData.limit(limit);
                    this.appData.position(this.appData.position() + read);
                    this.delegate.received(data);
                }
                switch (status) {
                    case CLOSED: {
                        Object object2 = this.notificationToken;
                        synchronized (object2) {
                            this.notificationToken.notifyAll();
                        }
                        return;
                    }
                    case BUFFER_OVERFLOW: {
                        this.appData = ByteBuffer.allocate(this.sslBufSize);
                        continue block26;
                    }
                    case BUFFER_UNDERFLOW: {
                        this.localBuffer.clear();
                        this.localBuffer.put(netData);
                        this.localBuffer.flip();
                        this.dataCached = true;
                        break;
                    }
                    case OK: {
                        break;
                    }
                    default: {
                        throw new IllegalStateException("SSLReceiver: Invalid State " + (Object)((Object)status));
                    }
                }
                switch (handshakeStatus) {
                    case NEED_UNWRAP: {
                        if (!netData.hasRemaining()) continue block26;
                        continue block26;
                    }
                    case NEED_TASK: {
                        this.sender.doTasks();
                        handshakeStatus = this.engine.getHandshakeStatus();
                    }
                    case FINISHED: {
                        if (this.settings != null && this.settings.isVerifyHostname()) {
                            SSLUtil.verifyHostname(this.engine, this.settings.getHost());
                        }
                    }
                    case NEED_WRAP: 
                    case NOT_HANDSHAKING: {
                        Object object3 = this.notificationToken;
                        synchronized (object3) {
                            this.notificationToken.notifyAll();
                            break;
                        }
                    }
                    default: {
                        throw new IllegalStateException("SSLReceiver: Invalid State " + (Object)((Object)status));
                    }
                }
            }
            catch (SSLException e) {
                log.error(e, "Error caught in SSLReceiver", new Object[0]);
                this.sender.setErrorFlag();
                Object object = this.notificationToken;
                synchronized (object) {
                    this.notificationToken.notifyAll();
                }
                this.exception(new TransportException("Error in SSLReceiver", e));
            }
        }
    }
}

