/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.transport.network.security.sasl;

import javax.security.sasl.SaslClient;
import org.apache.qpid.transport.Connection;
import org.apache.qpid.transport.ConnectionException;
import org.apache.qpid.transport.ConnectionListener;

public abstract class SASLEncryptor
implements ConnectionListener {
    protected SaslClient saslClient;
    protected boolean securityLayerEstablished = false;
    protected int sendBuffSize;
    protected int recvBuffSize;

    public boolean isSecurityLayerEstablished() {
        return this.securityLayerEstablished;
    }

    public void opened(Connection conn) {
        if (conn.getSaslClient() != null) {
            this.saslClient = conn.getSaslClient();
            if (this.saslClient.isComplete() && this.saslClient.getNegotiatedProperty("javax.security.sasl.qop") == "auth-conf") {
                this.sendBuffSize = Integer.parseInt((String)this.saslClient.getNegotiatedProperty("javax.security.sasl.rawsendsize"));
                this.recvBuffSize = Integer.parseInt((String)this.saslClient.getNegotiatedProperty("javax.security.sasl.maxbuffer"));
                this.securityLayerEstablished();
                this.securityLayerEstablished = true;
            }
        }
    }

    public void exception(Connection conn, ConnectionException exception) {
    }

    public void closed(Connection conn) {
    }

    public abstract void securityLayerEstablished();
}

