/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.transport.network;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.qpid.transport.Header;
import org.apache.qpid.transport.Method;
import org.apache.qpid.transport.ProtocolDelegate;
import org.apache.qpid.transport.ProtocolError;
import org.apache.qpid.transport.ProtocolEvent;
import org.apache.qpid.transport.ProtocolHeader;
import org.apache.qpid.transport.SegmentType;
import org.apache.qpid.transport.Sender;
import org.apache.qpid.transport.Struct;
import org.apache.qpid.transport.codec.BBEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Disassembler
implements Sender<ProtocolEvent>,
ProtocolDelegate<Void> {
    private final Sender<ByteBuffer> sender;
    private final int maxPayload;
    private final Object sendlock = new Object();
    private static final ThreadLocal<BBEncoder> _encoder = new ThreadLocal<BBEncoder>(){

        @Override
        public BBEncoder initialValue() {
            return new BBEncoder(4096);
        }
    };

    public Disassembler(Sender<ByteBuffer> sender, int maxFrame) {
        if (maxFrame <= 12 || maxFrame >= 65536) {
            throw new IllegalArgumentException("maxFrame must be > HEADER_SIZE and < 64K: " + maxFrame);
        }
        this.sender = sender;
        this.maxPayload = maxFrame - 12;
    }

    @Override
    public void send(ProtocolEvent event) {
        event.delegate(null, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        Object object = this.sendlock;
        synchronized (object) {
            this.sender.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.sendlock;
        synchronized (object) {
            this.sender.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void frame(byte flags, byte type, byte track, int channel, int size, ByteBuffer buf) {
        Object object = this.sendlock;
        synchronized (object) {
            ByteBuffer data = ByteBuffer.allocate(size + 12);
            data.order(ByteOrder.BIG_ENDIAN);
            data.put(0, flags);
            data.put(1, type);
            data.putShort(2, (short)(size + 12));
            data.put(5, track);
            data.putShort(6, (short)channel);
            data.position(12);
            int limit = buf.limit();
            buf.limit(buf.position() + size);
            data.put(buf);
            buf.limit(limit);
            data.rewind();
            this.sender.send(data);
        }
    }

    private void fragment(byte flags, SegmentType type, ProtocolEvent event, ByteBuffer buf) {
        byte typeb = (byte)type.getValue();
        byte track = event.getEncodedTrack() == 3 ? (byte)1 : 0;
        int remaining = buf.remaining();
        boolean first = true;
        do {
            int size = Math.min(this.maxPayload, remaining);
            remaining -= size;
            byte newflags = flags;
            if (first) {
                newflags = (byte)(newflags | 2);
                first = false;
            }
            if (remaining == 0) {
                newflags = (byte)(newflags | 1);
            }
            this.frame(newflags, typeb, track, event.getChannel(), size, buf);
        } while (remaining != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(Void v, ProtocolHeader header) {
        Object object = this.sendlock;
        synchronized (object) {
            this.sender.send(header.toByteBuffer());
            this.sender.flush();
        }
    }

    @Override
    public void control(Void v, Method method) {
        this.method(method, SegmentType.CONTROL);
    }

    @Override
    public void command(Void v, Method method) {
        this.method(method, SegmentType.COMMAND);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void method(Method method, SegmentType type) {
        BBEncoder enc = _encoder.get();
        enc.init();
        enc.writeUint16(method.getEncodedType());
        if (type == SegmentType.COMMAND) {
            if (method.isSync()) {
                enc.writeUint16(257);
            } else {
                enc.writeUint16(256);
            }
        }
        method.write(enc);
        ByteBuffer methodSeg = enc.segment();
        byte flags = 8;
        boolean payload = method.hasPayload();
        if (!payload) {
            flags = (byte)(flags | 4);
        }
        ByteBuffer headerSeg = null;
        if (payload) {
            Header hdr = method.getHeader();
            if (hdr != null) {
                Struct[] structs;
                for (Struct st : structs = hdr.getStructs()) {
                    enc.writeStruct32(st);
                }
            }
            headerSeg = enc.segment();
        }
        Object object = this.sendlock;
        synchronized (object) {
            this.fragment(flags, type, method, methodSeg);
            if (payload) {
                ByteBuffer body = method.getBody();
                this.fragment(body == null ? (byte)4 : 0, SegmentType.HEADER, method, headerSeg);
                if (body != null) {
                    this.fragment((byte)4, SegmentType.BODY, method, body);
                }
            }
        }
    }

    @Override
    public void error(Void v, ProtocolError error) {
        throw new IllegalArgumentException(String.valueOf(error));
    }

    @Override
    public void setIdleTimeout(int i) {
        this.sender.setIdleTimeout(i);
    }
}

