/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.transport;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.qpid.transport.Method;
import org.apache.qpid.transport.MethodDelegate;
import org.apache.qpid.transport.Option;
import org.apache.qpid.transport.codec.Decoder;
import org.apache.qpid.transport.codec.Encoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MessageResume
extends Method {
    public static final int TYPE = 1030;
    private short packing_flags = 0;
    private String destination;
    private String resumeId;

    @Override
    public final int getStructType() {
        return 1030;
    }

    @Override
    public final int getSizeWidth() {
        return 0;
    }

    @Override
    public final int getPackWidth() {
        return 2;
    }

    @Override
    public final boolean hasPayload() {
        return false;
    }

    @Override
    public final byte getEncodedTrack() {
        return 3;
    }

    @Override
    public final boolean isConnectionControl() {
        return false;
    }

    public MessageResume() {
    }

    public MessageResume(String destination, String resumeId, Option ... _options) {
        if (destination != null) {
            this.setDestination(destination);
        }
        if (resumeId != null) {
            this.setResumeId(resumeId);
        }
        block6: for (int i = 0; i < _options.length; ++i) {
            switch (_options[i]) {
                case SYNC: {
                    this.setSync(true);
                    continue block6;
                }
                case BATCH: {
                    this.setBatch(true);
                    continue block6;
                }
                case UNRELIABLE: {
                    this.setUnreliable(true);
                    continue block6;
                }
                case NONE: {
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("invalid option: " + (Object)((Object)_options[i]));
                }
            }
        }
    }

    @Override
    public <C> void dispatch(C context, MethodDelegate<C> delegate) {
        delegate.messageResume(context, this);
    }

    public final boolean hasDestination() {
        return (this.packing_flags & 0x100) != 0;
    }

    public final MessageResume clearDestination() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFEFF);
        this.destination = null;
        this.dirty = true;
        return this;
    }

    public final String getDestination() {
        return this.destination;
    }

    public final MessageResume setDestination(String value) {
        this.destination = value;
        this.packing_flags = (short)(this.packing_flags | 0x100);
        this.dirty = true;
        return this;
    }

    public final MessageResume destination(String value) {
        return this.setDestination(value);
    }

    public final boolean hasResumeId() {
        return (this.packing_flags & 0x200) != 0;
    }

    public final MessageResume clearResumeId() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFDFF);
        this.resumeId = null;
        this.dirty = true;
        return this;
    }

    public final String getResumeId() {
        return this.resumeId;
    }

    public final MessageResume setResumeId(String value) {
        this.resumeId = value;
        this.packing_flags = (short)(this.packing_flags | 0x200);
        this.dirty = true;
        return this;
    }

    public final MessageResume resumeId(String value) {
        return this.setResumeId(value);
    }

    @Override
    public void write(Encoder enc) {
        enc.writeUint16(this.packing_flags);
        if ((this.packing_flags & 0x100) != 0) {
            enc.writeStr8(this.destination);
        }
        if ((this.packing_flags & 0x200) != 0) {
            enc.writeStr16(this.resumeId);
        }
    }

    @Override
    public void read(Decoder dec) {
        this.packing_flags = (short)dec.readUint16();
        if ((this.packing_flags & 0x100) != 0) {
            this.destination = dec.readStr8();
        }
        if ((this.packing_flags & 0x200) != 0) {
            this.resumeId = dec.readStr16();
        }
    }

    @Override
    public Map<String, Object> getFields() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if ((this.packing_flags & 0x100) != 0) {
            result.put("destination", this.getDestination());
        }
        if ((this.packing_flags & 0x200) != 0) {
            result.put("resumeId", this.getResumeId());
        }
        return result;
    }
}

