/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.transport;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.qpid.transport.Method;
import org.apache.qpid.transport.MethodDelegate;
import org.apache.qpid.transport.Option;
import org.apache.qpid.transport.codec.Decoder;
import org.apache.qpid.transport.codec.Encoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExchangeBind
extends Method {
    public static final int TYPE = 1796;
    private short packing_flags = 0;
    private String queue;
    private String exchange;
    private String bindingKey;
    private Map<String, Object> arguments;

    @Override
    public final int getStructType() {
        return 1796;
    }

    @Override
    public final int getSizeWidth() {
        return 0;
    }

    @Override
    public final int getPackWidth() {
        return 2;
    }

    @Override
    public final boolean hasPayload() {
        return false;
    }

    @Override
    public final byte getEncodedTrack() {
        return 3;
    }

    @Override
    public final boolean isConnectionControl() {
        return false;
    }

    public ExchangeBind() {
    }

    public ExchangeBind(String queue, String exchange, String bindingKey, Map<String, Object> arguments, Option ... _options) {
        if (queue != null) {
            this.setQueue(queue);
        }
        if (exchange != null) {
            this.setExchange(exchange);
        }
        if (bindingKey != null) {
            this.setBindingKey(bindingKey);
        }
        if (arguments != null) {
            this.setArguments(arguments);
        }
        block6: for (int i = 0; i < _options.length; ++i) {
            switch (_options[i]) {
                case SYNC: {
                    this.setSync(true);
                    continue block6;
                }
                case BATCH: {
                    this.setBatch(true);
                    continue block6;
                }
                case UNRELIABLE: {
                    this.setUnreliable(true);
                    continue block6;
                }
                case NONE: {
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("invalid option: " + (Object)((Object)_options[i]));
                }
            }
        }
    }

    @Override
    public <C> void dispatch(C context, MethodDelegate<C> delegate) {
        delegate.exchangeBind(context, this);
    }

    public final boolean hasQueue() {
        return (this.packing_flags & 0x100) != 0;
    }

    public final ExchangeBind clearQueue() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFEFF);
        this.queue = null;
        this.dirty = true;
        return this;
    }

    public final String getQueue() {
        return this.queue;
    }

    public final ExchangeBind setQueue(String value) {
        this.queue = value;
        this.packing_flags = (short)(this.packing_flags | 0x100);
        this.dirty = true;
        return this;
    }

    public final ExchangeBind queue(String value) {
        return this.setQueue(value);
    }

    public final boolean hasExchange() {
        return (this.packing_flags & 0x200) != 0;
    }

    public final ExchangeBind clearExchange() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFDFF);
        this.exchange = null;
        this.dirty = true;
        return this;
    }

    public final String getExchange() {
        return this.exchange;
    }

    public final ExchangeBind setExchange(String value) {
        this.exchange = value;
        this.packing_flags = (short)(this.packing_flags | 0x200);
        this.dirty = true;
        return this;
    }

    public final ExchangeBind exchange(String value) {
        return this.setExchange(value);
    }

    public final boolean hasBindingKey() {
        return (this.packing_flags & 0x400) != 0;
    }

    public final ExchangeBind clearBindingKey() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFBFF);
        this.bindingKey = null;
        this.dirty = true;
        return this;
    }

    public final String getBindingKey() {
        return this.bindingKey;
    }

    public final ExchangeBind setBindingKey(String value) {
        this.bindingKey = value;
        this.packing_flags = (short)(this.packing_flags | 0x400);
        this.dirty = true;
        return this;
    }

    public final ExchangeBind bindingKey(String value) {
        return this.setBindingKey(value);
    }

    public final boolean hasArguments() {
        return (this.packing_flags & 0x800) != 0;
    }

    public final ExchangeBind clearArguments() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFF7FF);
        this.arguments = null;
        this.dirty = true;
        return this;
    }

    public final Map<String, Object> getArguments() {
        return this.arguments;
    }

    public final ExchangeBind setArguments(Map<String, Object> value) {
        this.arguments = value;
        this.packing_flags = (short)(this.packing_flags | 0x800);
        this.dirty = true;
        return this;
    }

    public final ExchangeBind arguments(Map<String, Object> value) {
        return this.setArguments(value);
    }

    @Override
    public void write(Encoder enc) {
        enc.writeUint16(this.packing_flags);
        if ((this.packing_flags & 0x100) != 0) {
            enc.writeStr8(this.queue);
        }
        if ((this.packing_flags & 0x200) != 0) {
            enc.writeStr8(this.exchange);
        }
        if ((this.packing_flags & 0x400) != 0) {
            enc.writeStr8(this.bindingKey);
        }
        if ((this.packing_flags & 0x800) != 0) {
            enc.writeMap(this.arguments);
        }
    }

    @Override
    public void read(Decoder dec) {
        this.packing_flags = (short)dec.readUint16();
        if ((this.packing_flags & 0x100) != 0) {
            this.queue = dec.readStr8();
        }
        if ((this.packing_flags & 0x200) != 0) {
            this.exchange = dec.readStr8();
        }
        if ((this.packing_flags & 0x400) != 0) {
            this.bindingKey = dec.readStr8();
        }
        if ((this.packing_flags & 0x800) != 0) {
            this.arguments = dec.readMap();
        }
    }

    @Override
    public Map<String, Object> getFields() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if ((this.packing_flags & 0x100) != 0) {
            result.put("queue", this.getQueue());
        }
        if ((this.packing_flags & 0x200) != 0) {
            result.put("exchange", this.getExchange());
        }
        if ((this.packing_flags & 0x400) != 0) {
            result.put("bindingKey", this.getBindingKey());
        }
        if ((this.packing_flags & 0x800) != 0) {
            result.put("arguments", this.getArguments());
        }
        return result;
    }
}

