/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing.amqp_0_91;

import org.apache.mina.common.ByteBuffer;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQMethodBodyInstanceFactory;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.MethodDispatcher;
import org.apache.qpid.framing.QueueDeclareOkBody;
import org.apache.qpid.framing.amqp_0_91.AMQMethodBody_0_91;
import org.apache.qpid.framing.amqp_0_91.MethodDispatcher_0_91;

public class QueueDeclareOkBodyImpl
extends AMQMethodBody_0_91
implements QueueDeclareOkBody {
    private static final AMQMethodBodyInstanceFactory FACTORY_INSTANCE = new AMQMethodBodyInstanceFactory(){

        public AMQMethodBody newInstance(ByteBuffer in, long size) throws AMQFrameDecodingException {
            return new QueueDeclareOkBodyImpl(in);
        }
    };
    public static final int CLASS_ID = 50;
    public static final int METHOD_ID = 11;
    private final AMQShortString _queue;
    private final long _messageCount;
    private final long _consumerCount;

    public static AMQMethodBodyInstanceFactory getFactory() {
        return FACTORY_INSTANCE;
    }

    public QueueDeclareOkBodyImpl(ByteBuffer buffer) throws AMQFrameDecodingException {
        this._queue = this.readAMQShortString(buffer);
        this._messageCount = this.readUnsignedInteger(buffer);
        this._consumerCount = this.readUnsignedInteger(buffer);
    }

    public QueueDeclareOkBodyImpl(AMQShortString queue, long messageCount, long consumerCount) {
        this._queue = queue;
        this._messageCount = messageCount;
        this._consumerCount = consumerCount;
    }

    public int getClazz() {
        return 50;
    }

    public int getMethod() {
        return 11;
    }

    public final AMQShortString getQueue() {
        return this._queue;
    }

    public final long getMessageCount() {
        return this._messageCount;
    }

    public final long getConsumerCount() {
        return this._consumerCount;
    }

    protected int getBodySize() {
        int size = 8;
        return size += this.getSizeOf(this._queue);
    }

    public void writeMethodPayload(ByteBuffer buffer) {
        this.writeAMQShortString(buffer, this._queue);
        this.writeUnsignedInteger(buffer, this._messageCount);
        this.writeUnsignedInteger(buffer, this._consumerCount);
    }

    public boolean execute(MethodDispatcher dispatcher, int channelId) throws AMQException {
        return ((MethodDispatcher_0_91)dispatcher).dispatchQueueDeclareOk(this, channelId);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("[QueueDeclareOkBodyImpl: ");
        buf.append("queue=");
        buf.append(this.getQueue());
        buf.append(", ");
        buf.append("messageCount=");
        buf.append(this.getMessageCount());
        buf.append(", ");
        buf.append("consumerCount=");
        buf.append(this.getConsumerCount());
        buf.append("]");
        return buf.toString();
    }
}

