/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing.amqp_0_9;

import org.apache.mina.common.ByteBuffer;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQMethodBodyInstanceFactory;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.MethodDispatcher;
import org.apache.qpid.framing.StreamDeliverBody;
import org.apache.qpid.framing.amqp_0_9.AMQMethodBody_0_9;
import org.apache.qpid.framing.amqp_0_9.MethodDispatcher_0_9;

public class StreamDeliverBodyImpl
extends AMQMethodBody_0_9
implements StreamDeliverBody {
    private static final AMQMethodBodyInstanceFactory FACTORY_INSTANCE = new AMQMethodBodyInstanceFactory(){

        public AMQMethodBody newInstance(ByteBuffer in, long size) throws AMQFrameDecodingException {
            return new StreamDeliverBodyImpl(in);
        }
    };
    public static final int CLASS_ID = 80;
    public static final int METHOD_ID = 60;
    private final AMQShortString _consumerTag;
    private final long _deliveryTag;
    private final AMQShortString _exchange;
    private final AMQShortString _queue;

    public static AMQMethodBodyInstanceFactory getFactory() {
        return FACTORY_INSTANCE;
    }

    public StreamDeliverBodyImpl(ByteBuffer buffer) throws AMQFrameDecodingException {
        this._consumerTag = this.readAMQShortString(buffer);
        this._deliveryTag = this.readLong(buffer);
        this._exchange = this.readAMQShortString(buffer);
        this._queue = this.readAMQShortString(buffer);
    }

    public StreamDeliverBodyImpl(AMQShortString consumerTag, long deliveryTag, AMQShortString exchange, AMQShortString queue) {
        this._consumerTag = consumerTag;
        this._deliveryTag = deliveryTag;
        this._exchange = exchange;
        this._queue = queue;
    }

    public int getClazz() {
        return 80;
    }

    public int getMethod() {
        return 60;
    }

    public final AMQShortString getConsumerTag() {
        return this._consumerTag;
    }

    public final long getDeliveryTag() {
        return this._deliveryTag;
    }

    public final AMQShortString getExchange() {
        return this._exchange;
    }

    public final AMQShortString getQueue() {
        return this._queue;
    }

    protected int getBodySize() {
        int size = 8;
        size += this.getSizeOf(this._consumerTag);
        size += this.getSizeOf(this._exchange);
        return size += this.getSizeOf(this._queue);
    }

    public void writeMethodPayload(ByteBuffer buffer) {
        this.writeAMQShortString(buffer, this._consumerTag);
        this.writeLong(buffer, this._deliveryTag);
        this.writeAMQShortString(buffer, this._exchange);
        this.writeAMQShortString(buffer, this._queue);
    }

    public boolean execute(MethodDispatcher dispatcher, int channelId) throws AMQException {
        return ((MethodDispatcher_0_9)dispatcher).dispatchStreamDeliver(this, channelId);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("[StreamDeliverBodyImpl: ");
        buf.append("consumerTag=");
        buf.append(this.getConsumerTag());
        buf.append(", ");
        buf.append("deliveryTag=");
        buf.append(this.getDeliveryTag());
        buf.append(", ");
        buf.append("exchange=");
        buf.append(this.getExchange());
        buf.append(", ");
        buf.append("queue=");
        buf.append(this.getQueue());
        buf.append("]");
        return buf.toString();
    }
}

