/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing.amqp_0_9;

import java.util.Arrays;
import org.apache.mina.common.ByteBuffer;
import org.apache.qpid.AMQException;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQMethodBodyInstanceFactory;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.ConnectionStartOkBody;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.framing.MethodDispatcher;
import org.apache.qpid.framing.amqp_0_9.AMQMethodBody_0_9;
import org.apache.qpid.framing.amqp_0_9.MethodDispatcher_0_9;

public class ConnectionStartOkBodyImpl
extends AMQMethodBody_0_9
implements ConnectionStartOkBody {
    private static final AMQMethodBodyInstanceFactory FACTORY_INSTANCE = new AMQMethodBodyInstanceFactory(){

        public AMQMethodBody newInstance(ByteBuffer in, long size) throws AMQFrameDecodingException {
            return new ConnectionStartOkBodyImpl(in);
        }
    };
    public static final int CLASS_ID = 10;
    public static final int METHOD_ID = 11;
    private final FieldTable _clientProperties;
    private final AMQShortString _mechanism;
    private final byte[] _response;
    private final AMQShortString _locale;

    public static AMQMethodBodyInstanceFactory getFactory() {
        return FACTORY_INSTANCE;
    }

    public ConnectionStartOkBodyImpl(ByteBuffer buffer) throws AMQFrameDecodingException {
        this._clientProperties = this.readFieldTable(buffer);
        this._mechanism = this.readAMQShortString(buffer);
        this._response = this.readBytes(buffer);
        this._locale = this.readAMQShortString(buffer);
    }

    public ConnectionStartOkBodyImpl(FieldTable clientProperties, AMQShortString mechanism, byte[] response, AMQShortString locale) {
        this._clientProperties = clientProperties;
        this._mechanism = mechanism;
        this._response = response;
        this._locale = locale;
    }

    public int getClazz() {
        return 10;
    }

    public int getMethod() {
        return 11;
    }

    public final FieldTable getClientProperties() {
        return this._clientProperties;
    }

    public final AMQShortString getMechanism() {
        return this._mechanism;
    }

    public final byte[] getResponse() {
        return this._response;
    }

    public final AMQShortString getLocale() {
        return this._locale;
    }

    protected int getBodySize() {
        int size = 0;
        size += this.getSizeOf(this._clientProperties);
        size += this.getSizeOf(this._mechanism);
        size += this.getSizeOf(this._response);
        return size += this.getSizeOf(this._locale);
    }

    public void writeMethodPayload(ByteBuffer buffer) {
        this.writeFieldTable(buffer, this._clientProperties);
        this.writeAMQShortString(buffer, this._mechanism);
        this.writeBytes(buffer, this._response);
        this.writeAMQShortString(buffer, this._locale);
    }

    public boolean execute(MethodDispatcher dispatcher, int channelId) throws AMQException {
        return ((MethodDispatcher_0_9)dispatcher).dispatchConnectionStartOk(this, channelId);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("[ConnectionStartOkBodyImpl: ");
        buf.append("clientProperties=");
        buf.append(this.getClientProperties());
        buf.append(", ");
        buf.append("mechanism=");
        buf.append(this.getMechanism());
        buf.append(", ");
        buf.append("response=");
        buf.append(this.getResponse() == null ? "null" : Arrays.toString(this.getResponse()));
        buf.append(", ");
        buf.append("locale=");
        buf.append(this.getLocale());
        buf.append("]");
        return buf.toString();
    }
}

