/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.configuration;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.qpid.configuration.PropertyException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyUtils {
    public static String replaceProperties(String value) throws PropertyException {
        if (value == null) {
            return null;
        }
        ArrayList<String> fragments = new ArrayList<String>();
        ArrayList<String> propertyRefs = new ArrayList<String>();
        PropertyUtils.parsePropertyString(value, fragments, propertyRefs);
        StringBuffer sb = new StringBuffer();
        Iterator<String> j = propertyRefs.iterator();
        for (String fragment : fragments) {
            if (fragment == null) {
                String propertyName = j.next();
                String replacement = System.getProperty(propertyName);
                if (replacement == null) {
                    throw new PropertyException("Property ${" + propertyName + "} has not been set", null);
                }
                fragment = replacement;
            }
            sb.append(fragment);
        }
        return sb.toString();
    }

    private static void parsePropertyString(String value, ArrayList<String> fragments, ArrayList<String> propertyRefs) throws PropertyException {
        int pos;
        int prev = 0;
        while ((pos = value.indexOf("$", prev)) >= 0) {
            if (pos > 0) {
                fragments.add(value.substring(prev, pos));
            }
            if (pos == value.length() - 1) {
                fragments.add("$");
                prev = pos + 1;
                continue;
            }
            if (value.charAt(pos + 1) != '{') {
                if (value.charAt(pos + 1) == '$') {
                    fragments.add("$");
                    prev = pos + 2;
                    continue;
                }
                fragments.add(value.substring(pos, pos + 2));
                prev = pos + 2;
                continue;
            }
            int endName = value.indexOf(125, pos);
            if (endName < 0) {
                throw new PropertyException("Syntax error in property: " + value, null);
            }
            String propertyName = value.substring(pos + 2, endName);
            fragments.add(null);
            propertyRefs.add(propertyName);
            prev = endName + 1;
        }
        if (prev < value.length()) {
            fragments.add(value.substring(prev));
        }
    }
}

