/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client.handler;

import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.StringTokenizer;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.apache.qpid.AMQException;
import org.apache.qpid.client.protocol.AMQProtocolSession;
import org.apache.qpid.client.security.AMQCallbackHandler;
import org.apache.qpid.client.security.CallbackHandlerRegistry;
import org.apache.qpid.client.state.AMQState;
import org.apache.qpid.client.state.StateAwareMethodListener;
import org.apache.qpid.common.ClientProperties;
import org.apache.qpid.common.QpidProperties;
import org.apache.qpid.framing.AMQDataBlock;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.ConnectionStartBody;
import org.apache.qpid.framing.ConnectionStartOkBody;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.framing.FieldTableFactory;
import org.apache.qpid.framing.ProtocolVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionStartMethodHandler
implements StateAwareMethodListener<ConnectionStartBody> {
    private static final Logger _log = LoggerFactory.getLogger(ConnectionStartMethodHandler.class);
    private static final ConnectionStartMethodHandler _instance = new ConnectionStartMethodHandler();

    public static ConnectionStartMethodHandler getInstance() {
        return _instance;
    }

    private ConnectionStartMethodHandler() {
    }

    @Override
    public void methodReceived(AMQProtocolSession session, ConnectionStartBody body, int channelId) throws AMQException {
        _log.debug("public void methodReceived(AMQStateManager stateManager, AMQProtocolSession protocolSession, AMQMethodEvent evt): called");
        ProtocolVersion pv = new ProtocolVersion((byte)body.getVersionMajor(), (byte)body.getVersionMinor());
        if (pv.equals((Object)ProtocolVersion.v0_9) && session.getProtocolVersion().equals((Object)ProtocolVersion.v0_91)) {
            pv = ProtocolVersion.v0_91;
        }
        if (Boolean.getBoolean("qpid.accept.broker.version") && !pv.isSupported()) {
            pv = ProtocolVersion.getLatestSupportedVersion();
        }
        if (pv.isSupported()) {
            session.setProtocolVersion(pv);
            try {
                byte[] saslResponse;
                if (body.getMechanisms() == null) {
                    throw new AMQException(null, "mechanism not specified in ConnectionStart method frame", null);
                }
                String mechanism = this.chooseMechanism(body.getMechanisms());
                _log.debug("mechanism = " + mechanism);
                if (mechanism == null) {
                    throw new AMQException(null, "No supported security mechanism found, passed: " + new String(body.getMechanisms()), null);
                }
                try {
                    SaslClient sc = Sasl.createSaslClient(new String[]{mechanism}, null, "AMQP", "localhost", null, this.createCallbackHandler(mechanism, session));
                    if (sc == null) {
                        throw new AMQException(null, "Client SASL configuration error: no SaslClient could be created for mechanism " + mechanism + ". Please ensure all factories are registered. See DynamicSaslRegistrar for " + " details of how to register non-standard SASL client providers.", null);
                    }
                    session.setSaslClient(sc);
                    saslResponse = sc.hasInitialResponse() ? sc.evaluateChallenge(new byte[0]) : null;
                }
                catch (SaslException e) {
                    session.setSaslClient(null);
                    throw new AMQException(null, "Unable to create SASL client: " + e, (Throwable)e);
                }
                if (body.getLocales() == null) {
                    throw new AMQException(null, "Locales is not defined in Connection Start method", null);
                }
                String locales = new String(body.getLocales(), "utf8");
                StringTokenizer tokenizer = new StringTokenizer(locales, " ");
                if (!tokenizer.hasMoreTokens()) {
                    throw new AMQException(null, "No locales sent from server, passed: " + locales, null);
                }
                tokenizer.nextToken();
                session.getStateManager().changeState(AMQState.CONNECTION_NOT_TUNED);
                FieldTable clientProperties = FieldTableFactory.newFieldTable();
                clientProperties.setString(new AMQShortString(ClientProperties.instance.toString()), session.getClientID());
                clientProperties.setString(new AMQShortString(ClientProperties.product.toString()), QpidProperties.getProductName());
                clientProperties.setString(new AMQShortString(ClientProperties.version.toString()), QpidProperties.getReleaseVersion());
                clientProperties.setString(new AMQShortString(ClientProperties.platform.toString()), this.getFullSystemInfo());
                ConnectionStartOkBody connectionStartOkBody = session.getMethodRegistry().createConnectionStartOkBody(clientProperties, new AMQShortString(mechanism), saslResponse, new AMQShortString(locales));
                session.writeFrame((AMQDataBlock)connectionStartOkBody.generateFrame(channelId));
            }
            catch (UnsupportedEncodingException e) {
                throw new AMQException(null, "Unable to decode data: " + e, (Throwable)e);
            }
        }
        _log.error("Broker requested Protocol [" + body.getVersionMajor() + "-" + body.getVersionMinor() + "] which is not supported by this version of the client library");
        session.closeProtocolSession();
    }

    private String getFullSystemInfo() {
        StringBuffer fullSystemInfo = new StringBuffer();
        fullSystemInfo.append(System.getProperty("java.runtime.name"));
        fullSystemInfo.append(", " + System.getProperty("java.runtime.version"));
        fullSystemInfo.append(", " + System.getProperty("java.vendor"));
        fullSystemInfo.append(", " + System.getProperty("os.arch"));
        fullSystemInfo.append(", " + System.getProperty("os.name"));
        fullSystemInfo.append(", " + System.getProperty("os.version"));
        fullSystemInfo.append(", " + System.getProperty("sun.os.patch.level"));
        return fullSystemInfo.toString();
    }

    private String chooseMechanism(byte[] availableMechanisms) throws UnsupportedEncodingException {
        String mechanisms = new String(availableMechanisms, "utf8");
        StringTokenizer tokenizer = new StringTokenizer(mechanisms, " ");
        HashSet<String> mechanismSet = new HashSet<String>();
        while (tokenizer.hasMoreTokens()) {
            mechanismSet.add(tokenizer.nextToken());
        }
        String preferredMechanisms = CallbackHandlerRegistry.getInstance().getMechanisms();
        StringTokenizer prefTokenizer = new StringTokenizer(preferredMechanisms, " ");
        while (prefTokenizer.hasMoreTokens()) {
            String mech = prefTokenizer.nextToken();
            if (!mechanismSet.contains(mech)) continue;
            return mech;
        }
        return null;
    }

    private AMQCallbackHandler createCallbackHandler(String mechanism, AMQProtocolSession protocolSession) throws AMQException {
        Class mechanismClass = CallbackHandlerRegistry.getInstance().getCallbackHandlerClass(mechanism);
        try {
            Object instance = mechanismClass.newInstance();
            AMQCallbackHandler cbh = (AMQCallbackHandler)instance;
            cbh.initialise(protocolSession.getAMQConnection().getConnectionURL());
            return cbh;
        }
        catch (Exception e) {
            throw new AMQException(null, "Unable to create callback handler: " + e, (Throwable)e);
        }
    }
}

