/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client;

import java.util.UUID;
import javax.jms.JMSException;
import javax.jms.TemporaryTopic;
import org.apache.qpid.client.AMQSession;
import org.apache.qpid.client.AMQTopic;
import org.apache.qpid.client.TemporaryDestination;
import org.apache.qpid.framing.AMQShortString;

class AMQTemporaryTopic
extends AMQTopic
implements TemporaryTopic,
TemporaryDestination {
    private final AMQSession _session;
    private boolean _deleted;

    public AMQTemporaryTopic(AMQSession session) {
        super(session.getTemporaryTopicExchangeName(), new AMQShortString("tmp_" + UUID.randomUUID()));
        this._session = session;
    }

    public void delete() throws JMSException {
        if (this._session.hasConsumer(this)) {
            throw new JMSException("Temporary Topic has consumers so cannot be deleted");
        }
        this._deleted = true;
    }

    public AMQSession getSession() {
        return this._session;
    }

    public boolean isDeleted() {
        return this._deleted;
    }
}

