/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.concurrent.Callable;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.encryption.AccessPermission;
import org.apache.pdfbox.tools.Version;
import picocli.CommandLine;

@CommandLine.Command(name="decrpyt", header={"Decrypts a PDF document"}, description={"This will read an encrypted document and decrypt it either using a password or a certificate."}, versionProvider=Version.class, mixinStandardHelpOptions=true)
public final class Decrypt
implements Callable<Integer> {
    private static final PrintStream SYSERR = System.err;
    @CommandLine.Option(names={"-alias"}, description={"the alias to the certificate in the keystore."})
    private String alias;
    @CommandLine.Option(names={"-keyStore"}, description={"the path to the keystore that holds the certificate to decrypt the document. This is only required if the document is encrypted with a certificate, otherwise only the password is required."})
    private String keyStore;
    @CommandLine.Option(names={"-password"}, arity="0..1", interactive=true, description={"the password for the PDF or certificate in keystore."})
    private String password;
    @CommandLine.Option(names={"-i", "--input"}, description={"the PDF file to decrypt"}, required=true)
    private File infile;
    @CommandLine.Option(names={"-o", "--output"}, description={"the decrypted PDF file. If omitted the original file is overwritten."})
    private File outfile;

    public static void main(String[] args) {
        System.setProperty("apple.awt.UIElement", "true");
        int exitCode = new CommandLine((Object)new Decrypt()).execute(args);
        System.exit(exitCode);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Integer call() {
        try (FileInputStream keyStoreStream = this.keyStore == null ? null : new FileInputStream(this.keyStore);
             PDDocument document = Loader.loadPDF((File)this.infile, (String)this.password, (InputStream)keyStoreStream, (String)this.alias);){
            if (this.outfile == null) {
                this.outfile = this.infile;
            }
            if (document.isEncrypted()) {
                AccessPermission ap = document.getCurrentAccessPermission();
                if (ap.isOwnerPermission()) {
                    document.setAllSecurityToBeRemoved(true);
                    document.save(this.outfile);
                    return 0;
                }
                SYSERR.println("Error: You are only allowed to decrypt a document with the owner password.");
                Integer n = 1;
                return n;
            }
            SYSERR.println("Error: Document is not encrypted.");
            Integer n = 1;
            return n;
        }
        catch (IOException ioe) {
            SYSERR.println("Error decrypting document [" + ioe.getClass().getSimpleName() + "]: " + ioe.getMessage());
            return 4;
        }
    }
}

