/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.rendering;

import android.graphics.Path;
import android.util.Log;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.pdfbox.pdmodel.font.PDType1Equivalent;
import org.apache.pdfbox.rendering.Glyph2D;

final class Type1Glyph2D
implements Glyph2D {
    private final Map<Integer, Path> cache = new HashMap<Integer, Path>();
    private final PDType1Equivalent font;

    public Type1Glyph2D(PDType1Equivalent font) {
        this.font = font;
    }

    @Override
    public Path getPathForCharacterCode(int code) {
        if (this.cache.containsKey(code)) {
            return this.cache.get(code);
        }
        try {
            Path path;
            String name = this.font.codeToName(code);
            if (name.equals(".notdef")) {
                Log.w((String)"PdfBoxAndroid", (String)("No glyph for " + code + " (" + name + ") in font " + this.font.getName()));
            }
            if ((path = this.font.getPath(name)) == null) {
                path = this.font.getPath(".notdef");
            }
            this.cache.put(code, path);
            return path;
        }
        catch (IOException e) {
            Log.e((String)"PdfBoxAndroid", (String)"Glyph rendering failed", (Throwable)e);
            return new Path();
        }
    }

    @Override
    public void dispose() {
        this.cache.clear();
    }
}

