/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.rendering;

import android.graphics.Path;
import android.util.Log;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.fontbox.ttf.GlyphData;
import org.apache.fontbox.ttf.HeaderTable;
import org.apache.fontbox.ttf.TrueTypeFont;
import org.apache.pdfbox.pdmodel.font.PDCIDFontType2;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDTrueTypeFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.rendering.Glyph2D;
import org.apache.pdfbox.util.awt.AffineTransform;

final class TTFGlyph2D
implements Glyph2D {
    private final PDFont font;
    private final TrueTypeFont ttf;
    private float scale = 1.0f;
    private boolean hasScaling;
    private final Map<Integer, Path> glyphs = new HashMap<Integer, Path>();
    private final boolean isCIDFont;

    public TTFGlyph2D(PDTrueTypeFont ttfFont) throws IOException {
        this(ttfFont.getTrueTypeFont(), ttfFont, false);
    }

    public TTFGlyph2D(PDType0Font type0Font) throws IOException {
        this(((PDCIDFontType2)type0Font.getDescendantFont()).getTrueTypeFont(), type0Font, true);
    }

    public TTFGlyph2D(TrueTypeFont ttf, PDFont font, boolean isCIDFont) throws IOException {
        this.font = font;
        this.ttf = ttf;
        this.isCIDFont = isCIDFont;
        HeaderTable header = this.ttf.getHeader();
        if (header != null && header.getUnitsPerEm() != 1000) {
            this.scale = 1000.0f / (float)header.getUnitsPerEm();
            this.hasScaling = true;
        }
    }

    @Override
    public Path getPathForCharacterCode(int code) throws IOException {
        int gid = this.getGIDForCharacterCode(code);
        return this.getPathForGID(gid, code);
    }

    private int getGIDForCharacterCode(int code) throws IOException {
        if (this.isCIDFont) {
            return ((PDType0Font)this.font).codeToGID(code);
        }
        return ((PDTrueTypeFont)this.font).codeToGID(code);
    }

    public Path getPathForGID(int gid, int code) throws IOException {
        Path glyphPath;
        if (this.glyphs.containsKey(gid)) {
            glyphPath = this.glyphs.get(gid);
        } else {
            if (gid == 0 || gid >= this.ttf.getMaximumProfile().getNumGlyphs()) {
                if (this.isCIDFont) {
                    int cid = ((PDType0Font)this.font).codeToCID(code);
                    String cidHex = String.format("%04x", cid);
                    Log.w((String)"PdfBoxAndroid", (String)("No glyph for " + code + " (CID " + cidHex + ") in font " + this.font.getName()));
                } else {
                    Log.w((String)"PdfBoxAndroid", (String)("No glyph for " + code + " in font " + this.font.getName()));
                }
            }
            GlyphData glyph = this.ttf.getGlyph().getGlyph(gid);
            if (gid == 0 && !this.font.isEmbedded() && !this.font.isStandard14()) {
                glyph = null;
            }
            if (glyph == null) {
                glyphPath = new Path();
                this.glyphs.put(gid, glyphPath);
            } else {
                glyphPath = glyph.getPath();
                if (this.hasScaling) {
                    AffineTransform atScale = AffineTransform.getScaleInstance(this.scale, this.scale);
                    glyphPath.transform(atScale.toMatrix());
                }
                this.glyphs.put(gid, glyphPath);
            }
        }
        return glyphPath != null ? new Path(glyphPath) : null;
    }

    @Override
    public void dispose() {
        this.glyphs.clear();
    }
}

