/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.rendering;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.util.Log;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.pdfbox.contentstream.PDFGraphicsStreamEngine;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDCIDFontType0;
import org.apache.pdfbox.pdmodel.font.PDCIDFontType2;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDTrueTypeFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.font.PDType1CFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.pdmodel.graphics.color.PDColor;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.form.PDFormXObject;
import org.apache.pdfbox.pdmodel.graphics.image.PDImage;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShading;
import org.apache.pdfbox.pdmodel.graphics.state.PDGraphicsState;
import org.apache.pdfbox.pdmodel.graphics.state.PDSoftMask;
import org.apache.pdfbox.pdmodel.graphics.state.RenderingMode;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.rendering.CIDType0Glyph2D;
import org.apache.pdfbox.rendering.Glyph2D;
import org.apache.pdfbox.rendering.TTFGlyph2D;
import org.apache.pdfbox.rendering.Type1Glyph2D;
import org.apache.pdfbox.util.Matrix;
import org.apache.pdfbox.util.Vector;
import org.apache.pdfbox.util.awt.AffineTransform;

public final class PageDrawer
extends PDFGraphicsStreamEngine {
    Paint paint;
    Canvas canvas;
    private AffineTransform xform;
    PDRectangle pageSize;
    private int clipWindingRule = -1;
    private Path linePath = new Path();
    private Region lastClip;
    private Region textClippingArea;
    private final Map<PDFont, Glyph2D> fontGlyph2D = new HashMap<PDFont, Glyph2D>();

    public PageDrawer(PDPage page) throws IOException {
        super(page);
    }

    private void setRenderingHints() {
        this.paint.setAntiAlias(true);
    }

    public void drawPage(Paint p, Canvas c, PDRectangle pageSize) throws IOException {
        this.paint = p;
        this.canvas = c;
        this.xform = new AffineTransform(this.canvas.getMatrix());
        this.pageSize = pageSize;
        this.setRenderingHints();
        this.canvas.translate(0.0f, pageSize.getHeight());
        this.canvas.scale(1.0f, -1.0f);
        this.paint.setStrokeCap(Paint.Cap.BUTT);
        this.paint.setStrokeJoin(Paint.Join.MITER);
        this.paint.setStrokeWidth(1.0f);
        this.canvas.translate(-pageSize.getLowerLeftX(), -pageSize.getLowerLeftY());
        this.processPage(this.getPage());
        for (PDAnnotation annotation : this.getPage().getAnnotations()) {
            this.showAnnotation(annotation);
        }
    }

    private int getColor(PDColor color) throws IOException {
        PDColorSpace colorSpace = color.getColorSpace();
        float[] floats = colorSpace.toRGB(color.getComponents());
        int r = Math.round(floats[0] * 255.0f);
        int g = Math.round(floats[1] * 255.0f);
        int b = Math.round(floats[2] * 255.0f);
        return Color.rgb((int)r, (int)g, (int)b);
    }

    private void setClip() {
        Region clippingPath = this.getGraphicsState().getCurrentClippingPath();
        if (clippingPath != this.lastClip) {
            this.canvas.clipRegion(clippingPath);
            this.lastClip = clippingPath;
        }
    }

    @Override
    public void beginText() throws IOException {
        this.setClip();
    }

    @Override
    protected void showText(byte[] string) throws IOException {
        PDGraphicsState state = this.getGraphicsState();
        RenderingMode renderingMode = state.getTextState().getRenderingMode();
        if (renderingMode.isClip()) {
            this.textClippingArea = new Region();
        }
        super.showText(string);
        if (renderingMode.isClip()) {
            state.intersectClippingPath(this.textClippingArea);
            this.textClippingArea = null;
        }
    }

    private void drawGlyph2D(Glyph2D glyph2D, PDFont font, int code, Vector displacement, AffineTransform at) throws IOException {
        PDGraphicsState state = this.getGraphicsState();
        RenderingMode renderingMode = state.getTextState().getRenderingMode();
        Path path = glyph2D.getPathForCharacterCode(code);
        if (path != null) {
            float fontWidth;
            if (!font.isEmbedded() && (fontWidth = font.getWidthFromFont(code)) > 0.0f && (double)Math.abs(fontWidth - displacement.getX() * 1000.0f) > 1.0E-4) {
                float pdfWidth = displacement.getX() * 1000.0f;
                at.scale(pdfWidth / fontWidth, 1.0);
            }
            if (renderingMode.isFill()) {
                this.paint.setColor(-16777216);
                this.setClip();
                this.paint.setStyle(Paint.Style.FILL);
                this.canvas.clipPath(path);
                this.canvas.drawRect(new Rect(0, 0, this.canvas.getWidth(), this.canvas.getHeight()), this.paint);
            }
            if (renderingMode.isStroke()) {
                this.paint.setColor(-16777216);
                this.setClip();
                this.paint.setStyle(Paint.Style.STROKE);
                this.canvas.clipPath(path);
                this.canvas.drawRect(new Rect(0, 0, this.canvas.getWidth(), this.canvas.getHeight()), this.paint);
            }
            if (renderingMode.isClip()) {
                // empty if block
            }
        }
    }

    private Glyph2D createGlyph2D(PDFont font) throws IOException {
        if (this.fontGlyph2D.containsKey(font)) {
            return this.fontGlyph2D.get(font);
        }
        Glyph2D glyph2D = null;
        if (font instanceof PDTrueTypeFont) {
            PDTrueTypeFont ttfFont = (PDTrueTypeFont)font;
            glyph2D = new TTFGlyph2D(ttfFont);
        } else if (font instanceof PDType1Font) {
            PDType1Font pdType1Font = (PDType1Font)font;
            glyph2D = new Type1Glyph2D(pdType1Font);
        } else if (font instanceof PDType1CFont) {
            PDType1CFont type1CFont = (PDType1CFont)font;
            glyph2D = new Type1Glyph2D(type1CFont);
        } else if (font instanceof PDType0Font) {
            PDType0Font type0Font = (PDType0Font)font;
            if (type0Font.getDescendantFont() instanceof PDCIDFontType2) {
                glyph2D = new TTFGlyph2D(type0Font);
            } else if (type0Font.getDescendantFont() instanceof PDCIDFontType0) {
                PDCIDFontType0 cidType0Font = (PDCIDFontType0)type0Font.getDescendantFont();
                glyph2D = new CIDType0Glyph2D(cidType0Font);
            }
        } else {
            throw new IllegalStateException("Bad font type: " + font.getClass().getSimpleName());
        }
        if (glyph2D != null) {
            this.fontGlyph2D.put(font, glyph2D);
        }
        if (glyph2D == null) {
            throw new UnsupportedOperationException("No font for " + font.getName());
        }
        return glyph2D;
    }

    @Override
    public void appendRectangle(PointF p0, PointF p1, PointF p2, PointF p3) {
        this.linePath.moveTo(p0.x, p0.y);
        this.linePath.lineTo(p1.x, p1.y);
        this.linePath.lineTo(p2.x, p2.y);
        this.linePath.lineTo(p3.x, p3.y);
        this.linePath.close();
    }

    private int getStrokingColor() throws IOException {
        return this.getColor(this.getGraphicsState().getStrokingColor());
    }

    private void setStroke() {
        PDGraphicsState state = this.getGraphicsState();
        float lineWidth = this.transformWidth(state.getLineWidth());
        if ((double)lineWidth < 0.25) {
            lineWidth = 0.25f;
        }
        this.paint.setStrokeWidth(lineWidth);
        this.paint.setStrokeCap(state.getLineCap());
        this.paint.setStrokeJoin(state.getLineJoin());
    }

    @Override
    public void strokePath() throws IOException {
        this.setStroke();
        this.setClip();
        this.paint.setARGB(255, 0, 0, 0);
        this.paint.setStyle(Paint.Style.STROKE);
        this.paint.setColor(this.getStrokingColor());
        this.canvas.drawPath(this.linePath, this.paint);
        this.linePath.reset();
    }

    @Override
    public void fillPath(int windingRule) throws IOException {
        this.setClip();
        this.setRenderingHints();
    }

    @Override
    public void fillAndStrokePath(int windingRule) throws IOException {
        Path path = new Path(this.linePath);
        this.fillPath(windingRule);
        this.linePath = path;
        this.strokePath();
    }

    @Override
    public void clip(int windingRule) {
    }

    @Override
    public void moveTo(float x, float y) {
        this.linePath.moveTo(x, y);
    }

    @Override
    public void lineTo(float x, float y) {
        this.linePath.lineTo(x, y);
    }

    @Override
    public void curveTo(float x1, float y1, float x2, float y2, float x3, float y3) {
        this.linePath.cubicTo(x1, y1, x2, y2, x3, y3);
    }

    @Override
    public PointF getCurrentPoint() {
        Log.d((String)"PdfBoxAndroid", (String)"PageDrawer.getCurrentPoint does not return the right value");
        return new PointF();
    }

    @Override
    public void closePath() {
        this.linePath.close();
    }

    @Override
    public void endPath() {
        this.linePath.reset();
    }

    @Override
    public void drawImage(PDImage pdImage) throws IOException {
        Matrix ctm = this.getGraphicsState().getCurrentTransformationMatrix();
        AffineTransform at = ctm.createAffineTransform();
        if (!pdImage.getInterpolate()) {
            boolean isScaledUp;
            boolean bl = isScaledUp = (long)pdImage.getWidth() < Math.round(at.getScaleX()) || (long)pdImage.getHeight() < Math.round(at.getScaleY());
            if (isScaledUp || pdImage.isStencil()) {
                // empty if block
            }
        }
        if (pdImage.isStencil()) {
            PDColor color = this.getGraphicsState().getNonStrokingColor();
        } else {
            this.drawBufferedImage(pdImage.getImage(), at);
        }
        if (!pdImage.getInterpolate()) {
            this.setRenderingHints();
        }
    }

    public void drawBufferedImage(Bitmap image, AffineTransform at) throws IOException {
        this.setClip();
        PDSoftMask softMask = this.getGraphicsState().getSoftMask();
        if (softMask != null) {
            AffineTransform imageTransform = new AffineTransform(at);
            imageTransform.scale(1.0, -1.0);
            imageTransform.translate(0.0, -1.0);
            RectF unitRect = new RectF(0.0f, 0.0f, 1.0f, 1.0f);
        } else {
            int width = image.getWidth();
            int height = image.getHeight();
            AffineTransform imageTransform = new AffineTransform(at);
            imageTransform.scale(1.0f / (float)width, -1.0f / (float)height);
            imageTransform.translate(0.0, -height);
        }
    }

    @Override
    public void shadingFill(COSName shadingName) throws IOException {
        PDShading shading = this.getResources().getShading(shadingName);
        Matrix ctm = this.getGraphicsState().getCurrentTransformationMatrix();
    }

    @Override
    public void showAnnotation(PDAnnotation annotation) throws IOException {
        if (annotation.isNoView()) {
            return;
        }
        if (annotation.isHidden()) {
            return;
        }
        super.showAnnotation(annotation);
    }

    @Override
    public void showTransparencyGroup(PDFormXObject form) throws IOException {
        TransparencyGroup group = new TransparencyGroup(form, false);
        this.setClip();
        PDSoftMask softMask = this.getGraphicsState().getSoftMask();
        if (softMask != null) {
            // empty if block
        }
    }

    private final class TransparencyGroup {
        private TransparencyGroup(PDFormXObject form, boolean isSoftMask) throws IOException {
            if (!isSoftMask) {
                PageDrawer.this.processTransparencyGroup(form);
            }
        }
    }
}

